/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.DataSetCommandExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutorProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KeyBasedDataSetCommandExecutorProvider
implements IDataSetCommandExecutorProvider {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, KeyBasedDataSetCommandExecutorProvider.class);
    private final List<ExecutorNameMapping> nameMappings = new ArrayList<ExecutorNameMapping>();
    private final Map<String, IDataSetCommandExecutor> executorsByName = new HashMap<String, IDataSetCommandExecutor>();
    private final String commandQueueDirPath;
    private final IDataSetCommandExecutorFactory executorFactory;
    private IDataSetCommandExecutor defaultExecutor;

    public KeyBasedDataSetCommandExecutorProvider(String mapping, String commandQueueDir) {
        this(mapping, commandQueueDir, new IDataSetCommandExecutorFactory(){

            @Override
            public IDataSetCommandExecutor create(File store, File queueDir, String nameOrNull) {
                return new DataSetCommandExecutor(store, queueDir, nameOrNull);
            }
        });
    }

    KeyBasedDataSetCommandExecutorProvider(String mapping, String commandQueueDir, IDataSetCommandExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
        if (!mapping.startsWith("${")) {
            String[] definitions;
            String[] stringArray = definitions = mapping.split(",");
            int n = definitions.length;
            int n2 = 0;
            while (n2 < n) {
                String definition = stringArray[n2];
                this.nameMappings.add(new ExecutorNameMapping(definition));
                ++n2;
            }
        }
        this.nameMappings.add(new ExecutorNameMapping("", Pattern.compile(".*")));
        this.commandQueueDirPath = StringUtils.isBlank((String)commandQueueDir) || commandQueueDir.startsWith("${") ? "" : commandQueueDir;
    }

    @Override
    public void init(File storeRoot) {
        File commandQueueDir = storeRoot;
        if (StringUtils.isNotBlank((String)this.commandQueueDirPath)) {
            commandQueueDir = new File(this.commandQueueDirPath);
        }
        for (ExecutorNameMapping mapping : this.nameMappings) {
            String name = mapping.getName();
            IDataSetCommandExecutor executor = this.executorFactory.create(storeRoot, commandQueueDir, name);
            this.executorsByName.put(name, executor);
            executor.start();
            if (StringUtils.isBlank((String)name)) {
                this.defaultExecutor = executor;
                operationLog.info((Object)"Default command executor started.");
                continue;
            }
            operationLog.info((Object)("Command executor '" + name + "' started."));
        }
    }

    @Override
    public IDataSetCommandExecutor getDefaultExecutor() {
        if (this.defaultExecutor == null) {
            throw new IllegalStateException("Default executor not yet defined.");
        }
        return this.defaultExecutor;
    }

    @Override
    public IDataSetCommandExecutor getExecutor(IProcessingPluginTask processingTask, String processingTaskKey) {
        String identifier = this.getIdentifier(processingTask, processingTaskKey);
        for (ExecutorNameMapping mapping : this.nameMappings) {
            if (!mapping.getPattern().matcher(identifier).matches()) continue;
            return this.executorsByName.get(mapping.getName());
        }
        throw new IllegalStateException("Couldn't find executor. This is a programming error.");
    }

    protected String getIdentifier(IProcessingPluginTask processingTask, String processingTaskKey) {
        return processingTaskKey;
    }

    private static final class ExecutorNameMapping {
        private final String name;
        private final Pattern pattern;

        ExecutorNameMapping(String mapping) {
            int indexOfColon = mapping.indexOf(58);
            if (indexOfColon < 0) {
                throw new ConfigurationFailureException("Missing ':' in mapping definition: " + mapping);
            }
            this.name = mapping.substring(0, indexOfColon).trim();
            if (this.name.length() == 0) {
                throw new ConfigurationFailureException("Unspecified executor name in mapping definition: " + mapping);
            }
            try {
                this.pattern = Pattern.compile(mapping.substring(indexOfColon + 1).trim());
            }
            catch (PatternSyntaxException ex) {
                throw new ConfigurationFailureException("Invalid regex in mapping definition: " + mapping, ex);
            }
        }

        ExecutorNameMapping(String name, Pattern pattern) {
            this.name = name;
            this.pattern = pattern;
        }

        String getName() {
            return this.name;
        }

        Pattern getPattern() {
            return this.pattern;
        }
    }
}

