/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.fasta.FastaUtilities;
import ch.systemsx.cisd.common.fasta.SequenceType;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases.AbstractSearchDomainService;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.BlastUtils;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.AlignmentMatch;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileBlastSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityPropertyBlastSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityPropertySearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ISearchDomainResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BlastDatabase
extends AbstractSearchDomainService {
    public static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, BlastDatabase.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, BlastDatabase.class);
    private static final String QUERY_FILE_NAME_TEMPLATE = "query-{0,date,yyyyMMDDHHmmssSSS}-{1}.fasta";
    private static final Pattern STITLE_PATTERN = Pattern.compile("(.*) \\[Data set: (.*), File: (.*)\\]$");
    private static final Pattern ENTITY_PROPERTY_TITLE_PATTERN = Pattern.compile("^(MATERIAL|EXPERIMENT|SAMPLE|DATA_SET)\\+(.+)\\+([A-Z0-9_\\-.]+)\\+(\\d+)$");
    private static final String[] BLASTN_OPTIONS = new String[]{"task", "evalue", "word_size", "ungapped"};
    private static final String[] BLASTP_OPTIONS = new String[]{"task", "evalue", "word_size"};
    private final File databaseFolder;
    private final String blastn;
    private final String blastp;
    private final boolean available;
    private final File queriesFolder;
    private AtomicInteger counter = new AtomicInteger();

    public BlastDatabase(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        String blastToolDirectory = BlastUtils.getBLASTToolDirectory(properties);
        this.blastn = String.valueOf(blastToolDirectory) + "blastn";
        this.blastp = String.valueOf(blastToolDirectory) + "blastp";
        this.available = this.process(this.blastn, "-version");
        if (!this.available) {
            BlastUtils.logMissingTools(operationLog);
        }
        this.databaseFolder = BlastUtils.getBlastDatabaseFolder(properties, storeRoot);
        this.queriesFolder = new File(this.databaseFolder, "queries-folder");
        this.queriesFolder.mkdirs();
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public List<SearchDomainSearchResult> search(String sequenceSnippet, Map<String, String> optionalParametersOrNull) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (optionalParametersOrNull != null) {
            parameters.putAll(optionalParametersOrNull);
        }
        ArrayList<SearchDomainSearchResult> result = new ArrayList<SearchDomainSearchResult>();
        SequenceType sequenceType = FastaUtilities.determineSequenceType(sequenceSnippet);
        String queryFileName = new MessageFormat(QUERY_FILE_NAME_TEMPLATE).format(new Object[]{new Date(), this.counter.getAndIncrement()});
        File queryFile = new File(this.queriesFolder, queryFileName);
        try {
            FileUtilities.writeToFile(queryFile, ">query\n" + sequenceSnippet + "\n");
            List<String> command = this.createCommand(sequenceType, queryFile, parameters);
            List<String> output = this.processAndDeliverOutput(command);
            for (String line : output) {
                ISearchDomainResultLocation resultLocation;
                Row row = new Row(line);
                SearchDomainSearchResult sequenceSearchResult = new SearchDomainSearchResult();
                sequenceSearchResult.setScore(row.bitscore);
                AlignmentMatch alignmentMatch = new AlignmentMatch();
                alignmentMatch.setSequenceStart(row.sstart);
                alignmentMatch.setSequenceEnd(row.send);
                alignmentMatch.setQueryStart(row.qstart);
                alignmentMatch.setQueryEnd(row.qend);
                alignmentMatch.setNumberOfMismatches(row.numberOfMismatchs);
                alignmentMatch.setTotalNumberOfGaps(row.totalNumberOfGaps);
                Matcher matcher = STITLE_PATTERN.matcher(row.title);
                if (matcher.matches()) {
                    resultLocation = new DataSetFileBlastSearchResultLocation();
                    ((DataSetFileSearchResultLocation)resultLocation).setIdentifier(matcher.group(1));
                    ((DataSetFileSearchResultLocation)resultLocation).setDataSetCode(matcher.group(2));
                    ((DataSetFileSearchResultLocation)resultLocation).setPathInDataSet(matcher.group(3));
                    ((DataSetFileBlastSearchResultLocation)resultLocation).setAlignmentMatch(alignmentMatch);
                    sequenceSearchResult.setResultLocation(resultLocation);
                    result.add(sequenceSearchResult);
                    continue;
                }
                matcher = ENTITY_PROPERTY_TITLE_PATTERN.matcher(row.title);
                if (!matcher.matches()) continue;
                resultLocation = new EntityPropertyBlastSearchResultLocation();
                ((EntityPropertySearchResultLocation)resultLocation).setEntityKind(EntityKind.valueOf(matcher.group(1)));
                ((EntityPropertySearchResultLocation)resultLocation).setPermId(matcher.group(2));
                ((EntityPropertySearchResultLocation)resultLocation).setPropertyType(matcher.group(3));
                ((EntityPropertyBlastSearchResultLocation)resultLocation).setAlignmentMatch(alignmentMatch);
                sequenceSearchResult.setResultLocation(resultLocation);
                result.add(sequenceSearchResult);
            }
        }
        finally {
            FileUtilities.delete(queryFile);
        }
        return result;
    }

    private List<String> createCommand(SequenceType sequenceType, File queryFile, Map<String, String> parameters) {
        String[] options;
        String defaultTask;
        ArrayList<String> command = new ArrayList<String>();
        if (sequenceType == SequenceType.NUCL) {
            command.add(this.blastn);
            defaultTask = "blastn";
            options = BLASTN_OPTIONS;
        } else {
            command.add(this.blastp);
            defaultTask = "blastp";
            options = BLASTP_OPTIONS;
        }
        command.add("-db");
        command.add(String.valueOf(this.databaseFolder.getAbsolutePath()) + "/all-" + sequenceType.toString().toLowerCase());
        command.add("-query");
        command.add(queryFile.getAbsolutePath());
        command.add("-outfmt");
        command.add("6 stitle bitscore sstart send qstart qend mismatch gaps");
        if (!parameters.containsKey("task")) {
            parameters.put("task", defaultTask);
        }
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            String value = this.tryGetOption(option, sequenceType, parameters);
            if (value != null) {
                command.add("-" + option);
                if (StringUtils.isNotBlank((String)value)) {
                    command.add(value);
                }
            }
            ++n2;
        }
        return command;
    }

    private String tryGetOption(String option, SequenceType sequenceType, Map<String, String> parameters) {
        String value = parameters.get(option);
        if (value != null) {
            return value;
        }
        String prefixedOption = String.valueOf(sequenceType == SequenceType.NUCL ? "blastn." : "blastp.") + option;
        value = parameters.get(prefixedOption);
        if (value != null) {
            return value;
        }
        value = parameters.get(String.valueOf(this.name) + "." + option);
        if (value != null) {
            return value;
        }
        return parameters.get(String.valueOf(this.name) + "." + prefixedOption);
    }

    private boolean process(String ... command) {
        ProcessResult processResult = this.run(Arrays.asList(command));
        if (processResult.isOK()) {
            processResult.logAsInfo();
        } else {
            processResult.log();
        }
        return processResult.isOK();
    }

    private List<String> processAndDeliverOutput(List<String> command) {
        ProcessResult processResult = this.run(command);
        List<String> output = processResult.getOutput();
        if (processResult.isOK()) {
            return output;
        }
        StringBuilder builder = new StringBuilder("Execution failed: ").append(command);
        List<String> lines = processResult.isBinaryOutput() ? processResult.getErrorOutput() : output;
        for (String line : lines) {
            builder.append("\n").append(line);
        }
        processResult.log();
        throw new EnvironmentFailureException(builder.toString());
    }

    @Private
    ProcessResult run(List<String> command) {
        return ProcessExecutionHelper.run(command, operationLog, machineLog);
    }

    private static final class Row {
        private String title;
        private double bitscore;
        private int sstart;
        private int send;
        private int qstart;
        private int qend;
        private int len;
        private int numberOfMismatchs;
        private int totalNumberOfGaps;

        Row(String line) {
            String[] cells = line.split("\t");
            this.title = cells[this.len++];
            this.bitscore = this.asDouble(cells);
            this.sstart = this.asInt(cells);
            this.send = this.asInt(cells);
            this.qstart = this.asInt(cells);
            this.qend = this.asInt(cells);
            this.numberOfMismatchs = this.asInt(cells);
            this.totalNumberOfGaps = this.asInt(cells);
        }

        private int asInt(String[] cells) {
            try {
                return Integer.parseInt(cells[this.len++]);
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }

        private double asDouble(String[] cells) {
            try {
                return Double.parseDouble(cells[this.len++]);
            }
            catch (RuntimeException runtimeException) {
                return 0.0;
            }
        }
    }
}

