/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.ExceptionWithStatus;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.FilteredHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentNodeFilter;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPathCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.ISshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.AbstractDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.ArchiveDestination;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.ArchiveDestinationFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetPackageManager;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MultiDataSetFileOperationsManager
extends AbstractDataSetFileOperationsManager
implements IMultiDataSetFileOperationsManager,
Serializable {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MultiDataSetFileOperationsManager.class);
    private static final long serialVersionUID = 1L;
    public static final String STAGING_DESTINATION_KEY = "staging-destination";
    public static final String FINAL_DESTINATION_KEY = "final-destination";
    public static final String WITH_SHARDING_KEY = "with-sharding";
    private transient ArchiveDestination stageArchive;
    private transient ArchiveDestination finalArchive;
    private final ArchiveDestinationFactory stageArchivefactory;
    private final ArchiveDestinationFactory finalArchivefactory;
    private final boolean withSharding;
    protected IMultiDataSetPackageManager packageManager;
    private static final IHierarchicalContentNodeFilter METADATA_IN_CONTAINER_FILTER = new IHierarchicalContentNodeFilter(){

        @Override
        public boolean accept(IHierarchicalContentNode node) {
            return !"meta-data.tsv".equals(node.getName());
        }
    };

    public MultiDataSetFileOperationsManager(Properties properties, IPathCopierFactory pathCopierFactory, ISshCommandExecutorFactory sshCommandExecutorFactory) {
        this.packageManager = new MultiDataSetPackageManager(properties);
        this.withSharding = PropertyUtils.getBoolean(properties, WITH_SHARDING_KEY, false);
        long timeoutInSeconds = PropertyUtils.getLong(properties, "timeout", 15L);
        long timeoutInMillis = timeoutInSeconds * 1000L;
        String stagingHostFile = PropertyUtils.getMandatoryProperty(properties, STAGING_DESTINATION_KEY);
        String finalHostFile = PropertyUtils.getMandatoryProperty(properties, FINAL_DESTINATION_KEY);
        if (!new File(stagingHostFile).isDirectory()) {
            throw new ConfigurationFailureException("Archiving stage area '" + stagingHostFile + "' is not an existing directory");
        }
        if (!new File(finalHostFile).isDirectory()) {
            throw new ConfigurationFailureException("Archiving final destination '" + finalHostFile + "' is not an existing directory");
        }
        this.stageArchivefactory = new ArchiveDestinationFactory(properties, pathCopierFactory, sshCommandExecutorFactory, stagingHostFile, timeoutInMillis);
        this.finalArchivefactory = new ArchiveDestinationFactory(properties, pathCopierFactory, sshCommandExecutorFactory, finalHostFile, timeoutInMillis);
    }

    private ArchiveDestination getStageArchive() {
        if (this.stageArchive == null) {
            this.stageArchive = this.stageArchivefactory.createArchiveDestination();
        }
        return this.stageArchive;
    }

    private ArchiveDestination getFinalArchive() {
        if (this.finalArchive == null) {
            this.finalArchive = this.finalArchivefactory.createArchiveDestination();
        }
        return this.finalArchive;
    }

    @Override
    public Status deleteContainerFromStage(String containerPath) {
        File stageArchiveContainerFile = new File(this.getStageArchive().getDestination(), containerPath);
        if (!stageArchiveContainerFile.isFile()) {
            operationLog.warn((Object)("Archive container '" + containerPath + "' doesn't exist."));
            return Status.OK;
        }
        boolean success = stageArchiveContainerFile.delete();
        return success ? Status.OK : Status.createError("Couldn't delete archive container '" + containerPath);
    }

    @Override
    public Status restoreDataSetsFromContainerInFinalDestination(String containerPath, List<? extends IDatasetLocation> dataSetLocations) {
        HashMap<String, File> dataSetToLocation = new HashMap<String, File>();
        for (IDatasetLocation iDatasetLocation : dataSetLocations) {
            File location = this.getDirectoryProvider().getDataSetDirectory(iDatasetLocation);
            dataSetToLocation.put(iDatasetLocation.getDataSetCode(), location);
        }
        File file = new File(this.getFinalArchive().getDestination(), containerPath);
        this.packageManager.extractMultiDataSets(file, dataSetToLocation);
        return Status.OK;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Status createContainerInStage(String containerPath, List<DatasetDescription> datasetDescriptions) {
        block19: {
            block18: {
                stageArchiveContainerFile = new File(this.getStageArchive().getDestination(), containerPath);
                shareIdManager = this.getDirectoryProvider().getShareIdManager();
                status = Status.OK;
                try {
                    try {
                        dataSets = new LinkedList<AbstractExternalData>();
                        for (DatasetDescription datasetDescription : datasetDescriptions) {
                            dataSet = this.getDataSetWithAllMetaData(datasetDescription);
                            dataSets.add(dataSet);
                            shareIdManager.lock(dataSet.getCode());
                            MultiDataSetFileOperationsManager.operationLog.info((Object)("Archive dataset " + dataSet.getCode() + " in " + containerPath));
                        }
                        result = this.createFolderIfNotExists(this.stageArchive, stageArchiveContainerFile.getParentFile());
                        if (result) {
                            MultiDataSetFileOperationsManager.operationLog.warn((Object)("File already exists in archive " + stageArchiveContainerFile.getParentFile()));
                        }
                        this.packageManager.create(stageArchiveContainerFile, dataSets);
                        break block18;
                    }
                    catch (Exception ex) {
                        status = Status.createError(ex.toString());
                        MultiDataSetFileOperationsManager.operationLog.error((Object)("Couldn't create package file: " + containerPath), (Throwable)ex);
                        try {
                            if (Status.OK.equals(status) && (errors = this.packageManager.verify(stageArchiveContainerFile)).size() > 0) {
                                status = Status.createError(errors.toString());
                                throw new RuntimeException(errors.toString());
                            }
                            MultiDataSetFileOperationsManager.operationLog.info((Object)("Data sets archived: " + containerPath));
                        }
                        catch (Exception ex) {
                            MultiDataSetFileOperationsManager.operationLog.error((Object)("Couldn't create package file: " + containerPath), (Throwable)ex);
                        }
                        ** for (datasetDescription : datasetDescriptions)
                    }
                }
                catch (Throwable var10_21) {
                    try {
                        if (Status.OK.equals(status) && (errors = this.packageManager.verify(stageArchiveContainerFile)).size() > 0) {
                            status = Status.createError(errors.toString());
                            throw new RuntimeException(errors.toString());
                        }
                        MultiDataSetFileOperationsManager.operationLog.info((Object)("Data sets archived: " + containerPath));
                    }
                    catch (Exception ex) {
                        MultiDataSetFileOperationsManager.operationLog.error((Object)("Couldn't create package file: " + containerPath), (Throwable)ex);
                    }
                    ** for (datasetDescription : datasetDescriptions)
                }
lbl-1000:
                // 1 sources

                {
                    shareIdManager.releaseLock(datasetDescription.getDataSetCode());
                    continue;
lbl33:
                    // 1 sources

                    break block19;
                }
lbl-1000:
                // 1 sources

                {
                    shareIdManager.releaseLock(datasetDescription.getDataSetCode());
                    continue;
                }
lbl46:
                // 1 sources

                throw var10_21;
            }
            try {
                if (Status.OK.equals(status) && (errors = this.packageManager.verify(stageArchiveContainerFile)).size() > 0) {
                    status = Status.createError(errors.toString());
                    throw new RuntimeException(errors.toString());
                }
                MultiDataSetFileOperationsManager.operationLog.info((Object)("Data sets archived: " + containerPath));
            }
            catch (Exception ex) {
                MultiDataSetFileOperationsManager.operationLog.error((Object)("Couldn't create package file: " + containerPath), (Throwable)ex);
            }
            for (DatasetDescription datasetDescription : datasetDescriptions) {
                shareIdManager.releaseLock(datasetDescription.getDataSetCode());
            }
        }
        return status;
    }

    @Override
    public String generateContainerPath(List<DatasetDescription> dataSets) {
        String name = this.packageManager.getName(dataSets.get(0).getDataSetCode());
        if (this.withSharding) {
            return String.valueOf(dataSets.get(0).getDataSetLocation()) + "/" + name;
        }
        return name;
    }

    @Override
    public Status copyToFinalDestination(String containerLocalPath) {
        ArchiveDestination stageDestination = this.getStageArchive();
        File containerFile = new File(stageDestination.getDestination(), containerLocalPath);
        ArchiveDestination finalDestination = this.getFinalArchive();
        try {
            File destinationFolder = new File(finalDestination.getDestination(), containerLocalPath);
            if (this.createFolderIfNotExists(finalDestination, destinationFolder.getParentFile()) || !this.destinationExists(finalDestination, destinationFolder).isSuccess()) {
                operationLog.info((Object)("Copy archive container from '" + containerFile + "' to '" + destinationFolder.getParentFile()));
                finalDestination.getExecutor().copyDataSetToDestination(containerFile, destinationFolder.getParentFile());
            } else {
                operationLog.info((Object)("Update archive container from '" + containerFile + "' to '" + destinationFolder.getParentFile()));
                finalDestination.getExecutor().syncDataSetWithDestination(containerFile, destinationFolder.getParentFile());
            }
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    @Override
    public Status deleteContainerFromFinalDestination(String containerLocalPath) {
        try {
            ArchiveDestination finalDestination = this.getFinalArchive();
            File containerInFinalDestination = new File(finalDestination.getDestination(), containerLocalPath);
            finalDestination.getExecutor().deleteFolder(containerInFinalDestination);
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    @Override
    public IHierarchicalContent getContainerAsHierarchicalContent(String containerPath) {
        ArchiveDestination archiveDestination = this.getFinalArchive();
        String destinationRoot = archiveDestination.getDestination();
        File containerInDestination = new File(destinationRoot, containerPath);
        return new FilteredHierarchicalContent(this.packageManager.asHierarchialContent(containerInDestination), METADATA_IN_CONTAINER_FILTER);
    }

    private boolean createFolderIfNotExists(ArchiveDestination archiveDestination, File destinationFolder) {
        BooleanStatus destinationExists = this.destinationExists(archiveDestination, destinationFolder);
        if (!destinationExists.isSuccess()) {
            archiveDestination.getExecutor().createFolder(destinationFolder);
            return true;
        }
        return false;
    }

    private BooleanStatus destinationExists(ArchiveDestination archiveDestination, File destinationFolder) {
        BooleanStatus destinationExists = archiveDestination.getExecutor().exists(destinationFolder);
        if (destinationExists.isError()) {
            throw new ExceptionWithStatus(Status.createError("CHECK_EXISTENCE_FAILED"));
        }
        return destinationExists;
    }
}

