/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.TextArea;

public class MultilineVarcharField
extends TextArea {
    private static final double DEFAULT_LINE_HEIGHT = 1.6;
    public static final int EM_TO_PIXEL = 10;
    protected static final int DEFAULT_LINES = 5;

    public MultilineVarcharField(String label, boolean mandatory) {
        this(label, mandatory, 5);
    }

    public MultilineVarcharField(String label, boolean mandatory, int lines) {
        this.setFieldLabel(label);
        this.setValidateOnBlur(true);
        this.setAutoValidate(true);
        this.setFireChangeEventOnSetValue(true);
        FieldUtil.setMandatoryFlag(this, mandatory);
        this.setHeightInLines(lines);
    }

    private void setHeightInLines(int lines) {
        this.setHeight(MultilineVarcharField.linesToPixelHeight(lines));
    }

    public static int linesToPixelHeight(int lines) {
        return (int)((double)lines * 1.6 * 10.0);
    }

    public void treatTabKeyAsInput() {
        this.addListener(Events.OnKeyDown, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                if (be.getKeyCode() == 9) {
                    be.preventDefault();
                    String t = (String)MultilineVarcharField.this.getValue();
                    int cp = MultilineVarcharField.this.getCursorPos();
                    String start = t.substring(0, cp);
                    String end = t.substring(cp, t.length());
                    MultilineVarcharField.this.setValue(String.valueOf(start) + '\t' + end);
                    MultilineVarcharField.this.setCursorPos(cp + 1);
                }
            }
        });
    }
}

