/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.EntityTypePropertyTypeProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETNewPTAssigments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewPTNewAssigment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class EntityTypePropertyTypeBrowserProvider
extends EntityTypePropertyTypeProvider {
    private final List<NewPTNewAssigment> propertyTypesAsgs;

    public EntityTypePropertyTypeBrowserProvider(EntityType entity, List<NewPTNewAssigment> propertyTypesAsgs) {
        super(null, null, entity);
        this.propertyTypesAsgs = propertyTypesAsgs;
    }

    @Override
    protected TypedTableModel<EntityTypePropertyType<?>> createTableModel() {
        TypedTableModelBuilder builder = new TypedTableModelBuilder();
        builder.addColumn("ORDINAL").withDefaultWidth(100);
        builder.addColumn("SECTION");
        builder.addColumn("PROPERTY_TYPE_CODE").withDefaultWidth(200);
        builder.addColumn("LABEL").hideByDefault();
        builder.addColumn("DESCRIPTION").hideByDefault();
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("IS_MANDATORY");
        builder.addColumn("DATA_TYPE").withDefaultWidth(200);
        builder.addColumn("IS_DYNAMIC");
        builder.addColumn("IS_MANAGED");
        builder.addColumn("IS_SHOWN_IN_EDITOR_VIEW");
        builder.addColumn("SHOW_RAW_VALUE");
        builder.addColumn("SCRIPT");
        for (NewPTNewAssigment propertyTypeAsg : this.propertyTypesAsgs) {
            EntityTypePropertyType<?> etpt = NewETNewPTAssigments.getEntityTypePropertyType(this.entity, propertyTypeAsg);
            builder.addRow(etpt);
            PropertyType propertyType = etpt.getPropertyType();
            builder.column("ORDINAL").addInteger(etpt.getOrdinal());
            builder.column("SECTION").addString(etpt.getSection());
            builder.column("PROPERTY_TYPE_CODE").addString(propertyType.getCode());
            builder.column("LABEL").addString(propertyType.getLabel());
            builder.column("DESCRIPTION").addString(propertyType.getDescription());
            builder.column("MODIFICATION_DATE").addDate(propertyType.getModificationDate());
            builder.column("IS_MANDATORY").addString(SimpleYesNoRenderer.render(etpt.isMandatory()));
            builder.column("DATA_TYPE").addString(EntityTypePropertyTypeBrowserProvider.renderDataType(propertyType));
            builder.column("IS_DYNAMIC").addString(SimpleYesNoRenderer.render(etpt.isDynamic()));
            builder.column("IS_MANAGED").addString(SimpleYesNoRenderer.render(etpt.isManaged()));
            builder.column("IS_SHOWN_IN_EDITOR_VIEW").addString(SimpleYesNoRenderer.render(etpt.isShownInEditView()));
            builder.column("SHOW_RAW_VALUE").addString(SimpleYesNoRenderer.render(etpt.getShowRawValue()));
            Script script = etpt.getScript();
            if (script == null) continue;
            builder.column("SCRIPT").addString(script.getName());
        }
        return builder.getModel();
    }
}

