/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class LongRunningThreadInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, InvocationStart> invocations = new ConcurrentHashMap<String, InvocationStart>();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String threadName = Thread.currentThread().getName();
        this.invocations.put(threadName, new InvocationStart(System.currentTimeMillis(), invocation, threadName));
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.invocations.remove(threadName);
        }
    }

    public Set<InvocationStart> getInvocationsRunningLongerThan(long limit) {
        HashSet<InvocationStart> overdue = new HashSet<InvocationStart>();
        for (String threadName : this.invocations.keySet()) {
            InvocationStart invocation = this.invocations.get(threadName);
            if (invocation.startTime + limit >= System.currentTimeMillis()) continue;
            overdue.add(invocation);
        }
        return overdue;
    }

    static class InvocationStart {
        public final long startTime;
        public final MethodInvocation invocation;
        public final String threadName;

        public InvocationStart(long startTime, MethodInvocation invocation, String threadName) {
            this.startTime = startTime;
            this.invocation = invocation;
            this.threadName = threadName;
        }
    }
}

