/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.AuthorizationChecker;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.IAuthorizationChecker;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.GroupLoaderFactory;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.IGroupLoaderFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryResultFilter {
    private final IGroupLoaderFactory groupLoaderFactory;
    private final IAuthorizationChecker authorizationChecker;
    private static final EntityKind[] FILTRABLE_ENTITY_KINDS = new EntityKind[]{EntityKind.EXPERIMENT, EntityKind.SAMPLE, EntityKind.DATA_SET};

    public QueryResultFilter(IDAOFactory daoFactory) {
        this.groupLoaderFactory = new GroupLoaderFactory(daoFactory);
        this.authorizationChecker = new AuthorizationChecker();
    }

    @Private
    QueryResultFilter(IGroupLoaderFactory groupLoaderFactory, IAuthorizationChecker authorizationChecker) {
        this.groupLoaderFactory = groupLoaderFactory;
        this.authorizationChecker = authorizationChecker;
    }

    public TableModel filterResults(PersonPE person, TableModel table) {
        EntityKind[] entityKindArray = FILTRABLE_ENTITY_KINDS;
        int n = FILTRABLE_ENTITY_KINDS.length;
        int n2 = 0;
        while (n2 < n) {
            EntityKind kind = entityKindArray[n2];
            this.filterByKind(table, person, kind);
            ++n2;
        }
        return table;
    }

    private void filterByKind(TableModel table, PersonPE person, EntityKind kind) {
        List<Integer> columnsToFilter = QueryResultFilter.getColumnsToFilter(table, kind);
        Set<String> entityIdentifiers = QueryResultFilter.getValues(table, columnsToFilter);
        Map<String, SpacePE> entitySpaces = this.loadGroups(entityIdentifiers, kind);
        Iterator<TableModelRow> rowIterator = table.getRows().iterator();
        block0: while (rowIterator.hasNext()) {
            TableModelRow row = rowIterator.next();
            for (int c : columnsToFilter) {
                ISerializableComparable value = row.getValues().get(c);
                if (value == null || this.authorizationChecker.isAuthorized(person, entitySpaces.get(value.toString()), RoleWithHierarchy.SPACE_OBSERVER)) continue;
                rowIterator.remove();
                continue block0;
            }
        }
    }

    private static Set<String> getValues(TableModel table, List<Integer> columns) {
        HashSet<String> values = new HashSet<String>();
        for (TableModelRow row : table.getRows()) {
            for (int c : columns) {
                ISerializableComparable value = row.getValues().get(c);
                if (value == null) continue;
                values.add(value.toString());
            }
        }
        return values;
    }

    private static List<Integer> getColumnsToFilter(TableModel table, EntityKind kind) {
        ArrayList<Integer> columns = new ArrayList<Integer>();
        int i = 0;
        while (i < table.getHeader().size()) {
            TableModelColumnHeader header = table.getHeader().get(i);
            EntityKind headerEntityKindOrNull = header.tryGetEntityKind();
            if (headerEntityKindOrNull != null && headerEntityKindOrNull.equals(kind)) {
                columns.add(i);
            }
            ++i;
        }
        return columns;
    }

    private Map<String, SpacePE> loadGroups(Set<String> values, EntityKind kind) {
        return this.groupLoaderFactory.create(kind).loadGroups(values);
    }
}

