/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class AbandonedObjectPool
extends GenericObjectPool {
    private final AbandonedConfig config;
    private final List trace = new ArrayList();

    public AbandonedObjectPool(PoolableObjectFactory poolableObjectFactory, AbandonedConfig abandonedConfig) {
        super(poolableObjectFactory);
        this.config = abandonedConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject() throws Exception {
        Object object;
        if (this.config != null && this.config.getRemoveAbandoned() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxActive() - 3) {
            this.removeAbandoned();
        }
        if ((object = super.borrowObject()) instanceof AbandonedTrace) {
            ((AbandonedTrace)object).setStackTrace();
        }
        if (object != null && this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                this.trace.add(object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                boolean bl = this.trace.remove(object);
                if (!bl) {
                    return;
                }
            }
        }
        super.returnObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object object) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                boolean bl = this.trace.remove(object);
                if (!bl) {
                    return;
                }
            }
        }
        super.invalidateObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbandoned() {
        long l = System.currentTimeMillis();
        long l2 = l - (long)(this.config.getRemoveAbandonedTimeout() * 1000);
        ArrayList<AbandonedTrace> arrayList = new ArrayList<AbandonedTrace>();
        List list = this.trace;
        synchronized (list) {
            for (AbandonedTrace abandonedTrace : this.trace) {
                if (abandonedTrace.getLastUsed() > l2 || abandonedTrace.getLastUsed() <= 0L) continue;
                arrayList.add(abandonedTrace);
            }
        }
        for (AbandonedTrace abandonedTrace : arrayList) {
            if (this.config.getLogAbandoned()) {
                abandonedTrace.printStackTrace();
            }
            try {
                this.invalidateObject(abandonedTrace);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

