/*
 * Decompiled with CFR 0.152.
 */
package eu.basynthec.cisd.client.examples;

import ch.systemsx.cisd.openbis.dss.client.api.v1.IOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.dss.client.api.v1.OpenbisServiceFacadeFactory;
import eu.basynthec.cisd.client.examples.AbstractBaSynthecClient;
import eu.basynthec.cisd.client.examples.DataSetSearch;
import eu.basynthec.cisd.client.examples.ExperimentLister;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class BaSynthecClient
extends AbstractBaSynthecClient {
    private static final long CONNECTION_TIMEOUT_MILLIS = 15000L;

    public static void main(String[] args) {
        if (args.length < 2) {
            BaSynthecClient.printUsage();
            return;
        }
        BaSynthecClient.configureLogging();
        IOpenbisServiceFacade facade = BaSynthecClient.createServiceFacade(args);
        if (facade == null) {
            System.err.println("Authentication failed: check the user name and password.");
            System.exit(1);
            return;
        }
        BaSynthecClient newMe = new BaSynthecClient(facade);
        newMe.run();
        newMe.logout();
    }

    private static IOpenbisServiceFacade createServiceFacade(String[] args) {
        String userId = args[0];
        String userPassword = args[1];
        String serverUrl = args.length > 2 ? args[2] : "https://basynthec.ethz.ch";
        BaSynthecClient.logInfo(String.format("Connecting to the server '%s' as a user '%s'.", serverUrl, userId));
        IOpenbisServiceFacade facade = OpenbisServiceFacadeFactory.tryCreate((String)userId, (String)userPassword, (String)serverUrl, (long)15000L);
        return facade;
    }

    private static void printUsage() {
        System.err.println("Usage: <user> <password> [<openbis-server-url>]");
        System.err.println("Example: test-user my-password");
        System.err.println("Example: test-user my-password https://basynthec.ethz.ch");
        System.err.println("Example: test-user my-password http://localhost:8888");
        System.exit(1);
    }

    private static void configureLogging() {
        Properties props = new Properties();
        props.put("log4j.appender.STDOUT", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.STDOUT.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.STDOUT.layout.ConversionPattern", "%d %-5p [%t] %c - %m%n");
        props.put("log4j.rootLogger", "INFO, STDOUT");
        PropertyConfigurator.configure((Properties)props);
    }

    private BaSynthecClient(IOpenbisServiceFacade facade) {
        super(facade);
    }

    public void run() {
        List<String> projectIdentifiers = Arrays.asList("/PRIVATE/TEST");
        BaSynthecClient.logInfo("Listing experiments in projects " + projectIdentifiers + "...");
        ExperimentLister experimentLister = new ExperimentLister(this.openBis);
        experimentLister.run(projectIdentifiers);
        this.println("\n");
        List<String> strainNames = Arrays.asList("MGP100");
        BaSynthecClient.logInfo("Listing data sets containing data for strains " + strainNames + "...");
        File downloadFolder = new File("targets/downloads/");
        DataSetSearch dataSetSearch = new DataSetSearch(this.openBis, downloadFolder);
        dataSetSearch.run(strainNames);
    }

    private void logout() {
        this.openBis.logout();
    }
}

