/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.utils.Column;
import ch.systemsx.cisd.etlserver.utils.TabSeparatedValueTable;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import eu.basysbio.cisd.dss.AbstractDataValue;
import eu.basysbio.cisd.dss.ChipChipData;
import eu.basysbio.cisd.dss.ChipChipInjectionFactory;
import eu.basysbio.cisd.dss.DataColumnHeader;
import eu.basysbio.cisd.dss.HeaderUtils;
import eu.basysbio.cisd.dss.IColumnInjection;
import eu.basysbio.cisd.dss.IDatabaseFeeder;
import eu.basysbio.cisd.dss.IInjectionFactory;
import eu.basysbio.cisd.dss.ITimeSeriesDAO;
import eu.basysbio.cisd.dss.TimeSeriesColumnDescriptor;
import eu.basysbio.cisd.dss.TimeSeriesDataSetUploaderParameters;
import eu.basysbio.cisd.dss.TimeSeriesInjectionFactory;
import eu.basysbio.cisd.dss.TimeSeriesValue;
import eu.basysbio.cisd.dss.Util;
import eu.basysbio.cisd.dss.ValueGroupDescriptor;
import eu.basysbio.cisd.dss.ValueGroupIdGenerator;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DatabaseFeeder
implements IDatabaseFeeder {
    static final String UPLOADER_EMAIL_KEY = "UPLOADER_EMAIL";
    private static final int POSITION_COLUMN_INDEX = 5;
    private static final int HEIGHT_COLUMN_INDEX = 6;
    private static final int SCORE_COLUMN_INDEX = 7;
    private final ITimeSeriesDAO dao;
    private final IEncapsulatedOpenBISService service;
    private final TimeSeriesDataSetUploaderParameters parameters;
    private final ValueGroupIdGenerator valueGroupIdGenerator;
    private final Map<ExperimentIdentifier, Experiment> experimentCache = new HashMap<ExperimentIdentifier, Experiment>();

    DatabaseFeeder(ITimeSeriesDAO dao, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
        this.dao = dao;
        this.service = service;
        this.parameters = parameters;
        this.valueGroupIdGenerator = new ValueGroupIdGenerator(dao);
    }

    @Override
    public void resetValueGroupIDGenerator() {
        this.valueGroupIdGenerator.clear();
    }

    @Override
    public void feedDatabase(DataSetInformation dataSetInformation, Reader reader, String nameOfReaderSource) {
        this.feedDatabase(dataSetInformation, reader, nameOfReaderSource, null);
    }

    @Override
    public void feedDatabase(DataSetInformation dataSetInformation, Reader reader, String nameOfReaderSource, String biIdOrNull) {
        TabSeparatedValueTable table = new TabSeparatedValueTable(reader, nameOfReaderSource, this.parameters.isIgnoreEmptyLines(), true, false);
        List columns = table.getColumns();
        this.feedDatabase(dataSetInformation, columns, biIdOrNull);
    }

    private void feedDatabase(DataSetInformation dataSetInformation, List<Column> columns, String biIdOrNull) {
        this.assertExperiment(dataSetInformation, columns);
        long dataSetID = this.getOrCreateDataSet(dataSetInformation);
        String dataSetType = dataSetInformation.getDataSetType().getCode();
        if (dataSetType.equals("CHIP_CHIP")) {
            this.feedDatabaseWithChipChipData(columns, dataSetID);
        } else {
            this.feedDatabaseWithTimeSeriesData(columns, dataSetID, biIdOrNull);
        }
    }

    private void feedDatabaseWithTimeSeriesData(List<Column> columns, long dataSetID, String biIdOrNull) {
        List<IColumnInjection<TimeSeriesValue>> columnInjections = this.createInjections(columns, TimeSeriesInjectionFactory.values());
        ArrayList<TimeSeriesValue> dataValues = new ArrayList<TimeSeriesValue>();
        HashSet<DataColumnHeader> headers = new HashSet<DataColumnHeader>();
        int colIndex = 0;
        while (colIndex < columns.size()) {
            Column column = columns.get(colIndex);
            String header = column.getHeader();
            if (HeaderUtils.isDataColumnHeader(header)) {
                TimeSeriesValue timeSeriesValue = new TimeSeriesValue();
                timeSeriesValue.setColumnIndex(colIndex);
                DataColumnHeader dataColumnHeader = new DataColumnHeader(header);
                this.assertUniqueDataColumnHeader(dataColumnHeader, biIdOrNull, headers, new DataSetProviderForTimeSeriesData());
                ValueGroupDescriptor valueGroupDescriptor = new ValueGroupDescriptor(dataColumnHeader);
                timeSeriesValue.setValueGroupId(this.valueGroupIdGenerator.getValueGroupIdFor(valueGroupDescriptor));
                timeSeriesValue.setDescriptor(new TimeSeriesColumnDescriptor(valueGroupDescriptor, dataColumnHeader));
                int i = 0;
                int n = column.getValues().size();
                while (i < n) {
                    Double value = Util.parseDouble(column, i);
                    dataValues.add(timeSeriesValue.createFor(i, value, columnInjections));
                    ++i;
                }
            }
            ++colIndex;
        }
        String identifierType = columns.get(0).getHeader();
        this.dao.insertTimeSeriesValues(dataSetID, identifierType, dataValues);
    }

    private void feedDatabaseWithChipChipData(List<Column> columns, long dataSetID) {
        List<IColumnInjection<ChipChipData>> columnInjections = this.createInjections(columns, ChipChipInjectionFactory.values());
        ArrayList<ChipChipData> dataValues = new ArrayList<ChipChipData>();
        ChipChipData chipChipData = new ChipChipData();
        TimeSeriesColumnDescriptor peakColumnDescriptor = this.createDataColumnDescriptor(columns, 5);
        chipChipData.setDescriptor(peakColumnDescriptor);
        chipChipData.setChipPeakPositionScale(peakColumnDescriptor.getScale());
        chipChipData.setChipLocalHeightScale(this.createDataColumnDescriptor(columns, 6).getScale());
        chipChipData.setChipScoreScale(this.createDataColumnDescriptor(columns, 7).getScale());
        Column positions = columns.get(5);
        Column heights = columns.get(6);
        Column scores = columns.get(7);
        int rowIndex = 0;
        int n = positions.getValues().size();
        while (rowIndex < n) {
            Integer position = Util.parseInteger(positions, rowIndex);
            Double height = Util.parseDouble(heights, rowIndex);
            Double score = Util.parseDouble(scores, rowIndex);
            dataValues.add(chipChipData.createFor(rowIndex, position, height, score, columnInjections));
            ++rowIndex;
        }
        this.dao.insertChipChipValues(dataSetID, dataValues);
    }

    private TimeSeriesColumnDescriptor createDataColumnDescriptor(List<Column> columns, int columnIndex) {
        Column column = columns.get(columnIndex);
        DataColumnHeader dataColumnHeader = new DataColumnHeader(column.getHeader());
        this.assertUniqueDataColumnHeader(dataColumnHeader, null, new HashSet<DataColumnHeader>(), new DataSetProviderForChipChipData());
        ValueGroupDescriptor valueGroupDescriptor = new ValueGroupDescriptor(dataColumnHeader);
        return new TimeSeriesColumnDescriptor(valueGroupDescriptor, dataColumnHeader);
    }

    private <T extends AbstractDataValue> List<IColumnInjection<T>> createInjections(List<Column> columns, IInjectionFactory<T>[] enums) {
        ArrayList<IColumnInjection<T>> columnInjections = new ArrayList<IColumnInjection<T>>();
        IInjectionFactory<T>[] iInjectionFactoryArray = enums;
        int n = enums.length;
        int n2 = 0;
        while (n2 < n) {
            IInjectionFactory<T> factory = iInjectionFactoryArray[n2];
            IColumnInjection<T> injection = factory.tryToCreate(columns);
            if (injection != null) {
                columnInjections.add(injection);
            }
            ++n2;
        }
        return columnInjections;
    }

    private void assertUniqueDataColumnHeader(DataColumnHeader dataColumnHeader, String biIdOrNull, Set<DataColumnHeader> headers, IDataSetProvider dataSetProvider) {
        if (headers.contains(dataColumnHeader)) {
            throw new UserFailureException("Data column '" + dataColumnHeader + "' appears twice.");
        }
        List<String> dataSets = dataSetProvider.getDataSetsByDataColumnHeader(dataColumnHeader);
        if (biIdOrNull != null) {
            Set<String> biIds = this.dao.getIdentifiersForTimeSeriesDataSet(dataSets.toArray(new String[dataSets.size()]));
            if (biIds.contains(biIdOrNull)) {
                throw new UserFailureException("The data sets " + dataSets + " measure the identifiers " + biIds + " for data column '" + dataColumnHeader + "', which duplicates time series measurements for identifier " + biIdOrNull);
            }
        } else if (!dataSets.isEmpty()) {
            throw new UserFailureException("For data column '" + dataColumnHeader + "' following data sets have already been registered: " + dataSets);
        }
        headers.add(dataColumnHeader);
    }

    private void assertExperiment(DataSetInformation dataSetInformation, List<Column> columns) {
        String code = dataSetInformation.getExperimentIdentifier().getExperimentCode();
        LinkedHashSet<String> invalidExperimentCodes = new LinkedHashSet<String>();
        LinkedHashSet<String> experimentCodes = new LinkedHashSet<String>();
        for (Column column : columns) {
            String header = column.getHeader();
            if (!HeaderUtils.isDataColumnHeader(header)) continue;
            DataColumnHeader dataColumnHeader = new DataColumnHeader(header);
            String experimentCode = this.createExperimentCode(dataColumnHeader);
            experimentCodes.add(experimentCode);
            if (code.equalsIgnoreCase(experimentCode)) continue;
            invalidExperimentCodes.add(experimentCode);
        }
        if (!invalidExperimentCodes.isEmpty()) {
            if (experimentCodes.size() == 1 && invalidExperimentCodes.size() == 1) {
                throw new UserFailureException("Data should be uploaded for experiment '" + (String)invalidExperimentCodes.iterator().next() + "' instead of '" + code + "'.");
            }
            throw new UserFailureException("Data columns found for more than one experiment: " + experimentCodes);
        }
    }

    private long getOrCreateDataSet(DataSetInformation dataSetInformation) {
        ExperimentIdentifier experimentIdentifier = dataSetInformation.getExperimentIdentifier();
        Experiment experiment = this.tryToGetExperiment(experimentIdentifier);
        if (experiment == null) {
            throw new UserFailureException("Unknown experiment: " + experimentIdentifier);
        }
        String dataSetCode = dataSetInformation.getDataSetCode();
        Long dataSetID = this.dao.tryToGetDataSetIDByPermID(dataSetCode);
        if (dataSetID == null) {
            String eMailAddress = this.getUploaderEMailAddress(dataSetInformation);
            dataSetID = this.dao.createDataSet(dataSetCode, eMailAddress, experiment);
        }
        return dataSetID;
    }

    private String getUploaderEMailAddress(DataSetInformation dataSetInformation) {
        List properties = dataSetInformation.getDataSetProperties();
        for (NewProperty property : properties) {
            if (!property.getPropertyCode().equals(UPLOADER_EMAIL_KEY)) continue;
            return property.getValue();
        }
        throw new IllegalArgumentException("No uploader email address specified: " + dataSetInformation);
    }

    private String createExperimentCode(DataColumnHeader dataColumnHeader) {
        return this.parameters.getExperimentCodeFormat().format(new Object[]{dataColumnHeader.getExperimentCode(), dataColumnHeader.getCultivationMethod(), dataColumnHeader.getBiologicalReplicateCode()});
    }

    private Experiment tryToGetExperiment(ExperimentIdentifier experimentIdentifier) {
        Experiment experiment = this.experimentCache.get(experimentIdentifier);
        if (experiment == null) {
            experiment = this.service.tryGetExperiment(experimentIdentifier);
            this.experimentCache.put(experimentIdentifier, experiment);
        }
        return experiment;
    }

    private final class DataSetProviderForChipChipData
    implements IDataSetProvider {
        private DataSetProviderForChipChipData() {
        }

        @Override
        public List<String> getDataSetsByDataColumnHeader(DataColumnHeader dataColumnHeader) {
            return DatabaseFeeder.this.dao.listDataSetsByChipChipDataColumnHeader(dataColumnHeader);
        }
    }

    private final class DataSetProviderForTimeSeriesData
    implements IDataSetProvider {
        private DataSetProviderForTimeSeriesData() {
        }

        @Override
        public List<String> getDataSetsByDataColumnHeader(DataColumnHeader dataColumnHeader) {
            return DatabaseFeeder.this.dao.listDataSetsByTimeSeriesDataColumnHeader(dataColumnHeader);
        }
    }

    private static interface IDataSetProvider {
        public List<String> getDataSetsByDataColumnHeader(DataColumnHeader var1);
    }
}

