/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.cli;

import ch.systemsx.cisd.cina.client.util.v1.ICinaUtilities;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.v1.FileInfoDssDownloader;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.util.Collections;
import java.util.List;

class ReplicaDownloader {
    private final ICinaUtilities component;
    private final SampleIdentifier replicaIdentifier;
    private final File outputDir;

    ReplicaDownloader(ICinaUtilities component, String replicaIdentifier, File outputDir) {
        this.component = component;
        this.replicaIdentifier = SampleIdentifierFactory.parse((String)replicaIdentifier);
        this.outputDir = outputDir;
    }

    protected void download() {
        Sample replicaSample = this.searchForSample(this.replicaIdentifier);
        this.downloadReplica(replicaSample);
    }

    private void downloadReplica(Sample replicaSample) {
        List<DataSet> dataSets = this.component.listDataSets(Collections.singletonList(replicaSample));
        DataSet mostRecentMetadata = null;
        for (DataSet dataSet : dataSets) {
            String typeCode = dataSet.getDataSetTypeCode();
            if (typeCode.equals("RAW_IMAGES")) {
                this.downloadDataSet(dataSet, "RawData");
            }
            if (!typeCode.equals("METADATA")) continue;
            mostRecentMetadata = this.compareReturningMoreRecent(mostRecentMetadata, dataSet);
        }
        if (mostRecentMetadata != null) {
            this.downloadDataSet(mostRecentMetadata, "Annotations");
        }
    }

    private DataSet compareReturningMoreRecent(DataSet mostRecentReplicaMetadata, DataSet dataSet) {
        if (mostRecentReplicaMetadata == null) {
            return dataSet;
        }
        if (mostRecentReplicaMetadata.getRegistrationDate().compareTo(dataSet.getRegistrationDate()) < 0) {
            return dataSet;
        }
        return mostRecentReplicaMetadata;
    }

    private Sample searchForSample(SampleIdentifier identifier) {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch((SearchCriteria.MatchClauseAttribute)SearchCriteria.MatchClauseAttribute.CODE, (String)identifier.getSampleCode()));
        List<Sample> samples = this.component.searchForSamples(searchCriteria);
        if (samples.size() < 1) {
            throw new UserFailureException("No sample with specified code.");
        }
        if (samples.size() > 1) {
            throw new EnvironmentFailureException("Found multiple matching samples -- this should not happen. Please contact administrator to resolve this problem.");
        }
        return samples.get(0);
    }

    private void downloadDataSet(DataSet dataSet, String subfolderNameOrNull) {
        IDataSetDss dataSetDss = this.component.getDataSet(dataSet.getCode());
        FileInfoDssDTO[] fileInfos = dataSetDss.listFiles("original/", true);
        File targetDir = subfolderNameOrNull != null ? new File(this.outputDir, subfolderNameOrNull) : this.outputDir;
        FileInfoDssDownloader downloader = new FileInfoDssDownloader(dataSetDss, fileInfos, targetDir, (FileInfoDssDownloader.FileInfoDssDownloaderListener)new DownloaderListener(targetDir));
        downloader.downloadFiles();
    }

    private static class DownloaderListener
    implements FileInfoDssDownloader.FileInfoDssDownloaderListener {
        private final File targetDir;

        DownloaderListener(File targetDir) {
            this.targetDir = targetDir;
        }

        public void willDownload(FileInfoDssDTO fileInfo) {
            System.out.println("downloading " + this.getPathForFileInfo(fileInfo));
        }

        public void willCreateDirectory(FileInfoDssDTO fileInfo) {
            System.out.println("mkdir " + this.getPathForFileInfo(fileInfo));
        }

        public void didFinish() {
            System.out.println("Finished.");
        }

        private String getPathForFileInfo(FileInfoDssDTO fileInfo) {
            return String.valueOf(this.targetDir.getPath()) + "/" + fileInfo.getPathInListing();
        }
    }
}

