/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.yeastx.server;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDatasetDownloadServlet;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.yeastx.db.DBUtils;
import ch.systemsx.cisd.yeastx.eicml.ChromatogramDTO;
import ch.systemsx.cisd.yeastx.eicml.EICMLChromatogramImageGenerator;
import ch.systemsx.cisd.yeastx.eicml.IEICMSRunDAO;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;

public class EICMLChromatogramGeneratorServlet
extends AbstractDatasetDownloadServlet {
    private static final long serialVersionUID = 1L;
    public static final String DATASET_CODE_PARAM = "dataset";
    public static final String CHROMATOGRAM_CODE_PARAM = "chromatogram";
    public static final String IMAGE_WIDTH_PARAM = "w";
    public static final String IMAGE_HEIGHT_PARAM = "h";
    public static final int DEFAULT_WIDTH = 300;
    public static final int DEFAULT_HEIGHT = 200;
    private DataSource dataSource;

    protected synchronized void doSpecificInitialization(Enumeration<String> parameterNames, ServletConfig servletConfig) {
        if (this.dataSource != null) {
            return;
        }
        String dataSourceName = servletConfig.getInitParameter("data-source");
        if (dataSourceName == null) {
            throw new ConfigurationFailureException("Data source not defined.");
        }
        this.dataSource = ServiceProvider.getDataSourceProvider().getDataSource(dataSourceName);
    }

    private IEICMSRunDAO createQuery() {
        return DBUtils.getQuery(this.dataSource, IEICMSRunDAO.class);
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RequestParams params = new RequestParams(request);
            String sessionId = params.getSessionId();
            String datasetCode = params.getDatasetCode();
            int height = params.getHeight();
            int width = params.getWidth();
            HttpSession session = this.tryGetOrCreateSession(request, sessionId);
            if (session == null) {
                EICMLChromatogramGeneratorServlet.printSessionExpired((HttpServletResponse)response);
                return;
            }
            this.ensureDatasetAccessible(datasetCode, session, sessionId);
            ChromatogramDTO chromatogram = this.getChromatogramForParameters(params);
            EICMLChromatogramImageGenerator generator = new EICMLChromatogramImageGenerator(chromatogram, (OutputStream)response.getOutputStream(), width, height);
            generator.generateImage();
        }
        catch (Exception e) {
            operationLog.error((Object)"", (Throwable)e);
            EICMLChromatogramGeneratorServlet.printErrorResponse((HttpServletResponse)response, (String)"Invalid Request");
        }
    }

    private ChromatogramDTO getChromatogramForParameters(RequestParams params) {
        IEICMSRunDAO query = this.createQuery();
        try {
            ChromatogramDTO chromatogram;
            long chromatogramId = params.getChromatogramId();
            ChromatogramDTO chromatogramDTO = chromatogram = query.getChromatogramById(chromatogramId);
            return chromatogramDTO;
        }
        finally {
            query.close();
        }
    }

    private static class RequestParams {
        private final String sessionId;
        private final String datasetCode;
        private final long chromatogramId;
        private final int width;
        private final int height;

        public RequestParams(HttpServletRequest request) {
            this.sessionId = RequestParams.getParam(request, "sessionID");
            this.datasetCode = RequestParams.getParam(request, EICMLChromatogramGeneratorServlet.DATASET_CODE_PARAM);
            this.chromatogramId = RequestParams.getLongParam(request, EICMLChromatogramGeneratorServlet.CHROMATOGRAM_CODE_PARAM);
            this.width = RequestParams.getIntParam(request, EICMLChromatogramGeneratorServlet.IMAGE_WIDTH_PARAM, 300);
            this.height = RequestParams.getIntParam(request, EICMLChromatogramGeneratorServlet.IMAGE_HEIGHT_PARAM, 200);
        }

        private static int getIntParam(HttpServletRequest request, String paramName, int defaultValue) {
            String value = request.getParameter(paramName);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UserFailureException("parameter " + paramName + " should be an integer, but is: " + value);
            }
        }

        private static long getLongParam(HttpServletRequest request, String paramName) {
            String value = RequestParams.getParam(request, paramName);
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UserFailureException("parameter " + paramName + " should be an integer, but is: " + value);
            }
        }

        private static String getParam(HttpServletRequest request, String paramName) {
            String value = request.getParameter(paramName);
            if (value == null) {
                throw new UserFailureException("no value for the parameter " + paramName + " found in the URL");
            }
            return value;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getDatasetCode() {
            return this.datasetCode;
        }

        long getChromatogramId() {
            return this.chromatogramId;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

