/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.fileconverter;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.fileconverter.IFileConversionMethod;
import ch.systemsx.cisd.common.fileconverter.IFileConversionStrategy;
import ch.systemsx.cisd.common.fileconverter.ImageMagickTiffToPngConverter;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class Tiff2PngConversionStrategy
implements IFileConversionStrategy {
    private final boolean deleteOriginalFile;
    private final IFileConversionMethod method;

    public Tiff2PngConversionStrategy(String transparentColorOrNull, int page, boolean deleteOriginalFile) throws EnvironmentFailureException {
        this.deleteOriginalFile = deleteOriginalFile;
        this.method = new ImageMagickTiffToPngConverter(transparentColorOrNull, page);
        if (!this.method.isAvailable()) {
            throw new EnvironmentFailureException("No suitable converter method found");
        }
    }

    public Tiff2PngConversionStrategy(String transparentColorOrNull, int page) throws EnvironmentFailureException {
        this(transparentColorOrNull, page, false);
    }

    public Tiff2PngConversionStrategy(String transparentColorOrNull) throws EnvironmentFailureException {
        this(transparentColorOrNull, 0, false);
    }

    public Tiff2PngConversionStrategy() throws EnvironmentFailureException {
        this(null, 0, false);
    }

    @Override
    public File tryCheckConvert(File inFile) {
        String ext = FilenameUtils.getExtension((String)inFile.getName()).toLowerCase();
        if ("tiff".equals(ext) || "tif".equals(ext)) {
            return new File(inFile.getParent(), String.valueOf(FilenameUtils.getBaseName((String)inFile.getName())) + ".png");
        }
        return null;
    }

    @Override
    public boolean deleteOriginalFile() {
        return this.deleteOriginalFile;
    }

    @Override
    public IFileConversionMethod getConverter() {
        return this.method;
    }
}

