/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SharesHolder;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SpeedUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class ShareFactory {
    @Private
    static final String SPEED_FILE = "speed";
    public static final String SHARE_PROPS_FILE = "share.properties";
    @Private
    static final String SPEED_HINT_PROP = "speed";
    @Private
    static final String SHUFFLE_PRIORITY_PROP = "shuffle-priority";
    public static final String WITHDRAW_SHARE_PROP = "withdraw-share";
    public static final String IGNORED_FOR_SHUFFLING_PROP = "ignored-for-shuffling";
    public static final String UNARCHIVING_SCRATCH_SHARE_PROP = "unarchiving-scratch-share";
    public static final String EXPERIMENTS_PROP = "experiments";
    private int speed = Math.abs(-50);
    private Share.ShufflePriority shufflePriority = Share.ShufflePriority.SPEED;
    private boolean withdrawShare;
    private boolean ignoredForShuffling;
    private boolean unarchivingScratchShare;
    private Set<String> experimentIdentifiers = Collections.emptySet();

    Share createShare(SharesHolder sharesHolder, File shareRoot, IFreeSpaceProvider freeSpaceProvider, ISimpleLogger log) {
        this.readSpeedFile(shareRoot, log);
        this.readSharePropertiesFile(shareRoot, log);
        Share share = new Share(sharesHolder, shareRoot, this.speed, freeSpaceProvider);
        share.setShufflePriority(this.shufflePriority);
        share.setWithdrawShare(this.withdrawShare);
        share.setUnarchivingScratchShare(this.unarchivingScratchShare);
        share.setIgnoredForShuffling(this.ignoredForShuffling);
        share.setExperimentIdentifiers(this.experimentIdentifiers);
        return share;
    }

    Share createShare(File shareRoot, IFreeSpaceProvider freeSpaceProvider, ISimpleLogger log) {
        return this.createShare(null, shareRoot, freeSpaceProvider, log);
    }

    private void readSharePropertiesFile(File shareRoot, ISimpleLogger log) {
        File propsFile = new File(shareRoot, SHARE_PROPS_FILE);
        if (propsFile.isFile()) {
            String errorMsg;
            Properties props = this.loadShareProperties(propsFile, log);
            if (props.containsKey("speed")) {
                String speedHintProp = props.getProperty("speed");
                try {
                    this.speed = SpeedUtils.trim(Integer.parseInt(speedHintProp));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    errorMsg = String.format("The value for property (%s) in file (%s) must be a number : (%s)", "speed", propsFile.getAbsolutePath(), speedHintProp);
                    log.log(LogLevel.WARN, errorMsg);
                }
            }
            if (props.containsKey(SHUFFLE_PRIORITY_PROP)) {
                String shufflePriorityProp = props.getProperty(SHUFFLE_PRIORITY_PROP);
                try {
                    this.shufflePriority = Share.ShufflePriority.valueOf(shufflePriorityProp.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    errorMsg = String.format("Invalid value for property (%s) in file (%s) : (%s)", SHUFFLE_PRIORITY_PROP, propsFile.getAbsolutePath(), shufflePriorityProp);
                    log.log(LogLevel.WARN, errorMsg);
                }
            }
            this.withdrawShare = PropertyUtils.getBoolean(props, WITHDRAW_SHARE_PROP, false);
            this.ignoredForShuffling = PropertyUtils.getBoolean(props, IGNORED_FOR_SHUFFLING_PROP, false);
            this.unarchivingScratchShare = PropertyUtils.getBoolean(props, UNARCHIVING_SCRATCH_SHARE_PROP, false);
            this.experimentIdentifiers = new HashSet<String>(Arrays.asList(PropertyParametersUtil.parseItemisedProperty(props.getProperty(EXPERIMENTS_PROP, ""), EXPERIMENTS_PROP)));
        }
    }

    private Properties loadShareProperties(File propsFile, ISimpleLogger log) {
        Properties props;
        block5: {
            props = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(propsFile);
                    props.load(fis);
                }
                catch (IOException ioex) {
                    log.log(LogLevel.WARN, "Error while reading from " + propsFile.getAbsolutePath() + " : " + ioex.getMessage());
                    IOUtils.closeQuietly((InputStream)fis);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        return props;
    }

    private void readSpeedFile(File shareRoot, ISimpleLogger log) {
        File speedFile = new File(shareRoot, "speed");
        if (speedFile.isFile()) {
            String value = FileUtilities.loadToString(speedFile).trim();
            try {
                this.speed = SpeedUtils.trim(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                log.log(LogLevel.WARN, "Speed file " + speedFile + " doesn't contain a number: " + value);
            }
        }
    }
}

