/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.concurrent.ExecutionResult;
import ch.systemsx.cisd.common.concurrent.ExecutionStatus;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class ProcessResult {
    public static final int EXIT_VALUE_OK = 0;
    public static final int NO_EXIT_VALUE = -1;
    private static final int EXIT_VALUE_FOR_TERMINATION_WINDOWS = 1;
    private static final int EXIT_VALUE_FOR_TERMINATION_UNIX = 143;
    private final ExecutionStatus status;
    private final String startupFailureMessage;
    private final int exitValue;
    private final List<String> commandLine;
    private final String commandName;
    private final int processNumber;
    private final Logger operationLog;
    private final Logger machineLog;
    private final boolean outputAvailable;
    private final List<String> output;
    private final byte[] binaryOutput;
    private final List<String> errorOutput;
    private final boolean isBinaryOutput;
    private final ExecutionResult<?> processIOResult;

    public static boolean isProcessTerminated(int exitValue) {
        if (OSUtilities.isWindows()) {
            return exitValue == 1;
        }
        return exitValue == 143;
    }

    public static boolean isProcessOK(int exitValue) {
        return exitValue == 0;
    }

    public ProcessResult(List<String> commandLine, int processNumber, ExecutionStatus status, ExecutionResult<?> processIOResult, String startupFailureMessageOrNull, int exitValue, List<String> processOutputOrNull, List<String> processErrorOutputOrNull, Logger operationLog, Logger machineLog) {
        this.commandLine = commandLine;
        this.commandName = ProcessExecutionHelper.getCommandName(commandLine);
        this.processNumber = processNumber;
        this.status = status;
        this.processIOResult = processIOResult;
        this.startupFailureMessage = startupFailureMessageOrNull == null ? "" : startupFailureMessageOrNull;
        this.exitValue = exitValue;
        this.isBinaryOutput = false;
        this.outputAvailable = processOutputOrNull != null;
        this.output = this.outputAvailable ? Collections.unmodifiableList(processOutputOrNull) : Collections.emptyList();
        this.errorOutput = processErrorOutputOrNull;
        this.binaryOutput = null;
        this.operationLog = operationLog;
        this.machineLog = machineLog;
    }

    public ProcessResult(List<String> commandLine, int processNumber, ExecutionStatus status, ExecutionResult<?> processIOResult, String startupFailureMessageOrNull, int exitValue, byte[] processBinaryOutputOrNull, List<String> processErrorOutputOrNull, Logger operationLog, Logger machineLog) {
        this.commandLine = commandLine;
        this.commandName = ProcessExecutionHelper.getCommandName(commandLine);
        this.processNumber = processNumber;
        this.status = status;
        this.processIOResult = processIOResult;
        this.startupFailureMessage = startupFailureMessageOrNull == null ? "" : startupFailureMessageOrNull;
        this.exitValue = exitValue;
        this.isBinaryOutput = true;
        boolean bl = this.outputAvailable = processBinaryOutputOrNull != null;
        if (this.outputAvailable) {
            this.errorOutput = processErrorOutputOrNull == null ? Collections.emptyList() : Collections.unmodifiableList(processErrorOutputOrNull);
            this.binaryOutput = processBinaryOutputOrNull;
        } else {
            this.errorOutput = Collections.emptyList();
            this.binaryOutput = new byte[0];
        }
        this.output = null;
        this.operationLog = operationLog;
        this.machineLog = machineLog;
    }

    public List<String> getCommandLine() {
        return this.commandLine;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public int getProcessNumber() {
        return this.processNumber;
    }

    public boolean isOutputAvailable() {
        return this.outputAvailable;
    }

    public boolean isBinaryOutput() {
        return this.isBinaryOutput;
    }

    public byte[] getBinaryOutput() {
        return this.binaryOutput;
    }

    public List<String> getErrorOutput() {
        return this.errorOutput;
    }

    public Status toStatus() {
        if (this.isOK()) {
            return Status.OK;
        }
        if (this.isTimedOut()) {
            return Status.createRetriableError("Process timed out");
        }
        if (this.isInterruped()) {
            return Status.createRetriableError("Process got interrupted");
        }
        if (!StringUtils.isBlank((String)this.getStartupFailureMessage())) {
            return Status.createError(this.getStartupFailureMessage());
        }
        List<String> statusOutput = this.getErrorOutput();
        if (statusOutput.isEmpty()) {
            statusOutput = this.getOutput();
        }
        return Status.createError((String.valueOf(StringUtils.join(this.getCommandLine(), (String)" ").trim()) + "\n  " + "Exit Value: " + this.getExitValue() + "\n  " + StringUtils.join(statusOutput, (String)"\n")).trim());
    }

    public List<String> getOutput() {
        return this.output;
    }

    public ExecutionResult<?> getProcessIOResult() {
        return this.processIOResult;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getStartupFailureMessage() {
        return this.startupFailureMessage;
    }

    public boolean isOK() {
        return ProcessResult.isProcessOK(this.exitValue) && this.processIOResult.isOK();
    }

    public boolean isOKIgnoreIO() {
        return ProcessResult.isProcessOK(this.exitValue);
    }

    public boolean isRun() {
        return StringUtils.isBlank((String)this.startupFailureMessage);
    }

    public boolean isTerminated() {
        return ProcessResult.isProcessTerminated(this.getExitValue());
    }

    public boolean isTimedOut() {
        return ExecutionStatus.TIMED_OUT.equals((Object)this.status);
    }

    public boolean isInterruped() {
        return ExecutionStatus.INTERRUPTED.equals((Object)this.status);
    }

    public void log() {
        if (!this.isOK()) {
            this.log(Level.WARN);
        } else if (this.operationLog.isDebugEnabled()) {
            this.logProcessExitValue(Level.DEBUG);
            this.logProcessOutput(Level.DEBUG);
        }
    }

    public void logAsInfo() {
        this.log(Level.INFO);
    }

    private void log(Level level) {
        this.logCommandLine(level);
        this.logProcessExitValue(level);
        this.logProcessOutput(level);
    }

    private void logCommandLine(Level logLevel) {
        this.operationLog.log(logLevel, String.format("P%d-{%s} had command line: %s", this.processNumber, this.commandName, this.getCommandLine()));
    }

    private void logProcessExitValue(Level logLevel) {
        if (!this.isRun()) {
            this.operationLog.log(logLevel, String.format("P%d-{%s} process has not started up: '%s'.", this.processNumber, this.commandName, this.startupFailureMessage));
        } else if (this.isTimedOut()) {
            this.operationLog.log(logLevel, String.format("P%d-{%s} process has timed out.", this.processNumber, this.commandName));
        } else if (this.isInterruped()) {
            this.operationLog.log(logLevel, String.format("P%d-{%s} thread was interrupted.", this.processNumber, this.commandName));
        } else if (this.isTerminated()) {
            this.operationLog.log(logLevel, String.format("P%d-{%s} process was terminated.", this.processNumber, this.commandName));
        } else {
            this.operationLog.log(logLevel, String.format("P%d-{%s} process returned with exit value %d.", this.processNumber, this.commandName, this.getExitValue()));
        }
    }

    private void logProcessOutput(Level logLevel) {
        block6: {
            block5: {
                List<String> processErrorOutputLines;
                assert (logLevel != null);
                if (!this.isBinaryOutput) break block5;
                if (this.getBinaryOutput().length != 0) {
                    this.machineLog.log(logLevel, String.format("[%s] output: %d bytes", this.commandName, this.getBinaryOutput().length));
                }
                if ((processErrorOutputLines = this.getErrorOutput()).size() <= 0) break block6;
                this.machineLog.log(logLevel, String.format("[%s] error output:", this.commandName));
                for (String ln : processErrorOutputLines) {
                    if (ln.trim().length() <= 0) continue;
                    this.machineLog.log(logLevel, String.format("\"%s\"", ln));
                }
                break block6;
            }
            List<String> processOutputLines = this.getOutput();
            if (processOutputLines.size() == 0) {
                return;
            }
            this.machineLog.log(logLevel, String.format("[%s] output:", this.commandName));
            for (String ln : processOutputLines) {
                if (ln.trim().length() <= 0) continue;
                this.machineLog.log(logLevel, String.format("\"%s\"", ln));
            }
        }
    }
}

