/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation.client;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ServiceExecutionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String serviceConversationId;
    private final String description;

    ServiceExecutionException(String serviceConversationId, String description) {
        super(String.valueOf(description) + "(service conversation " + serviceConversationId + ")");
        this.serviceConversationId = serviceConversationId;
        this.description = description;
    }

    public String getServiceConversationId() {
        return this.serviceConversationId;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return "ServiceExecutionException [serviceConversationId=" + this.serviceConversationId + ", description=" + this.description + "]";
    }

    @Override
    public void printStackTrace() {
        System.err.println(this.getMessage());
        System.err.println(this.getDescription());
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.println(this.getMessage());
        s.println(this.getDescription());
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.println(this.getMessage());
        s.println(this.getDescription());
    }

    public static String getDescriptionFromException(Throwable th) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        th.printStackTrace(pw);
        pw.close();
        String errorMessage = new String(os.toByteArray());
        return errorMessage;
    }
}

