/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.security.PasswordGenerator;
import ch.systemsx.cisd.openbis.installer.izpack.PostgresInstallationDetectorUtils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import java.io.File;

public class GlobalInstallationContext {
    public static final String POSTGRES_BIN_VARNAME = "POSTGRES_BIN";
    public static final String ADMIN_PASSWORD_VARNAME = "ADMIN_PASSWORD";
    public static final String ETL_SERVER_PASSWORD_VARNAME = "ETLSERVER_PASSWORD";
    public static final String KEY_STORE_FILE_VARNAME = "KEY_STORE_FILE";
    public static final String KEY_STORE_PASSWORD_VARNAME = "KEY_STORE_PASSWORD";
    public static final String KEY_PASSWORD_VARNAME = "KEY_PASSWORD";
    public static final String DATA_DIR_VARNAME = "DSS_ROOT_DIR";
    public static final String BACKUP_FOLDER_VARNAME = "BACKUP_FOLDER";
    public static final String TECHNOLOGY_PROTEOMICS = "PROTEOMICS";
    public static final String TECHNOLOGY_SCREENING = "SCREENING";
    public static final String TECHNOLOGY_ILLUMINA_NGS = "ILLUMINA-NGS";
    public static final String PATHINFO_DB_ENABLED = "PATHINFO_DB_ENABLED";
    public static final String[] TECHNOLOGIES = new String[]{"PROTEOMICS", "SCREENING", "ILLUMINA-NGS"};
    public static boolean isUpdateInstallation = false;
    public static boolean isUpdateInstallationWithoutDatabaseSelection = false;
    public static boolean isUpdateInstallationWithDatabaseSelection = false;
    public static boolean isFirstTimeInstallation = true;
    public static boolean noPsqlToolsOnPath = !PostgresInstallationDetectorUtils.areCommandLineToolsOnPath();
    public static boolean presentKeyStoreFile = false;
    public static File installDir;

    public static void initialize(AutomatedInstallData data) {
        String installPath = data.getInstallPath();
        installDir = new File(installPath);
        isUpdateInstallation = GlobalInstallationContext.installationExists();
        isFirstTimeInstallation = !isUpdateInstallation;
        String postgresBinPath = "";
        if (!isFirstTimeInstallation) {
            String backupScript;
            boolean canBackupDatabasesSelectively;
            File pathFile = new File(installDir, "bin/postgres_bin_path.txt");
            if (pathFile.isFile()) {
                postgresBinPath = FileUtilities.loadToString(pathFile).trim();
            }
            if (canBackupDatabasesSelectively = (backupScript = FileUtilities.loadToString(new File(installDir, "bin/backup-installation.sh"))).contains("DATABASES_TO_BACKUP")) {
                isUpdateInstallationWithDatabaseSelection = true;
            } else {
                isUpdateInstallationWithoutDatabaseSelection = true;
            }
        }
        data.setVariable(POSTGRES_BIN_VARNAME, postgresBinPath);
        if (isFirstTimeInstallation) {
            GlobalInstallationContext.populateFirstTimeInstallVariables(data);
        }
    }

    private static boolean installationExists() {
        if (!installDir.exists()) {
            return false;
        }
        File[] files = installDir.listFiles();
        boolean binExists = false;
        boolean serversExists = false;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                if (fileName.equals("bin")) {
                    binExists = true;
                }
                if (fileName.equals("servers")) {
                    serversExists = true;
                }
                ++n2;
            }
        }
        return binExists && serversExists;
    }

    public static String getDataDir(AutomatedInstallData data) {
        return data.getVariable(DATA_DIR_VARNAME);
    }

    private static void populateFirstTimeInstallVariables(AutomatedInstallData data) {
        data.setVariable(ETL_SERVER_PASSWORD_VARNAME, new PasswordGenerator(true).generatePassword());
    }
}

