/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.substitutor;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum SubstitutionType {
    TYPE_PLAIN("plain"),
    TYPE_JAVA_PROPERTIES("javaprop"),
    TYPE_XML("xml"),
    TYPE_SHELL("shell"),
    TYPE_AT("at"),
    TYPE_JAVA("java"),
    TYPE_ANT("ant");

    private String type;
    private static Map<String, SubstitutionType> lookup;

    static {
        lookup = new HashMap<String, SubstitutionType>();
        for (SubstitutionType substitutionType : EnumSet.allOf(SubstitutionType.class)) {
            lookup.put(substitutionType.getType(), substitutionType);
        }
    }

    private SubstitutionType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static final SubstitutionType getDefault() {
        return TYPE_PLAIN;
    }

    public static SubstitutionType lookup(String typeString) {
        if (lookup.containsKey(typeString)) {
            return lookup.get(typeString);
        }
        return SubstitutionType.getDefault();
    }
}

