/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.variable.ZipEntryConfigFileValue;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

public class JarEntryConfigValue
extends ZipEntryConfigFileValue {
    public JarEntryConfigValue(String filename, String entryname, int type, String section, String key) {
        super(filename, entryname, type, section, key);
    }

    @Override
    public String resolve() throws Exception {
        return super.resolve(this.getJarEntryInputStream(this.getFilename(), this.getEntryname()));
    }

    @Override
    public String resolve(VariableSubstitutor ... substitutors) throws Exception {
        VariableSubstitutor substitutor;
        String _filename_ = this.getFilename();
        String _entryname_ = this.getEntryname();
        VariableSubstitutor[] variableSubstitutorArray = substitutors;
        int n = substitutors.length;
        int n2 = 0;
        while (n2 < n) {
            substitutor = variableSubstitutorArray[n2];
            _filename_ = substitutor.substitute(_filename_);
            ++n2;
        }
        variableSubstitutorArray = substitutors;
        n = substitutors.length;
        n2 = 0;
        while (n2 < n) {
            substitutor = variableSubstitutorArray[n2];
            _entryname_ = substitutor.substitute(_entryname_);
            ++n2;
        }
        return super.resolve(this.getJarEntryInputStream(_filename_, _entryname_), substitutors);
    }

    private InputStream getJarEntryInputStream(String filename, String entryname) throws Exception {
        try {
            JarFile jarfile = new JarFile(filename);
            JarEntry entry = jarfile.getJarEntry(entryname);
            if (entry == null) {
                throw new Exception("Jar file entry " + entryname + " not found in " + jarfile.getName());
            }
            return jarfile.getInputStream(entry);
        }
        catch (ZipException ze) {
            throw new Exception("Error opening jar file " + filename, ze);
        }
    }
}

