/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xmlmerge.action;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.xmlmerge.AbstractXmlMergeException;
import com.izforge.izpack.util.xmlmerge.Action;
import com.izforge.izpack.util.xmlmerge.DocumentException;
import com.izforge.izpack.util.xmlmerge.Mapper;
import com.izforge.izpack.util.xmlmerge.Matcher;
import com.izforge.izpack.util.xmlmerge.MergeAction;
import com.izforge.izpack.util.xmlmerge.action.AbstractMergeAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class OrderedMergeAction
extends AbstractMergeAction {
    @Override
    public void perform(Element originalElement, Element patchElement, Element outputParentElement) throws AbstractXmlMergeException {
        Debug.log("Merging: " + originalElement + "(List 1) and " + patchElement + "(List 2)");
        Mapper mapper = (Mapper)this.m_mapperFactory.getOperation(originalElement, patchElement);
        if (originalElement == null) {
            outputParentElement.addContent((Content)mapper.map(patchElement));
        } else if (patchElement == null) {
            outputParentElement.addContent((Content)originalElement.clone());
        } else {
            Element workingElement = new Element(originalElement.getName(), originalElement.getNamespacePrefix(), originalElement.getNamespaceURI());
            this.addAttributes(workingElement, originalElement);
            Debug.log("Adding " + workingElement);
            outputParentElement.addContent((Content)workingElement);
            this.doIt(workingElement, originalElement, patchElement);
        }
    }

    private void doIt(Element parentOut, Element parentIn1, Element parentIn2) throws AbstractXmlMergeException {
        this.addAttributes(parentOut, parentIn2);
        Content[] list1 = parentIn1.getContent().toArray(new Content[0]);
        Content[] list2 = parentIn2.getContent().toArray(new Content[0]);
        int offsetTreated1 = 0;
        int offsetTreated2 = 0;
        Content[] contentArray = list1;
        int n = list1.length;
        int n2 = 0;
        while (n2 < n) {
            Content content1 = contentArray[n2];
            Debug.log("List 1: " + content1);
            if (content1 instanceof Comment || content1 instanceof Text) {
                parentOut.addContent((Content)content1.clone());
                ++offsetTreated1;
            } else {
                if (!(content1 instanceof Element)) {
                    throw new DocumentException(content1.getDocument(), "Contents of type " + content1.getClass().getName() + " not supported");
                }
                Element e1 = (Element)content1;
                int posInList2 = -1;
                int j = offsetTreated2;
                while (j < list2.length) {
                    Debug.log("List 2: " + list2[j]);
                    if (list2[j] instanceof Element) {
                        if (((Matcher)this.m_matcherFactory.getOperation(e1, (Element)list2[j])).matches(e1, (Element)list2[j])) {
                            Debug.log("Match found: " + e1 + " and " + list2[j]);
                            posInList2 = j;
                            break;
                        }
                    } else if (!(list2[j] instanceof Comment) && !(list2[j] instanceof Text)) {
                        throw new DocumentException(list2[j].getDocument(), "Contents of type " + list2[j].getClass().getName() + " not supported");
                    }
                    ++j;
                }
                while (posInList2 != -1 && offsetTreated2 < posInList2) {
                    if (list2[offsetTreated2] instanceof Element) {
                        this.applyAction(parentOut, null, (Element)list2[offsetTreated2]);
                    } else if (!(list2[offsetTreated2] instanceof Comment)) {
                        Content contentToAdd = (Content)list2[offsetTreated2].clone();
                        parentOut.addContent(contentToAdd);
                    }
                    ++offsetTreated2;
                }
                if (posInList2 != -1) {
                    this.applyAction(parentOut, (Element)list1[offsetTreated1], (Element)list2[offsetTreated2]);
                    ++offsetTreated1;
                    ++offsetTreated2;
                } else {
                    this.applyAction(parentOut, (Element)list1[offsetTreated1], null);
                    ++offsetTreated1;
                }
            }
            ++n2;
        }
        while (offsetTreated2 < list2.length) {
            if (list2[offsetTreated2] instanceof Element) {
                this.applyAction(parentOut, null, (Element)list2[offsetTreated2]);
            } else if (!(list2[offsetTreated2] instanceof Comment)) {
                Content contentToAdd = (Content)list2[offsetTreated2].clone();
                parentOut.addContent(contentToAdd);
            }
            ++offsetTreated2;
        }
    }

    private void applyAction(Element workingParent, Element originalElement, Element patchElement) throws AbstractXmlMergeException {
        Action action = (Action)this.m_actionFactory.getOperation(originalElement, patchElement);
        Mapper mapper = (Mapper)this.m_mapperFactory.getOperation(originalElement, patchElement);
        if (action instanceof MergeAction) {
            MergeAction mergeAction = (MergeAction)action;
            mergeAction.setActionFactory(this.m_actionFactory);
            mergeAction.setMapperFactory(this.m_mapperFactory);
            mergeAction.setMatcherFactory(this.m_matcherFactory);
        }
        action.perform(originalElement, mapper.map(patchElement), workingParent);
    }

    private void addAttributes(Element out, Element in) {
        LinkedHashMap<String, Attribute> allAttributes = new LinkedHashMap<String, Attribute>();
        ArrayList outAttributes = new ArrayList(out.getAttributes());
        ArrayList inAttributes = new ArrayList(in.getAttributes());
        for (Attribute attr : outAttributes) {
            attr.detach();
            allAttributes.put(attr.getQualifiedName(), attr);
            Debug.log("adding attr from out:" + attr);
        }
        for (Attribute attr : inAttributes) {
            attr.detach();
            allAttributes.put(attr.getQualifiedName(), attr);
            Debug.log("adding attr from in:" + attr);
        }
        out.setAttributes(new ArrayList(allAttributes.values()));
    }
}

