/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.security;

import java.security.SecureRandom;
import java.util.Random;

public class PasswordGenerator {
    private static final char[] ALLOWED_CHARACTERS = new char[]{'!', '#', '$', '%', '&', '(', ')', '*', '+', '-', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', ']', '^', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '}', '~'};
    public static final int DEFAULT_LENGTH = 10;
    private final Random random;
    private final boolean generatePronouncablePasswordsDefault;
    private final int lengthDefault;

    public PasswordGenerator() {
        this(10, false);
    }

    public PasswordGenerator(boolean generatePronouncablePasswords) {
        this(new SecureRandom(), 10, generatePronouncablePasswords);
    }

    public PasswordGenerator(int length, boolean generatePronouncablePasswords) {
        this(new SecureRandom(), length, generatePronouncablePasswords);
    }

    public PasswordGenerator(Random random, int length, boolean generatePronouncablePasswords) {
        assert (random != null) : "Unspecified random number generator.";
        this.random = random;
        this.lengthDefault = length;
        this.generatePronouncablePasswordsDefault = generatePronouncablePasswords;
    }

    private char nextChar() {
        return ALLOWED_CHARACTERS[this.random.nextInt(ALLOWED_CHARACTERS.length)];
    }

    public String generatePassword() {
        return this.generatePassword(this.lengthDefault, this.generatePronouncablePasswordsDefault);
    }

    public String generatePassword(boolean generatePronouncablePasswords) {
        return this.generatePassword(this.lengthDefault, this.generatePronouncablePasswordsDefault);
    }

    public String generatePassword(int length) {
        return this.generatePassword(length, this.generatePronouncablePasswordsDefault);
    }

    public String generatePassword(int length, boolean generatePronouncablePasswords) {
        StringBuilder builder = new StringBuilder();
        if (generatePronouncablePasswords) {
            State state = State.DIGIT;
            int i = 0;
            while (i < length) {
                state = state.nextState(this.random);
                state.appendCharacterTo(builder, this.random);
                ++i;
            }
            return builder.toString();
        }
        int i = 0;
        while (i < length) {
            builder.append(this.nextChar());
            ++i;
        }
        return builder.toString();
    }

    private static enum State {
        DIGIT{

            @Override
            State nextState(Random random) {
                return random.nextBoolean() ? CONSONANT : VOWEL;
            }

            @Override
            String getCharacters() {
                return "0123456789";
            }
        }
        ,
        CONSONANT{

            @Override
            State nextState(Random random) {
                return random.nextBoolean() ? DIGIT : VOWEL;
            }

            @Override
            String getCharacters() {
                return "bdcfghjklmnpqrstvwxzBCDFGHJKLMNPQRSTVWXZ";
            }
        }
        ,
        VOWEL{

            @Override
            State nextState(Random random) {
                return random.nextBoolean() ? CONSONANT : DIGIT;
            }

            @Override
            String getCharacters() {
                return "aeiouyAEIOUY";
            }
        };


        State nextState(Random random) {
            return this;
        }

        void appendCharacterTo(StringBuilder builder, Random random) {
            String characters = this.getCharacters();
            builder.append(characters.charAt(random.nextInt(characters.length())));
        }

        abstract String getCharacters();
    }
}

