/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import java.lang.reflect.Field;
import java.util.Timer;

public class TimerUtilities {
    private static final Field timerThreadFieldOrNull = TimerUtilities.tryGetTimerThreadField();

    private static Field tryGetTimerThreadField() {
        Field field = ClassUtils.tryGetDeclaredField(Timer.class, "thread");
        if (field != null && Thread.class.isAssignableFrom(field.getType())) {
            return field;
        }
        return null;
    }

    private static Thread tryGetTimerThread(Timer timer) {
        try {
            if (timerThreadFieldOrNull != null) {
                return (Thread)timerThreadFieldOrNull.get(timer);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static void stopTimerThread(Thread timerThread) {
        timerThread.stop(new InterruptedExceptionUnchecked());
    }

    private static boolean tryJoinThread(Thread thread2, long millis) {
        try {
            thread2.join(millis);
            return !thread2.isAlive();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isOperational() {
        return timerThreadFieldOrNull != null;
    }

    public static boolean tryInterruptTimerThread(Timer timer) {
        Thread timerThreadOrNull = TimerUtilities.tryGetTimerThread(timer);
        if (timerThreadOrNull != null) {
            timerThreadOrNull.interrupt();
            return true;
        }
        return false;
    }

    public static boolean tryJoinTimerThread(Timer timer, long millis) {
        Thread timerThreadOrNull = TimerUtilities.tryGetTimerThread(timer);
        if (timerThreadOrNull != null) {
            return TimerUtilities.tryJoinThread(timerThreadOrNull, millis);
        }
        return false;
    }

    public static boolean tryShutdownTimer(Timer timer, long millis) {
        timer.cancel();
        Thread timerThread = TimerUtilities.tryGetTimerThread(timer);
        if (timerThread == null) {
            return false;
        }
        timerThread.interrupt();
        boolean joinOK = TimerUtilities.tryJoinThread(timerThread, millis);
        if (joinOK) {
            return true;
        }
        if (timerThread.isInterrupted()) {
            TimerUtilities.stopTimerThread(timerThread);
            return TimerUtilities.tryJoinThread(timerThread, millis);
        }
        return false;
    }
}

