/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.filesystem.IPathHandler;
import ch.systemsx.cisd.common.filesystem.IStoreHandler;
import ch.systemsx.cisd.common.filesystem.StoreItem;
import java.io.File;

public class PathHandlerAdapter
implements IStoreHandler {
    private final IPathHandler pathHandler;
    private final File directory;

    public PathHandlerAdapter(IPathHandler pathHandler, File directory) {
        this.pathHandler = pathHandler;
        this.directory = directory;
    }

    static final IStoreHandler asScanningHandler(File directory, IPathHandler handler) {
        return new PathHandlerAdapter(handler, directory);
    }

    private final File asFile(StoreItem item) {
        return StoreItem.asFile(this.directory, item);
    }

    @Override
    public final boolean handle(StoreItem item) {
        File file = this.asFile(item);
        this.pathHandler.handle(file);
        return !file.exists();
    }

    @Override
    public boolean isStopped() {
        return this.pathHandler.isStopped();
    }
}

