/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentNodeFilter;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AbstractHierarchicalContent
implements IHierarchicalContent {
    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(String relativePathPattern) {
        IHierarchicalContentNode startingNode = this.getRootNode();
        final Pattern compiledPattern = Pattern.compile(relativePathPattern);
        IHierarchicalContentNodeFilter relativePathFilter = new IHierarchicalContentNodeFilter(){

            @Override
            public boolean accept(IHierarchicalContentNode node) {
                return compiledPattern.matcher(node.getRelativePath()).matches();
            }
        };
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        this.findMatchingNodes(startingNode, relativePathFilter, result);
        return result;
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(String startingPath, String fileNamePattern) {
        IHierarchicalContentNode startingNode = this.getNode(startingPath);
        final Pattern compiledPattern = Pattern.compile(fileNamePattern);
        IHierarchicalContentNodeFilter fileNameFilter = new IHierarchicalContentNodeFilter(){

            @Override
            public boolean accept(IHierarchicalContentNode node) {
                return compiledPattern.matcher(node.getName()).matches();
            }
        };
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        this.findMatchingNodes(startingNode, fileNameFilter, result);
        return result;
    }

    private void findMatchingNodes(IHierarchicalContentNode dirNode, IHierarchicalContentNodeFilter filter, List<IHierarchicalContentNode> result) {
        assert (dirNode.isDirectory()) : "expected a directory node, got: " + dirNode;
        for (IHierarchicalContentNode childNode : dirNode.getChildNodes()) {
            if (filter.accept(childNode)) {
                result.add(childNode);
            }
            if (!childNode.isDirectory()) continue;
            this.findMatchingNodes(childNode, filter, result);
        }
    }
}

