import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.DataType as DataType

tr = service.transaction()

file_type_PNG = tr.getOrCreateNewFileFormatType('PNG')
file_type_PNG.setDescription(None)

file_type_UNKNOWN = tr.getOrCreateNewFileFormatType('UNKNOWN')
file_type_UNKNOWN.setDescription('Unknown file format')

vocabulary_PLATE_GEOMETRY = tr.getOrCreateNewVocabulary('PLATE_GEOMETRY')
vocabulary_PLATE_GEOMETRY.setDescription('The geometry or dimensions of a plate')
vocabulary_PLATE_GEOMETRY.setUrlTemplate(None)
vocabulary_PLATE_GEOMETRY.setManagedInternally(True)
vocabulary_PLATE_GEOMETRY.setInternalNamespace(True)
vocabulary_PLATE_GEOMETRY.setChosenFromList(True)

vocabulary_term_PLATE_GEOMETRY_48_WELLS_6X8 = tr.createNewVocabularyTerm('48_WELLS_6X8')
vocabulary_term_PLATE_GEOMETRY_48_WELLS_6X8.setDescription(None)
vocabulary_term_PLATE_GEOMETRY_48_WELLS_6X8.setLabel('48 Wells, 6x8')
vocabulary_term_PLATE_GEOMETRY_48_WELLS_6X8.setOrdinal(5)
vocabulary_PLATE_GEOMETRY.addTerm(vocabulary_term_PLATE_GEOMETRY_48_WELLS_6X8)

vocabulary_term_PLATE_GEOMETRY_24_WELLS_4X6 = tr.createNewVocabularyTerm('24_WELLS_4X6')
vocabulary_term_PLATE_GEOMETRY_24_WELLS_4X6.setDescription(None)
vocabulary_term_PLATE_GEOMETRY_24_WELLS_4X6.setLabel('24 Wells, 4x6')
vocabulary_term_PLATE_GEOMETRY_24_WELLS_4X6.setOrdinal(4)
vocabulary_PLATE_GEOMETRY.addTerm(vocabulary_term_PLATE_GEOMETRY_24_WELLS_4X6)

vocabulary_term_PLATE_GEOMETRY_1536_WELLS_32X48 = tr.createNewVocabularyTerm('1536_WELLS_32X48')
vocabulary_term_PLATE_GEOMETRY_1536_WELLS_32X48.setDescription(None)
vocabulary_term_PLATE_GEOMETRY_1536_WELLS_32X48.setLabel('1536 Wells, 32x48')
vocabulary_term_PLATE_GEOMETRY_1536_WELLS_32X48.setOrdinal(3)
vocabulary_PLATE_GEOMETRY.addTerm(vocabulary_term_PLATE_GEOMETRY_1536_WELLS_32X48)

vocabulary_term_PLATE_GEOMETRY_96_WELLS_8X12 = tr.createNewVocabularyTerm('96_WELLS_8X12')
vocabulary_term_PLATE_GEOMETRY_96_WELLS_8X12.setDescription(None)
vocabulary_term_PLATE_GEOMETRY_96_WELLS_8X12.setLabel('96 Wells, 8x12')
vocabulary_term_PLATE_GEOMETRY_96_WELLS_8X12.setOrdinal(2)
vocabulary_PLATE_GEOMETRY.addTerm(vocabulary_term_PLATE_GEOMETRY_96_WELLS_8X12)

vocabulary_term_PLATE_GEOMETRY_384_WELLS_16X24 = tr.createNewVocabularyTerm('384_WELLS_16X24')
vocabulary_term_PLATE_GEOMETRY_384_WELLS_16X24.setDescription(None)
vocabulary_term_PLATE_GEOMETRY_384_WELLS_16X24.setLabel('384 Wells, 16x24')
vocabulary_term_PLATE_GEOMETRY_384_WELLS_16X24.setOrdinal(1)
vocabulary_PLATE_GEOMETRY.addTerm(vocabulary_term_PLATE_GEOMETRY_384_WELLS_16X24)

samp_type_CONTROL_WELL = tr.getOrCreateNewSampleType('CONTROL_WELL')
samp_type_CONTROL_WELL.setDescription(None)
samp_type_CONTROL_WELL.setListable(False)
samp_type_CONTROL_WELL.setSubcodeUnique(False)
samp_type_CONTROL_WELL.setAutoGeneratedCode(False)
samp_type_CONTROL_WELL.setGeneratedCodePrefix('C')

samp_type_LIBRARY = tr.getOrCreateNewSampleType('LIBRARY')
samp_type_LIBRARY.setDescription(None)
samp_type_LIBRARY.setListable(False)
samp_type_LIBRARY.setSubcodeUnique(False)
samp_type_LIBRARY.setAutoGeneratedCode(False)
samp_type_LIBRARY.setGeneratedCodePrefix('L')

samp_type_PLATE = tr.getOrCreateNewSampleType('PLATE')
samp_type_PLATE.setDescription('Cell Plate')
samp_type_PLATE.setListable(True)
samp_type_PLATE.setSubcodeUnique(False)
samp_type_PLATE.setAutoGeneratedCode(False)
samp_type_PLATE.setGeneratedCodePrefix('S')

samp_type_SIRNA_WELL = tr.getOrCreateNewSampleType('SIRNA_WELL')
samp_type_SIRNA_WELL.setDescription(None)
samp_type_SIRNA_WELL.setListable(False)
samp_type_SIRNA_WELL.setSubcodeUnique(False)
samp_type_SIRNA_WELL.setAutoGeneratedCode(False)
samp_type_SIRNA_WELL.setGeneratedCodePrefix('O')

data_set_type_HCS_ANALYSIS_WELL_FEATURES = tr.getOrCreateNewDataSetType('HCS_ANALYSIS_WELL_FEATURES')
data_set_type_HCS_ANALYSIS_WELL_FEATURES.setDescription('HCS image analysis well feature vectors.')
data_set_type_HCS_ANALYSIS_WELL_FEATURES.setContainerType(False)

data_set_type_HCS_IMAGE_OVERVIEW = tr.getOrCreateNewDataSetType('HCS_IMAGE_OVERVIEW')
data_set_type_HCS_IMAGE_OVERVIEW.setDescription('Overview High Content Screening Images. Generated from raw images.')
data_set_type_HCS_IMAGE_OVERVIEW.setContainerType(False)

data_set_type_HCS_IMAGE_RAW = tr.getOrCreateNewDataSetType('HCS_IMAGE_RAW')
data_set_type_HCS_IMAGE_RAW.setDescription('Raw High Content Screening Images')
data_set_type_HCS_IMAGE_RAW.setContainerType(False)

data_set_type_HCS_IMAGE_SEGMENTATION = tr.getOrCreateNewDataSetType('HCS_IMAGE_SEGMENTATION')
data_set_type_HCS_IMAGE_SEGMENTATION.setDescription('HCS Segmentation Images (overlays).')
data_set_type_HCS_IMAGE_SEGMENTATION.setContainerType(False)

data_set_type_HCS_IMAGE_CONTAINER_RAW = tr.getOrCreateNewDataSetType('HCS_IMAGE_CONTAINER_RAW')
data_set_type_HCS_IMAGE_CONTAINER_RAW.setDescription('Container for HCS images of different resolutions (raw, overviews, thumbnails).')
data_set_type_HCS_IMAGE_CONTAINER_RAW.setContainerType(True)

data_set_type_HCS_ANALYSIS_FEATURES_LIST = tr.getOrCreateNewDataSetType('HCS_ANALYSIS_FEATURES_LIST')
data_set_type_HCS_ANALYSIS_FEATURES_LIST.setDescription('The list (or group) of features. The subset of features from feature vectors.')
data_set_type_HCS_ANALYSIS_FEATURES_LIST.setContainerType(False)

material_type_COMPOUND = tr.getOrCreateNewMaterialType('COMPOUND')
material_type_COMPOUND.setDescription('Compound')

material_type_CONTROL = tr.getOrCreateNewMaterialType('CONTROL')
material_type_CONTROL.setDescription('Control of a control layout')

material_type_GENE = tr.getOrCreateNewMaterialType('GENE')
material_type_GENE.setDescription('Gene')

material_type_SIRNA = tr.getOrCreateNewMaterialType('SIRNA')
material_type_SIRNA.setDescription('Oligo nucleotide')

prop_type_ANALYSIS_PROCEDURE = tr.getOrCreateNewPropertyType('ANALYSIS_PROCEDURE', DataType.VARCHAR)
prop_type_ANALYSIS_PROCEDURE.setLabel('Analysis procedure')
prop_type_ANALYSIS_PROCEDURE.setManagedInternally(False)
prop_type_ANALYSIS_PROCEDURE.setInternalNamespace(True)

prop_type_RESOLUTION = tr.getOrCreateNewPropertyType('RESOLUTION', DataType.VARCHAR)
prop_type_RESOLUTION.setLabel('Resolution')
prop_type_RESOLUTION.setManagedInternally(False)
prop_type_RESOLUTION.setInternalNamespace(True)

prop_type_PLATE_GEOMETRY = tr.getOrCreateNewPropertyType('PLATE_GEOMETRY', DataType.CONTROLLEDVOCABULARY)
prop_type_PLATE_GEOMETRY.setLabel('Plate Geometry')
prop_type_PLATE_GEOMETRY.setManagedInternally(True)
prop_type_PLATE_GEOMETRY.setInternalNamespace(True)
prop_type_PLATE_GEOMETRY.setVocabulary(vocabulary_PLATE_GEOMETRY)

prop_type_CONTROL = tr.getOrCreateNewPropertyType('CONTROL', DataType.MATERIAL)
prop_type_CONTROL.setLabel('Control')
prop_type_CONTROL.setManagedInternally(True)
prop_type_CONTROL.setInternalNamespace(False)
prop_type_CONTROL.setMaterialType(material_type_CONTROL)

# Already exists in the database
prop_type_DESCRIPTION = tr.getPropertyType('DESCRIPTION')

prop_type_GENE = tr.getOrCreateNewPropertyType('GENE', DataType.MATERIAL)
prop_type_GENE.setLabel('Gene')
prop_type_GENE.setManagedInternally(True)
prop_type_GENE.setInternalNamespace(False)
prop_type_GENE.setMaterialType(material_type_GENE)

prop_type_GENE_SYMBOLS = tr.getOrCreateNewPropertyType('GENE_SYMBOLS', DataType.VARCHAR)
prop_type_GENE_SYMBOLS.setLabel('Gene symbols')
prop_type_GENE_SYMBOLS.setManagedInternally(True)
prop_type_GENE_SYMBOLS.setInternalNamespace(False)

prop_type_INHIBITOR_OF = tr.getOrCreateNewPropertyType('INHIBITOR_OF', DataType.MATERIAL)
prop_type_INHIBITOR_OF.setLabel('Inhibitor Of')
prop_type_INHIBITOR_OF.setManagedInternally(True)
prop_type_INHIBITOR_OF.setInternalNamespace(False)
prop_type_INHIBITOR_OF.setMaterialType(material_type_GENE)

prop_type_LIBRARY_ID = tr.getOrCreateNewPropertyType('LIBRARY_ID', DataType.VARCHAR)
prop_type_LIBRARY_ID.setLabel('Library ID')
prop_type_LIBRARY_ID.setManagedInternally(True)
prop_type_LIBRARY_ID.setInternalNamespace(False)

prop_type_NUCLEOTIDE_SEQUENCE = tr.getOrCreateNewPropertyType('NUCLEOTIDE_SEQUENCE', DataType.VARCHAR)
prop_type_NUCLEOTIDE_SEQUENCE.setLabel('Nucleotide Sequence')
prop_type_NUCLEOTIDE_SEQUENCE.setManagedInternally(True)
prop_type_NUCLEOTIDE_SEQUENCE.setInternalNamespace(False)

prop_type_SIRNA = tr.getOrCreateNewPropertyType('SIRNA', DataType.MATERIAL)
prop_type_SIRNA.setLabel('siRNA')
prop_type_SIRNA.setManagedInternally(True)
prop_type_SIRNA.setInternalNamespace(False)
prop_type_SIRNA.setMaterialType(material_type_SIRNA)

assignment_MATERIAL_COMPOUND_DESCRIPTION = tr.assignPropertyType(material_type_COMPOUND, prop_type_DESCRIPTION)
assignment_MATERIAL_COMPOUND_DESCRIPTION.setMandatory(False)
assignment_MATERIAL_COMPOUND_DESCRIPTION.setSection(None)
assignment_MATERIAL_COMPOUND_DESCRIPTION.setPositionInForms(1)

assignment_MATERIAL_CONTROL_DESCRIPTION = tr.assignPropertyType(material_type_CONTROL, prop_type_DESCRIPTION)
assignment_MATERIAL_CONTROL_DESCRIPTION.setMandatory(False)
assignment_MATERIAL_CONTROL_DESCRIPTION.setSection(None)
assignment_MATERIAL_CONTROL_DESCRIPTION.setPositionInForms(1)

assignment_SAMPLE_CONTROL_WELL_CONTROL = tr.assignPropertyType(samp_type_CONTROL_WELL, prop_type_CONTROL)
assignment_SAMPLE_CONTROL_WELL_CONTROL.setMandatory(False)
assignment_SAMPLE_CONTROL_WELL_CONTROL.setSection(None)
assignment_SAMPLE_CONTROL_WELL_CONTROL.setPositionInForms(1)

assignment_MATERIAL_GENE_DESCRIPTION = tr.assignPropertyType(material_type_GENE, prop_type_DESCRIPTION)
assignment_MATERIAL_GENE_DESCRIPTION.setMandatory(False)
assignment_MATERIAL_GENE_DESCRIPTION.setSection(None)
assignment_MATERIAL_GENE_DESCRIPTION.setPositionInForms(2)

assignment_MATERIAL_GENE_GENE_SYMBOLS = tr.assignPropertyType(material_type_GENE, prop_type_GENE_SYMBOLS)
assignment_MATERIAL_GENE_GENE_SYMBOLS.setMandatory(False)
assignment_MATERIAL_GENE_GENE_SYMBOLS.setSection(None)
assignment_MATERIAL_GENE_GENE_SYMBOLS.setPositionInForms(4)

assignment_DATA_SET_HCS_IMAGE_OVERVIEW_RESOLUTION = tr.assignPropertyType(data_set_type_HCS_IMAGE_OVERVIEW, prop_type_RESOLUTION)
assignment_DATA_SET_HCS_IMAGE_OVERVIEW_RESOLUTION.setMandatory(False)
assignment_DATA_SET_HCS_IMAGE_OVERVIEW_RESOLUTION.setSection(None)
assignment_DATA_SET_HCS_IMAGE_OVERVIEW_RESOLUTION.setPositionInForms(1)

assignment_SAMPLE_PLATE_PLATE_GEOMETRY = tr.assignPropertyType(samp_type_PLATE, prop_type_PLATE_GEOMETRY)
assignment_SAMPLE_PLATE_PLATE_GEOMETRY.setMandatory(True)
assignment_SAMPLE_PLATE_PLATE_GEOMETRY.setSection(None)
assignment_SAMPLE_PLATE_PLATE_GEOMETRY.setPositionInForms(1)

assignment_MATERIAL_SIRNA_NUCLEOTIDE_SEQUENCE = tr.assignPropertyType(material_type_SIRNA, prop_type_NUCLEOTIDE_SEQUENCE)
assignment_MATERIAL_SIRNA_NUCLEOTIDE_SEQUENCE.setMandatory(True)
assignment_MATERIAL_SIRNA_NUCLEOTIDE_SEQUENCE.setSection(None)
assignment_MATERIAL_SIRNA_NUCLEOTIDE_SEQUENCE.setPositionInForms(1)

assignment_MATERIAL_SIRNA_DESCRIPTION = tr.assignPropertyType(material_type_SIRNA, prop_type_DESCRIPTION)
assignment_MATERIAL_SIRNA_DESCRIPTION.setMandatory(False)
assignment_MATERIAL_SIRNA_DESCRIPTION.setSection(None)
assignment_MATERIAL_SIRNA_DESCRIPTION.setPositionInForms(3)

assignment_MATERIAL_SIRNA_INHIBITOR_OF = tr.assignPropertyType(material_type_SIRNA, prop_type_INHIBITOR_OF)
assignment_MATERIAL_SIRNA_INHIBITOR_OF.setMandatory(True)
assignment_MATERIAL_SIRNA_INHIBITOR_OF.setSection(None)
assignment_MATERIAL_SIRNA_INHIBITOR_OF.setPositionInForms(4)

assignment_MATERIAL_SIRNA_LIBRARY_ID = tr.assignPropertyType(material_type_SIRNA, prop_type_LIBRARY_ID)
assignment_MATERIAL_SIRNA_LIBRARY_ID.setMandatory(False)
assignment_MATERIAL_SIRNA_LIBRARY_ID.setSection(None)
assignment_MATERIAL_SIRNA_LIBRARY_ID.setPositionInForms(5)

assignment_SAMPLE_SIRNA_WELL_SIRNA = tr.assignPropertyType(samp_type_SIRNA_WELL, prop_type_SIRNA)
assignment_SAMPLE_SIRNA_WELL_SIRNA.setMandatory(False)
assignment_SAMPLE_SIRNA_WELL_SIRNA.setSection(None)
assignment_SAMPLE_SIRNA_WELL_SIRNA.setPositionInForms(1)

assignment_SAMPLE_SIRNA_WELL_GENE = tr.assignPropertyType(samp_type_SIRNA_WELL, prop_type_GENE)
assignment_SAMPLE_SIRNA_WELL_GENE.setMandatory(False)
assignment_SAMPLE_SIRNA_WELL_GENE.setSection(None)
assignment_SAMPLE_SIRNA_WELL_GENE.setPositionInForms(2)
