/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.etlserver.path.IPathsInfoDAO;
import ch.systemsx.cisd.etlserver.path.PathEntryDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PathInfoDataSourceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class FillUnknownDataSetSizeInOpenbisDBFromPathInfoDBMaintenanceTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FillUnknownDataSetSizeInOpenbisDBFromPathInfoDBMaintenanceTask.class);
    static final String CHUNK_SIZE_PROPERTY = "data-set-chunk-size";
    static final int CHUNK_SIZE_DEFAULT = 100;
    static final String TIME_LIMIT_PROPERTY = "time-limit";
    static final long TIME_LIMIT_DEFAULT = 3600000L;
    static final String LAST_SEEN_DATA_SET_FILE_PROPERTY = "last-seen-data-set-file";
    static final String LAST_SEEN_DATA_SET_FILE_DEFAULT = "fillUnknownDataSetSizeTaskLastSeen";
    static final String DELETE_LAST_SEEN_DATA_SET_FILE_INTERVAL_PROPERTY = "delete-last-seen-data-set-file-interval";
    static final long DELETE_LAST_SEEN_DATA_SET_FILE_INTERVAL_DEFAULT = 604800000L;
    private IEncapsulatedOpenBISService service;
    private IPathsInfoDAO dao;
    private ITimeProvider timeProvider;
    private IConfigProvider configProvider;
    private int chunkSize;
    private long timeLimit;
    private File lastSeenDataSetFile;
    private long deleteLastSeenDataSetFileInterval;

    public FillUnknownDataSetSizeInOpenbisDBFromPathInfoDBMaintenanceTask() {
        this.service = ServiceProvider.getOpenBISService();
        this.dao = (IPathsInfoDAO)QueryTool.getQuery((DataSource)PathInfoDataSourceProvider.getDataSource(), IPathsInfoDAO.class);
        this.timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
        this.configProvider = ServiceProvider.getConfigProvider();
    }

    public FillUnknownDataSetSizeInOpenbisDBFromPathInfoDBMaintenanceTask(IEncapsulatedOpenBISService service, IPathsInfoDAO dao, ITimeProvider timeProvider, IConfigProvider configProvider) {
        this.service = service;
        this.dao = dao;
        this.timeProvider = timeProvider;
        this.configProvider = configProvider;
    }

    @Override
    public void setUp(String pluginName, Properties properties) {
        this.chunkSize = PropertyUtils.getInt(properties, CHUNK_SIZE_PROPERTY, 100);
        this.timeLimit = DateTimeUtils.getDurationInMillis(properties, TIME_LIMIT_PROPERTY, 3600000L);
        String lastSeenDataSetFileProperty = properties.getProperty(LAST_SEEN_DATA_SET_FILE_PROPERTY);
        this.lastSeenDataSetFile = lastSeenDataSetFileProperty == null ? new File(this.configProvider.getStoreRoot(), LAST_SEEN_DATA_SET_FILE_DEFAULT) : new File(lastSeenDataSetFileProperty);
        this.deleteLastSeenDataSetFileInterval = DateTimeUtils.getDurationInMillis(properties, DELETE_LAST_SEEN_DATA_SET_FILE_INTERVAL_PROPERTY, 604800000L);
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append("Maintenance task '" + pluginName + "' was initialized with the following property values:\n");
        logBuilder.append("\tdata-set-chunk-size: " + this.chunkSize + "\n");
        logBuilder.append("\ttime-limit: " + DateTimeUtils.renderDuration(this.timeLimit) + "\n");
        logBuilder.append("\tlast-seen-data-set-file: " + this.lastSeenDataSetFile.getAbsolutePath() + "\n");
        logBuilder.append("\tdelete-last-seen-data-set-file-interval: " + DateTimeUtils.renderDuration(this.deleteLastSeenDataSetFileInterval));
        operationLog.info(logBuilder.toString());
    }

    @Override
    public void execute() {
        operationLog.info("Start filling.");
        List<SimpleDataSetInformationDTO> dataSets = null;
        boolean fixedAllDataSets = true;
        long startTime = this.timeProvider.getTimeInMilliseconds();
        boolean reachedTimeLimit = false;
        int chunkIndex = 1;
        this.prepareLastSeenDataSetFile();
        LastSeenDataSetFileContent initialLastSeenContent = LastSeenDataSetFileContent.readFromFile(this.lastSeenDataSetFile);
        do {
            LastSeenDataSetFileContent currentLastSeenContent = LastSeenDataSetFileContent.readFromFile(this.lastSeenDataSetFile);
            dataSets = this.findDataSetsWithUnknownSizeInOpenbisDB(currentLastSeenContent.getLastSeenDataSetCode());
            this.logWithChunkInfo("Found " + dataSets.size() + " dataset(s) with unknown size in openbis database", chunkIndex, currentLastSeenContent.getLastSeenDataSetCode());
            if (!dataSets.isEmpty()) {
                HashSet<String> codes = new HashSet<String>();
                for (SimpleDataSetInformationDTO dataSet : dataSets) {
                    codes.add(dataSet.getDataSetCode());
                }
                Map<String, Long> sizeMap = this.findDataSetsSizeInPathInfoDB(codes);
                this.logWithChunkInfo("Found " + sizeMap.size() + " size(s) in pathinfo database", chunkIndex, currentLastSeenContent.getLastSeenDataSetCode());
                if (!sizeMap.isEmpty()) {
                    this.service.updatePhysicalDataSetsSize(sizeMap);
                }
                fixedAllDataSets = fixedAllDataSets && codes.equals(sizeMap.keySet());
                LastSeenDataSetFileContent newLastSeenContent = new LastSeenDataSetFileContent();
                newLastSeenContent.setFileCreationTime(currentLastSeenContent.getFileCreationTime());
                newLastSeenContent.setLastSeenDataSetCode(Collections.max(codes));
                newLastSeenContent.writeToFile(this.lastSeenDataSetFile);
            }
            boolean bl = reachedTimeLimit = this.timeProvider.getTimeInMilliseconds() > startTime + this.timeLimit;
            if (reachedTimeLimit) {
                this.logWithChunkInfo("Reached time limit of " + DateTimeUtils.renderDuration(this.timeLimit) + ".", chunkIndex, currentLastSeenContent.getLastSeenDataSetCode());
            }
            ++chunkIndex;
        } while (!dataSets.isEmpty() && !reachedTimeLimit);
        if (initialLastSeenContent.getLastSeenDataSetCode() == null && fixedAllDataSets && !reachedTimeLimit) {
            operationLog.info("All data sets with unknown size in openbis database have been fixed. The maintenance task can be now disabled.");
        } else {
            operationLog.info("Some data sets with unknown size in openbis database have not been fixed yet. Do not disable the maintenance task yet.");
        }
        operationLog.info("Filling finished.");
    }

    private void prepareLastSeenDataSetFile() {
        LastSeenDataSetFileContent content = LastSeenDataSetFileContent.readFromFile(this.lastSeenDataSetFile);
        if (content == null) {
            content = new LastSeenDataSetFileContent();
            content.setFileCreationTime(this.timeProvider.getTimeInMilliseconds());
            content.writeToFile(this.lastSeenDataSetFile);
            operationLog.info("Created last seen data set file.");
        } else if (content.getFileCreationTime() == null || this.timeProvider.getTimeInMilliseconds() > content.getFileCreationTime() + this.deleteLastSeenDataSetFileInterval) {
            this.lastSeenDataSetFile.delete();
            operationLog.info("Deleted last seen data set file because its age was unknown or its age was greater than " + DateTimeUtils.renderDuration(this.deleteLastSeenDataSetFileInterval) + " ('" + DELETE_LAST_SEEN_DATA_SET_FILE_INTERVAL_PROPERTY + "' property value).");
            content = new LastSeenDataSetFileContent();
            content.setFileCreationTime(this.timeProvider.getTimeInMilliseconds());
            content.writeToFile(this.lastSeenDataSetFile);
        }
    }

    private List<SimpleDataSetInformationDTO> findDataSetsWithUnknownSizeInOpenbisDB(String lastSeenDataSetCode) {
        List<SimpleDataSetInformationDTO> dataSets = this.service.listPhysicalDataSetsWithUnknownSize(this.chunkSize, lastSeenDataSetCode);
        if (dataSets == null) {
            return Collections.emptyList();
        }
        return dataSets;
    }

    private Map<String, Long> findDataSetsSizeInPathInfoDB(Collection<String> dataSetCodes) {
        List<PathEntryDTO> entries = this.dao.listDataSetsSize(dataSetCodes.toArray(new String[dataSetCodes.size()]));
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (entries != null && !entries.isEmpty()) {
            for (PathEntryDTO pathInfoEntry : entries) {
                if (pathInfoEntry.getSizeInBytes() == null) continue;
                map.put(pathInfoEntry.getDataSetCode(), pathInfoEntry.getSizeInBytes());
            }
        }
        return map;
    }

    private void logWithChunkInfo(String msg, int chunkIndex, String lastSeenDataSetCode) {
        operationLog.info(String.valueOf(msg) + " (chunkIndex: " + chunkIndex + ", lastSeenDataSetCode: " + lastSeenDataSetCode + ").");
    }

    public static class LastSeenDataSetFileContent {
        private static final String FILE_CREATION_TIME_PROPERTY = "file-creation-time";
        private static final String LAST_SEEN_DATA_SET_CODE_PROPERTY = "last-seen-data-set-code";
        private Long fileCreationTime;
        private String lastSeenDataSetCode;

        public void setFileCreationTime(Long fileCreationTime) {
            this.fileCreationTime = fileCreationTime;
        }

        public Long getFileCreationTime() {
            return this.fileCreationTime;
        }

        public void setLastSeenDataSetCode(String lastSeenDataSetCode) {
            this.lastSeenDataSetCode = lastSeenDataSetCode;
        }

        public String getLastSeenDataSetCode() {
            return this.lastSeenDataSetCode;
        }

        public static LastSeenDataSetFileContent readFromFile(File file) {
            if (file.exists()) {
                Map map = null;
                try {
                    map = (Map)new ObjectMapper().readValue(file, Map.class);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not read the last seen data set file", e);
                }
                LastSeenDataSetFileContent content = new LastSeenDataSetFileContent();
                content.setFileCreationTime(LastSeenDataSetFileContent.readPropertyAsLong(map, FILE_CREATION_TIME_PROPERTY));
                content.setLastSeenDataSetCode(LastSeenDataSetFileContent.readPropertyAsString(map, LAST_SEEN_DATA_SET_CODE_PROPERTY));
                return content;
            }
            return null;
        }

        private static Long readPropertyAsLong(Map<String, Object> propertyMap, String propertyName) {
            Object propertyValue;
            block5: {
                try {
                    propertyValue = propertyMap.get(propertyName);
                    if (propertyValue != null) break block5;
                    return null;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not read " + propertyName + " property", e);
                }
            }
            if (propertyValue instanceof String) {
                return Long.parseLong((String)propertyValue);
            }
            if (propertyValue instanceof Number) {
                return ((Number)propertyValue).longValue();
            }
            throw new IllegalArgumentException("Cannot convert value: " + propertyValue + " of type: " + propertyValue.getClass() + " to long.");
        }

        private static String readPropertyAsString(Map<String, Object> propertyMap, String propertyName) {
            Object value = propertyMap.get(propertyName);
            try {
                return (String)value;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not read " + propertyName + " property", e);
            }
        }

        public void writeToFile(File file) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(FILE_CREATION_TIME_PROPERTY, this.getFileCreationTime());
            map.put(LAST_SEEN_DATA_SET_CODE_PROPERTY, this.getLastSeenDataSetCode());
            try {
                new ObjectMapper().writeValue(file, map);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not write the last seen data set file", e);
            }
        }
    }
}

