/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v1.impl;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.etlserver.DynamicTransactionQueryFactory;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.ITransactionalCommand;
import ch.systemsx.cisd.etlserver.registrator.api.impl.MkdirsCommand;
import ch.systemsx.cisd.etlserver.registrator.api.impl.MoveFileCommand;
import ch.systemsx.cisd.etlserver.registrator.api.impl.NewFileCommand;
import ch.systemsx.cisd.etlserver.registrator.api.impl.RollbackStack;
import ch.systemsx.cisd.etlserver.registrator.api.impl.SecondaryTransactionFailure;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IDataSetUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IExperiment;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IExperimentUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IMaterial;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IMetaproject;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IProject;
import ch.systemsx.cisd.etlserver.registrator.api.v1.ISample;
import ch.systemsx.cisd.etlserver.registrator.api.v1.ISpace;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IVocabularyTerm;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ConversionUtils;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSetImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSetUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.Experiment;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ExperimentImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ExperimentUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.Material;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.MaterialImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.Metaproject;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.Project;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ProjectImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.Sample;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.SampleImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.Space;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.Vocabulary;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetRegistrationService;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetStorageAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetStorageAlgorithmRunner;
import ch.systemsx.cisd.etlserver.registrator.v1.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IDataSetImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IMaterialImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IProjectImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.ISampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetRegistrationInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMetaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewProject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSpace;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialUpdateDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewVocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpaceRoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lemnik.eodsql.DynamicTransactionQuery;

public abstract class AbstractTransactionState<T extends DataSetInformation> {
    protected final DataSetRegistrationTransaction<T> parent;

    protected AbstractTransactionState(DataSetRegistrationTransaction<T> parent) {
        this.parent = parent;
    }

    public boolean isCommitted() {
        return false;
    }

    public boolean isRolledback() {
        return false;
    }

    static class CommitedTransactionState<T extends DataSetInformation>
    extends TerminalTransactionState<T> {
        public CommitedTransactionState(LiveTransactionState<T> liveState) {
            super(liveState);
        }

        @Override
        public boolean isCommitted() {
            return true;
        }
    }

    public static class LiveTransactionRollbackDelegate
    implements RollbackStack.IRollbackStackDelegate {
        private final File stagingDirectory;
        private final int fileSystemAvailablityWaitCount;
        private final int fileSystemAvailablityPollingWaitTimeMs;

        public LiveTransactionRollbackDelegate(File stagingDirectory) {
            this.stagingDirectory = stagingDirectory;
            this.fileSystemAvailablityWaitCount = LiveTransactionState.fileSystemAvailablityWaitCount;
            this.fileSystemAvailablityPollingWaitTimeMs = LiveTransactionState.fileSystemAvailablityPollingWaitTimeMs;
        }

        @Override
        public void willContinueRollbackAll(RollbackStack stack) {
            InterruptedExceptionUnchecked.check();
            if (FileUtilities.checkDirectoryFullyAccessible(this.stagingDirectory, "staging") != null) {
                boolean keepPolling = true;
                int waitCount = 0;
                while (waitCount < this.fileSystemAvailablityWaitCount && keepPolling) {
                    try {
                        Thread.sleep(this.fileSystemAvailablityPollingWaitTimeMs);
                        keepPolling = FileUtilities.checkDirectoryFullyAccessible(this.stagingDirectory, "staging") != null;
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedExceptionUnchecked(e);
                    }
                    ++waitCount;
                }
                if (FileUtilities.checkDirectoryFullyAccessible(this.stagingDirectory, "staging") != null) {
                    throw new IOExceptionUnchecked("The staging directory " + this.stagingDirectory.getAbsolutePath() + " is not available. Could not rollback transaction.");
                }
            }
        }
    }

    static class LiveTransactionState<T extends DataSetInformation>
    extends AbstractTransactionState<T> {
        private static int fileSystemAvailablityWaitCount = 30;
        private static int fileSystemAvailablityPollingWaitTimeMs = 10000;
        private final RollbackStack rollbackStack;
        private final File workingDirectory;
        private final File stagingDirectory;
        private final DataSetRegistrationService<T> registrationService;
        private final IEncapsulatedOpenBISService openBisService;
        private final IDataSetRegistrationDetailsFactory<T> registrationDetailsFactory;
        private final List<DataSet<? extends T>> registeredDataSets = new ArrayList<DataSet<? extends T>>();
        private final List<DataSetUpdatable> dataSetsToBeUpdated = new ArrayList<DataSetUpdatable>();
        private final List<Experiment> experimentsToBeRegistered = new ArrayList<Experiment>();
        private final List<ExperimentUpdatable> experimentsToBeUpdated = new ArrayList<ExperimentUpdatable>();
        private final List<Space> spacesToBeRegistered = new ArrayList<Space>();
        private final List<Project> projectsToBeRegistered = new ArrayList<Project>();
        private final List<Project> projectsToBeUpdated = new ArrayList<Project>();
        private final List<Sample> samplesToBeRegistered = new ArrayList<Sample>();
        private final List<Sample> samplesToBeUpdated = new ArrayList<Sample>();
        private final List<Material> materialsToBeRegistered = new ArrayList<Material>();
        private final List<Material> materialsToBeUpdated = new ArrayList<Material>();
        private final List<Metaproject> metaprojectsToBeRegistered = new ArrayList<Metaproject>();
        private final List<Metaproject> metaprojectsToBeUpdated = new ArrayList<Metaproject>();
        private final List<Vocabulary> vocabulariesToBeUpdated = new ArrayList<Vocabulary>();
        private final Map<String, DynamicTransactionQuery> queriesToCommit = new HashMap<String, DynamicTransactionQuery>();
        private String userIdOrNull = null;

        public static void setFileSystemAvailabilityPollingWaitTimeAndWaitCount(int waitTimeMS, int waitCount) {
            fileSystemAvailablityWaitCount = waitTimeMS;
            fileSystemAvailablityPollingWaitTimeMs = waitCount;
        }

        public LiveTransactionState(DataSetRegistrationTransaction<T> parent, RollbackStack rollbackStack, File workingDirectory, File stagingDirectory, DataSetRegistrationService<T> registrationService, IDataSetRegistrationDetailsFactory<T> registrationDetailsFactory) {
            super(parent);
            this.rollbackStack = rollbackStack;
            this.workingDirectory = workingDirectory;
            this.stagingDirectory = stagingDirectory;
            this.registrationService = registrationService;
            this.openBisService = this.registrationService.getRegistratorContext().getGlobalState().getOpenBisService();
            this.registrationDetailsFactory = registrationDetailsFactory;
            this.userIdOrNull = registrationDetailsFactory.getUserIdOrNull();
        }

        public String getUserId() {
            return this.userIdOrNull;
        }

        public void setUserId(String userIdOrNull) {
            this.userIdOrNull = userIdOrNull;
        }

        public IDataSet createNewDataSet() {
            return this.createNewDataSet(this.registrationDetailsFactory, null, null);
        }

        public IDataSet createNewDataSet(String dataSetType) {
            return this.createNewDataSet(this.registrationDetailsFactory, dataSetType, null);
        }

        public IDataSet createNewDataSet(String dataSetType, String dataSetCode) {
            return this.createNewDataSet(this.registrationDetailsFactory, dataSetType, dataSetCode);
        }

        public IDataSet createNewDataSet(DataSetRegistrationDetails<T> registrationDetails) {
            return this.createNewDataSet(registrationDetails, ((DataSetInformation)registrationDetails.getDataSetInformation()).getDataSetCode());
        }

        public IDataSet createNewDataSet(DataSetRegistrationDetails<T> registrationDetails, String specifiedCodeOrNull) {
            return this.createNewDataSet(this.registrationDetailsFactory, registrationDetails, null, specifiedCodeOrNull);
        }

        public IDataSet createNewDataSet(IDataSetRegistrationDetailsFactory<T> factory, String dataSetTypeOrNull, String dataSetCodeOrNull) {
            return this.createNewDataSet(factory, null, dataSetTypeOrNull, dataSetCodeOrNull);
        }

        private IDataSet createNewDataSet(IDataSetRegistrationDetailsFactory<T> factory, DataSetRegistrationDetails<T> registrationDetailsOrNull, String dataSetTypeOrNull, String specifiedCodeOrNull) {
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment experiment;
            ExperimentIdentifier experimentId;
            Object sample;
            String dataSetCode;
            DataSetRegistrationDetails<T> registrationDetails = registrationDetailsOrNull;
            if (registrationDetails == null) {
                registrationDetails = factory.createDataSetRegistrationDetails();
            }
            if (dataSetTypeOrNull != null) {
                registrationDetails.setDataSetType(dataSetTypeOrNull);
            }
            if (specifiedCodeOrNull == null) {
                dataSetCode = this.generateDataSetCode(registrationDetails);
                ((DataSetInformation)registrationDetails.getDataSetInformation()).setDataSetCode(dataSetCode);
            } else {
                dataSetCode = specifiedCodeOrNull.toUpperCase();
            }
            ((DataSetInformation)registrationDetails.getDataSetInformation()).setDataSetCode(dataSetCode);
            File stagingFolder = new File(this.stagingDirectory, dataSetCode);
            MkdirsCommand cmd = new MkdirsCommand(stagingFolder.getAbsolutePath());
            this.executeCommand(cmd);
            DataSet<T> dataSet = factory.createDataSet(registrationDetails, stagingFolder);
            SampleIdentifier sampleId = ((DataSetInformation)registrationDetails.getDataSetInformation()).getSampleIdentifier();
            if (sampleId != null) {
                sample = this.tryFindSampleToRegister(sampleId);
                if (sample == null) {
                    sample = this.parent.getSample(sampleId.toString());
                }
                dataSet.setSample((ISampleImmutable)sample);
            }
            if ((sample = ((DataSetInformation)registrationDetails.getDataSetInformation()).tryToGetSample()) != null) {
                dataSet.setSample(new SampleImmutable((ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample)sample));
            }
            if ((experimentId = ((DataSetInformation)registrationDetails.getDataSetInformation()).getExperimentIdentifier()) != null) {
                IExperimentImmutable exp = this.tryFindExperimentToRegister(experimentId);
                if (exp == null) {
                    exp = this.parent.getExperiment(experimentId.toString());
                }
                dataSet.setExperiment(exp);
            }
            if ((experiment = ((DataSetInformation)registrationDetails.getDataSetInformation()).tryToGetExperiment()) != null) {
                dataSet.setExperiment(new ExperimentImmutable(experiment));
            }
            List<String> parents = ((DataSetInformation)registrationDetails.getDataSetInformation()).getParentDataSetCodes();
            if (((DataSetInformation)registrationDetails.getDataSetInformation()).getParentDataSetCodes() != null) {
                dataSet.setParentDatasets(parents);
            }
            this.registeredDataSets.add(dataSet);
            return dataSet;
        }

        private IExperimentImmutable tryFindExperimentToRegister(ExperimentIdentifier experimentId) {
            for (Experiment expToBeRegistered : this.experimentsToBeRegistered) {
                if (!LiveTransactionState.isPointingTo(expToBeRegistered, experimentId)) continue;
                return expToBeRegistered;
            }
            return null;
        }

        private static boolean isPointingTo(Experiment experiment, ExperimentIdentifier experimentId) {
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment expDTO = experiment.getExperiment();
            if (expDTO.getIdentifier() != null && expDTO.getIdentifier().equalsIgnoreCase(experimentId.toString())) {
                return true;
            }
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project project = expDTO.getProject();
            if (expDTO.getCode() == null || project == null || project.getSpace() == null) {
                return false;
            }
            return expDTO.getCode().equals(experimentId.getExperimentCode()) && project.getCode().equals(experimentId.getProjectCode()) && project.getSpace().getCode().equals(experimentId.getSpaceCode());
        }

        private SampleImmutable tryFindSampleToRegister(SampleIdentifier sampleId) {
            for (Sample sampleToBeRegistered : this.samplesToBeRegistered) {
                if (!LiveTransactionState.isPointingTo(sampleToBeRegistered, sampleId)) continue;
                return sampleToBeRegistered;
            }
            return null;
        }

        private static boolean isPointingTo(Sample sample, SampleIdentifier sampleIdentifier) {
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sampleDTO = sample.getSample();
            if (!sampleIdentifier.getSampleCode().equals(sampleDTO.getCode())) {
                return false;
            }
            if (sampleIdentifier.isSpaceLevel()) {
                return sampleIdentifier.getSpaceLevel().getSpaceCode().equals(sampleDTO.getSpace().getCode());
            }
            return sampleDTO.getSpace() == null;
        }

        public IDataSetImmutable getDataSet(String dataSetCode) {
            AbstractExternalData dataSet = this.openBisService.tryGetDataSet(dataSetCode);
            if (dataSet == null) {
                return null;
            }
            return new DataSetImmutable(dataSet, this.openBisService);
        }

        public IDataSetUpdatable getDataSetForUpdate(String dataSetCode) {
            DataSetUpdatable result = this.findDataSetLocally(dataSetCode);
            if (result != null) {
                return result;
            }
            AbstractExternalData dataSet = this.openBisService.tryGetDataSet(dataSetCode);
            if (dataSet == null) {
                return null;
            }
            result = new DataSetUpdatable(dataSet, this.openBisService);
            this.dataSetsToBeUpdated.add(result);
            return result;
        }

        public IDataSetUpdatable makeDataSetMutable(IDataSetImmutable dataSet) {
            if (dataSet == null) {
                return null;
            }
            DataSetUpdatable result = this.findDataSetLocally(dataSet);
            if (result != null) {
                return result;
            }
            if (dataSet instanceof DataSetImmutable) {
                result = new DataSetUpdatable((DataSetImmutable)dataSet);
                this.dataSetsToBeUpdated.add(result);
                return result;
            }
            return null;
        }

        private DataSetUpdatable findDataSetLocally(String dataSetCode) {
            for (DataSetUpdatable dataSet : this.dataSetsToBeUpdated) {
                if (!dataSet.getDataSetCode().equalsIgnoreCase(dataSetCode)) continue;
                return dataSet;
            }
            return null;
        }

        private DataSetUpdatable findDataSetLocally(IDataSetImmutable dataSetToFind) {
            for (DataSetUpdatable dataSet : this.dataSetsToBeUpdated) {
                if (!dataSet.equals(dataSetToFind)) continue;
                return dataSet;
            }
            return null;
        }

        public ISample getSampleForUpdate(String sampleIdentifierString) {
            SampleIdentifier sampleIdentifier = new SampleIdentifierFactory(sampleIdentifierString).createIdentifier();
            Sample result = this.findSampleLocally(sampleIdentifier);
            if (result != null) {
                return result;
            }
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample = this.openBisService.tryGetSampleWithExperiment(sampleIdentifier);
            if (sample != null) {
                result = new Sample(sample);
                this.samplesToBeUpdated.add(result);
            }
            return result;
        }

        public ISample makeSampleMutable(ISampleImmutable sample) {
            if (sample == null) {
                return null;
            }
            Sample result = this.findSampleLocally(sample);
            if (result != null) {
                return result;
            }
            if (sample instanceof SampleImmutable) {
                result = new Sample((SampleImmutable)sample);
                this.samplesToBeUpdated.add(result);
                return result;
            }
            return null;
        }

        private Sample findSampleLocally(SampleIdentifier sampleIdentifier) {
            String sampleIdentifierString = sampleIdentifier.toString();
            for (Sample sample : this.samplesToBeUpdated) {
                if (!sample.getSampleIdentifier().equalsIgnoreCase(sampleIdentifierString)) continue;
                return sample;
            }
            return null;
        }

        private Sample findSampleLocally(ISampleImmutable sampleToFind) {
            for (Sample sample : this.samplesToBeUpdated) {
                if (!sample.equals(sampleToFind)) continue;
                return sample;
            }
            return null;
        }

        public ISample createNewSample(String sampleIdentifierString, String sampleTypeCode) {
            String permId = this.openBisService.createPermId();
            Sample sample = new Sample(sampleIdentifierString, permId);
            sample.setSampleType(sampleTypeCode);
            this.samplesToBeRegistered.add(sample);
            return sample;
        }

        public ISample createNewSampleWithGeneratedCode(String spaceCode, String sampleTypeCode) {
            String permId = this.openBisService.createPermId();
            SampleType sampleType = this.openBisService.getSampleType(sampleTypeCode);
            String sampleIdentifierString = spaceCode == null || spaceCode.length() == 0 ? "/" + this.openBisService.generateCodes(sampleType.getGeneratedCodePrefix(), EntityKind.SAMPLE, 1).get(0) : "/" + spaceCode + "/" + this.openBisService.generateCodes(sampleType.getGeneratedCodePrefix(), EntityKind.SAMPLE, 1).get(0);
            Sample sample = new Sample(sampleIdentifierString, permId);
            sample.setSampleType(sampleTypeCode);
            this.samplesToBeRegistered.add(sample);
            return sample;
        }

        public IExperimentUpdatable getExperimentForUpdate(String experimentIdentifierString) {
            ExperimentIdentifier identifier = ExperimentIdentifierFactory.parse(experimentIdentifierString);
            ExperimentUpdatable result = this.findExperimentLocally(identifier);
            if (result != null) {
                return result;
            }
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment experimentOrNull = this.openBisService.tryGetExperiment(identifier);
            if (experimentOrNull != null) {
                result = new ExperimentUpdatable(experimentOrNull);
                this.experimentsToBeUpdated.add(result);
            }
            return result;
        }

        public IExperimentUpdatable makeExperimentMutable(IExperimentImmutable experiment) {
            if (experiment == null) {
                return null;
            }
            ExperimentUpdatable result = this.findExperimentLocally(experiment);
            if (result != null) {
                return result;
            }
            if (experiment instanceof ExperimentImmutable) {
                result = new ExperimentUpdatable(((ExperimentImmutable)experiment).getExperiment());
                this.experimentsToBeUpdated.add(result);
                return result;
            }
            return null;
        }

        private ExperimentUpdatable findExperimentLocally(ExperimentIdentifier experimentIdentifier) {
            String experimentIdentifierString = experimentIdentifier.toString();
            for (ExperimentUpdatable experiment : this.experimentsToBeUpdated) {
                if (!experiment.getExperimentIdentifier().equalsIgnoreCase(experimentIdentifierString)) continue;
                return experiment;
            }
            return null;
        }

        private ExperimentUpdatable findExperimentLocally(IExperimentImmutable experimentToFind) {
            for (ExperimentUpdatable experiment : this.experimentsToBeUpdated) {
                if (!experiment.equals(experimentToFind)) continue;
                return experiment;
            }
            return null;
        }

        public IExperiment createNewExperiment(String experimentIdentifierString, String experimentTypeCode) {
            String permId = this.openBisService.createPermId();
            Experiment experiment = new Experiment(experimentIdentifierString, permId);
            experiment.setExperimentType(experimentTypeCode);
            this.experimentsToBeRegistered.add(experiment);
            return experiment;
        }

        public ISpace createNewSpace(String spaceCode, String spaceAdminUserIdOrNull) {
            Space space = new Space(spaceCode, spaceAdminUserIdOrNull);
            this.spacesToBeRegistered.add(space);
            return space;
        }

        public IProject createNewProject(String projectIdentifier) {
            Project project = new Project(projectIdentifier);
            this.projectsToBeRegistered.add(project);
            return project;
        }

        public IProject getProjectForUpdate(String projectIdentifier) {
            ProjectIdentifier identifier = ProjectIdentifierFactory.parse(projectIdentifier);
            Project result = this.findProjectLocally(identifier);
            if (result != null) {
                return result;
            }
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project projectOrNull = this.openBisService.tryGetProject(identifier);
            if (projectOrNull != null) {
                result = new Project(projectOrNull);
                this.projectsToBeUpdated.add(result);
            }
            return result;
        }

        public IProject makeProjectMutable(IProjectImmutable project) {
            if (project == null) {
                return null;
            }
            Project result = this.findProjectLocally(project);
            if (result != null) {
                return result;
            }
            if (project instanceof ProjectImmutable) {
                result = new Project(((ProjectImmutable)project).getProject());
                this.projectsToBeUpdated.add(result);
                return result;
            }
            return null;
        }

        private Project findProjectLocally(ProjectIdentifier projectIdentifier) {
            String projectIdentifierString = projectIdentifier.toString();
            for (Project project : this.projectsToBeUpdated) {
                if (!project.getProjectIdentifier().equalsIgnoreCase(projectIdentifierString)) continue;
                return project;
            }
            return null;
        }

        private Project findProjectLocally(IProjectImmutable projectToFind) {
            for (Project project : this.projectsToBeUpdated) {
                if (!project.equals(projectToFind)) continue;
                return project;
            }
            return null;
        }

        public IMaterial createNewMaterial(String materialCode, String materialType) {
            Material material = new Material(materialCode, materialType);
            this.materialsToBeRegistered.add(material);
            return material;
        }

        public IMaterial getMaterialForUpdate(String materialCode, String materialType) {
            MaterialIdentifier materialIdentifier = new MaterialIdentifier(materialCode, materialType);
            Material result = this.findMaterialLocally(materialIdentifier);
            if (result != null) {
                return result;
            }
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material materialOrNull = this.openBisService.tryGetMaterial(materialIdentifier);
            if (materialOrNull != null) {
                result = new Material(materialOrNull);
                this.materialsToBeUpdated.add(result);
            }
            return result;
        }

        public IMaterial makeMaterialMutable(IMaterialImmutable material) {
            if (material == null) {
                return null;
            }
            Material result = this.findMaterialLocally(material);
            if (result != null) {
                return result;
            }
            if (material instanceof MaterialImmutable) {
                result = new Material(((MaterialImmutable)material).getMaterial());
                this.materialsToBeUpdated.add(result);
                return result;
            }
            return null;
        }

        private Material findMaterialLocally(MaterialIdentifier materialIdentifier) {
            String materialIdentifierString = materialIdentifier.toString();
            for (Material material : this.materialsToBeUpdated) {
                if (!material.getMaterialIdentifier().equalsIgnoreCase(materialIdentifierString)) continue;
                return material;
            }
            return null;
        }

        private Material findMaterialLocally(IMaterialImmutable materialToFind) {
            for (Material material : this.materialsToBeUpdated) {
                if (!material.equals(materialToFind)) continue;
                return material;
            }
            return null;
        }

        public IMetaproject createNewMetaproject(String name, String description, String ownerId) {
            Metaproject metaproject = Metaproject.createMetaproject(name, description, ownerId);
            this.metaprojectsToBeRegistered.add(metaproject);
            return metaproject;
        }

        public Metaproject getMetaproject(String name, String ownerId) {
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject dto = this.openBisService.tryGetMetaproject(name, ownerId);
            Metaproject metaproject = this.findExistingMetaprojectLocally(dto);
            if (metaproject == null) {
                metaproject = new Metaproject(dto);
                this.metaprojectsToBeUpdated.add(metaproject);
            }
            return metaproject;
        }

        public Metaproject findExistingMetaprojectLocally(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject dto) {
            for (Metaproject m : this.metaprojectsToBeUpdated) {
                if (m.getId() != dto.getId()) continue;
                return m;
            }
            return null;
        }

        public Vocabulary getVocabularyForUpdate(String code) {
            for (Vocabulary v : this.vocabulariesToBeUpdated) {
                if (!v.getCode().equals(code)) continue;
                return v;
            }
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary vocabulary = this.openBisService.tryGetVocabulary(code);
            if (vocabulary != null) {
                Vocabulary apiVocabulary = new Vocabulary(vocabulary);
                this.vocabulariesToBeUpdated.add(apiVocabulary);
                return apiVocabulary;
            }
            return null;
        }

        public String moveFile(String src, IDataSet dst) {
            File srcFile = new File(src);
            return this.moveFile(src, dst, srcFile.getName());
        }

        public String moveFile(String src, IDataSet dst, String dstInDataset) {
            DataSet dataSet = (DataSet)dst;
            File srcFile = new File(src);
            if (!srcFile.exists() && !(srcFile = new File(this.workingDirectory, src)).exists()) {
                throw CheckedExceptionTunnel.wrapIfNecessary(new FileNotFoundException("Neither '" + src + "' nor '" + srcFile.getAbsolutePath() + "' were found."));
            }
            File dataSetFolder = dataSet.getDataSetStagingFolder();
            File dstFile = new File(dataSetFolder, dstInDataset);
            FileUtilities.checkInputFile(srcFile);
            File dstFolder = dstFile.getParentFile();
            this.mkdirsIfNeeded(dstFolder);
            MoveFileCommand cmd = new MoveFileCommand(srcFile.getParentFile().getAbsolutePath(), srcFile.getName(), dstFolder.getAbsolutePath(), dstFile.getName());
            this.executeCommand(cmd);
            return dstFile.getAbsolutePath();
        }

        private void mkdirsIfNeeded(File dstFolder) {
            File parentDir = dstFolder.getParentFile();
            if (!parentDir.exists()) {
                this.mkdirsIfNeeded(parentDir);
            }
            if (!dstFolder.exists()) {
                MkdirsCommand cmd = new MkdirsCommand(dstFolder.getAbsolutePath());
                this.executeCommand(cmd);
            }
        }

        public String createNewDirectory(IDataSet dst, String dirName) {
            DataSet dataSet = (DataSet)dst;
            File dataSetFolder = dataSet.getDataSetStagingFolder();
            File dstFile = new File(dataSetFolder, dirName);
            MkdirsCommand cmd = new MkdirsCommand(dstFile.getAbsolutePath());
            this.executeCommand(cmd);
            return dstFile.getAbsolutePath();
        }

        public String createNewFile(IDataSet dst, String fileName) {
            return this.createNewFile(dst, "/", fileName);
        }

        public String createNewFile(IDataSet dst, String dstInDataset, String fileName) {
            DataSet dataSet = (DataSet)dst;
            File dataSetFolder = dataSet.getDataSetStagingFolder();
            File dstFolder = new File(dataSetFolder, dstInDataset);
            File dstFile = new File(dstFolder, fileName);
            NewFileCommand cmd = new NewFileCommand(dstFile.getAbsolutePath());
            this.executeCommand(cmd);
            return dstFile.getAbsolutePath();
        }

        public DynamicTransactionQuery getDatabaseQuery(String dataSourceName) {
            DynamicTransactionQuery query = this.queriesToCommit.get(dataSourceName);
            if (query == null) {
                DynamicTransactionQueryFactory factory = this.registrationService.getRegistratorContext().getGlobalState().getDynamicTransactionQueryFactory();
                query = factory.createDynamicTransactionQuery(dataSourceName);
                this.queriesToCommit.put(dataSourceName, query);
            }
            return query;
        }

        public void deleteFile(String src) {
            throw new NotImplementedException();
        }

        public boolean commit() {
            ArrayList<DataSetStorageAlgorithm<T>> algorithms = this.createStorageAlgorithmsForDataSets();
            DataSetStorageAlgorithmRunner<T> runner = new DataSetStorageAlgorithmRunner<T>(algorithms, this.parent, this.rollbackStack, this.registrationService.getDssRegistrationLog(), this.openBisService, this.registrationService, this.registrationService.getRegistratorContext().getGlobalState());
            boolean storageAlgorithmsSucceeded = runner.prepareAndRunStorageAlgorithms();
            this.reactToSecondaryTransactionErrors(storageAlgorithmsSucceeded);
            return storageAlgorithmsSucceeded;
        }

        private void reactToSecondaryTransactionErrors(boolean storageAlgorithmsSucceeded) {
            ArrayList<SecondaryTransactionFailure> encounteredErrors = new ArrayList<SecondaryTransactionFailure>();
            for (DynamicTransactionQuery query : this.queriesToCommit.values()) {
                try {
                    if (storageAlgorithmsSucceeded) {
                        query.commit();
                    } else {
                        query.rollback();
                    }
                    query.close(false);
                }
                catch (Throwable e) {
                    encounteredErrors.add(new SecondaryTransactionFailure(query, e));
                }
            }
            if (!encounteredErrors.isEmpty()) {
                this.parent.invokeDidEncounterSecondaryTransactionErrors(encounteredErrors);
            }
        }

        private ArrayList<DataSetStorageAlgorithm<T>> createStorageAlgorithmsForDataSets() {
            ArrayList<DataSetStorageAlgorithm<T>> algorithms = new ArrayList<DataSetStorageAlgorithm<T>>(this.registeredDataSets.size());
            for (DataSet<T> dataSet : this.registeredDataSets) {
                File contents = dataSet.tryDataSetContents();
                DataSetRegistrationDetails<? extends T> details = dataSet.getRegistrationDetails();
                IExperimentImmutable experiment = dataSet.getExperiment();
                ISampleImmutable sample = dataSet.getSample();
                if (this.experimentsToBeRegistered.contains(experiment) || this.samplesToBeRegistered.contains(sample)) {
                    algorithms.add(this.registrationService.createStorageAlgorithmWithIdentifiedStrategy(contents, details));
                    continue;
                }
                algorithms.add(this.registrationService.createStorageAlgorithm(contents, details));
            }
            return algorithms;
        }

        public void rollback() {
            this.rollbackStack.rollbackAll(new LiveTransactionRollbackDelegate(this.stagingDirectory));
            this.registeredDataSets.clear();
            for (DynamicTransactionQuery query : this.queriesToCommit.values()) {
                query.rollback();
                query.close(false);
            }
        }

        private void executeCommand(ITransactionalCommand cmd) {
            this.rollbackStack.pushAndExecuteCommand(cmd);
        }

        private String generateDataSetCode(DataSetRegistrationDetails<? extends T> registrationDetails) {
            return this.openBisService.createPermId();
        }

        AtomicEntityOperationDetails<T> createEntityOperationDetails(TechId registrationId, List<DataSetRegistrationInformation<T>> dataSetRegistrations) {
            for (DataSetRegistrationInformation<T> dataSetRegistrationInformation : dataSetRegistrations) {
                T dsInfo = dataSetRegistrationInformation.getDataSetInformation();
                if (((DataSetInformation)dsInfo).isLinkSample()) continue;
                ((DataSetInformation)dsInfo).setSample(null);
                ((DataSetInformation)dsInfo).setSampleCode(null);
                dataSetRegistrationInformation.getExternalData().setSampleIdentifierOrNull(null);
            }
            List<NewSpace> spaceRegistrations = this.convertSpacesToBeRegistered();
            List<NewProject> projectRegistrations = this.convertProjectsToBeRegistered();
            List<ProjectUpdatesDTO> projectUpdates = this.convertProjectsToBeUpdated();
            List<NewExperiment> experimentRegistrations = this.convertExperimentsToBeRegistered();
            List<ExperimentUpdatesDTO> experimentUpdates = this.convertExperimentsToBeUpdated();
            List<SampleUpdatesDTO> sampleUpdates = this.convertSamplesToBeUpdated();
            List<NewSample> sampleRegistrations = this.convertSamplesToBeRegistered();
            Map<String, List<NewMaterial>> materialRegistrations = this.convertMaterialsToBeRegistered();
            List<MaterialUpdateDTO> materialUpdates = this.convertMaterialsToBeUpdated();
            List<DataSetBatchUpdatesDTO> dataSetUpdates = this.convertDataSetsToBeUpdated();
            List<NewMetaproject> metaprojectRegistrations = this.convertMetaprojectsToBeRegistered();
            List<MetaprojectUpdatesDTO> metaprojectUpdates = this.convertMetaprojectsToBeUpdated();
            List<VocabularyUpdatesDTO> vocabularyUpdates = this.covertVocabulariesToBeUpdated();
            List<SpaceRoleAssignment> emptyAssignments = Collections.emptyList();
            AtomicEntityOperationDetails<T> registrationDetails = new AtomicEntityOperationDetails<T>(registrationId, this.getUserId(), spaceRegistrations, projectUpdates, projectRegistrations, experimentUpdates, experimentRegistrations, sampleUpdates, sampleRegistrations, materialRegistrations, materialUpdates, dataSetRegistrations, dataSetUpdates, metaprojectRegistrations, metaprojectUpdates, vocabularyUpdates, emptyAssignments, emptyAssignments);
            return registrationDetails;
        }

        private List<NewProject> convertProjectsToBeRegistered() {
            ArrayList<NewProject> result = new ArrayList<NewProject>();
            for (Project apiProject : this.projectsToBeRegistered) {
                result.add(ConversionUtils.convertToNewProject(apiProject));
            }
            return result;
        }

        private List<ProjectUpdatesDTO> convertProjectsToBeUpdated() {
            ArrayList<ProjectUpdatesDTO> result = new ArrayList<ProjectUpdatesDTO>(this.projectsToBeUpdated.size());
            for (Project apiProject : this.projectsToBeUpdated) {
                result.add(ConversionUtils.convertToProjectUpdateDTO(apiProject));
            }
            return result;
        }

        private List<NewSpace> convertSpacesToBeRegistered() {
            ArrayList<NewSpace> result = new ArrayList<NewSpace>();
            for (Space apiSpace : this.spacesToBeRegistered) {
                result.add(ConversionUtils.convertToNewSpace(apiSpace));
            }
            return result;
        }

        private List<NewExperiment> convertExperimentsToBeRegistered() {
            ArrayList<NewExperiment> result = new ArrayList<NewExperiment>();
            for (Experiment apiExperiment : this.experimentsToBeRegistered) {
                result.add(ConversionUtils.convertToNewExperiment(apiExperiment));
            }
            return result;
        }

        private List<ExperimentUpdatesDTO> convertExperimentsToBeUpdated() {
            ArrayList<ExperimentUpdatesDTO> result = new ArrayList<ExperimentUpdatesDTO>();
            for (ExperimentUpdatable experiment : this.experimentsToBeUpdated) {
                result.add(ConversionUtils.convertToExperimentUpdateDTO(experiment));
            }
            return result;
        }

        private List<NewSample> convertSamplesToBeRegistered() {
            ArrayList<NewSample> result = new ArrayList<NewSample>();
            for (Sample apiSample : this.samplesToBeRegistered) {
                result.add(ConversionUtils.convertToNewSample(apiSample));
            }
            return result;
        }

        private List<SampleUpdatesDTO> convertSamplesToBeUpdated() {
            ArrayList<SampleUpdatesDTO> result = new ArrayList<SampleUpdatesDTO>();
            for (Sample apiSample : this.samplesToBeUpdated) {
                result.add(ConversionUtils.convertToSampleUpdateDTO(apiSample));
            }
            return result;
        }

        private List<DataSetBatchUpdatesDTO> convertDataSetsToBeUpdated() {
            ArrayList<DataSetBatchUpdatesDTO> result = new ArrayList<DataSetBatchUpdatesDTO>();
            for (DataSetUpdatable dataSet : this.dataSetsToBeUpdated) {
                result.add(ConversionUtils.convertToDataSetBatchUpdatesDTO(dataSet));
            }
            return result;
        }

        private Map<String, List<NewMaterial>> convertMaterialsToBeRegistered() {
            HashMap<String, List<NewMaterial>> result = new HashMap<String, List<NewMaterial>>();
            for (Material material : this.materialsToBeRegistered) {
                NewMaterial converted = ConversionUtils.convertToNewMaterial(material);
                String materialType = material.getMaterialType();
                ArrayList<NewMaterial> materialsOfSameType = (ArrayList<NewMaterial>)result.get(materialType);
                if (materialsOfSameType == null) {
                    materialsOfSameType = new ArrayList<NewMaterial>();
                    result.put(materialType, materialsOfSameType);
                }
                materialsOfSameType.add(converted);
            }
            return result;
        }

        private List<MaterialUpdateDTO> convertMaterialsToBeUpdated() {
            ArrayList<MaterialUpdateDTO> result = new ArrayList<MaterialUpdateDTO>();
            for (Material material : this.materialsToBeUpdated) {
                MaterialUpdateDTO converted = ConversionUtils.convertToMaterialUpdateDTO(material);
                result.add(converted);
            }
            return result;
        }

        private List<NewMetaproject> convertMetaprojectsToBeRegistered() {
            ArrayList<NewMetaproject> result = new ArrayList<NewMetaproject>();
            for (Metaproject apiMetaproject : this.metaprojectsToBeRegistered) {
                result.add(ConversionUtils.convertToNewMetaproject(apiMetaproject));
            }
            return result;
        }

        private List<MetaprojectUpdatesDTO> convertMetaprojectsToBeUpdated() {
            ArrayList<MetaprojectUpdatesDTO> result = new ArrayList<MetaprojectUpdatesDTO>();
            for (Metaproject apiMetaproject : this.metaprojectsToBeUpdated) {
                result.add(ConversionUtils.convertToMetaprojectUpdatesDTO(apiMetaproject));
            }
            return result;
        }

        private List<VocabularyUpdatesDTO> covertVocabulariesToBeUpdated() {
            ArrayList<VocabularyUpdatesDTO> result = new ArrayList<VocabularyUpdatesDTO>();
            for (Vocabulary v : this.vocabulariesToBeUpdated) {
                LinkedList<NewVocabularyTerm> newTerms = new LinkedList<NewVocabularyTerm>();
                for (IVocabularyTerm t : v.getNewTerms()) {
                    NewVocabularyTerm newTerm = new NewVocabularyTerm(t.getCode(), t.getDescription(), t.getLabel(), t.getOrdinal());
                    newTerms.add(newTerm);
                }
                VocabularyUpdatesDTO updates = new VocabularyUpdatesDTO(v.getVocabulary().getId(), v.getCode(), v.getDescription(), v.isManagedInternally(), v.isInternalNamespace(), v.isChosenFromList(), v.getUrlTemplate(), newTerms);
                result.add(updates);
            }
            return result;
        }

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public boolean isRolledback() {
            return false;
        }
    }

    static class RolledbackTransactionState<T extends DataSetInformation>
    extends TerminalTransactionState<T> {
        public RolledbackTransactionState(LiveTransactionState<T> liveState) {
            super(liveState);
        }

        @Override
        public boolean isRolledback() {
            return true;
        }
    }

    private static abstract class TerminalTransactionState<T extends DataSetInformation>
    extends AbstractTransactionState<T> {
        private final LiveTransactionState<T> liveState;

        protected TerminalTransactionState(LiveTransactionState<T> liveState) {
            super(liveState.parent);
            this.liveState = liveState;
            this.deleteStagingFolders();
            ((LiveTransactionState)this.liveState).rollbackStack.discard();
        }

        private void deleteStagingFolders() {
            for (DataSet dataSet : ((LiveTransactionState)this.liveState).registeredDataSets) {
                dataSet.getDataSetStagingFolder().delete();
            }
        }
    }
}

