/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.AbstractTreeEntityPickerDialog;
import ch.systemsx.cisd.openbis.dss.client.api.gui.AsyncNodeAction;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.IAsyncAction;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.Identifier;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.SamplesDataSets;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;

public class DataSetPickerDialog
extends AbstractTreeEntityPickerDialog {
    private static final long serialVersionUID = 1L;

    public DataSetPickerDialog(JFrame mainWindow, DataSetUploadClientModel clientModel) {
        super(mainWindow, "Pick a data set", NewDataSetDTO.DataSetOwnerType.DATA_SET, clientModel);
        this.setDialogData();
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (node.getParent() == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (!(userObject instanceof Identifier)) {
            return;
        }
        Identifier identifier = (Identifier)userObject;
        this.expandNode(node, identifier);
    }

    @Override
    protected void expandNode(final DefaultMutableTreeNode node, Identifier identifier) {
        if (identifier.getOwnerType() != NewDataSetDTO.DataSetOwnerType.DATA_SET) {
            this.clientModel.listSamplesDataSets(identifier, (IAsyncAction<SamplesDataSets>)new AsyncNodeAction<SamplesDataSets>(this.tree, node, scheduler){

                @Override
                public void handleData(SamplesDataSets samplesDataSets) {
                    List<DataSet> dataSets = samplesDataSets.getDataSets();
                    node.removeAllChildren();
                    if (dataSets.size() > 0) {
                        DefaultMutableTreeNode dataSetsNode = new DefaultMutableTreeNode("Data Sets");
                        node.add(dataSetsNode);
                        for (DataSet dataSet : dataSets) {
                            dataSetsNode.add(new DefaultMutableTreeNode(Identifier.create(dataSet)));
                        }
                    }
                    for (Sample s : samplesDataSets.getSamples()) {
                        DefaultMutableTreeNode sampleNode = new DefaultMutableTreeNode(Identifier.create(s));
                        sampleNode.add(new DefaultMutableTreeNode("Loading data ..."));
                        node.add(sampleNode);
                    }
                }
            });
        }
    }
}

