/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases.AbstractSearchDomainService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomain;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EchoDatabase
extends AbstractSearchDomainService {
    public EchoDatabase(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public List<SearchDomainSearchResult> search(String sequenceSnippet, Map<String, String> optionalParametersOrNull) {
        String resultStr = optionalParametersOrNull.get(sequenceSnippet);
        if (resultStr != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                HelperBean bean = (HelperBean)mapper.readValue(resultStr, HelperBean.class);
                DataSetFileSearchResultLocation resultLocation = bean.getResultLoacation();
                SearchDomainSearchResult result = new SearchDomainSearchResult();
                result.setSearchDomain(bean.getSearchDomain());
                result.setResultLocation(resultLocation);
                return Collections.singletonList(result);
            }
            catch (Exception e) {
                throw CheckedExceptionTunnel.wrapIfNecessary(e);
            }
        }
        return Collections.emptyList();
    }

    public static final class HelperBean {
        private SearchDomain searchDomain = new SearchDomain();
        private DataSetFileSearchResultLocation resultLoacation = new DataSetFileSearchResultLocation();

        public DataSetFileSearchResultLocation getResultLoacation() {
            return this.resultLoacation;
        }

        public SearchDomain getSearchDomain() {
            return this.searchDomain;
        }

        public void setSearchDomain(String searchDomain) {
            this.searchDomain.setName(searchDomain);
        }

        public void setDataSetCode(String dataSetCode) {
            this.resultLoacation.setDataSetCode(dataSetCode);
        }

        public void setPathInDataSet(String path) {
            this.resultLoacation.setPathInDataSet(path);
        }

        public void setSequenceIdentifier(String identifier) {
            this.resultLoacation.setIdentifier(identifier);
        }

        public void setPositionInSequence(int position) {
            this.resultLoacation.setPosition(position);
        }
    }
}

