/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpUser;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.log4j.Logger;

public class FtpUserManager
implements UserManager {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FtpUserManager.class);
    private final IServiceForDataStoreServer service;

    public FtpUserManager(IServiceForDataStoreServer service) {
        this.service = service;
    }

    public User authenticate(Authentication authentication) throws AuthenticationFailedException {
        if (authentication instanceof UsernamePasswordAuthentication) {
            String password;
            UsernamePasswordAuthentication upa = (UsernamePasswordAuthentication)authentication;
            String user = upa.getUsername();
            SessionContextDTO session = this.service.tryAuthenticate(user, password = upa.getPassword());
            if (session != null && session.getSessionToken() != null) {
                return new FtpUser(user, session.getSessionToken());
            }
        } else {
            operationLog.warn("Unsupported authentication type :" + authentication.getClass());
        }
        throw new AuthenticationFailedException();
    }

    public void delete(String arg0) throws FtpException {
        throw new UnsupportedOperationException();
    }

    public boolean doesExist(String arg0) throws FtpException {
        return false;
    }

    public String getAdminName() throws FtpException {
        throw new UnsupportedOperationException();
    }

    public String[] getAllUserNames() throws FtpException {
        throw new UnsupportedOperationException();
    }

    public User getUserByName(String userName) throws FtpException {
        return new FtpUser(userName, null);
    }

    public boolean isAdmin(String arg0) throws FtpException {
        return false;
    }

    public void save(User arg0) throws FtpException {
        throw new UnsupportedOperationException();
    }
}

