/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.tar.Untar;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.TarBasedHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.TarDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class TarPackageManager
extends AbstractPackageManager {
    private final File tempFolder;

    public TarPackageManager(Properties properties) {
        this.tempFolder = PropertyUtils.getDirectory(properties, "temp-folder", null);
    }

    @Override
    public String getName(String dataSetCode) {
        return String.valueOf(dataSetCode) + ".tar";
    }

    @Override
    protected AbstractDataSetPackager createPackager(File packageFile, DataSetExistenceChecker existenceChecker) {
        return new TarDataSetPackager(packageFile, this.getContentProvider(), existenceChecker);
    }

    @Override
    public List<VerificationError> verify(File packageFile) {
        return Collections.emptyList();
    }

    @Override
    public Status extract(File packageFile, File toDirectory) {
        Untar untar = null;
        try {
            untar = new Untar(packageFile);
            untar.extract(toDirectory);
            File metadataFile = new File(toDirectory, "meta-data.tsv");
            if (metadataFile.exists() && metadataFile.isFile()) {
                FileUtilities.delete(metadataFile);
            }
            Status status = Status.OK;
            return status;
        }
        catch (Exception ex) {
            Status status = Status.createError(ex.toString());
            return status;
        }
        finally {
            if (untar != null) {
                try {
                    untar.close();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        }
    }

    @Override
    public IHierarchicalContent asHierarchialContent(File packageFile) {
        return new TarBasedHierarchicalContent(packageFile, this.tempFolder);
    }
}

