/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.base.io.ICloseable;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.collection.IExtendedBlockingQueue;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueDecorator;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueFactory;
import ch.systemsx.cisd.common.io.QueuePersister;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetCodesWithStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.remoting.RemoteAccessException;

public class QueueingDataSetStatusUpdaterService {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, QueueingDataSetStatusUpdaterService.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, QueueingDataSetStatusUpdaterService.class);
    private static IExtendedBlockingQueue<DataSetCodesWithStatus> queue = null;
    private static ICloseable queueCloseableOrNull = null;
    private static Thread thread = null;
    private static IDataSetStatusUpdater updater = null;

    public static final void start(File queueFile) {
        QueueingDataSetStatusUpdaterService.start(queueFile, TimingParameters.getDefaultParameters());
    }

    public static final synchronized void start(File queueFile, TimingParameters parameters) {
        PersistentExtendedBlockingQueueDecorator<DataSetCodesWithStatus> persistentQueue = PersistentExtendedBlockingQueueFactory.createSmartPersist(queueFile);
        queue = persistentQueue;
        queueCloseableOrNull = persistentQueue;
        updater = QueueingDataSetStatusUpdaterService.createDataSetStatusUpdater();
        thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        DataSetCodesWithStatus dataSets = (DataSetCodesWithStatus)queue.peekWait();
                        try {
                            updater.updateDataSetStatuses(dataSets.getDataSetCodes(), dataSets.getStatus(), dataSets.isPresentInArchive());
                            queue.take();
                            Sleeper.resetSleepTime();
                        }
                        catch (RemoteAccessException ex) {
                            this.notifyUpdateFailure(dataSets, (Exception)((Object)ex));
                            Sleeper.sleepAndIncreaseSleepTime();
                        }
                        catch (UserFailureException ex) {
                            this.notifyUpdateFailure(dataSets, ex);
                            Sleeper.sleepAndIncreaseSleepTime();
                            queue.add(dataSets);
                            queue.remove();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InterruptedExceptionUnchecked interruptedExceptionUnchecked) {}
            }

            private void notifyUpdateFailure(DataSetCodesWithStatus dataSets, Exception ex) {
                notificationLog.error("Update of data sets " + CollectionUtils.abbreviate(dataSets.getDataSetCodes(), 10) + " status to '" + (Object)((Object)dataSets.getStatus()) + "' has failed.\nRetry will occur not sooner than " + Sleeper.getCurrentSleepTime() + ".", ex);
            }
        }, "Updater Queue");
        thread.setDaemon(true);
        thread.start();
    }

    private static IDataSetStatusUpdater createDataSetStatusUpdater() {
        return new IDataSetStatusUpdater(){

            @Override
            public void updateDataSetStatuses(List<String> dataSetCodes, DataSetArchivingStatus newStatus, boolean presentInArchive) {
                ServiceProvider.getOpenBISService().updateDataSetStatuses(dataSetCodes, newStatus, presentInArchive);
                operationLog.info("Data Sets " + CollectionUtils.abbreviate(dataSetCodes, 10) + " changed status to " + (Object)((Object)newStatus));
            }
        };
    }

    public static void update(DataSetCodesWithStatus dataSets) {
        if (!dataSets.getDataSetCodes().isEmpty()) {
            queue.add(dataSets);
        }
    }

    private static final void close() {
        if (queueCloseableOrNull != null) {
            queueCloseableOrNull.close();
        }
    }

    public static final synchronized void stop() {
        if (thread == null) {
            return;
        }
        thread.interrupt();
        QueueingDataSetStatusUpdaterService.close();
        thread = null;
        queue = null;
        queueCloseableOrNull = null;
        updater = null;
    }

    public static final synchronized boolean stopAndWait(long timeoutMillis) {
        if (thread == null) {
            return true;
        }
        thread.interrupt();
        try {
            thread.join(timeoutMillis);
        }
        catch (InterruptedException interruptedException) {}
        QueueingDataSetStatusUpdaterService.close();
        boolean ok = !thread.isAlive();
        thread = null;
        queue = null;
        queueCloseableOrNull = null;
        updater = null;
        return ok;
    }

    public static final synchronized boolean isRunning() {
        return updater != null;
    }

    public static final List<DataSetCodesWithStatus> listItems(File queueFile) {
        return QueuePersister.list(DataSetCodesWithStatus.class, queueFile);
    }

    private QueueingDataSetStatusUpdaterService() {
    }

    public static interface IDataSetStatusUpdater {
        public void updateDataSetStatuses(List<String> var1, DataSetArchivingStatus var2, boolean var3);
    }

    private static class Sleeper {
        private static final long SECOND_IN_MILIS = 1000L;
        private static final long INITIAL_SLEEP_TIME = 60000L;
        private static final long MAX_SLEEP_TIME = 86400000L;
        private static final int FACTOR = 2;
        private static long sleepTime = 60000L;

        private Sleeper() {
        }

        public static String getCurrentSleepTime() {
            long seconds = sleepTime / 1000L;
            return String.valueOf(seconds) + "s";
        }

        public static void sleepAndIncreaseSleepTime() throws InterruptedException {
            operationLog.info("Going to sleep for " + Sleeper.getCurrentSleepTime());
            Thread.sleep(sleepTime);
            if ((sleepTime *= 2L) > 86400000L) {
                sleepTime = 86400000L;
            }
        }

        public static void resetSleepTime() {
            sleepTime = 60000L;
        }
    }
}

