/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.PngFilterType;
import ar.com.hjg.pngj.PngWriter;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.openbis.common.io.FileBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PngWritingHelper;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ImageUtil {
    public static final String TIFF_FILE = "tif";
    public static final String PNG_FILE = "png";
    public static final String JPEG_FILE = "jpg";
    public static final String GIF_FILE = "gif";
    public static final float DEFAULT_IMAGE_OPTIMAL_RESCALING_FACTOR = 0.01f;
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ImageUtil.class);
    private static final Set<String> FILE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("gif", "jpg", "jpeg", "png", "tif", "tiff")));
    private static final MagicNumbersManager MAGIC_NUMBERS_MANAGER = new MagicNumbersManager(new MagicNumber("gif", "474946383961", "474946383761"), new MagicNumber("jpg", "ffd8ff"), new MagicNumber("png", "89504e470d0a1a0a"), new MagicNumber("tif", "49492a00", "4d4d002a"));
    private static final Map<String, ImageLoader> imageLoaders = new HashMap<String, ImageLoader>();

    static {
        imageLoaders.put(GIF_FILE, new JavaImageLoader(GIF_FILE));
        imageLoaders.put(JPEG_FILE, new JavaImageLoader(JPEG_FILE));
        imageLoaders.put(PNG_FILE, new JavaImageLoader(PNG_FILE));
        imageLoaders.put(TIFF_FILE, new TiffImageLoader());
    }

    private static BufferedImage loadWithImageJ(IRandomAccessFile handle) {
        return ImageUtil.loadWithLibrary(handle, ImageID.NULL, "IJ", "tiff");
    }

    private static Dimension loadDimensionWithImageJ(IRandomAccessFile handle) {
        return ImageUtil.loadDimensionWithLibrary(handle, ImageID.NULL, "IJ", "tiff");
    }

    private static int loadColorDepthWithImageJ(IRandomAccessFile handle) {
        return ImageUtil.loadColorDepthWithLibrary(handle, ImageID.NULL, "IJ", "tiff");
    }

    private static BufferedImage loadWithBioFormats(IRandomAccessFile handle, ImageID imageID) {
        return ImageUtil.loadWithLibrary(handle, imageID, "BioFormats", "TiffDelegateReader");
    }

    private static Dimension loadDimensionWithBioFormats(IRandomAccessFile handle, ImageID imageID) {
        return ImageUtil.loadDimensionWithLibrary(handle, imageID, "BioFormats", "TiffDelegateReader");
    }

    private static int loadColorDepthWithBioFormats(IRandomAccessFile handle, ImageID imageID) {
        return ImageUtil.loadColorDepthWithLibrary(handle, imageID, "BioFormats", "TiffDelegateReader");
    }

    public static BufferedImage loadJavaAdvancedImagingTiff(IRandomAccessFile handle, ImageID imageID) throws EnvironmentFailureException {
        return ImageUtil.loadWithLibrary(handle, imageID, "JAI", "tiff");
    }

    public static Dimension loadDimensionJavaAdvancedImagingTiff(IRandomAccessFile handle, ImageID imageID) throws EnvironmentFailureException {
        return ImageUtil.loadDimensionWithLibrary(handle, imageID, "JAI", "tiff");
    }

    public static int loadColorDepthJavaAdvancedImagingTiff(IRandomAccessFile handle, ImageID imageID) throws EnvironmentFailureException {
        return ImageUtil.loadColorDepthWithLibrary(handle, imageID, "JAI", "tiff");
    }

    private static BufferedImage loadWithLibrary(IRandomAccessFile handle, ImageID imageIDOrNull, String libraryName, String readerName) {
        operationLog.debug("Load tiff image using " + libraryName);
        IImageReader imageReader = ImageReaderFactory.tryGetReader((String)libraryName, (String)readerName);
        if (imageReader == null) {
            throw new IllegalStateException(String.format("There is no reader '%s' in image library '%s'.", readerName, libraryName));
        }
        try {
            return imageReader.readImage(handle, imageIDOrNull, null);
        }
        catch (Exception ex) {
            throw EnvironmentFailureException.fromTemplate("Cannot decode image.", ex);
        }
    }

    private static Dimension loadDimensionWithLibrary(IRandomAccessFile handle, ImageID imageIDOrNull, String libraryName, String readerName) {
        operationLog.debug("Load tiff image using " + libraryName);
        IImageReader imageReader = ImageReaderFactory.tryGetReader((String)libraryName, (String)readerName);
        if (imageReader == null) {
            throw new IllegalStateException(String.format("There is no reader '%s' in image library '%s'.", readerName, libraryName));
        }
        try {
            return imageReader.readDimensions(handle, imageIDOrNull);
        }
        catch (Exception ex) {
            throw EnvironmentFailureException.fromTemplate("Cannot decode image.", ex);
        }
    }

    private static int loadColorDepthWithLibrary(IRandomAccessFile handle, ImageID imageIDOrNull, String libraryName, String readerName) {
        operationLog.debug("Load tiff image using " + libraryName);
        IImageReader imageReader = ImageReaderFactory.tryGetReader((String)libraryName, (String)readerName);
        if (imageReader == null) {
            throw new IllegalStateException(String.format("There is no reader '%s' in image library '%s'.", readerName, libraryName));
        }
        try {
            return imageReader.readColorDepth(handle, imageIDOrNull);
        }
        catch (Exception ex) {
            throw EnvironmentFailureException.fromTemplate("Cannot decode image.", ex);
        }
    }

    public static boolean isImageFile(File file) {
        String fileName = file.getName();
        String fileType = FilenameUtils.getExtension((String)fileName);
        return fileType != null && FILE_TYPES.contains(fileType.toLowerCase());
    }

    public static BufferedImage loadUnchangedImage(IHierarchicalContentNode contentNode, String imageIdOrNull, String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull, IReadParams params) {
        IImageReader reader;
        assert (imageLibraryReaderNameOrNull == null || imageLibraryNameOrNull != null) : "if image reader is specified then library name should be specified as well";
        ImageID imageID = ImageUtil.parseImageID(imageIdOrNull, contentNode);
        if (imageLibraryNameOrNull != null && imageLibraryReaderNameOrNull != null && (reader = ImageReaderFactory.tryGetReader((String)imageLibraryNameOrNull, (String)imageLibraryReaderNameOrNull)) != null) {
            IRandomAccessFile handle = contentNode.getFileContent();
            try {
                BufferedImage bufferedImage = reader.readImage(handle, imageID, params);
                return bufferedImage;
            }
            finally {
                ImageUtil.closeQuietly(handle);
            }
        }
        return ImageUtil.loadImageGuessingLibrary(contentNode, imageID);
    }

    public static Dimension loadUnchangedImageDimension(IHierarchicalContentNode contentNode, String imageIdOrNull, String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull) {
        IImageReader reader;
        assert (imageLibraryReaderNameOrNull == null || imageLibraryNameOrNull != null) : "if image reader is specified then library name should be specified as well";
        ImageID imageID = ImageUtil.parseImageID(imageIdOrNull, contentNode);
        if (imageLibraryNameOrNull != null && imageLibraryReaderNameOrNull != null && (reader = ImageReaderFactory.tryGetReader((String)imageLibraryNameOrNull, (String)imageLibraryReaderNameOrNull)) != null) {
            IRandomAccessFile handle = contentNode.getFileContent();
            try {
                Dimension dimension = reader.readDimensions(handle, imageID);
                return dimension;
            }
            finally {
                ImageUtil.closeQuietly(handle);
            }
        }
        return ImageUtil.loadImageDimensionGuessingLibrary(contentNode, imageID);
    }

    public static int loadUnchangedImageColorDepth(IHierarchicalContentNode contentNode, String imageIdOrNull, String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull) {
        IImageReader reader;
        assert (imageLibraryReaderNameOrNull == null || imageLibraryNameOrNull != null) : "if image reader is specified then library name should be specified as well";
        ImageID imageID = ImageUtil.parseImageID(imageIdOrNull, contentNode);
        if (imageLibraryNameOrNull != null && imageLibraryReaderNameOrNull != null && (reader = ImageReaderFactory.tryGetReader((String)imageLibraryNameOrNull, (String)imageLibraryReaderNameOrNull)) != null) {
            IRandomAccessFile handle = contentNode.getFileContent();
            try {
                int n = reader.readColorDepth(handle, imageID);
                return n;
            }
            finally {
                ImageUtil.closeQuietly(handle);
            }
        }
        return ImageUtil.loadImageColorDepthGuessingLibrary(contentNode, imageID);
    }

    public static byte[] imageToPngFast(BufferedImage image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtil.writeImageToPngFast(image, out);
        return out.toByteArray();
    }

    public static void writeImageToPngFast(BufferedImage image, OutputStream out) {
        ImageUtil.writeImageToPng(image, out, PngFilterType.FILTER_DEFAULT, 0);
    }

    public static byte[] imageToPng(BufferedImage image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtil.writeImageToPng(image, out);
        return out.toByteArray();
    }

    public static void writeImageToPng(BufferedImage image, OutputStream out) {
        ImageUtil.writeImageToPng(image, out, PngFilterType.FILTER_DEFAULT, 6);
    }

    public static byte[] imageToPng(BufferedImage image, PngFilterType filterType, int compressionLevel) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtil.writeImageToPng(image, out, filterType, compressionLevel);
        return out.toByteArray();
    }

    public static void writeImageToPng(BufferedImage image, OutputStream out, PngFilterType filterType, int compressionLevel) {
        PngWritingHelper helper = PngWritingHelper.createHelper(image);
        ImageInfo imgInfo = helper.getImageInfo();
        int rows = imgInfo.rows;
        PngWriter png = new PngWriter(out, imgInfo);
        png.setFilterType(filterType == null ? PngFilterType.FILTER_DEFAULT : filterType);
        png.setCompLevel(compressionLevel == -1 ? 6 : compressionLevel);
        ImageLine imageLine = new ImageLine(imgInfo);
        int row = 0;
        while (row < rows) {
            helper.fillLine(imageLine, row);
            imageLine.setRown(row);
            png.writeRow(imageLine);
            ++row;
        }
        png.end();
    }

    public static void writeImageUsingImageIO(BufferedImage image, OutputStream out, String format) throws IOExceptionUnchecked {
        try {
            ImageIO.write((RenderedImage)image, format, out);
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    public static ImageID parseImageID(String imageIdOrNull, IHierarchicalContentNode contentNode) {
        ImageID id = imageIdOrNull == null ? ImageID.NULL : ImageID.parse((String)imageIdOrNull);
        try {
            File fileOrNull = contentNode.tryGetFile();
            if (fileOrNull != null) {
                id.setFileName(fileOrNull.getCanonicalPath());
            }
        }
        catch (Exception ex) {
            operationLog.warn("Unable to set file name on image id. ", ex);
        }
        return id;
    }

    private static BufferedImage loadImageGuessingLibrary(IHierarchicalContentNode contentNode, ImageID imageID) {
        IRandomAccessFile handle = contentNode.getFileContent();
        String fileType = ImageUtil.tryToFigureOutFileTypeOf(handle);
        return ImageUtil.loadImageGuessingLibrary(handle, fileType, imageID);
    }

    private static Dimension loadImageDimensionGuessingLibrary(IHierarchicalContentNode contentNode, ImageID imageID) {
        IRandomAccessFile handle = contentNode.getFileContent();
        String fileType = ImageUtil.tryToFigureOutFileTypeOf(handle);
        return ImageUtil.loadImageDimensionGuessingLibrary(handle, fileType, imageID);
    }

    private static int loadImageColorDepthGuessingLibrary(IHierarchicalContentNode contentNode, ImageID imageID) {
        IRandomAccessFile handle = contentNode.getFileContent();
        String fileType = ImageUtil.tryToFigureOutFileTypeOf(handle);
        return ImageUtil.loadImageColorDepthGuessingLibrary(handle, fileType, imageID);
    }

    private static BufferedImage loadImageGuessingLibrary(IRandomAccessFile handle, String fileType, ImageID imageID) {
        try {
            if (fileType == null) {
                throw new IllegalArgumentException("File type of an image input stream couldn't be determined.");
            }
            ImageLoader imageLoader = imageLoaders.get(fileType);
            if (imageLoader == null) {
                throw new IllegalArgumentException("Unable to load image of file type '" + fileType + "'.");
            }
            BufferedImage bufferedImage = imageLoader.load(handle, imageID);
            return bufferedImage;
        }
        finally {
            ImageUtil.closeQuietly(handle);
        }
    }

    private static Dimension loadImageDimensionGuessingLibrary(IRandomAccessFile handle, String fileType, ImageID imageID) {
        try {
            if (fileType == null) {
                throw new IllegalArgumentException("File type of an image input stream couldn't be determined.");
            }
            ImageLoader imageLoader = imageLoaders.get(fileType);
            if (imageLoader == null) {
                throw new IllegalArgumentException("Unable to load image of file type '" + fileType + "'.");
            }
            Dimension dimension = imageLoader.readDimension(handle, imageID);
            return dimension;
        }
        finally {
            ImageUtil.closeQuietly(handle);
        }
    }

    private static int loadImageColorDepthGuessingLibrary(IRandomAccessFile handle, String fileType, ImageID imageID) {
        try {
            if (fileType == null) {
                throw new IllegalArgumentException("File type of an image input stream couldn't be determined.");
            }
            ImageLoader imageLoader = imageLoaders.get(fileType);
            if (imageLoader == null) {
                throw new IllegalArgumentException("Unable to load image of file type '" + fileType + "'.");
            }
            int n = imageLoader.readColorDepth(handle, imageID);
            return n;
        }
        finally {
            ImageUtil.closeQuietly(handle);
        }
    }

    @Private
    static BufferedImage loadImage(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file.getAbsolutePath());
        }
        return ImageUtil.loadImage(new FileBasedContentNode(file));
    }

    @Private
    static BufferedImage loadImage(IHierarchicalContentNode contentNode) {
        return ImageUtil.loadUnchangedImage(contentNode, null, null, null, null);
    }

    public static BufferedImage loadImageForDisplay(IHierarchicalContentNode contentNode) {
        if (!contentNode.exists()) {
            throw new IllegalArgumentException("File does not exist: " + contentNode.getRelativePath());
        }
        BufferedImage result = ImageUtil.loadImage(contentNode);
        result = ImageUtil.convertForDisplayIfNecessary(result);
        return result;
    }

    public static BufferedImage createThumbnailForDisplay(BufferedImage image, int maxWidth, int maxHeight) {
        BufferedImage result = ImageUtil.rescale(image, maxWidth, maxHeight, true, false);
        result = ImageUtil.convertForDisplayIfNecessary(result);
        return result;
    }

    public static BufferedImage convertForDisplayIfNecessary(BufferedImage image) {
        return ImageUtil.convertForDisplayIfNecessary(image, 0.01f);
    }

    public static BufferedImage convertForDisplayIfNecessary(BufferedImage image, float threshold) {
        if (ImageUtil.isGrayscale(image) && image.getColorModel().getPixelSize() > 8) {
            IntensityRescaling.GrayscalePixels pixels = new IntensityRescaling.GrayscalePixels(image);
            IntensityRescaling.Levels intensityRange = IntensityRescaling.computeLevels(pixels, threshold);
            BufferedImage result = IntensityRescaling.rescaleIntensityLevelTo8Bits(pixels, intensityRange);
            return result;
        }
        return image;
    }

    private static boolean isGrayscale(BufferedImage image) {
        return image.getColorModel().getColorSpace().getNumComponents() == 1;
    }

    public static BufferedImage rescale(BufferedImage image, int maxWidth, int maxHeight, boolean enlargeIfNecessary, boolean highQuality8Bit) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (width == maxWidth && maxHeight >= height || height == maxHeight && maxWidth >= width) {
            return image;
        }
        double widthScale = (double)maxWidth / (double)width;
        double heightScale = (double)maxHeight / (double)height;
        double scale = Math.min(widthScale, heightScale);
        if (!enlargeIfNecessary && scale > 1.0) {
            return image;
        }
        int thumbnailWidth = (int)(scale * (double)width + 0.5);
        int thumbnailHeight = (int)(scale * (double)height + 0.5);
        BufferedImage thumbnail = ImageUtil.createNewEmptyImage(image, highQuality8Bit, thumbnailWidth, thumbnailHeight);
        Graphics2D graphics2D = thumbnail.createGraphics();
        BufferedImage imageToRescale = image;
        if (highQuality8Bit) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            imageToRescale = ImageUtil.convertForDisplayIfNecessary(imageToRescale, 0.0f);
        }
        graphics2D.drawImage(imageToRescale, 0, 0, thumbnailWidth, thumbnailHeight, null);
        graphics2D.dispose();
        return thumbnail;
    }

    private static BufferedImage createNewEmptyImage(BufferedImage image, boolean highQuality8Bit, int thumbnailWidth, int thumbnailHeight) {
        boolean isTransparent = image.getColorModel().hasAlpha();
        int imageType = image.getType();
        if (highQuality8Bit) {
            imageType = imageType == 11 ? 10 : 1;
        } else if (imageType == 0) {
            imageType = isTransparent ? 2 : 1;
        } else if (imageType == 13) {
            imageType = 1;
        }
        BufferedImage thumbnail = new BufferedImage(thumbnailWidth, thumbnailHeight, imageType);
        return thumbnail;
    }

    private static void closeQuietly(IRandomAccessFile handle) {
        try {
            handle.close();
        }
        catch (Exception exception) {}
    }

    public static String tryToFigureOutFileTypeOf(IRandomAccessFile handle) {
        if (!handle.markSupported()) {
            throw new IllegalArgumentException("Input stream does not support marking. Wrap input stream with a BufferedInputStream to solve the problem.");
        }
        int maxLength = MAGIC_NUMBERS_MANAGER.getMaxLength();
        handle.mark(maxLength);
        byte[] initialBytes = new byte[maxLength];
        handle.read(initialBytes);
        handle.reset();
        return MAGIC_NUMBERS_MANAGER.tryToFigureOutFileTypeOf(initialBytes);
    }

    public static boolean isTiff(String fileTypeOrNull) {
        return TIFF_FILE.equals(fileTypeOrNull);
    }

    public static boolean isJpeg(String fileTypeOrNull) {
        return JPEG_FILE.equals(fileTypeOrNull);
    }

    public static boolean isPng(String fileTypeOrNull) {
        return PNG_FILE.equals(fileTypeOrNull);
    }

    public static boolean isGif(String fileTypeOrNull) {
        return GIF_FILE.equals(fileTypeOrNull);
    }

    private static interface ImageLoader {
        public BufferedImage load(IRandomAccessFile var1, ImageID var2);

        public Dimension readDimension(IRandomAccessFile var1, ImageID var2);

        public int readColorDepth(IRandomAccessFile var1, ImageID var2);
    }

    private static final class JavaImageLoader
    implements ImageLoader {
        private final String fileType;

        JavaImageLoader(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public BufferedImage load(IRandomAccessFile handle, ImageID imageID) {
            if (imageID.equals((Object)ImageID.NULL)) {
                IImageReader imageReader = ImageReaderFactory.tryGetReader((String)"ImageIO", (String)this.fileType);
                if (imageReader == null) {
                    throw EnvironmentFailureException.fromTemplate("Cannot find ImageIO reader for file type '%s'", this.fileType);
                }
                return imageReader.readImage(handle, ImageID.NULL, null);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Dimension readDimension(IRandomAccessFile handle, ImageID imageID) {
            if (imageID.equals((Object)ImageID.NULL)) {
                IImageReader imageReader = ImageReaderFactory.tryGetReader((String)"ImageIO", (String)this.fileType);
                if (imageReader == null) {
                    throw EnvironmentFailureException.fromTemplate("Cannot find ImageIO reader for file type '%s'", this.fileType);
                }
                return imageReader.readDimensions(handle, imageID);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public int readColorDepth(IRandomAccessFile handle, ImageID imageID) {
            if (imageID.equals((Object)ImageID.NULL)) {
                IImageReader imageReader = ImageReaderFactory.tryGetReader((String)"ImageIO", (String)this.fileType);
                if (imageReader == null) {
                    throw EnvironmentFailureException.fromTemplate("Cannot find ImageIO reader for file type '%s'", this.fileType);
                }
                return imageReader.readColorDepth(handle, imageID);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static final class MagicNumber {
        private final String fileType;
        private final String[] magicHexNumbers;
        private final int maxLength;

        MagicNumber(String fileType, String ... magicHexNumbers) {
            this.fileType = fileType;
            this.magicHexNumbers = magicHexNumbers;
            int length = 0;
            String[] stringArray = magicHexNumbers;
            int n = magicHexNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                String magicNumber = stringArray[n2];
                length = Math.max(length, magicNumber.length());
                ++n2;
            }
            this.maxLength = length / 2;
        }

        public String getFileType() {
            return this.fileType;
        }

        int getMaxLength() {
            return this.maxLength;
        }

        public boolean matches(byte[] bytes) {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < this.maxLength) {
                byte b = bytes[i];
                builder.append(Integer.toHexString(b >> 4 & 0xF));
                builder.append(Integer.toHexString(b & 0xF));
                ++i;
            }
            String initialBytes = builder.toString().toLowerCase();
            String[] stringArray = this.magicHexNumbers;
            int n = this.magicHexNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                String magicNumber = stringArray[n2];
                if (initialBytes.startsWith(magicNumber)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static final class MagicNumbersManager {
        private final MagicNumber[] magicNumbers;

        MagicNumbersManager(MagicNumber ... magicNumbers) {
            this.magicNumbers = magicNumbers;
        }

        int getMaxLength() {
            int max = 0;
            MagicNumber[] magicNumberArray = this.magicNumbers;
            int n = this.magicNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                MagicNumber magicNumber = magicNumberArray[n2];
                max = Math.max(max, magicNumber.getMaxLength());
                ++n2;
            }
            return max;
        }

        String tryToFigureOutFileTypeOf(byte[] initialBytes) {
            MagicNumber[] magicNumberArray = this.magicNumbers;
            int n = this.magicNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                MagicNumber magicNumber = magicNumberArray[n2];
                if (magicNumber.matches(initialBytes)) {
                    return magicNumber.getFileType();
                }
                ++n2;
            }
            return null;
        }
    }

    private static final class TiffImageLoader
    implements ImageLoader {
        private static final int MAX_READ_AHEAD = 30000000;

        private TiffImageLoader() {
        }

        @Override
        public BufferedImage load(IRandomAccessFile handle, ImageID imageID) {
            handle.mark(30000000);
            try {
                return ImageUtil.loadWithBioFormats(handle, imageID);
            }
            catch (RuntimeException runtimeException) {
                try {
                    return ImageUtil.loadJavaAdvancedImagingTiff(handle, imageID);
                }
                catch (RuntimeException ex2) {
                    if (imageID.equals((Object)ImageID.NULL)) {
                        handle.reset();
                        return ImageUtil.loadWithImageJ(handle);
                    }
                    throw ex2;
                }
            }
        }

        @Override
        public Dimension readDimension(IRandomAccessFile handle, ImageID imageID) {
            handle.mark(30000000);
            try {
                return ImageUtil.loadDimensionWithBioFormats(handle, imageID);
            }
            catch (RuntimeException runtimeException) {
                try {
                    return ImageUtil.loadDimensionJavaAdvancedImagingTiff(handle, imageID);
                }
                catch (RuntimeException ex2) {
                    if (imageID.equals((Object)ImageID.NULL)) {
                        handle.reset();
                        return ImageUtil.loadDimensionWithImageJ(handle);
                    }
                    throw ex2;
                }
            }
        }

        @Override
        public int readColorDepth(IRandomAccessFile handle, ImageID imageID) {
            handle.mark(30000000);
            try {
                return ImageUtil.loadColorDepthWithBioFormats(handle, imageID);
            }
            catch (RuntimeException runtimeException) {
                try {
                    return ImageUtil.loadColorDepthJavaAdvancedImagingTiff(handle, imageID);
                }
                catch (RuntimeException ex2) {
                    if (imageID.equals((Object)ImageID.NULL)) {
                        handle.reset();
                        return ImageUtil.loadColorDepthWithImageJ(handle);
                    }
                    throw ex2;
                }
            }
        }
    }
}

