/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GenericConstants;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ICallbackListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.InfoBoxCallbackListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IComponentWithCloseConfirmation;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ButtonWithConfirmations;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FormPanelWithSavePoint;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.InfoBox;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.HiddenField;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRegistrationForm
extends ContentPanel
implements IComponentWithCloseConfirmation {
    public static final int PANEL_MARGIN = 100;
    private static final String SESSION_KEY_PREFIX = "sessionKey_";
    public static final String SESSION_KEYS_NUMBER = "sessionKeysNumber";
    public static final String SAVE_BUTTON = "save-button";
    public static final int DEFAULT_LABEL_WIDTH = 100;
    public static final int DEFAULT_FIELD_WIDTH = 500;
    public static final int SECTION_LABEL_WIDTH = 109;
    public static final int SECTION_FIELD_WIDTH = 500;
    public static final int SECTION_DEFAULT_FIELD_WIDTH = 500;
    public static final int SECTION_WIDTH = 689;
    protected IMessageProvider messageProvider;
    protected InfoBox infoBox;
    protected InfoBoxResetListener infoBoxResetListener;
    protected FormPanelWithSavePoint formPanel;
    protected final int labelWidth;
    protected final int fieldWidth;
    protected ButtonWithConfirmations saveButton;
    private boolean sessionKeysInitiated = false;
    private Html loadingInfo;
    protected Html unsavedChangesInfo;
    protected LayoutContainer rightPanel;
    private Button resetButton;
    private Button revertButton;
    private boolean dirtyCheckEnabled = true;
    protected final boolean isPopUp;

    protected AbstractRegistrationForm(IMessageProvider messageProvider, String id) {
        this(messageProvider, id, 100, 500, false);
    }

    protected AbstractRegistrationForm(IMessageProvider messageProvider, String id, int labelWidth, int fieldWidth) {
        this(messageProvider, id, labelWidth, fieldWidth, false);
    }

    protected AbstractRegistrationForm(IMessageProvider messageProvider, String id, boolean isPopUp) {
        this(messageProvider, id, 100, 500, isPopUp);
    }

    protected AbstractRegistrationForm(IMessageProvider messageProvider, String id, int labelWidth, int fieldWidth, boolean isPopUp) {
        this.messageProvider = messageProvider;
        this.labelWidth = labelWidth;
        this.fieldWidth = fieldWidth;
        this.isPopUp = isPopUp;
        this.setHeaderVisible(false);
        this.setLayout((Layout)new FlowLayout(5));
        this.setBodyBorder(false);
        this.setBorders(false);
        this.setScrollMode(Style.Scroll.AUTO);
        this.setId(id);
        this.infoBox = AbstractRegistrationForm.createInfoBox(messageProvider);
        this.add((Widget)this.infoBox);
        if (isPopUp) {
            this.infoBox.setVisible(false);
        }
        this.loadingInfo = this.createLoadingInfo();
        this.add((Component)this.loadingInfo);
        Widget[] widgetArray = new Widget[2];
        this.formPanel = this.createFormPanel();
        widgetArray[0] = this.formPanel;
        this.rightPanel = this.createAdditionalPanel();
        widgetArray[1] = this.rightPanel;
        this.add((Component)WidgetUtils.inRow(widgetArray));
        if (isPopUp) {
            this.rightPanel.setVisible(false);
        }
        this.formPanel.setId("registration-panel-" + id);
        this.unsavedChangesInfo = this.createUnsavedChangesInfo();
        this.add((Component)this.unsavedChangesInfo);
    }

    public FormPanel getFormPanel() {
        return this.formPanel;
    }

    private LayoutContainer createAdditionalPanel() {
        LayoutContainer c = new LayoutContainer();
        c.setLayout((Layout)new FlowLayout(5));
        c.setBorders(false);
        c.setScrollMode(Style.Scroll.AUTO);
        return c;
    }

    private Html createLoadingInfo() {
        Html result = new Html("Loading...");
        result.setVisible(false);
        return result;
    }

    private Html createUnsavedChangesInfo() {
        Html result = new Html(this.messageProvider.getMessage("unsaved_form_changes_info", new Object[0]));
        result.addStyleName("unsaved-changes-info");
        result.setWidth(this.labelWidth + this.fieldWidth + 100);
        result.setVisible(false);
        return result;
    }

    private static final InfoBox createInfoBox(IMessageProvider messageProvider) {
        InfoBox infoBox = new InfoBox(messageProvider);
        return infoBox;
    }

    protected void setLoading(boolean loading) {
        this.formPanel.setVisible(!loading);
        this.loadingInfo.setVisible(loading);
        this.adjustFieldsSizes();
    }

    protected void updateDirtyCheck() {
        this.updateDirtyCheckAfterChange(this.formPanel.isDirtyForSavePoint());
    }

    protected void updateDirtyCheckAfterChange(boolean isDirty) {
        if (this.isDirtyCheckEnabled() && isDirty) {
            this.unsavedChangesInfo.setVisible(true);
        } else {
            this.unsavedChangesInfo.setVisible(false);
        }
    }

    protected void resetFieldsAfterSave() {
        this.resetPanel();
        this.updateDirtyCheckAfterSave();
    }

    protected void updateDirtyCheckAfterSave() {
        this.formPanel.setSavePoint();
        this.updateDirtyCheckAfterChange(false);
    }

    protected void resetPanel() {
        this.formPanel.reset();
        this.updateDirtyCheckAfterReset();
    }

    protected void updateDirtyCheckAfterReset() {
        this.updateDirtyCheckAfterChange(false);
    }

    protected void revertPanel() {
        this.updateDirtyCheckAfterRevert();
    }

    protected void updateDirtyCheckAfterRevert() {
        this.formPanel.resetToSavePoint();
        this.updateDirtyCheckAfterChange(false);
    }

    public void adjustFieldsSizes() {
        for (Field field : this.formPanel.getFields()) {
            field.syncSize();
        }
    }

    private FormPanelWithSavePoint createFormPanel() {
        final FormPanelWithSavePoint panel = new FormPanelWithSavePoint();
        this.infoBoxResetListener = new InfoBoxResetListener(this.infoBox);
        panel.addClickListener(this.infoBoxResetListener);
        panel.setHeaderVisible(false);
        panel.setBodyBorder(false);
        panel.setWidth(this.labelWidth + this.fieldWidth + 100);
        panel.setLabelWidth(this.labelWidth);
        panel.setFieldWidth(this.fieldWidth);
        panel.setButtonAlign(Style.HorizontalAlignment.RIGHT);
        panel.addDirtyChangeListener(new Listener<FormPanelWithSavePoint.DirtyChangeEvent>(){

            public void handleEvent(FormPanelWithSavePoint.DirtyChangeEvent e) {
                AbstractRegistrationForm.this.updateDirtyCheckAfterChange(e.isDirtyForSavePoint());
            }
        });
        this.saveButton = new ButtonWithConfirmations();
        this.saveButton.setText(this.messageProvider.getMessage("button_save", new Object[0]));
        this.saveButton.setStyleAttribute("marginRight", "20px");
        this.saveButton.setId(String.valueOf(this.getId()) + SAVE_BUTTON);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (panel.isValid()) {
                    AbstractRegistrationForm.this.submitValidForm();
                }
            }
        });
        this.addSaveButtonConfirmationListener();
        this.resetButton = new Button(this.messageProvider.getMessage("button_reset", new Object[0]));
        this.resetButton.setVisible(false);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractRegistrationForm.this.isDirtyCheckEnabled() && panel.isDirtyForSavePoint()) {
                    ce.setCancelled(true);
                    new ConfirmationDialog(AbstractRegistrationForm.this.messageProvider.getMessage("reset_unsaved_form_changes_confirmation_title", new Object[0]), AbstractRegistrationForm.this.messageProvider.getMessage("lose_unsaved_form_changes_confirmation_msg", new Object[0])){

                        @Override
                        protected void onYes() {
                            AbstractRegistrationForm.this.resetPanel();
                        }
                    }.show();
                } else {
                    AbstractRegistrationForm.this.resetPanel();
                }
            }
        });
        this.revertButton = new Button(this.messageProvider.getMessage("button_revert", new Object[0]));
        this.revertButton.setVisible(false);
        this.revertButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractRegistrationForm.this.isDirtyCheckEnabled() && panel.isDirtyForSavePoint()) {
                    ce.setCancelled(true);
                    new ConfirmationDialog(AbstractRegistrationForm.this.messageProvider.getMessage("revert_unsaved_form_changes_confirmation_title", new Object[0]), AbstractRegistrationForm.this.messageProvider.getMessage("lose_unsaved_form_changes_confirmation_msg", new Object[0])){

                        @Override
                        protected void onYes() {
                            AbstractRegistrationForm.this.revertPanel();
                        }
                    }.show();
                } else {
                    AbstractRegistrationForm.this.revertPanel();
                }
            }
        });
        if (!this.isPopUp) {
            panel.addButton(this.resetButton);
            panel.addButton(this.revertButton);
            panel.addButton(this.saveButton);
        }
        return panel;
    }

    protected void setUploadEnabled(boolean enabled) {
        this.saveButton.setEnabled(enabled);
    }

    protected void setResetButtonVisible(boolean visible) {
        this.resetButton.setVisible(visible);
    }

    protected void setRevertButtonVisible(boolean visible) {
        this.revertButton.setVisible(visible);
    }

    protected void addSaveButtonConfirmationListener() {
        this.addSaveButtonConfirmationListener(this.saveButton);
    }

    protected void addSaveButtonConfirmationListener(ButtonWithConfirmations button) {
        button.clearConfirmations();
        button.addConfirmation(new ButtonWithConfirmations.IConfirmation(){

            @Override
            public void confirm(final ButtonWithConfirmations.IConfirmationChain chain) {
                if (AbstractRegistrationForm.this.formPanel.isValid() && AbstractRegistrationForm.this.isDirtyCheckEnabled() && !AbstractRegistrationForm.this.formPanel.isDirtyForSavePoint()) {
                    new ConfirmationDialog(AbstractRegistrationForm.this.messageProvider.getMessage("save_unchanged_form_confirmation_title", new Object[0]), AbstractRegistrationForm.this.messageProvider.getMessage("save_unchanged_form_confirmation_msg", new Object[0])){

                        @Override
                        protected void onYes() {
                            chain.next();
                        }
                    }.show();
                } else {
                    chain.next();
                }
            }
        });
    }

    protected abstract void submitValidForm();

    public static final HiddenField<String> createHiddenSessionField(String value, int counter) {
        String name = SESSION_KEY_PREFIX + counter;
        return AbstractRegistrationForm.createHiddenField(name, value);
    }

    public static HiddenField<String> createHiddenField(String name, String value) {
        HiddenField hiddenField = new HiddenField();
        hiddenField.setName(name);
        hiddenField.setValue((Object)value);
        return hiddenField;
    }

    protected final void addUploadFeatures(String sessionKey) {
        ArrayList<String> sessionKeys = new ArrayList<String>();
        sessionKeys.add(sessionKey);
        this.addUploadFeatures(sessionKeys);
    }

    protected final void addUploadFeatures(List<String> sessionKeys) {
        assert (!this.sessionKeysInitiated) : "This method should be called only once.";
        AbstractRegistrationForm.addFileUploadFeature(this.formPanel, sessionKeys);
        this.sessionKeysInitiated = true;
    }

    public static void addFileUploadFeature(FormPanel formPanel, List<String> sessionKeys) {
        formPanel.setAction(GenericConstants.createServicePath("upload"));
        formPanel.setEncoding(FormPanel.Encoding.MULTIPART);
        formPanel.setMethod(FormPanel.Method.POST);
        formPanel.add(AbstractRegistrationForm.createHiddenField(SESSION_KEYS_NUMBER, String.valueOf(sessionKeys.size())));
        int i = 0;
        while (i < sessionKeys.size()) {
            formPanel.add(AbstractRegistrationForm.createHiddenSessionField(sessionKeys.get(i), i));
            ++i;
        }
    }

    public static String getEditTitle(IMessageProvider messageProvider, String entityKindDictKey, IIdAndCodeHolder identifiable) {
        return messageProvider.getMessage("edit_title", messageProvider.getMessage(entityKindDictKey, new Object[0]), identifiable.getCode());
    }

    @Override
    public boolean shouldAskForCloseConfirmation() {
        return this.isDirtyCheckEnabled() && this.formPanel.isDirtyForSavePoint();
    }

    public void setDirtyCheckEnabled(boolean dirtyCheckEnabled) {
        this.dirtyCheckEnabled = dirtyCheckEnabled;
    }

    public boolean isDirtyCheckEnabled() {
        return this.dirtyCheckEnabled;
    }

    protected abstract class AbstractRegistrationCallback<T>
    extends AbstractAsyncCallback<T> {
        protected AbstractRegistrationCallback(IViewContext<?> viewContext) {
            super(viewContext, new InfoBoxCallbackListener(AbstractRegistrationForm.this.infoBox));
            AbstractRegistrationForm.this.setUploadEnabled(false);
        }

        protected AbstractRegistrationCallback(IViewContext<?> viewContext, ICallbackListener<T> listener) {
            super(viewContext, listener);
            AbstractRegistrationForm.this.setUploadEnabled(false);
        }

        @Override
        protected void process(T result) {
            AbstractRegistrationForm.this.infoBox.displayInfo(this.createSuccessfullRegistrationInfo(result));
            try {
                AbstractRegistrationForm.this.resetFieldsAfterSave();
            }
            catch (JavaScriptException javaScriptException) {}
            AbstractRegistrationForm.this.setUploadEnabled(true);
        }

        protected abstract String createSuccessfullRegistrationInfo(T var1);

        @Override
        public void finishOnFailure(Throwable caught) {
            AbstractRegistrationForm.this.setUploadEnabled(true);
        }
    }

    public static final class InfoBoxResetListener
    implements Listener<FieldEvent>,
    ClickHandler {
        private final InfoBox infoBox;
        private boolean enabled = true;

        public InfoBoxResetListener(InfoBox infoBox) {
            assert (infoBox != null) : "Unspecified info box.";
            this.infoBox = infoBox;
        }

        private void resetInfoBox() {
            if (this.enabled) {
                this.infoBox.reset();
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public final void handleEvent(FieldEvent be) {
            this.resetInfoBox();
        }

        public final void onClick(ClickEvent sender) {
            this.resetInfoBox();
        }
    }
}

