/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractCommonServer;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.CommonServerLogger;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.server.IDataStoreServiceRegistrator;
import ch.systemsx.cisd.openbis.generic.server.IHotDeploymentController;
import ch.systemsx.cisd.openbis.generic.server.MetaprojectAssignmentsHelper;
import ch.systemsx.cisd.openbis.generic.server.SearchHelper;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationServiceUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractExpressionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.BasicEntityDescriptionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DeletionTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ListSampleCriteriaPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.RevertDeletionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.DeletionValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExpressionValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExternalDataValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.MatchingEntityValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ProjectValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SearchDomainSearchResultValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SpaceValidator;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.EntityCodeGenerator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.EntityTypeBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IAttachmentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IAuthorizationGroupBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICorePluginTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataStoreBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDeletedDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDeletionTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IEntityTypeBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IEntityTypePropertyTypeBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IGridCustomFilterOrColumnBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMaterialBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMaterialTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMetaprojectBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IProjectBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IPropertyTypeBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IPropertyTypeTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IRoleAssignmentTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IScriptBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISearchDomainSearcher;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISpaceBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ITrashBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IVocabularyBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IVocabularyTermBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.DatabaseContextUtils;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.IMaterialLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityHistoryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExternalDataManagementSystemDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IFileFormatTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMetaprojectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.HibernateSearchDataProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SampleDataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.DynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityAdaptorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.INonAbstractEntityAdapter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.JythonEntityValidationCalculator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDynamicPropertyCalculator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.IEntityValidatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.api.IEntityValidator;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.EncapsulatedCommonServer;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataRegistrationScriptRunner;
import ch.systemsx.cisd.openbis.generic.server.util.SpaceIdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignmentsIds;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomain;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.IMetaprojectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IdentifierExtractor;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroupUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImport;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImportFile;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelatedEntities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelationshipRole;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletionType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DynamicPropertyEvaluationInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityHistory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityValidationEvaluationInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IExpressionUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IMetaprojectRegistration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IMetaprojectUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IPropertyTypeUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IScriptUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISpaceUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyTermUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LastModificationState;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedUiActionDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsCount;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewColumnOrFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETNewPTAssigments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewPTNewAssigment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchDomainSearchResultWithFullEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermReplacement;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IPerson;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.ICorePluginResourceLoader;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractEntityPropertyHistoryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataManagementSystemPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.FileFormatTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomFilterPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationHolderDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityPropertyHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialUpdateDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewRoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermWithStats;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IManagedPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.shared.translator.AttachmentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.AuthorizationGroupTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataStoreServiceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataStoreTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityHistoryTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExternalDataManagementSystemTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.GridCustomExpressionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MetaprojectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ProjectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.RoleAssignmentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ScriptTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SpaceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.TypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTermTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;

public final class CommonServer
extends AbstractCommonServer<ICommonServerForInternalUse>
implements ICommonServerForInternalUse {
    private final LastModificationState lastModificationState;
    private final IDataStoreServiceRegistrator dataStoreServiceRegistrator;
    private final IEntityValidatorFactory entityValidationFactory;
    private final IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory;
    private final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;
    private String defaultPutDataStoreServerCodeOrNull;
    private static final String UPDATE_TEMPLATE_COMMENT = "# If one doesn't want to modify values in a column the column can be removed completely from the file.\n# Empty value in a column also means that the value stored in openBIS shouldn't be changed.\n# To delete a value/connection from openBIS one needs to put \"--DELETE--\" or \"__DELETE__\" into the corresponding cell.\n";

    public CommonServer(IAuthenticationService authenticationService, IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, ICommonBusinessObjectFactory businessObjectFactory, IDataStoreServiceRegistrator dataStoreServiceRegistrator, LastModificationState lastModificationState, IEntityValidatorFactory entityValidationFactory, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this(authenticationService, sessionManager, daoFactory, null, businessObjectFactory, dataStoreServiceRegistrator, lastModificationState, entityValidationFactory, dynamicPropertyCalculatorFactory, managedPropertyEvaluatorFactory);
    }

    CommonServer(IAuthenticationService authenticationService, IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, ICommonBusinessObjectFactory businessObjectFactory, IDataStoreServiceRegistrator dataStoreServiceRegistrator, LastModificationState lastModificationState, IEntityValidatorFactory entityValidationFactory, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(authenticationService, sessionManager, daoFactory, propertiesBatchManager, businessObjectFactory);
        this.dataStoreServiceRegistrator = dataStoreServiceRegistrator;
        this.lastModificationState = lastModificationState;
        this.entityValidationFactory = entityValidationFactory;
        this.dynamicPropertyCalculatorFactory = dynamicPropertyCalculatorFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    ICommonBusinessObjectFactory getBusinessObjectFactory() {
        return this.businessObjectFactory;
    }

    @Override
    public final ICommonServerForInternalUse createLogger(IInvocationLoggerContext context) {
        return new CommonServerLogger(this.getSessionManager(), context);
    }

    @Override
    public SessionContextDTO tryToAuthenticateAsSystem() {
        PersonPE systemUser = this.getSystemUser();
        HibernateUtils.initialize(systemUser.getAllPersonRoles());
        RoleAssignmentPE role = new RoleAssignmentPE();
        role.setDatabaseInstance(this.getDAOFactory().getHomeDatabaseInstance());
        role.setRole(RoleWithHierarchy.RoleCode.ADMIN);
        systemUser.addRoleAssignment(role);
        String sessionToken = this.sessionManager.tryToOpenSession(systemUser.getUserId(), new AbstractServer.AuthenticatedPersonBasedPrincipalProvider(systemUser));
        Session session = (Session)this.sessionManager.getSession(sessionToken);
        session.setPerson(systemUser);
        return this.tryGetSession(sessionToken);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SpaceValidator.class)
    public List<Space> listSpaces(String sessionToken, DatabaseInstanceIdentifier identifier) {
        Session session = this.getSession(sessionToken);
        DatabaseInstancePE databaseInstance = SpaceIdentifierHelper.getDatabaseInstance(identifier, this.getDAOFactory());
        List<SpacePE> spaces = this.getDAOFactory().getSpaceDAO().listSpaces(databaseInstance);
        SpacePE homeSpaceOrNull = session.tryGetHomeGroup();
        for (SpacePE space : spaces) {
            space.setHome(space.equals(homeSpaceOrNull));
        }
        Collections.sort(spaces);
        return SpaceTranslator.translate(spaces);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @Capability(value="REGISTER_SPACE")
    public void registerSpace(String sessionToken, String spaceCode, String descriptionOrNull) {
        Session session = this.getSession(sessionToken);
        ISpaceBO spaceBO = this.businessObjectFactory.createSpaceBO(session);
        spaceBO.define(spaceCode, descriptionOrNull);
        spaceBO.save();
        PersonPE person = session.tryGetPerson();
        if (person != null && !person.isSystemUser() && !new AuthorizationServiceUtils(this.getDAOFactory(), session.getUserName()).doesUserHaveRole(RoleWithHierarchy.RoleCode.ADMIN.toString(), null)) {
            this.registerSpaceRole(sessionToken, RoleWithHierarchy.RoleCode.ADMIN, new SpaceIdentifier(spaceCode), Grantee.createPerson(session.getUserName()));
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public ScriptUpdateResult updateScript(String sessionToken, IScriptUpdates updates) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (updates != null) : "Unspecified updates";
        Session session = this.getSession(sessionToken);
        IScriptBO bo = this.businessObjectFactory.createScriptBO(session);
        bo.update(updates);
        ScriptUpdateResult result = new ScriptUpdateResult();
        result.setModificationDate(bo.getScript().getModificationDate());
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @Capability(value="UPDATE_SPACE")
    public void updateSpace(String sessionToken, @AuthorizationGuard(guardClass=SpaceUpdatesPredicate.class) ISpaceUpdates updates) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (updates != null) : "Unspecified updates";
        Session session = this.getSession(sessionToken);
        ISpaceBO spaceBO = this.businessObjectFactory.createSpaceBO(session);
        spaceBO.update(updates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerPerson(String sessionToken, String userID) {
        this.registerPersons(sessionToken, Arrays.asList(userID));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    public List<RoleAssignment> listRoleAssignments(String sessionToken) {
        this.checkSession(sessionToken);
        List<RoleAssignmentPE> roles = this.getDAOFactory().getRoleAssignmentDAO().listRoleAssignments();
        return RoleAssignmentTranslator.translate(roles);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    public void registerSpaceRole(String sessionToken, RoleWithHierarchy.RoleCode roleCode, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier spaceIdentifier, Grantee grantee) {
        Session session = this.getSession(sessionToken);
        NewRoleAssignment newRoleAssignment = new NewRoleAssignment();
        newRoleAssignment.setSpaceIdentifier(spaceIdentifier);
        this.registerRole(roleCode, grantee, session, newRoleAssignment);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerInstanceRole(String sessionToken, RoleWithHierarchy.RoleCode roleCode, Grantee grantee) {
        Session session = this.getSession(sessionToken);
        NewRoleAssignment newRoleAssignment = new NewRoleAssignment();
        newRoleAssignment.setDatabaseInstanceIdentifier(new DatabaseInstanceIdentifier(DatabaseInstanceIdentifier.HOME));
        this.registerRole(roleCode, grantee, session, newRoleAssignment);
    }

    protected void registerRole(RoleWithHierarchy.RoleCode roleCode, Grantee grantee, Session session, NewRoleAssignment newRoleAssignment) {
        newRoleAssignment.setGrantee(grantee);
        newRoleAssignment.setRole(roleCode);
        IRoleAssignmentTable table = this.businessObjectFactory.createRoleAssignmentTable(session);
        table.add(newRoleAssignment);
        table.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    public void deleteSpaceRole(String sessionToken, RoleWithHierarchy.RoleCode roleCode, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier spaceIdentifier, Grantee grantee) {
        Session session = this.getSession(sessionToken);
        RoleAssignmentPE roleAssignment = this.getDAOFactory().getRoleAssignmentDAO().tryFindSpaceRoleAssignment(roleCode, spaceIdentifier.getSpaceCode(), grantee);
        if (roleAssignment == null) {
            throw new UserFailureException("Given space role does not exist.");
        }
        PersonPE personPE = session.tryGetPerson();
        if (roleAssignment.getPerson() != null && roleAssignment.getPerson().equals(personPE) && roleAssignment.getRole().equals((Object)RoleWithHierarchy.RoleCode.ADMIN)) {
            boolean isInstanceAdmin = false;
            for (RoleAssignmentPE roleAssigment : personPE.getRoleAssignments()) {
                if (roleAssigment.getDatabaseInstance() == null || !roleAssigment.getRole().equals((Object)RoleWithHierarchy.RoleCode.ADMIN)) continue;
                isInstanceAdmin = true;
            }
            if (!isInstanceAdmin) {
                throw new UserFailureException("For safety reason you cannot give away your own space admin power. Ask instance admin to do that for you.");
            }
        }
        this.getDAOFactory().getRoleAssignmentDAO().deleteRoleAssignment(roleAssignment);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deleteInstanceRole(String sessionToken, RoleWithHierarchy.RoleCode roleCode, Grantee grantee) {
        Session session = this.getSession(sessionToken);
        IRoleAssignmentDAO roleAssignmentDAO = this.getDAOFactory().getRoleAssignmentDAO();
        RoleAssignmentPE roleAssignment = roleAssignmentDAO.tryFindInstanceRoleAssignment(roleCode, grantee);
        if (roleAssignment == null) {
            throw new UserFailureException("Given database instance role does not exist.");
        }
        if (roleAssignment.getPerson() != null && roleAssignment.getPerson().equals(session.tryGetPerson()) && roleAssignment.getRole().equals((Object)RoleWithHierarchy.RoleCode.ADMIN) && roleAssignment.getDatabaseInstance() != null) {
            throw new UserFailureException("For safety reason you cannot give away your own omnipotence. Ask another instance admin to do that for you.");
        }
        roleAssignmentDAO.deleteRoleAssignment(roleAssignment);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public List<Person> listPersons(String sessionToken) {
        this.checkSession(sessionToken);
        List<PersonPE> persons = this.getDAOFactory().getPersonDAO().listPersons();
        Collections.sort(persons);
        return PersonTranslator.translate(persons);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public List<Person> listActivePersons(String sessionToken) {
        this.checkSession(sessionToken);
        List<PersonPE> persons = this.getDAOFactory().getPersonDAO().listActivePersons();
        Collections.sort(persons);
        return PersonTranslator.translate(persons);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ProjectValidator.class)
    public List<Project> listProjects(String sessionToken) {
        this.checkSession(sessionToken);
        List<ProjectPE> projects = this.getDAOFactory().getProjectDAO().listProjects();
        Collections.sort(projects);
        return ProjectTranslator.translate(projects);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<SampleType> listSampleTypes(String sessionToken) {
        this.checkSession(sessionToken);
        List<SampleTypePE> sampleTypes = this.getDAOFactory().getSampleTypeDAO().listSampleTypes();
        Collections.sort(sampleTypes);
        List<SampleType> translateSampleTypes = SampleTypeTranslator.translate(sampleTypes, new HashMap<PropertyTypePE, PropertyType>());
        return translateSampleTypes;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Map<String, List<IManagedInputWidgetDescription>> listManagedInputWidgetDescriptions(String sessionToken, EntityKind entityKind, String entityTypeCode) {
        this.checkSession(sessionToken);
        EntityTypePE entityTypePE = this.getDAOFactory().getEntityTypeDAO(DtoConverters.convertEntityKind(entityKind)).tryToFindEntityTypeByCode(entityTypeCode);
        EntityType entityType = EntityTypeTranslator.translate(entityTypePE);
        List<? extends EntityTypePropertyType<?>> assignedPropertyTypes = entityType.getAssignedPropertyTypes();
        return this.listManagedInputWidgetDescriptions(assignedPropertyTypes);
    }

    private Map<String, List<IManagedInputWidgetDescription>> listManagedInputWidgetDescriptions(List<? extends EntityTypePropertyType<?>> propertyTypes) {
        HashMap<String, List<IManagedInputWidgetDescription>> result = new HashMap<String, List<IManagedInputWidgetDescription>>();
        for (EntityTypePropertyType<?> entityTypePropertyType : propertyTypes) {
            IManagedPropertyEvaluator evaluator;
            List<IManagedInputWidgetDescription> inputWidgetDescriptions;
            String propertyTypeCode = entityTypePropertyType.getPropertyType().getCode();
            if (!entityTypePropertyType.isManaged() || (inputWidgetDescriptions = (evaluator = this.managedPropertyEvaluatorFactory.createManagedPropertyEvaluator(entityTypePropertyType)).getInputWidgetDescriptions()).isEmpty()) continue;
            result.put(propertyTypeCode, inputWidgetDescriptions);
        }
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleValidator.class)
    public List<Sample> listSamples(String sessionToken, @AuthorizationGuard(guardClass=ListSampleCriteriaPredicate.class) ListSampleCriteria criteria) {
        Session session = this.getSession(sessionToken);
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(session);
        return sampleLister.list(new ListOrSearchSampleCriteria(criteria));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Sample> listMetaprojectSamples(String sessionToken, IMetaprojectId metaprojectId) {
        Session session = this.getSession(sessionToken);
        AuthorizationServiceUtils authorization = this.getAuthorizationService(session);
        Metaproject metaproject = this.getMetaproject(sessionToken, metaprojectId);
        ISampleLister lister = this.businessObjectFactory.createSampleLister(session);
        List<Sample> samples = lister.list(new ListOrSearchSampleCriteria(new MetaprojectCriteria(metaproject.getId())));
        ArrayList<Sample> translatedSamples = new ArrayList<Sample>(samples.size());
        for (Sample sample : samples) {
            if (authorization.canAccessSample(sample)) {
                translatedSamples.add(sample);
                continue;
            }
            translatedSamples.add(SampleTranslator.translateWithoutRevealingData(sample));
        }
        return translatedSamples;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleValidator.class)
    public List<Sample> listSamplesOnBehalfOfUser(String sessionToken, @AuthorizationGuard(guardClass=ListSampleCriteriaPredicate.class) ListSampleCriteria criteria, String userId) {
        Session session = this.getSession(sessionToken);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        if (person == null) {
            throw new UserFailureException("Unknown user: " + userId);
        }
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(session, person.getId());
        return sampleLister.list(new ListOrSearchSampleCriteria(criteria));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleValidator.class)
    public List<Sample> listSamplesByMaterialProperties(String sessionToken, Collection<TechId> materialIds) {
        Session session = this.getSession(sessionToken);
        ISampleLister lister = this.businessObjectFactory.createSampleLister(session);
        Collection<TechId> ids = lister.listSamplesByMaterialProperties(materialIds);
        return lister.list(new ListOrSearchSampleCriteria(TechId.asLongs(ids)));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleValidator.class)
    public List<Sample> searchForSamples(String sessionToken, DetailedSearchCriteria criteria) {
        Session session = this.getSession(sessionToken);
        SearchHelper searchHelper = new SearchHelper(session, this.businessObjectFactory, this.getDAOFactory());
        return searchHelper.searchForSamples(session.getUserName(), criteria);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExternalDataValidator.class)
    public List<AbstractExternalData> listSampleExternalData(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId sampleId, boolean showOnlyDirectlyConnected) {
        Session session = this.getSession(sessionToken);
        IDatasetLister datasetLister = this.createDatasetLister(session);
        List<AbstractExternalData> datasets = datasetLister.listBySampleTechId(sampleId, showOnlyDirectlyConnected);
        Collections.sort(datasets);
        return datasets;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExternalDataValidator.class)
    public List<AbstractExternalData> listExperimentExternalData(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId, boolean showOnlyDirectlyConnected) {
        Session session = this.getSession(sessionToken);
        IDatasetLister datasetLister = this.createDatasetLister(session);
        List<AbstractExternalData> datasets = datasetLister.listByExperimentTechId(experimentId, showOnlyDirectlyConnected);
        Collections.sort(datasets);
        return datasets;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<AbstractExternalData> listMetaprojectExternalData(String sessionToken, IMetaprojectId metaprojectId) {
        Session session = this.getSession(sessionToken);
        AuthorizationServiceUtils authorization = this.getAuthorizationService(session);
        Metaproject metaproject = this.getMetaproject(sessionToken, metaprojectId);
        IDatasetLister lister = this.createDatasetLister(session);
        List<AbstractExternalData> datasets = lister.listByMetaprojectId(metaproject.getId());
        Collections.sort(datasets);
        ArrayList<AbstractExternalData> translatedDatasets = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData dataset : datasets) {
            if (authorization.canAccessDataSet(dataset)) {
                translatedDatasets.add(dataset);
                continue;
            }
            translatedDatasets.add(DataSetTranslator.translateWithoutRevealingData(dataset));
        }
        return translatedDatasets;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<AbstractExternalData> listDataSetRelationships(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.DataSetTechIdPredicate.class) TechId datasetId, DataSetRelationshipRole role) {
        Session session = this.getSession(sessionToken);
        IDatasetLister datasetLister = this.createDatasetLister(session);
        List<AbstractExternalData> datasets = null;
        switch (role) {
            case CONTAINER: {
                datasets = datasetLister.listByContainerTechId(datasetId);
                Collections.sort(datasets, AbstractExternalData.DATA_SET_COMPONENTS_COMPARATOR);
                break;
            }
            case CHILD: {
                datasets = datasetLister.listByChildTechId(datasetId);
                Collections.sort(datasets);
                break;
            }
            case PARENT: {
                datasets = datasetLister.listByParentTechIds(Arrays.asList(datasetId.getId()));
                Collections.sort(datasets);
            }
        }
        return datasets;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<PropertyType> listPropertyTypes(String sessionToken, boolean withRelations) {
        Session session = this.getSession(sessionToken);
        IPropertyTypeTable propertyTypeTable = this.businessObjectFactory.createPropertyTypeTable(session);
        if (withRelations) {
            propertyTypeTable.loadWithRelations();
        } else {
            propertyTypeTable.load();
        }
        List<PropertyTypePE> propertyTypes = propertyTypeTable.getPropertyTypes();
        Collections.sort(propertyTypes);
        return PropertyTypeTranslator.translate(propertyTypes, new HashMap<PropertyTypePE, PropertyType>());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<EntityTypePropertyType<?>> listEntityTypePropertyTypes(String sessionToken) {
        List<PropertyType> propertyTypes = this.listPropertyTypes(sessionToken, true);
        return CommonServer.extractAssignments(null, propertyTypes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<EntityTypePropertyType<?>> listEntityTypePropertyTypes(String sessionToken, EntityType entityType) {
        List<PropertyType> propertyTypes = this.listPropertyTypes(sessionToken, true);
        return CommonServer.extractAssignments(entityType, propertyTypes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<EntityHistory> listEntityHistory(String sessionToken, EntityKind entityKind, TechId entityID) {
        Session session = this.getSession(sessionToken);
        IEntityHistoryDAO entityPropertyHistoryDAO = this.getDAOFactory().getEntityPropertyHistoryDAO();
        List<AbstractEntityPropertyHistoryPE> result = entityPropertyHistoryDAO.getPropertyHistory(DtoConverters.convertEntityKind(entityKind), entityID);
        return EntityHistoryTranslator.translate(result, session.getBaseIndexURL(), this.managedPropertyEvaluatorFactory);
    }

    private static List<EntityTypePropertyType<?>> extractAssignments(EntityType entityTypeOrNull, List<PropertyType> listPropertyTypes) {
        ArrayList result = new ArrayList();
        for (PropertyType propertyType : listPropertyTypes) {
            CommonServer.extractAssignments(result, entityTypeOrNull, propertyType);
        }
        Collections.sort(result);
        return result;
    }

    private static void extractAssignments(List<EntityTypePropertyType<?>> result, EntityType entityTypeOrNull, PropertyType propertyType) {
        ArrayList<EntityTypePropertyType> allTypes = new ArrayList<EntityTypePropertyType>();
        for (ExperimentTypePropertyType experimentTypePropertyType : propertyType.getExperimentTypePropertyTypes()) {
            allTypes.add(experimentTypePropertyType);
        }
        for (SampleTypePropertyType sampleTypePropertyType : propertyType.getSampleTypePropertyTypes()) {
            allTypes.add(sampleTypePropertyType);
        }
        for (MaterialTypePropertyType materialTypePropertyType : propertyType.getMaterialTypePropertyTypes()) {
            allTypes.add(materialTypePropertyType);
        }
        for (DataSetTypePropertyType dataSetTypePropertyType : propertyType.getDataSetTypePropertyTypes()) {
            allTypes.add(dataSetTypePropertyType);
        }
        if (entityTypeOrNull == null) {
            result.addAll(allTypes);
        } else {
            for (EntityTypePropertyType entityTypePropertyType : allTypes) {
                if (!entityTypeOrNull.isEntityKind(entityTypePropertyType.getEntityKind()) || !entityTypeOrNull.equals(entityTypePropertyType.getEntityType())) continue;
                result.add(entityTypePropertyType);
            }
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=MatchingEntityValidator.class)
    public List<MatchingEntity> listMatchingEntities(String sessionToken, SearchableEntity[] searchableEntities, String queryText, boolean useWildcardSearchMode, int maxSize) {
        Session session = this.getSession(sessionToken);
        ArrayList<MatchingEntity> list = new ArrayList<MatchingEntity>();
        SearchableEntity[] searchableEntityArray = searchableEntities;
        int n = searchableEntities.length;
        int n2 = 0;
        while (n2 < n) {
            SearchableEntity searchableEntity = searchableEntityArray[n2];
            HibernateSearchDataProvider dataProvider = new HibernateSearchDataProvider(this.getDAOFactory());
            List<MatchingEntity> entities = this.getDAOFactory().getHibernateSearchDAO().searchEntitiesByTerm(session.getUserName(), searchableEntity, queryText, dataProvider, useWildcardSearchMode, list.size(), maxSize);
            list.addAll(entities);
            ++n2;
        }
        return list;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listMetaprojectExperiments(String sessionToken, IMetaprojectId metaprojectId) {
        Session session = this.getSession(sessionToken);
        AuthorizationServiceUtils authorization = this.getAuthorizationService(session);
        Metaproject metaproject = this.getMetaproject(sessionToken, metaprojectId);
        Collection<MetaprojectAssignmentPE> assignments = new MetaprojectAssignmentsHelper(this.getDAOFactory(), this.managedPropertyEvaluatorFactory).getMetaprojectAssignments(metaproject.getId(), EntityKind.EXPERIMENT);
        ArrayList<ExperimentPE> experimentsPE = new ArrayList<ExperimentPE>();
        for (MetaprojectAssignmentPE assignment : assignments) {
            experimentsPE.add(assignment.getExperiment());
        }
        List<Experiment> experiments = this.translateExperiments(sessionToken, experimentsPE);
        ArrayList<Experiment> translatedExperiments = new ArrayList<Experiment>(experiments.size());
        for (Experiment experiment : experiments) {
            if (authorization.canAccessExperiment(experiment)) {
                translatedExperiments.add(experiment);
                continue;
            }
            translatedExperiments.add(ExperimentTranslator.translateWithoutRevealingData(experiment));
        }
        return translatedExperiments;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperiments(String sessionToken, ExperimentType experimentType, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ProjectIdentifier projectIdentifier) {
        List<ProjectIdentifier> projectIdentifiers = projectIdentifier != null ? Collections.singletonList(projectIdentifier) : null;
        return this.listExperiments(sessionToken, experimentType, null, projectIdentifiers, false, false);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperiments(String sessionToken, ExperimentType experimentType, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) List<ProjectIdentifier> projectIdentifiers) {
        return this.listExperiments(sessionToken, experimentType, null, projectIdentifiers, false, false);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperimentsHavingSamples(String sessionToken, ExperimentType experimentType, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) List<ProjectIdentifier> projectIdentifiers) {
        return this.listExperiments(sessionToken, experimentType, null, projectIdentifiers, true, false);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperimentsHavingDataSets(String sessionToken, ExperimentType experimentType, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) List<ProjectIdentifier> projectIdentifiers) {
        return this.listExperiments(sessionToken, experimentType, null, projectIdentifiers, false, true);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperiments(String sessionToken, ExperimentType experimentType, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier spaceIdentifier) {
        return this.listExperiments(sessionToken, experimentType, spaceIdentifier, null, false, false);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperiments(String sessionToken, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) List<ExperimentIdentifier> experimentIdentifiers) {
        Session session = this.getSession(sessionToken);
        IExperimentTable experimentTable = this.businessObjectFactory.createExperimentTable(session);
        experimentTable.load(experimentIdentifiers);
        List<ExperimentPE> experiments = experimentTable.getExperiments();
        Collection<MetaprojectAssignmentPE> assignmentPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectAssignmentsForEntities(session.tryGetPerson(), experiments, ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.EXPERIMENT);
        Map<Long, Set<Metaproject>> assignments = MetaprojectTranslator.translateMetaprojectAssignments(assignmentPEs);
        Collections.sort(experiments);
        return ExperimentTranslator.translate(experiments, session.getBaseIndexURL(), assignments, this.managedPropertyEvaluatorFactory);
    }

    private final List<Experiment> listExperiments(String sessionToken, ExperimentType experimentType, SpaceIdentifier spaceIdentifierOrNull, List<ProjectIdentifier> projectIdentifiersOrNull, boolean onlyHavingSamples, boolean onlyHavingDataSets) {
        Session session = this.getSession(sessionToken);
        IExperimentTable experimentTable = this.businessObjectFactory.createExperimentTable(session);
        if (projectIdentifiersOrNull != null) {
            experimentTable.load(experimentType.getCode(), projectIdentifiersOrNull, onlyHavingSamples, onlyHavingDataSets);
        } else if (spaceIdentifierOrNull != null) {
            experimentTable.load(experimentType.getCode(), spaceIdentifierOrNull);
        }
        return this.translateExperiments(sessionToken, experimentTable.getExperiments());
    }

    private List<Experiment> translateExperiments(String sessionToken, List<ExperimentPE> experiments) {
        Session session = this.getSession(sessionToken);
        Collection<MetaprojectAssignmentPE> assignmentPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectAssignmentsForEntities(session.tryGetPerson(), experiments, ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.EXPERIMENT);
        Map<Long, Set<Metaproject>> assignments = MetaprojectTranslator.translateMetaprojectAssignments(assignmentPEs);
        Collections.sort(experiments);
        return ExperimentTranslator.translate(experiments, session.getBaseIndexURL(), assignments, this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ExperimentType> listExperimentTypes(String sessionToken) {
        List<ExperimentTypePE> experimentTypes = this.listEntityTypes(sessionToken, EntityKind.EXPERIMENT);
        return ExperimentTranslator.translate(experimentTypes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<MaterialType> listMaterialTypes(String sessionToken) {
        List<MaterialTypePE> materialTypes = this.listEntityTypes(sessionToken, EntityKind.MATERIAL);
        return MaterialTypeTranslator.translate(materialTypes, new HashMap<PropertyTypePE, PropertyType>());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public MaterialType getMaterialType(String sessionToken, String code) {
        EntityTypePE materialType = this.findEntityType(EntityKind.MATERIAL, code);
        return MaterialTypeTranslator.translateSimple(materialType);
    }

    private <T extends EntityTypePE> List<T> listEntityTypes(String sessionToken, EntityKind entityKind) {
        this.checkSession(sessionToken);
        List types = this.getDAOFactory().getEntityTypeDAO(DtoConverters.convertEntityKind(entityKind)).listEntityTypes();
        Collections.sort(types);
        return types;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<DataType> listDataTypes(String sessionToken) {
        assert (sessionToken != null) : "Unspecified session token";
        this.checkSession(sessionToken);
        List<DataTypePE> dataTypePEs = this.getDAOFactory().getPropertyTypeDAO().listDataTypes();
        List<DataType> dataTypes = DataTypeTranslator.translate(dataTypePEs);
        Collections.sort(dataTypes, new Comparator<DataType>(){

            @Override
            public int compare(DataType o1, DataType o2) {
                return o1.getCode().name().compareTo(o2.getCode().name());
            }
        });
        return dataTypes;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<FileFormatType> listFileFormatTypes(String sessionToken) {
        assert (sessionToken != null) : "Unspecified session token";
        this.checkSession(sessionToken);
        List<FileFormatTypePE> fileFormatTypePEs = this.getDAOFactory().getFileFormatTypeDAO().listFileFormatTypes();
        List<FileFormatType> fileFormatTypes = TypeTranslator.translate(fileFormatTypePEs);
        Collections.sort(fileFormatTypes, new Comparator<FileFormatType>(){

            @Override
            public int compare(FileFormatType o1, FileFormatType o2) {
                return o1.getCode().compareTo(o2.getCode());
            }
        });
        return fileFormatTypes;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Vocabulary> listVocabularies(String sessionToken, boolean withTerms, boolean excludeInternal) {
        assert (sessionToken != null) : "Unspecified session token";
        this.checkSession(sessionToken);
        List<VocabularyPE> vocabularies = this.getDAOFactory().getVocabularyDAO().listVocabularies(excludeInternal);
        if (withTerms) {
            for (VocabularyPE vocabularyPE : vocabularies) {
                this.enrichWithTerms(vocabularyPE);
            }
        }
        Collections.sort(vocabularies);
        return VocabularyTranslator.translate(vocabularies, withTerms);
    }

    private void enrichWithTerms(VocabularyPE vocabularyPE) {
        HibernateUtils.initialize(vocabularyPE.getTerms());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public String registerEntitytypeAndAssignPropertyTypes(String sessionToken, NewETNewPTAssigments newETNewPTAssigments) {
        newETNewPTAssigments.updateOrdinalToDBOrder();
        ArrayList<String> results = new ArrayList<String>();
        switch (newETNewPTAssigments.getEntity().getEntityKind()) {
            case SAMPLE: {
                this.registerSampleType(sessionToken, (SampleType)newETNewPTAssigments.getEntity());
                break;
            }
            case DATA_SET: {
                this.registerDataSetType(sessionToken, (DataSetType)newETNewPTAssigments.getEntity());
                break;
            }
            case EXPERIMENT: {
                this.registerExperimentType(sessionToken, (ExperimentType)newETNewPTAssigments.getEntity());
                break;
            }
            case MATERIAL: {
                this.registerMaterialType(sessionToken, (MaterialType)newETNewPTAssigments.getEntity());
            }
        }
        for (NewPTNewAssigment assigment : newETNewPTAssigments.getAssigments()) {
            if (!assigment.isExistingPropertyType()) {
                this.registerPropertyType(sessionToken, assigment.getPropertyType());
            }
            String result = this.assignPropertyType(sessionToken, assigment.getAssignment());
            results.add(result);
        }
        return ((Object)results).toString();
    }

    public static PropertyType returnIfContained(PropertyType propertyType, List<EntityTypePropertyType<?>> inList) {
        for (EntityTypePropertyType<?> etpt : inList) {
            if (!etpt.getPropertyType().getCode().equals(propertyType.getCode())) continue;
            return etpt.getPropertyType();
        }
        return null;
    }

    public void runIntegrityTest(List<EntityTypePropertyType<?>> ini, List<EntityTypePropertyType<?>> fin) {
        for (EntityTypePropertyType<?> etpt : fin) {
            PropertyType contained = CommonServer.returnIfContained(etpt.getPropertyType(), ini);
            if (contained == null || contained.getModificationDate().equals(etpt.getPropertyType().getModificationDate())) continue;
            throw new UserFailureException("Unfortunately " + contained.getCode() + " has been modified in the meantime.\n\n" + "Please, refresh the data and try it again.");
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public String updateEntitytypeAndPropertyTypes(String sessionToken, NewETNewPTAssigments newETNewPTAssigments) {
        newETNewPTAssigments.updateOrdinalToDBOrder();
        switch (newETNewPTAssigments.getEntity().getEntityKind()) {
            case SAMPLE: {
                this.updateSampleType(sessionToken, (SampleType)newETNewPTAssigments.getEntity());
                break;
            }
            case DATA_SET: {
                this.updateDataSetType(sessionToken, (DataSetType)newETNewPTAssigments.getEntity());
                break;
            }
            case EXPERIMENT: {
                this.updateExperimentType(sessionToken, (ExperimentType)newETNewPTAssigments.getEntity());
                break;
            }
            case MATERIAL: {
                this.updateMaterialType(sessionToken, (MaterialType)newETNewPTAssigments.getEntity());
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        List<EntityTypePropertyType<?>> ini = this.listEntityTypePropertyTypes(sessionToken, newETNewPTAssigments.getEntity());
        List<EntityTypePropertyType<?>> fin = newETNewPTAssigments.getEntity().getAssignedPropertyTypes();
        this.runIntegrityTest(ini, fin);
        int i = 0;
        while (i < fin.size()) {
            String result;
            if (i < ini.size()) {
                newETNewPTAssigments.getAssigments().get(i).getAssignment().setModificationDate(null);
                if (ini.get(i).getPropertyType().getCode().equals(fin.get(i).getPropertyType().getCode())) {
                    newETNewPTAssigments.getAssigments().get(i).getAssignment().setModificationDate(null);
                    this.updatePropertyTypeAssignment(sessionToken, newETNewPTAssigments.getAssigments().get(i).getAssignment());
                } else if (!fin.contains(ini.get(i))) {
                    this.unassignPropertyType(sessionToken, newETNewPTAssigments.getEntity().getEntityKind(), ini.get(i).getPropertyType().getCode(), newETNewPTAssigments.getEntity().getCode());
                    ini.remove(i);
                    --i;
                } else if (ini.contains(fin.get(i))) {
                    newETNewPTAssigments.getAssigments().get(i).getAssignment().setModificationDate(null);
                    this.updatePropertyTypeAssignment(sessionToken, newETNewPTAssigments.getAssigments().get(i).getAssignment());
                    ini.remove(fin.get(i));
                    ini.add(i, fin.get(i));
                } else {
                    if (!newETNewPTAssigments.getAssigments().get(i).isExistingPropertyType()) {
                        this.registerPropertyType(sessionToken, newETNewPTAssigments.getAssigments().get(i).getPropertyType());
                    }
                    result = this.assignPropertyType(sessionToken, newETNewPTAssigments.getAssigments().get(i).getAssignment());
                    results.add(result);
                    ini.add(i, fin.get(i));
                }
            } else {
                if (!newETNewPTAssigments.getAssigments().get(i).isExistingPropertyType()) {
                    this.registerPropertyType(sessionToken, newETNewPTAssigments.getAssigments().get(i).getPropertyType());
                }
                result = this.assignPropertyType(sessionToken, newETNewPTAssigments.getAssigments().get(i).getAssignment());
                results.add(result);
                ini.add(i, fin.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < ini.size()) {
            if (i >= fin.size() || !((Code)ini.get(i).getEntityType()).getCode().equals(((Code)fin.get(i).getEntityType()).getCode())) {
                this.unassignPropertyType(sessionToken, newETNewPTAssigments.getEntity().getEntityKind(), ini.get(i).getPropertyType().getCode(), newETNewPTAssigments.getEntity().getCode());
                this.unassignPropertyType(sessionToken, newETNewPTAssigments.getEntity().getEntityKind(), ini.get(i).getPropertyType().getCode(), newETNewPTAssigments.getEntity().getCode());
                ini.remove(i);
                --i;
            }
            ++i;
        }
        return ((Object)results).toString();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public String registerAndAssignPropertyType(String sessionToken, PropertyType propertyType, NewETPTAssignment assignment) {
        this.registerPropertyType(sessionToken, propertyType);
        return this.assignPropertyType(sessionToken, assignment);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public String assignPropertyType(String sessionToken, NewETPTAssignment assignment) {
        assert (sessionToken != null) : "Unspecified session token";
        Session session = this.getSession(sessionToken);
        ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind kind = DtoConverters.convertEntityKind(assignment.getEntityKind());
        IEntityTypePropertyTypeBO etptBO = this.businessObjectFactory.createEntityTypePropertyTypeBO(session, kind);
        etptBO.createAssignment(assignment);
        return String.format("%s property type '%s' successfully assigned to %s type '%s'", this.getAssignmentType(assignment), assignment.getPropertyTypeCode(), kind.getLabel(), assignment.getEntityTypeCode());
    }

    private String getAssignmentType(NewETPTAssignment assignment) {
        if (assignment.isDynamic()) {
            return "Dynamic";
        }
        if (assignment.isManaged()) {
            return "Managed";
        }
        if (assignment.isMandatory()) {
            return "Mandatory";
        }
        return "Optional";
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void updatePropertyTypeAssignment(String sessionToken, NewETPTAssignment assignmentUpdates) {
        assert (sessionToken != null) : "Unspecified session token";
        Session session = this.getSession(sessionToken);
        IEntityTypePropertyTypeBO etptBO = this.businessObjectFactory.createEntityTypePropertyTypeBO(session, DtoConverters.convertEntityKind(assignmentUpdates.getEntityKind()));
        etptBO.loadAssignment(assignmentUpdates.getPropertyTypeCode(), assignmentUpdates.getEntityTypeCode());
        etptBO.updateLoadedAssignment(assignmentUpdates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void unassignPropertyType(String sessionToken, EntityKind entityKind, String propertyTypeCode, String entityTypeCode) {
        assert (sessionToken != null) : "Unspecified session token";
        Session session = this.getSession(sessionToken);
        IEntityTypePropertyTypeBO etptBO = this.businessObjectFactory.createEntityTypePropertyTypeBO(session, DtoConverters.convertEntityKind(entityKind));
        etptBO.loadAssignment(propertyTypeCode, entityTypeCode);
        etptBO.deleteLoadedAssignment();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public int countPropertyTypedEntities(String sessionToken, EntityKind entityKind, String propertyTypeCode, String entityTypeCode) {
        assert (sessionToken != null) : "Unspecified session token";
        Session session = this.getSession(sessionToken);
        IEntityTypePropertyTypeBO etptBO = this.businessObjectFactory.createEntityTypePropertyTypeBO(session, DtoConverters.convertEntityKind(entityKind));
        return etptBO.countAssignmentValues(propertyTypeCode, entityTypeCode);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerPropertyType(String sessionToken, PropertyType propertyType) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (propertyType != null) : "Unspecified property type";
        Session session = this.getSession(sessionToken);
        IPropertyTypeBO propertyTypeBO = this.businessObjectFactory.createPropertyTypeBO(session);
        propertyTypeBO.define(propertyType);
        propertyTypeBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void updatePropertyType(String sessionToken, IPropertyTypeUpdates updates) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (updates != null) : "Unspecified updates";
        Session session = this.getSession(sessionToken);
        IPropertyTypeBO propertyTypeBO = this.businessObjectFactory.createPropertyTypeBO(session);
        propertyTypeBO.update(updates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="REGISTER_VOCABULARY")
    public void registerVocabulary(String sessionToken, NewVocabulary vocabulary) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (vocabulary != null) : "Unspecified vocabulary";
        Session session = this.getSession(sessionToken);
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(session);
        vocabularyBO.define(vocabulary);
        vocabularyBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_VOCABULARY")
    public void updateVocabulary(String sessionToken, IVocabularyUpdates updates) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (updates != null) : "Unspecified updates";
        Session session = this.getSession(sessionToken);
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(session);
        vocabularyBO.update(updates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_VOCABULARY_TERM")
    public void addVocabularyTerms(String sessionToken, TechId vocabularyId, List<VocabularyTerm> vocabularyTerms, Long previousTermOrdinal, boolean allowChangingInternallyManaged) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (vocabularyId != null) : "Unspecified vocabulary id";
        Session session = this.getSession(sessionToken);
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(session);
        if (allowChangingInternallyManaged) {
            vocabularyBO.setAllowChangingInternallyManaged(true);
        }
        vocabularyBO.loadDataByTechId(vocabularyId);
        vocabularyBO.addNewTerms(vocabularyTerms, previousTermOrdinal);
        vocabularyBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_UNOFFICIAL_VOCABULARY_TERM")
    public void addUnofficialVocabularyTerm(String sessionToken, TechId vocabularyId, String code, String label, String description, Long previousTermOrdinal) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (vocabularyId != null) : "Unspecified vocabulary id";
        assert (code != null) : "Unspecified code";
        assert (previousTermOrdinal != null) : "Unspecified previous term ordinal";
        Session session = this.getSession(sessionToken);
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(session);
        vocabularyBO.loadDataByTechId(vocabularyId);
        vocabularyBO.addNewUnofficialTerm(code, label, description, previousTermOrdinal);
        vocabularyBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_VOCABULARY_TERM")
    public void updateVocabularyTerm(String sessionToken, IVocabularyTermUpdates updates) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (updates != null) : "Unspecified updates";
        Session session = this.getSession(sessionToken);
        IVocabularyTermBO vocabularyTermBO = this.businessObjectFactory.createVocabularyTermBO(session);
        vocabularyTermBO.update(updates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_VOCABULARY_TERM")
    public void deleteVocabularyTerms(String sessionToken, TechId vocabularyId, List<VocabularyTerm> termsToBeDeleted, List<VocabularyTermReplacement> termsToBeReplaced) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (vocabularyId != null) : "Unspecified vocabulary id";
        Session session = this.getSession(sessionToken);
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(session);
        vocabularyBO.loadDataByTechId(vocabularyId);
        vocabularyBO.delete(termsToBeDeleted, termsToBeReplaced);
        vocabularyBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_VOCABULARY")
    public void makeVocabularyTermsOfficial(String sessionToken, TechId vocabularyId, List<VocabularyTerm> termsToBeOfficial) {
        assert (sessionToken != null) : "Unspecified session token";
        assert (vocabularyId != null) : "Unspecified vocabulary id";
        Session session = this.getSession(sessionToken);
        IVocabularyTermBO vocabularyTermBO = this.businessObjectFactory.createVocabularyTermBO(session);
        vocabularyTermBO.makeOfficial(termsToBeOfficial);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="REGISTER_PROJECT")
    public void registerProject(String sessionToken, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ProjectIdentifier projectIdentifier, String description, String leaderId, Collection<NewAttachment> attachments) {
        Session session = this.getSession(sessionToken);
        IProjectBO projectBO = this.businessObjectFactory.createProjectBO(session);
        projectBO.define(projectIdentifier, description, null, leaderId);
        projectBO.save();
        for (NewAttachment attachment : attachments) {
            AttachmentPE attachmentPE = AttachmentTranslator.translate(attachment);
            projectBO.addAttachment(attachmentPE);
        }
        projectBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> searchForExperiments(String sessionToken, DetailedSearchCriteria criteria) {
        Session session = this.getSession(sessionToken);
        SearchHelper searchHelper = new SearchHelper(session, this.businessObjectFactory, this.getDAOFactory());
        String userId = session.getUserName();
        List<ExperimentPE> experiments = searchHelper.searchForExperiments(userId, criteria);
        return this.translateExperiments(sessionToken, experiments);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SearchDomainSearchResultValidator.class)
    public List<SearchDomainSearchResultWithFullEntity> searchOnSearchDomain(String sessionToken, String preferredSearchDomainOrNull, String searchString, Map<String, String> optionalParametersOrNull) {
        Session session = this.getSession(sessionToken);
        ISearchDomainSearcher searcher = this.businessObjectFactory.createSearchDomainSearcher(session);
        return searcher.searchForEntitiesWithSequences(preferredSearchDomainOrNull, searchString, optionalParametersOrNull);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<SearchDomain> listAvailableSearchDomains(String sessionToken) {
        Session session = this.getSession(sessionToken);
        ISearchDomainSearcher searcher = this.businessObjectFactory.createSearchDomainSearcher(session);
        return searcher.listAvailableSearchDomains();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExternalDataValidator.class)
    public List<AbstractExternalData> searchForDataSets(String sessionToken, DetailedSearchCriteria criteria) {
        Session session = this.getSession(sessionToken);
        SearchHelper searchHelper = new SearchHelper(session, this.businessObjectFactory, this.getDAOFactory());
        return searchHelper.searchForDataSets(session.getUserName(), criteria);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<AbstractExternalData> searchForDataSetsOnBehalfOfUser(String sessionToken, DetailedSearchCriteria criteria, String userId) {
        Session session = this.getSession(sessionToken);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        if (person == null) {
            throw new UserFailureException("Unknown user: " + userId);
        }
        SearchHelper searchHelper = new SearchHelper(session, this.businessObjectFactory, this.getDAOFactory());
        List<AbstractExternalData> unfilteredDatasets = searchHelper.searchForDataSets(userId, person.getId(), criteria);
        ExternalDataValidator validator = new ExternalDataValidator();
        ArrayList<AbstractExternalData> datasets = new ArrayList<AbstractExternalData>(unfilteredDatasets.size());
        for (AbstractExternalData dataset : unfilteredDatasets) {
            if (!validator.doValidation(person, dataset)) continue;
            datasets.add(dataset);
        }
        return datasets;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public AbstractExternalData getDataSetInfo(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.DataSetTechIdPredicate.class) TechId datasetId) {
        Session session = this.getSession(sessionToken);
        IDataBO datasetBO = this.businessObjectFactory.createDataBO(session);
        datasetBO.loadDataByTechId(datasetId);
        datasetBO.enrichWithParentsAndExperiment();
        datasetBO.enrichWithContainedDataSets();
        datasetBO.enrichWithProperties();
        DataPE dataset = datasetBO.getData();
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), dataset);
        return DataSetTranslator.translate(dataset, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_DATASET")
    public DataSetUpdateResult updateDataSet(String sessionToken, @AuthorizationGuard(guardClass=DataSetUpdatesPredicate.class) DataSetUpdatesDTO updates) {
        Session session = this.getSession(sessionToken);
        IDataBO dataSetBO = this.businessObjectFactory.createDataBO(session);
        dataSetBO.update(updates);
        DataSetUpdateResult result = new DataSetUpdateResult();
        DataPE data = dataSetBO.getData();
        result.setVersion(data.getVersion());
        List<String> parents = IdentifierExtractor.extract(data.getParents());
        Collections.sort(parents);
        result.setParentCodes(parents);
        result.setContainedDataSetCodes(Code.extractCodes(data.getContainedDataSets()));
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExternalDataValidator.class)
    public List<AbstractExternalData> listRelatedDataSets(String sessionToken, DataSetRelatedEntities relatedEntities, boolean withDetails) {
        Session session = this.getSession(sessionToken);
        LinkedHashSet<DataPE> resultSet = new LinkedHashSet<DataPE>();
        this.addRelatedDataSets(resultSet, relatedEntities.getEntities());
        IMetaprojectDAO mpd = this.getDAOFactory().getMetaprojectDAO();
        Collection<MetaprojectAssignmentPE> assignments = mpd.listMetaprojectAssignmentsForEntities(session.tryGetPerson(), resultSet, ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.DATA_SET);
        Map<Long, Set<Metaproject>> translation = MetaprojectTranslator.translateMetaprojectAssignments(assignments);
        ArrayList<AbstractExternalData> list = new ArrayList<AbstractExternalData>(resultSet.size());
        for (DataPE hit : resultSet) {
            HibernateUtils.initialize(hit.getChildRelationships());
            list.add(DataSetTranslator.translate(hit, session.getBaseIndexURL(), withDetails, (Collection<Metaproject>)translation.get(hit.getId()), this.managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]));
        }
        return list;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    @ReturnValueFilter(validatorClass=ExternalDataValidator.class)
    public List<AbstractExternalData> listRelatedDataSetsOnBehalfOfUser(String sessionToken, DataSetRelatedEntities relatedEntities, boolean withDetails, String userId) {
        Session session = this.getSession(sessionToken);
        LinkedHashSet<DataPE> resultSet = new LinkedHashSet<DataPE>();
        this.addRelatedDataSets(resultSet, relatedEntities.getEntities());
        IMetaprojectDAO mpd = this.getDAOFactory().getMetaprojectDAO();
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        if (person == null) {
            throw new UserFailureException("Unknown user: " + userId);
        }
        Collection<MetaprojectAssignmentPE> assignments = mpd.listMetaprojectAssignmentsForEntities(person, resultSet, ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.DATA_SET);
        Map<Long, Set<Metaproject>> translation = MetaprojectTranslator.translateMetaprojectAssignments(assignments);
        ArrayList<AbstractExternalData> list = new ArrayList<AbstractExternalData>(resultSet.size());
        for (DataPE hit : resultSet) {
            HibernateUtils.initialize(hit.getChildRelationships());
            list.add(DataSetTranslator.translate(hit, session.getBaseIndexURL(), withDetails, (Collection<Metaproject>)translation.get(hit.getId()), this.managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]));
        }
        return list;
    }

    private void addRelatedDataSets(Set<DataPE> resultSet, List<? extends IEntityInformationHolder> relatedEntities) {
        IDataDAO dataDAO = this.getDAOFactory().getDataDAO();
        EnumMap<EntityKind, ArrayList<IEntityInformationHolder>> entities = new EnumMap<EntityKind, ArrayList<IEntityInformationHolder>>(EntityKind.class);
        for (IEntityInformationHolder iEntityInformationHolder : relatedEntities) {
            if (!this.isEntityKindRelatedWithDataSets(iEntityInformationHolder.getEntityKind())) continue;
            ArrayList<IEntityInformationHolder> entitiesOfGivenKind = (ArrayList<IEntityInformationHolder>)entities.get(iEntityInformationHolder.getEntityKind());
            if (entitiesOfGivenKind == null) {
                entitiesOfGivenKind = new ArrayList<IEntityInformationHolder>();
                entities.put(iEntityInformationHolder.getEntityKind(), entitiesOfGivenKind);
            }
            entitiesOfGivenKind.add(iEntityInformationHolder);
        }
        for (Map.Entry entry : entities.entrySet()) {
            if (entry.getValue() == null || ((List)entry.getValue()).size() <= 0) continue;
            List<DataPE> relatedDataSets = dataDAO.listRelatedDataSets((List)entry.getValue(), (EntityKind)entry.getKey());
            resultSet.addAll(relatedDataSets);
        }
    }

    private boolean isEntityKindRelatedWithDataSets(EntityKind entityKind) {
        switch (entityKind) {
            case EXPERIMENT: 
            case SAMPLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Material> listMaterials(String sessionToken, ListMaterialCriteria criteria, boolean withProperties) {
        Session session = this.getSession(sessionToken);
        IMaterialLister materialLister = this.businessObjectFactory.createMaterialLister(session);
        return materialLister.list(criteria, withProperties);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Collection<TechId> listMaterialIdsByMaterialProperties(String sessionToken, Collection<TechId> materialIds) {
        Session session = this.getSession(sessionToken);
        IMaterialLister materialLister = this.businessObjectFactory.createMaterialLister(session);
        return materialLister.listMaterialsByMaterialProperties(materialIds);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Material> listMetaprojectMaterials(String sessionToken, IMetaprojectId metaprojectId) {
        Session session = this.getSession(sessionToken);
        Metaproject metaproject = this.getMetaproject(sessionToken, metaprojectId);
        IMaterialLister materialLister = this.businessObjectFactory.createMaterialLister(session);
        return materialLister.list(new MetaprojectCriteria(metaproject.getId()), true);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerSampleType(String sessionToken, SampleType entityType) {
        Session session = this.getSession(sessionToken);
        IEntityTypeBO entityTypeBO = this.businessObjectFactory.createEntityTypeBO(session);
        entityTypeBO.define(entityType);
        entityTypeBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void updateSampleType(String sessionToken, EntityType entityType) {
        try {
            this.updateEntityType(sessionToken, EntityKind.SAMPLE, entityType);
        }
        catch (DataAccessException e) {
            if (SampleDataAccessExceptionTranslator.isUniqueSubcodeViolationException(e)) {
                throw new UserFailureException("Cannot enable 'Unique Subcodes' option as some of the samples of this type already have duplicated subcodes.");
            }
            throw e;
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerMaterialType(String sessionToken, MaterialType entityType) {
        Session session = this.getSession(sessionToken);
        IEntityTypeBO entityTypeBO = this.businessObjectFactory.createEntityTypeBO(session);
        entityTypeBO.define(entityType);
        entityTypeBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void updateMaterialType(String sessionToken, EntityType entityType) {
        this.updateEntityType(sessionToken, EntityKind.MATERIAL, entityType);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerExperimentType(String sessionToken, ExperimentType entityType) {
        Session session = this.getSession(sessionToken);
        IEntityTypeBO entityTypeBO = this.businessObjectFactory.createEntityTypeBO(session);
        entityTypeBO.define(entityType);
        entityTypeBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void updateExperimentType(String sessionToken, EntityType entityType) {
        this.updateEntityType(sessionToken, EntityKind.EXPERIMENT, entityType);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerFileFormatType(String sessionToken, FileFormatType type) {
        this.checkSession(sessionToken);
        FileFormatTypePE fileFormatType = new FileFormatTypePE();
        try {
            fileFormatType.setCode(type.getCode());
            fileFormatType.setDescription(type.getDescription());
            this.getDAOFactory().getFileFormatTypeDAO().createOrUpdate(fileFormatType);
        }
        catch (DataAccessException ex) {
            DataAccessExceptionTranslator.throwException(ex, String.format("File format type '%s' ", fileFormatType.getCode()), null);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerDataSetType(String sessionToken, DataSetType entityType) {
        Session session = this.getSession(sessionToken);
        IEntityTypeBO entityTypeBO = this.businessObjectFactory.createEntityTypeBO(session);
        entityTypeBO.define(entityType);
        entityTypeBO.save();
        this.dataStoreServiceRegistrator.register(entityType);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void updateDataSetType(String sessionToken, EntityType entityType) {
        this.updateEntityType(sessionToken, EntityKind.DATA_SET, entityType);
    }

    private void setValidationScript(EntityTypePE entityTypePE, EntityType entityType) {
        if (entityType.getValidationScript() == null || entityType.getValidationScript().getName() == null || entityType.getValidationScript().getName().equals("")) {
            entityTypePE.setValidationScript(null);
        } else {
            ScriptPE script = this.getDAOFactory().getScriptDAO().tryFindByName(entityType.getValidationScript().getName());
            if (script != null && entityType.isEntityKind(script.getEntityKind())) {
                entityTypePE.setValidationScript(script);
            } else {
                entityTypePE.setValidationScript(null);
            }
        }
    }

    private void updateEntityType(String sessionToken, EntityKind entityKind, EntityType entityType) {
        this.checkSession(sessionToken);
        IEntityTypeDAO entityTypeDAO = this.getDAOFactory().getEntityTypeDAO(DtoConverters.convertEntityKind(entityKind));
        EntityTypePE entityTypePE = entityTypeDAO.tryToFindEntityTypeByCode(entityType.getCode());
        if (entityType.getModificationDate() != null && !entityTypePE.getModificationDate().equals(entityType.getModificationDate())) {
            throw new UserFailureException("Unfortunately " + entityType.getCode() + " has been modified in the meantime.\n\n" + "Please, refresh the data and try it again.");
        }
        entityTypePE.setDescription(entityType.getDescription());
        this.setValidationScript(entityTypePE, entityType);
        this.updateSpecificEntityTypeProperties(entityKind, entityTypePE, entityType);
        entityTypeDAO.createOrUpdateEntityType(entityTypePE);
    }

    private void updateSpecificEntityTypeProperties(EntityKind entityKind, EntityTypePE entityTypePE, EntityType entityType) {
        if (entityKind == EntityKind.SAMPLE) {
            SampleTypePE sampleTypePE = (SampleTypePE)entityTypePE;
            SampleType sampleType = (SampleType)entityType;
            sampleTypePE.setListable(sampleType.isListable());
            sampleTypePE.setAutoGeneratedCode(sampleType.isAutoGeneratedCode());
            sampleTypePE.setShowParentMetadata(sampleType.isShowParentMetadata());
            sampleTypePE.setGeneratedCodePrefix(sampleType.getGeneratedCodePrefix());
            sampleTypePE.setSubcodeUnique(sampleType.isSubcodeUnique());
            sampleTypePE.setContainerHierarchyDepth(sampleType.getContainerHierarchyDepth());
            sampleTypePE.setGeneratedFromHierarchyDepth(sampleType.getGeneratedFromHierarchyDepth());
            this.setValidationScript(entityTypePE, entityType);
        } else if (entityKind == EntityKind.DATA_SET) {
            DataSetTypePE dataSetTypePE = (DataSetTypePE)entityTypePE;
            DataSetType dataSetType = (DataSetType)entityType;
            dataSetTypePE.setDeletionDisallow(dataSetType.isDeletionDisallow());
            dataSetTypePE.setMainDataSetPath(dataSetType.getMainDataSetPath());
            String mainDataSetPattern = dataSetType.getMainDataSetPattern();
            EntityTypeBO.assertValidDataSetTypeMainPattern(mainDataSetPattern);
            dataSetTypePE.setMainDataSetPattern(mainDataSetPattern);
            this.setValidationScript(entityTypePE, entityType);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="DELETE_DATASET")
    public void deleteDataSets(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> dataSetCodes, String reason, DeletionType type, boolean isTrashEnabled) {
        this.deleteDataSetsCommon(sessionToken, dataSetCodes, reason, type, false, isTrashEnabled);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_DISABLED})
    @Capability(value="FORCE_DELETE_DATASET")
    public void deleteDataSetsForced(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> dataSetCodes, String reason, DeletionType type, boolean isTrashEnabled) {
        this.deleteDataSetsCommon(sessionToken, dataSetCodes, reason, type, true, isTrashEnabled);
    }

    private void deleteDataSetsCommon(String sessionToken, List<String> dataSetCodes, String reason, DeletionType type, boolean forceDisallowedTypes, boolean isTrashEnabled) {
        Session session = this.getSession(sessionToken);
        this.updateModificationDateAndModifierOfRelatedEntitiesOfDataSets(dataSetCodes, session);
        switch (type) {
            case PERMANENT: {
                if (isTrashEnabled) {
                    IDeletedDataSetTable deletedDataSetTable = this.businessObjectFactory.createDeletedDataSetTable(session);
                    deletedDataSetTable.loadByDataSetCodes(dataSetCodes);
                    deletedDataSetTable.permanentlyDeleteLoadedDataSets(reason, forceDisallowedTypes);
                    break;
                }
                IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
                this.permanentlyDeleteDataSets(session, dataSetTable, dataSetCodes, reason, forceDisallowedTypes);
                break;
            }
            case TRASH: {
                IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
                dataSetTable.loadByDataSetCodes(dataSetCodes, false, false);
                List<DataPE> dataSets = dataSetTable.getDataSets();
                ITrashBO trashBO = this.businessObjectFactory.createTrashBO(session);
                trashBO.createDeletion(reason);
                trashBO.trashDataSets(TechId.createList(dataSets));
            }
        }
    }

    private void updateModificationDateAndModifierOfRelatedEntitiesOfDataSets(Collection<String> dataSetCodes, Session session) {
        List<DataPE> dataSets = this.getDAOFactory().getDataDAO().listByCode(new HashSet<String>(dataSetCodes));
        for (DataPE dataSet : dataSets) {
            ExperimentPE experiment = dataSet.getExperiment();
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session);
            SamplePE sample = dataSet.tryGetSample();
            if (sample != null) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session);
            }
            this.updateModificationDateAndModifierOfDataSets(dataSet.getChildren(), session);
            this.updateModificationDateAndModifierOfDataSets(dataSet.getParents(), session);
            DataPE container = dataSet.getContainer();
            if (container == null) continue;
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)container, session);
        }
    }

    private void updateModificationDateAndModifierOfDataSets(List<DataPE> dataSets, Session session) {
        if (dataSets != null) {
            for (DataPE child : dataSets) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)child, session);
            }
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="DELETE_SAMPLE")
    public void deleteSamples(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdCollectionPredicate.class) List<TechId> sampleIds, String reason, DeletionType deletionType) {
        Session session = this.getSession(sessionToken);
        this.updateModificationDateAndModifierOfRelatedEntitiesOfSamples(sampleIds, session);
        switch (deletionType) {
            case PERMANENT: {
                ISampleTable sampleTableBO = this.businessObjectFactory.createSampleTable(session);
                sampleTableBO.deleteByTechIds(sampleIds, reason);
                break;
            }
            case TRASH: {
                ITrashBO trashBO = this.businessObjectFactory.createTrashBO(session);
                trashBO.createDeletion(reason);
                trashBO.trashSamples(sampleIds);
            }
        }
    }

    private void updateModificationDateAndModifierOfRelatedEntitiesOfSamples(Collection<TechId> sampleIds, Session session) {
        List<SamplePE> samples = this.getDAOFactory().getSampleDAO().listByIDs(TechId.asLongs(sampleIds));
        for (SamplePE sample : samples) {
            Set<SampleRelationshipPE> childRelationships;
            List<SamplePE> parents;
            SamplePE container;
            ExperimentPE experiment = sample.getExperiment();
            if (experiment != null) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session);
            }
            if ((container = sample.getContainer()) != null) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)container, session);
            }
            if ((parents = sample.getParents()) != null) {
                for (SamplePE parent : parents) {
                    RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session);
                }
            }
            if ((childRelationships = sample.getChildRelationships()) == null) continue;
            for (SampleRelationshipPE childRelationship : childRelationships) {
                SamplePE childSample = childRelationship.getChildSample();
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)childSample, session);
            }
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="DELETE_EXPERIMENT")
    public void deleteExperiments(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdCollectionPredicate.ExperimentTechIdCollectionPredicate.class) List<TechId> experimentIds, String reason, DeletionType deletionType) {
        Session session = this.getSession(sessionToken);
        this.updateModificationDateAndModifierOfRelatedProjectsOfExperiments(experimentIds, session);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        switch (deletionType) {
            case PERMANENT: {
                experimentBO.deleteByTechIds(experimentIds, reason);
                break;
            }
            case TRASH: {
                ITrashBO trashBO = this.businessObjectFactory.createTrashBO(session);
                trashBO.createDeletion(reason);
                trashBO.trashExperiments(experimentIds);
            }
        }
    }

    private void updateModificationDateAndModifierOfRelatedProjectsOfExperiments(Collection<TechId> experimentIds, Session session) {
        List<ExperimentPE> experiments = this.getDAOFactory().getExperimentDAO().listByIDs(TechId.asLongs(experimentIds));
        for (ExperimentPE experiment : experiments) {
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment.getProject(), session);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="DELETE_VOCABULARY")
    public void deleteVocabularies(String sessionToken, List<TechId> vocabularyIds, String reason) {
        Session session = this.getSession(sessionToken);
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(session);
        for (TechId id : vocabularyIds) {
            vocabularyBO.deleteByTechId(id, reason);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deletePropertyTypes(String sessionToken, List<TechId> propertyTypeIds, String reason) {
        Session session = this.getSession(sessionToken);
        IPropertyTypeBO propertyTypeBO = this.businessObjectFactory.createPropertyTypeBO(session);
        for (TechId id : propertyTypeIds) {
            propertyTypeBO.deleteByTechId(id, reason);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="DELETE_PROJECT")
    public void deleteProjects(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdCollectionPredicate.ProjectTechIdCollectionPredicate.class) List<TechId> projectIds, String reason) {
        Session session = this.getSession(sessionToken);
        IProjectBO projectBO = this.businessObjectFactory.createProjectBO(session);
        for (TechId id : projectIds) {
            projectBO.deleteByTechId(id, reason);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @Capability(value="DELETE_SPACE")
    public void deleteSpaces(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdCollectionPredicate.SpaceTechIdCollectionPredicate.class) List<TechId> spaceIds, String reason) {
        Session session = this.getSession(sessionToken);
        ISpaceBO spaceBO = this.businessObjectFactory.createSpaceBO(session);
        for (TechId id : spaceIds) {
            spaceBO.deleteByTechId(id, reason);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deleteScripts(String sessionToken, List<TechId> scriptIds) {
        Session session = this.getSession(sessionToken);
        IScriptBO scriptBO = this.businessObjectFactory.createScriptBO(session);
        ArrayList<String> namesOfPredeployedPlugins = new ArrayList<String>();
        for (TechId id : scriptIds) {
            ScriptPE script = scriptBO.deleteByTechId(id);
            if (script.getPluginType() != PluginType.PREDEPLOYED) continue;
            namesOfPredeployedPlugins.add(script.getName());
        }
        if (namesOfPredeployedPlugins.isEmpty()) {
            return;
        }
        IHotDeploymentController hotDeploymentController = this.entityValidationFactory.getHotDeploymentController();
        if (hotDeploymentController == null) {
            this.operationLog.warn("Can not disable hot-deployed plugins because of missing controller.");
            return;
        }
        for (String name : namesOfPredeployedPlugins) {
            hotDeploymentController.disablePlugin(name);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="DELETE_EXPERIMENT_ATTACHMENT")
    public void deleteExperimentAttachments(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId, List<String> fileNames, String reason) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.loadDataByTechId(experimentId);
        this.deleteHolderAttachments(session, experimentBO.getExperiment(), fileNames, reason);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_EXPERIMENT_ATTACHMENT")
    public void updateExperimentAttachments(String sessionToken, TechId experimentId, Attachment attachment) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.loadDataByTechId(experimentId);
        IAttachmentBO attachmentBO = this.businessObjectFactory.createAttachmentBO(session);
        attachmentBO.updateAttachment(experimentBO.getExperiment(), attachment);
        attachmentBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_EXPERIMENT_ATTACHMENT")
    public void addExperimentAttachment(String sessionToken, TechId experimentId, NewAttachment attachment) {
        Session session = this.getSession(sessionToken);
        IExperimentBO bo = this.businessObjectFactory.createExperimentBO(session);
        bo.loadDataByTechId(experimentId);
        bo.addAttachment(AttachmentTranslator.translate(attachment));
        bo.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="DELETE_SAMPLE_ATTACHMENT")
    public void deleteSampleAttachments(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId sampleId, List<String> fileNames, String reason) {
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadDataByTechId(sampleId);
        this.deleteHolderAttachments(session, sampleBO.getSample(), fileNames, reason);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="DELETE_PROJECT_ATTACHMENT")
    public void deleteProjectAttachments(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ProjectTechIdPredicate.class) TechId projectId, List<String> fileNames, String reason) {
        Session session = this.getSession(sessionToken);
        IProjectBO projectBO = this.businessObjectFactory.createProjectBO(session);
        projectBO.loadDataByTechId(projectId);
        this.deleteHolderAttachments(session, projectBO.getProject(), fileNames, reason);
    }

    private void deleteHolderAttachments(Session session, AttachmentHolderPE holder, List<String> fileNames, String reason) throws DataAccessException {
        IAttachmentBO attachmentBO = this.businessObjectFactory.createAttachmentBO(session);
        attachmentBO.deleteHolderAttachments(holder, fileNames, reason);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Attachment> listExperimentAttachments(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.loadDataByTechId(experimentId);
        return AttachmentTranslator.translate(this.listHolderAttachments(session, experimentBO.getExperiment()), session.getBaseIndexURL());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Attachment> listSampleAttachments(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId sampleId) {
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadDataByTechId(sampleId);
        return AttachmentTranslator.translate(this.listHolderAttachments(session, sampleBO.getSample()), session.getBaseIndexURL());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Attachment> listProjectAttachments(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ProjectTechIdPredicate.class) TechId projectId) {
        Session session = this.getSession(sessionToken);
        IProjectBO projectBO = this.businessObjectFactory.createProjectBO(session);
        projectBO.loadDataByTechId(projectId);
        return AttachmentTranslator.translate(this.listHolderAttachments(session, projectBO.getProject()), session.getBaseIndexURL());
    }

    private List<AttachmentPE> listHolderAttachments(Session session, AttachmentHolderPE holder) {
        return this.getDAOFactory().getAttachmentDAO().listAttachments(holder);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public String uploadDataSets(String sessionToken, List<String> dataSetCodes, DataSetUploadContext uploadContext) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        dataSetTable.loadByDataSetCodes(dataSetCodes, true, false);
        return dataSetTable.uploadLoadedDataSetsToCIFEX(uploadContext);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<VocabularyTermWithStats> listVocabularyTermsWithStatistics(String sessionToken, Vocabulary vocabulary) {
        Session session = this.getSession(sessionToken);
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(session);
        vocabularyBO.loadDataByTechId(TechId.create(vocabulary));
        return vocabularyBO.countTermsUsageStatistics();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Set<VocabularyTerm> listVocabularyTerms(String sessionToken, Vocabulary vocabulary) {
        Session session = this.getSession(sessionToken);
        IVocabularyBO vocabularyBO = this.businessObjectFactory.createVocabularyBO(session);
        vocabularyBO.loadDataByTechId(TechId.create(vocabulary));
        return VocabularyTermTranslator.translateTerms(vocabularyBO.enrichWithTerms());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<DataSetType> listDataSetTypes(String sessionToken) {
        List<DataSetTypePE> dataSetTypes = this.listEntityTypes(sessionToken, EntityKind.DATA_SET);
        return DataSetTypeTranslator.translate(dataSetTypes, new HashMap<PropertyTypePE, PropertyType>());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public LastModificationState getLastModificationState(String sessionToken) {
        this.checkSession(sessionToken);
        return this.lastModificationState;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public SampleParentWithDerived getSampleInfo(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId sampleId) throws UserFailureException {
        assert (sessionToken != null) : "Unspecified session token.";
        assert (sampleId != null) : "Unspecified sample techId.";
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadDataByTechId(sampleId);
        sampleBO.enrichWithAttachments();
        sampleBO.enrichWithPropertyTypes();
        SamplePE sample = sampleBO.getSample();
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), sample);
        return SampleTranslator.translate(this.getSampleTypeSlaveServerPlugin(sample.getSampleType()).getSampleInfo(session, sample), session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_SAMPLE")
    public SampleUpdateResult updateSample(String sessionToken, @AuthorizationGuard(guardClass=SampleUpdatesPredicate.class) SampleUpdatesDTO updates) {
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.update(updates);
        sampleBO.save();
        SampleUpdateResult result = new SampleUpdateResult();
        SamplePE sample = sampleBO.getSample();
        result.setVersion(sample.getVersion());
        List<String> parents = IdentifierExtractor.extract(sample.getParents());
        Collections.sort(parents);
        result.setParents(parents);
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Experiment getExperimentInfo(String sessionToken, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ExperimentIdentifier identifier) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.loadByExperimentIdentifier(identifier);
        experimentBO.enrichWithProperties();
        experimentBO.enrichWithAttachments();
        ExperimentPE experiment = experimentBO.getExperiment();
        if (experiment == null) {
            throw UserFailureException.fromTemplate("No experiment could be found with given identifier '%s'.", identifier);
        }
        Collection<MetaprojectPE> metaprojects = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), experiment);
        return ExperimentTranslator.translate(experiment, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojects), this.managedPropertyEvaluatorFactory, ExperimentTranslator.LoadableFields.PROPERTIES, ExperimentTranslator.LoadableFields.ATTACHMENTS);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Experiment getExperimentInfo(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentId) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.loadDataByTechId(experimentId);
        experimentBO.enrichWithProperties();
        experimentBO.enrichWithAttachments();
        ExperimentPE experiment = experimentBO.getExperiment();
        Collection<MetaprojectPE> metaprojects = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), experiment);
        return ExperimentTranslator.translate(experiment, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojects), this.managedPropertyEvaluatorFactory, ExperimentTranslator.LoadableFields.PROPERTIES, ExperimentTranslator.LoadableFields.ATTACHMENTS);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_EXPERIMENT_SAMPLE")
    public ExperimentUpdateResult updateExperiment(String sessionToken, @AuthorizationGuard(guardClass=ExperimentUpdatesPredicate.class) ExperimentUpdatesDTO updates) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.update(updates);
        experimentBO.save();
        ExperimentUpdateResult result = new ExperimentUpdateResult();
        ExperimentPE experiment = experimentBO.getExperiment();
        result.setVersion(experiment.getVersion());
        result.setSamples(Code.extractCodes(experiment.getSamples()));
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Project getProjectInfo(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ProjectTechIdPredicate.class) TechId projectId) {
        Session session = this.getSession(sessionToken);
        IProjectBO bo = this.businessObjectFactory.createProjectBO(session);
        bo.loadDataByTechId(projectId);
        bo.enrichWithAttachments();
        ProjectPE project = bo.getProject();
        return ProjectTranslator.translate(project);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Project getProjectInfo(String sessionToken, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ProjectIdentifier projectIdentifier) {
        Session session = this.getSession(sessionToken);
        IProjectBO bo = this.businessObjectFactory.createProjectBO(session);
        bo.loadByProjectIdentifier(projectIdentifier);
        ProjectPE project = bo.getProject();
        return ProjectTranslator.translate(project);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public IIdHolder getProjectIdHolder(String sessionToken, String projectPermId) {
        Session session = this.getSession(sessionToken);
        IProjectBO bo = this.businessObjectFactory.createProjectBO(session);
        bo.loadByPermId(projectPermId);
        ProjectPE project = bo.getProject();
        return new TechId(project.getId());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Material getMaterialInfo(String sessionToken, MaterialIdentifier identifier) {
        Session session = this.getSession(sessionToken);
        IMaterialBO materialBO = this.getBusinessObjectFactory().createMaterialBO(session);
        materialBO.loadByMaterialIdentifier(identifier);
        materialBO.enrichWithProperties();
        MaterialPE materialPE = materialBO.getMaterial();
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), materialPE);
        return MaterialTranslator.translate(materialPE, MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Material getMaterialInfo(String sessionToken, TechId materialId) {
        Session session = this.getSession(sessionToken);
        IMaterialBO materialBO = this.businessObjectFactory.createMaterialBO(session);
        materialBO.loadDataByTechId(materialId);
        materialBO.enrichWithProperties();
        MaterialPE material = materialBO.getMaterial();
        Collection<MetaprojectPE> metaprojectPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), material);
        return MaterialTranslator.translate(material, true, MetaprojectTranslator.translate(metaprojectPEs), this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public IEntityInformationHolderWithPermId getMaterialInformationHolder(String sessionToken, MaterialIdentifier identifier) {
        return this.getMaterialInfo(sessionToken, identifier);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_MATERIAL")
    public Date updateMaterial(String sessionToken, TechId materialId, List<IEntityProperty> properties, String[] metaprojects, Date version) {
        Session session = this.getSession(sessionToken);
        IMaterialBO materialBO = this.businessObjectFactory.createMaterialBO(session);
        MaterialUpdateDTO updates = new MaterialUpdateDTO(materialId, properties, version);
        updates.setMetaprojectsOrNull(metaprojects);
        materialBO.update(updates);
        materialBO.save();
        return materialBO.getMaterial().getModificationDate();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public IEntityInformationHolderWithPermId getEntityInformationHolder(String sessionToken, EntityKind entityKind, String permId) {
        this.checkSession(sessionToken);
        switch (entityKind) {
            case DATA_SET: {
                return this.createInformationHolder(entityKind, permId, this.getDAOFactory().getDataDAO().tryToFindDataSetByCode(permId));
            }
            case EXPERIMENT: 
            case SAMPLE: {
                return this.createInformationHolder(entityKind, permId, this.getDAOFactory().getPermIdDAO().tryToFindByPermId(permId, DtoConverters.convertEntityKind(entityKind)));
            }
            case MATERIAL: {
                MaterialIdentifier identifier = MaterialIdentifier.tryParseIdentifier(permId);
                return this.getMaterialInformationHolder(sessionToken, identifier);
            }
        }
        throw UserFailureException.fromTemplate("Operation not available for " + entityKind.getDescription() + "s", new Object[0]);
    }

    private IEntityInformationHolderWithPermId createInformationHolder(EntityKind kind, String permId, IEntityInformationHolderDTO entityOrNull) {
        if (entityOrNull == null) {
            throw UserFailureException.fromTemplate("There is no %s with permId '%s'.", kind.getDescription(), permId);
        }
        return this.createInformationHolder(kind, entityOrNull);
    }

    private IEntityInformationHolderWithPermId createInformationHolder(EntityKind kind, IEntityInformationHolderDTO entity) {
        assert (entity != null);
        EntityType entityType = EntityHelper.createEntityType(kind, entity.getEntityType().getCode());
        String code = entity.getCode();
        Long id = HibernateUtils.getId(entity);
        String permId = entity.getPermId();
        return new BasicEntityInformationHolder(kind, entityType, code, id, permId);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public String generateCode(String sessionToken, String prefix, EntityKind entityKind) {
        this.checkSession(sessionToken);
        return new EntityCodeGenerator(this.getDAOFactory()).generateCode(prefix, entityKind);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_PROJECT")
    public int updateProject(String sessionToken, @AuthorizationGuard(guardClass=ProjectUpdatesPredicate.class) ProjectUpdatesDTO updates) {
        Session session = this.getSession(sessionToken);
        IProjectBO bo = this.businessObjectFactory.createProjectBO(session);
        bo.update(updates);
        bo.save();
        return bo.getProject().getVersion();
    }

    private void deleteEntityTypes(String sessionToken, EntityKind entityKind, List<String> codes) throws UserFailureException {
        Session session = this.getSession(sessionToken);
        for (String code : codes) {
            IEntityTypeBO bo = this.businessObjectFactory.createEntityTypeBO(session);
            bo.load(DtoConverters.convertEntityKind(entityKind), code);
            bo.delete();
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deleteDataSetTypes(String sessionToken, List<String> entityTypesCodes) {
        this.deleteEntityTypes(sessionToken, EntityKind.DATA_SET, entityTypesCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deleteExperimentTypes(String sessionToken, List<String> entityTypesCodes) {
        this.deleteEntityTypes(sessionToken, EntityKind.EXPERIMENT, entityTypesCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deleteMaterialTypes(String sessionToken, List<String> entityTypesCodes) {
        this.deleteEntityTypes(sessionToken, EntityKind.MATERIAL, entityTypesCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deleteSampleTypes(String sessionToken, List<String> entityTypesCodes) {
        this.deleteEntityTypes(sessionToken, EntityKind.SAMPLE, entityTypesCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deleteFileFormatTypes(String sessionToken, List<String> codes) {
        assert (sessionToken != null) : "Unspecified session token";
        this.checkSession(sessionToken);
        IFileFormatTypeDAO dao = this.getDAOFactory().getFileFormatTypeDAO();
        for (String code : codes) {
            FileFormatTypePE type = dao.tryToFindFileFormatTypeByCode(code);
            if (type == null) {
                throw new UserFailureException(String.format("File format type '%s' not found.", code));
            }
            try {
                dao.delete(type);
            }
            catch (DataIntegrityViolationException dataIntegrityViolationException) {
                throw new UserFailureException(String.format("File format type '%s' is being used. Use 'Data Set Search' to find all connected data sets.", code));
            }
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public String getTemplateColumns(String sessionToken, EntityKind entityKind, String type, boolean autoGenerate, boolean withExperiments, boolean withSpace, BatchOperationKind operationKind) {
        ArrayList<Object> types = new ArrayList<Object>();
        if ((entityKind.equals(EntityKind.SAMPLE) || entityKind.equals(EntityKind.DATA_SET) || entityKind.equals(EntityKind.MATERIAL)) && EntityType.isDefinedInFileEntityTypeCode(type)) {
            types.addAll(this.getDAOFactory().getEntityTypeDAO(DtoConverters.convertEntityKind(entityKind)).listEntityTypes());
        } else {
            types.add(this.findEntityType(entityKind, type));
        }
        StringBuilder sb = new StringBuilder();
        boolean firstSection = true;
        for (EntityTypePE entityTypePE : types) {
            String section = this.createTemplateForType(entityKind, autoGenerate, entityTypePE, firstSection, withExperiments, withSpace, operationKind);
            if (types.size() != 1) {
                section = String.format("[%s]\n%s%s\n", entityTypePE.getCode(), firstSection ? "# Comments must be located after the type declaration ('[TYPE]').\n" : "", section);
            }
            sb.append(section);
            firstSection = false;
        }
        return sb.toString();
    }

    private String createTemplateForType(EntityKind entityKind, boolean autoGenerate, EntityTypePE entityType, boolean addComments, boolean withExperiments, boolean withSpace, BatchOperationKind operationKind) {
        ArrayList<String> columns = new ArrayList<String>();
        switch (entityKind) {
            case SAMPLE: {
                if (!autoGenerate) {
                    columns.add("identifier");
                }
                columns.add("container");
                columns.add("parents");
                if (withExperiments) {
                    columns.add("experiment");
                }
                if (withSpace) {
                    columns.add("default_space");
                }
                this.addPropertiesToTemplateColumns(columns, ((SampleTypePE)entityType).getSampleTypePropertyTypes());
                break;
            }
            case DATA_SET: {
                columns.add("code");
                columns.add("container");
                columns.add("parents");
                columns.add("experiment");
                columns.add("sample");
                columns.add("file_format");
                this.addPropertiesToTemplateColumns(columns, ((DataSetTypePE)entityType).getDataSetTypePropertyTypes());
                break;
            }
            case MATERIAL: {
                columns.add("code");
                this.addPropertiesToTemplateColumns(columns, ((MaterialTypePE)entityType).getMaterialTypePropertyTypes());
                break;
            }
            case EXPERIMENT: {
                columns.add("identifier");
                if (operationKind == BatchOperationKind.UPDATE) {
                    columns.add("project");
                }
                this.addPropertiesToTemplateColumns(columns, ((ExperimentTypePE)entityType).getExperimentTypePropertyTypes());
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String column : columns) {
            if (sb.length() != 0) {
                sb.append("\t");
            }
            sb.append(column);
        }
        if (addComments) {
            switch (operationKind) {
                case REGISTRATION: {
                    if (entityKind.equals(EntityKind.SAMPLE)) {
                        if (withSpace) {
                            sb.insert(0, NewSample.WITH_SPACE_COMMENT);
                        }
                        if (withExperiments) {
                            sb.insert(0, NewSample.WITH_EXPERIMENTS_COMMENT);
                        }
                        sb.insert(0, "# The \"container\" and \"parents\" columns are optional, only one should be specified.\n# \"container\" should contain a sample identifier, e.g. /SPACE/SAMPLE_1, while \"parents\" should contain comma separated list of sample identifiers. \n# If \"container\" sample is provided, the registered sample will become a \"component\" of it.\n# The column \"container\" has an alias \"current_container\", which has a different meaning when samples are updated.\n# If \"parents\" are provided, the registered sample will become a \"child\" of all specified samples.\n");
                        break;
                    }
                    if (!entityKind.equals(EntityKind.EXPERIMENT)) break;
                    sb.insert(0, "# Besides the full identifier of format '/SPACE_CODE/PROJECT_CODE/EXPERIMENT_CODE', two short formats 'EXPERIMENT_CODE' and 'PROJECT_CODE/EXPERIMENT_CODE' are accepted given that the default project (former short format) or default space (latter short format) are configured. If the proper default value is not configured when using a short format, experiment import will fail.\n");
                    break;
                }
                case UPDATE: {
                    if (entityKind.equals(EntityKind.SAMPLE)) {
                        sb.insert(0, "# All columns except \"identifier\" can be removed from the file.\n# If a column is removed from the file or a cell in a column is left empty the corresponding values of updated samples will be preserved.\n# To delete a value/connection from openBIS one needs to put \"--DELETE--\"  or \\\"__DELETE__\\\" into the corresponding cell\n# (in particular, a sample can become detached from an experiment, container or all parents this way).\n# Basically the \"identifier\" column should contain sample identifiers, e.g. /SPACE/SAMPLE_1,\n# but for samples from default space (if it was provided in the form) it is enough to put sample codes (e.g. SAMPLE_1) into the column.\n# The \"container\" column (if not removed) should contain sample identifier for the new container of the updated sample, e.g. /SPACE/SAMPLE_1\n# The \"parent\" column (if not removed) should contain comma separated list of sample identifiers, e.g. /SPACE/SAMPLE_1,/SPACE/SAMPLE_2\n# The \"experiment\" column (if not removed) should contain experiment identifier, e.g. /SPACE/PROJECT/EXP_1\n# The \"default_space\" column is optional, it can be used to override home space for the row\n# The \"current_container\" column is optional, it can be used to specify container where the updated sample belongs before the update\n");
                        break;
                    }
                    if (entityKind.equals(EntityKind.DATA_SET)) {
                        sb.insert(0, "# All columns except \"code\" can be removed from the file.\n# If a column is removed from the file or a cell in a column is left empty the corresponding values of updated data set will be preserved.\n# To delete a value/connection from openBIS one needs to put \"--DELETE--\"  or \\\"__DELETE__\\\" into the corresponding cell\n# (in particular, a data set can become detached from an experiment, sample, container or all parents this way).\n# Basically the \"code\" column should contain a data set code, e.g. 20100823231225012-79089,\n# The \"container\" column (if not removed) should contain a data set code for the new container of the updated data set, e.g. 20100823231225012-83462\n# The \"parents\" column (if not removed) should contain comma separated list of data set codes, e.g. 20100823231225012-93247,20100823231225012-23877\n# The \"experiment\" column (if not removed) should contain an experiment identifier, e.g. /SPACE/PROJECT/EXP_1\n# The \"sample\" column (if not removed) should contain a sample identifier, e.g. /SPACE/SAMPLE_1\n# The \"file_format\" column (if not removed) should contain a file format code, e.g. XML\n");
                        break;
                    }
                    if (entityKind.equals(EntityKind.EXPERIMENT)) {
                        sb.insert(0, "# All columns except \"identifier\" can be removed from the file.\n# Besides the full identifier of format '/SPACE_CODE/PROJECT_CODE/EXPERIMENT_CODE', two short formats 'EXPERIMENT_CODE' and 'PROJECT_CODE/EXPERIMENT_CODE' are accepted given that the default project (former short format) or default space (latter short format) are configured. If the proper default value is not configured when using a short format, experiment update will fail.\n# If a column is removed from the file or a cell in a column is left empty the corresponding values of updated expriments will be preserved.\n# To delete a value/connection from openBIS one needs to put \"--DELETE--\" or \"__DELETE__\" into the corresponding cell\n# The \"project\" column (if not removed) should contain project identifiers, e.g. /SPACE/PROJECT\n");
                        break;
                    }
                    sb.insert(0, UPDATE_TEMPLATE_COMMENT);
                }
            }
        }
        return sb.toString();
    }

    private <T extends EntityTypePropertyTypePE> void addPropertiesToTemplateColumns(List<String> columns, Set<T> propertyTypes) {
        List<T> sortedPropertyTypes = this.asSortedList(propertyTypes);
        for (EntityTypePropertyTypePE etpt : sortedPropertyTypes) {
            if (etpt.isDynamic()) continue;
            String code = etpt.getPropertyType().getCode();
            if (etpt.isManaged()) {
                IManagedPropertyEvaluator evaluator = this.managedPropertyEvaluatorFactory.createManagedPropertyEvaluator(etpt);
                List<String> batchColumnNames = evaluator.getBatchColumnNames();
                if (batchColumnNames.isEmpty()) {
                    columns.add(code);
                    continue;
                }
                for (String name : batchColumnNames) {
                    columns.add(String.valueOf(code) + ':' + name);
                }
                continue;
            }
            columns.add(code);
        }
    }

    private <T extends EntityTypePropertyTypePE> List<T> asSortedList(Set<T> propertyTypes) {
        ArrayList<T> list = new ArrayList<T>(propertyTypes);
        Collections.sort(list);
        return list;
    }

    private EntityTypePE findEntityType(EntityKind entityKind, String type) {
        EntityTypePE typeOrNull = this.getDAOFactory().getEntityTypeDAO(DtoConverters.convertEntityKind(entityKind)).tryToFindEntityTypeByCode(type);
        if (typeOrNull == null) {
            throw new UserFailureException("Unknown " + entityKind.name() + " type '" + type + "'");
        }
        return typeOrNull;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void updateFileFormatType(String sessionToken, AbstractType type) {
        this.checkSession(sessionToken);
        IFileFormatTypeDAO dao = this.getDAOFactory().getFileFormatTypeDAO();
        FileFormatTypePE typePE = dao.tryToFindFileFormatTypeByCode(type.getCode());
        typePE.setDescription(type.getDescription());
        dao.createOrUpdate(typePE);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_PROJECT_ATTACHMENT")
    public void updateProjectAttachments(String sessionToken, TechId projectId, Attachment attachment) {
        Session session = this.getSession(sessionToken);
        IProjectBO bo = this.businessObjectFactory.createProjectBO(session);
        bo.loadDataByTechId(projectId);
        IAttachmentBO attachmentBO = this.businessObjectFactory.createAttachmentBO(session);
        attachmentBO.updateAttachment(bo.getProject(), attachment);
        attachmentBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_PROJECT_ATTACHMENT")
    public void addProjectAttachments(String sessionToken, TechId projectId, NewAttachment attachment) {
        Session session = this.getSession(sessionToken);
        IProjectBO bo = this.businessObjectFactory.createProjectBO(session);
        bo.loadDataByTechId(projectId);
        bo.addAttachment(AttachmentTranslator.translate(attachment));
        bo.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_SAMPLE_ATTACHMENT")
    public void updateSampleAttachments(String sessionToken, TechId sampleId, Attachment attachment) {
        Session session = this.getSession(sessionToken);
        ISampleBO bo = this.businessObjectFactory.createSampleBO(session);
        bo.loadDataByTechId(sampleId);
        IAttachmentBO attachmentBO = this.businessObjectFactory.createAttachmentBO(session);
        attachmentBO.updateAttachment(bo.getSample(), attachment);
        attachmentBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_SAMPLE_ATTACHMENT")
    public void addSampleAttachments(String sessionToken, TechId sampleId, NewAttachment attachment) {
        Session session = this.getSession(sessionToken);
        ISampleBO bo = this.businessObjectFactory.createSampleBO(session);
        bo.loadDataByTechId(sampleId);
        bo.addAttachment(AttachmentTranslator.translate(attachment));
        bo.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<DataStore> listDataStores(String sessionToken) {
        this.checkSession(sessionToken);
        return this.listDataStores();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<DatastoreServiceDescription> listDataStoreServices(String sessionToken, DataStoreServiceKind dataStoreServiceKind) {
        this.checkSession(sessionToken);
        ArrayList<DatastoreServiceDescription> result = new ArrayList<DatastoreServiceDescription>();
        List<DataStorePE> dataStores = this.getDAOFactory().getDataStoreDAO().listDataStores();
        for (DataStorePE dataStore : dataStores) {
            result.addAll(CommonServer.convertAndFilter(dataStore.getServices(), dataStoreServiceKind));
        }
        return result;
    }

    private static List<DatastoreServiceDescription> convertAndFilter(Set<DataStoreServicePE> services, DataStoreServiceKind dataStoreServiceKind) {
        ArrayList<DatastoreServiceDescription> result = new ArrayList<DatastoreServiceDescription>();
        for (DataStoreServicePE service : services) {
            if (service.getKind() != dataStoreServiceKind) continue;
            result.add(DataStoreServiceTranslator.translate(service));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public TableModel createReportFromDatasets(String sessionToken, DatastoreServiceDescription serviceDescription, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> datasetCodes) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        return dataSetTable.createReportFromDatasets(serviceDescription.getKey(), serviceDescription.getDatastoreCode(), datasetCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public TableModel createReportFromDatasets(String sessionToken, String serviceKey, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> datasetCodes) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        return dataSetTable.createReportFromDatasets(serviceKey, datasetCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public TableModel createReportFromAggregationService(String sessionToken, DatastoreServiceDescription serviceDescription, Map<String, Object> parameters) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        return dataSetTable.createReportFromAggregationService(serviceDescription.getKey(), serviceDescription.getDatastoreCode(), parameters);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void processDatasets(String sessionToken, DatastoreServiceDescription serviceDescription, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> datasetCodes) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        HashMap<String, String> parameterBindings = new HashMap<String, String>();
        dataSetTable.processDatasets(serviceDescription.getKey(), datasetCodes, parameterBindings);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="ARCHIVE_DATASET")
    public int archiveDatasets(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> datasetCodes, boolean removeFromDataStore) {
        return super.archiveDatasets(sessionToken, datasetCodes, removeFromDataStore);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="UNARCHIVE_DATASET")
    public int unarchiveDatasets(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> datasetCodes) {
        return super.unarchiveDatasets(sessionToken, datasetCodes);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerAuthorizationGroup(String sessionToken, NewAuthorizationGroup newAuthorizationGroup) {
        Session session = this.getSession(sessionToken);
        IAuthorizationGroupBO bo = this.businessObjectFactory.createAuthorizationGroupBO(session);
        bo.define(newAuthorizationGroup);
        bo.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerScript(String sessionToken, Script script) {
        Session session = this.getSession(sessionToken);
        IScriptBO bo = this.businessObjectFactory.createScriptBO(session);
        bo.define(script);
        bo.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void registerOrUpdatePredeployedPlugin(String sessionToken, Script script) {
        Session session = this.getSession(sessionToken);
        try {
            IScriptBO bo = this.businessObjectFactory.createScriptBO(session);
            bo.tryDefineOrUpdateIfPossible(script);
        }
        catch (IllegalArgumentException e) {
            this.operationLog.warn(e.getMessage());
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void invalidatePredeployedPlugin(String sessionToken, String name, ScriptType scriptType) {
        Session session = this.getSession(sessionToken);
        try {
            IScriptBO bo = this.businessObjectFactory.createScriptBO(session);
            bo.tryDeleteOrInvalidatePredeployedPlugin(name, scriptType);
        }
        catch (IllegalArgumentException e) {
            this.operationLog.warn(e.getMessage());
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deleteAuthorizationGroups(String sessionToken, List<TechId> authGroupIds, String reason) {
        Session session = this.getSession(sessionToken);
        IAuthorizationGroupBO authGroupBO = this.businessObjectFactory.createAuthorizationGroupBO(session);
        for (TechId id : authGroupIds) {
            authGroupBO.deleteByTechId(id, reason);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    public List<AuthorizationGroup> listAuthorizationGroups(String sessionToken) {
        this.checkSession(sessionToken);
        List<AuthorizationGroupPE> persons = this.getDAOFactory().getAuthorizationGroupDAO().list();
        Collections.sort(persons);
        return AuthorizationGroupTranslator.translate(persons);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Script> listScripts(String sessionToken, ScriptType scriptTypeOrNull, EntityKind entityKindOrNull) {
        this.checkSession(sessionToken);
        List<ScriptPE> scripts = this.getDAOFactory().getScriptDAO().listEntities(scriptTypeOrNull, entityKindOrNull);
        Collections.sort(scripts);
        List<Script> result = ScriptTranslator.enhancePredeployedPlugins(ScriptTranslator.translate(scripts), this.entityValidationFactory, this.dynamicPropertyCalculatorFactory, this.managedPropertyEvaluatorFactory);
        if (entityKindOrNull != null) {
            Iterator<Script> iterator = result.iterator();
            while (iterator.hasNext()) {
                Script script = iterator.next();
                if (this.isApplicableScript(script, entityKindOrNull)) continue;
                iterator.remove();
            }
        }
        return result;
    }

    private boolean isApplicableScript(Script script, EntityKind entityKind) {
        EntityKind[] entityKinds = script.getEntityKind();
        if (entityKinds == null) {
            return true;
        }
        EntityKind[] entityKindArray = entityKinds;
        int n = entityKinds.length;
        int n2 = 0;
        while (n2 < n) {
            EntityKind ek = entityKindArray[n2];
            if (ek == entityKind) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public Date updateAuthorizationGroup(String sessionToken, AuthorizationGroupUpdates updates) {
        Session session = this.getSession(sessionToken);
        IAuthorizationGroupBO bo = this.businessObjectFactory.createAuthorizationGroupBO(session);
        bo.update(updates);
        bo.save();
        return bo.getAuthorizationGroup().getModificationDate();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    public List<Person> listPersonInAuthorizationGroup(String sessionToken, TechId authorizatonGroupId) {
        Session session = this.getSession(sessionToken);
        IAuthorizationGroupBO bo = this.businessObjectFactory.createAuthorizationGroupBO(session);
        bo.loadByTechId(authorizatonGroupId);
        return PersonTranslator.translate(bo.getAuthorizationGroup().getPersons());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void addPersonsToAuthorizationGroup(String sessionToken, TechId authorizationGroupId, List<String> personsCodes) {
        List<String> inexistent = this.addExistingPersonsToAuthorizationGroup(sessionToken, authorizationGroupId, personsCodes);
        if (inexistent.size() > 0) {
            this.registerPersons(sessionToken, inexistent);
            this.addExistingPersonsToAuthorizationGroup(sessionToken, authorizationGroupId, inexistent);
        }
    }

    private List<String> addExistingPersonsToAuthorizationGroup(String sessionToken, TechId authorizationGroupId, List<String> personsCodes) {
        Session session = this.getSession(sessionToken);
        IAuthorizationGroupBO bo = this.businessObjectFactory.createAuthorizationGroupBO(session);
        bo.loadByTechId(authorizationGroupId);
        List<String> inexistent = bo.addPersons(personsCodes);
        bo.save();
        return inexistent;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void removePersonsFromAuthorizationGroup(String sessionToken, TechId authorizationGroupId, List<String> personsCodes) {
        Session session = this.getSession(sessionToken);
        IAuthorizationGroupBO bo = this.businessObjectFactory.createAuthorizationGroupBO(session);
        bo.loadByTechId(authorizationGroupId);
        bo.removePersons(personsCodes);
        bo.save();
    }

    private IGridCustomFilterOrColumnBO createGridCustomColumnBO(String sessionToken) {
        Session session = this.getSession(sessionToken);
        return this.businessObjectFactory.createGridCustomColumnBO(session);
    }

    private IGridCustomFilterOrColumnBO createGridCustomFilterBO(String sessionToken) {
        Session session = this.getSession(sessionToken);
        return this.businessObjectFactory.createGridCustomFilterBO(session);
    }

    private void registerFilterOrColumn(NewColumnOrFilter filter, IGridCustomFilterOrColumnBO bo) {
        bo.define(filter);
        bo.save();
    }

    private void deleteFiltersOrColumns(List<TechId> filterIds, IGridCustomFilterOrColumnBO bo) {
        for (TechId id : filterIds) {
            bo.deleteByTechId(id);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExpressionValidator.class)
    public List<GridCustomFilter> listFilters(String sessionToken, String gridId) {
        this.checkSession(sessionToken);
        List<GridCustomFilterPE> filters = this.getDAOFactory().getGridCustomFilterDAO().listFilters(gridId);
        Collections.sort(filters);
        return GridCustomExpressionTranslator.GridCustomFilterTranslator.translate(filters);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_FILTER")
    public void registerFilter(String sessionToken, NewColumnOrFilter filter) {
        IGridCustomFilterOrColumnBO bo = this.createGridCustomFilterBO(sessionToken);
        this.registerFilterOrColumn(filter, bo);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="DELETE_FILTER")
    public void deleteFilters(String sessionToken, @AuthorizationGuard(guardClass=AbstractExpressionPredicate.DeleteGridCustomFilterPredicate.class) List<TechId> filterIds) {
        IGridCustomFilterOrColumnBO bo = this.createGridCustomFilterBO(sessionToken);
        this.deleteFiltersOrColumns(filterIds, bo);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_FILTER")
    public void updateFilter(String sessionToken, @AuthorizationGuard(guardClass=AbstractExpressionPredicate.UpdateGridCustomFilterPredicate.class) IExpressionUpdates updates) {
        assert (updates != null) : "Unspecified updates";
        this.createGridCustomFilterBO(sessionToken).update(updates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_CUSTOM_COLUMN")
    public void registerGridCustomColumn(String sessionToken, NewColumnOrFilter column) {
        IGridCustomFilterOrColumnBO bo = this.createGridCustomColumnBO(sessionToken);
        this.registerFilterOrColumn(column, bo);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="DELETE_CUSTOM_COLUMN")
    public void deleteGridCustomColumns(String sessionToken, @AuthorizationGuard(guardClass=AbstractExpressionPredicate.DeleteGridCustomColumnPredicate.class) List<TechId> columnIds) {
        IGridCustomFilterOrColumnBO bo = this.createGridCustomColumnBO(sessionToken);
        this.deleteFiltersOrColumns(columnIds, bo);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="WRITE_CUSTOM_COLUMN")
    public void updateGridCustomColumn(String sessionToken, @AuthorizationGuard(guardClass=AbstractExpressionPredicate.UpdateGridCustomColumnPredicate.class) IExpressionUpdates updates) {
        assert (updates != null) : "Unspecified updates";
        this.createGridCustomColumnBO(sessionToken).update(updates);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void keepSessionAlive(String sessionToken) {
        this.checkSession(sessionToken);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_VOCABULARY")
    public void updateVocabularyTerms(String sessionToken, TechId vocabularyId, List<VocabularyTerm> terms) {
        Session session = this.getSession(sessionToken);
        IVocabularyBO bo = this.getBusinessObjectFactory().createVocabularyBO(session);
        bo.loadDataByTechId(vocabularyId);
        bo.updateTerms(terms);
        bo.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="DELETE_MATERIAL")
    public void deleteMaterials(String sessionToken, List<TechId> materialIds, String reason) {
        Session session = this.getSession(sessionToken);
        IMaterialTable materialTable = this.businessObjectFactory.createMaterialTable(session);
        materialTable.deleteByTechIds(materialIds, reason);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    public int lockDatasets(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> datasetCodes) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        dataSetTable.loadByDataSetCodes(datasetCodes, false, true);
        return dataSetTable.lockDatasets();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    public int unlockDatasets(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> datasetCodes) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        dataSetTable.loadByDataSetCodes(datasetCodes, false, true);
        return dataSetTable.unlockDatasets();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public LinkModel retrieveLinkFromDataSet(String sessionToken, DatastoreServiceDescription serviceDescription, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String dataSetCode) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        return dataSetTable.retrieveLinkFromDataSet(serviceDescription.getKey(), serviceDescription.getDatastoreCode(), dataSetCode);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Script getScriptInfo(String sessionToken, TechId scriptId) {
        this.getSession(sessionToken);
        ScriptPE script = (ScriptPE)this.getDAOFactory().getScriptDAO().getByTechId(scriptId);
        return ScriptTranslator.enhancePredeployedPlugin(ScriptTranslator.translate(script), this.entityValidationFactory, this.dynamicPropertyCalculatorFactory, this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public String evaluate(String sessionToken, DynamicPropertyEvaluationInfo info) {
        Session session = this.getSession(sessionToken);
        IEntityInformationWithPropertiesHolder entity = this.getEntity(info, session);
        try {
            IDynamicPropertyCalculator calculator = this.dynamicPropertyCalculatorFactory.getCalculator(info.getPluginType(), info.getSciptName(), info.getScript());
            DynamicPropertyEvaluator evaluator = new DynamicPropertyEvaluator(this.getDAOFactory(), null, this.dynamicPropertyCalculatorFactory, this.managedPropertyEvaluatorFactory);
            IEntityAdaptor adaptor = EntityAdaptorFactory.create(entity, (IDynamicPropertyEvaluator)evaluator, (org.hibernate.Session)this.getDAOFactory().getSessionFactory().getCurrentSession());
            return calculator.eval(adaptor);
        }
        catch (Throwable e) {
            this.operationLog.warn("Dynamic property evaluation failed", e);
            return e.getMessage();
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public String evaluate(String sessionToken, EntityValidationEvaluationInfo info) {
        Session session = this.getSession(sessionToken);
        IEntityInformationWithPropertiesHolder entity = this.getEntity(info, session);
        try {
            final LinkedList objectsWhichValidationWouldBeForced = new LinkedList();
            IEntityValidator entityValidator = this.entityValidationFactory.createEntityValidator(info.getPluginType(), info.getScriptName(), info.getScript());
            entityValidator.init(new JythonEntityValidationCalculator.IValidationRequestDelegate<INonAbstractEntityAdapter>(){

                @Override
                public void requestValidation(INonAbstractEntityAdapter entityAdaptor) {
                    IEntityInformationWithPropertiesHolder localEntity = entityAdaptor.entityPE();
                    objectsWhichValidationWouldBeForced.add((Object)((Object)localEntity.getEntityKind()) + " " + localEntity.getIdentifier());
                }
            });
            DynamicPropertyEvaluator evaluator = new DynamicPropertyEvaluator(this.getDAOFactory(), null, this.dynamicPropertyCalculatorFactory, this.managedPropertyEvaluatorFactory);
            IEntityAdaptor adaptor = EntityAdaptorFactory.create(entity, (IDynamicPropertyEvaluator)evaluator, (org.hibernate.Session)this.getDAOFactory().getSessionFactory().getCurrentSession());
            String result = entityValidator.validate(adaptor, info.isNew());
            if (result != null) {
                return "Validation fail: " + result;
            }
            result = "Validation OK";
            if (objectsWhichValidationWouldBeForced.size() > 0) {
                result = String.valueOf(result) + "\n\nOther entities would be forced to validate:\n";
                for (Object o : objectsWhichValidationWouldBeForced) {
                    result = String.valueOf(result) + "  " + o + "\n";
                }
            }
            return result;
        }
        catch (Throwable e) {
            this.operationLog.warn("Validation script evaluation failed", e);
            return e.getMessage();
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public IEntityInformationHolderWithPermId getEntityInformationHolder(String sessionToken, @AuthorizationGuard(guardClass=BasicEntityDescriptionPredicate.class) BasicEntityDescription info) {
        Session session = this.getSession(sessionToken);
        IEntityInformationWithPropertiesHolder entity = this.getEntity(info, session);
        return this.createInformationHolder(info.getEntityKind(), entity);
    }

    private IEntityInformationWithPropertiesHolder getEntity(BasicEntityDescription info, Session session) {
        IEntityWithMetaprojects entity = null;
        String entityIdentifier = info.getEntityIdentifier();
        EntityKind entityKind = info.getEntityKind();
        switch (entityKind) {
            case DATA_SET: {
                IDataBO bo = this.businessObjectFactory.createDataBO(session);
                bo.loadByCode(entityIdentifier);
                entity = bo.getData();
                break;
            }
            case EXPERIMENT: {
                IExperimentBO expBO = this.businessObjectFactory.createExperimentBO(session);
                ExperimentIdentifier expIdentifier = new ExperimentIdentifierFactory(entityIdentifier).createIdentifier();
                entity = expBO.tryFindByExperimentIdentifier(expIdentifier);
                break;
            }
            case SAMPLE: {
                ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
                sampleBO.tryToLoadBySampleIdentifier(SampleIdentifierFactory.parse(entityIdentifier));
                entity = sampleBO.tryToGetSample();
                break;
            }
            case MATERIAL: {
                entity = this.getDAOFactory().getMaterialDAO().tryFindMaterial(MaterialIdentifier.tryParseIdentifier(entityIdentifier));
            }
        }
        if (entity == null) {
            throw new UserFailureException(String.format("%s '%s' not found", entityKind.getDescription(), entityIdentifier));
        }
        return entity;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void updateManagedPropertyOnExperiment(String sessionToken, TechId experimentId, IManagedProperty managedProperty, IManagedUiAction updateAction) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(session);
        experimentBO.loadDataByTechId(experimentId);
        experimentBO.enrichWithProperties();
        Set<ExperimentPropertyPE> properties = experimentBO.getExperiment().getProperties();
        IManagedPropertyEvaluator evaluator = this.tryManagedPropertyEvaluator(managedProperty, properties);
        CommonServer.extendWithPerson(updateAction, session.tryGetPerson());
        evaluator.updateFromUI(managedProperty, PersonTranslator.translateToIPerson(session.tryGetPerson()), updateAction);
        experimentBO.updateManagedProperty(managedProperty);
        experimentBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void updateManagedPropertyOnSample(String sessionToken, TechId experimentId, IManagedProperty managedProperty, IManagedUiAction updateAction) {
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.businessObjectFactory.createSampleBO(session);
        sampleBO.loadDataByTechId(experimentId);
        sampleBO.enrichWithProperties();
        Set<SamplePropertyPE> properties = sampleBO.getSample().getProperties();
        IManagedPropertyEvaluator evaluator = this.tryManagedPropertyEvaluator(managedProperty, properties);
        CommonServer.extendWithPerson(updateAction, session.tryGetPerson());
        evaluator.updateFromUI(managedProperty, PersonTranslator.translateToIPerson(session.tryGetPerson()), updateAction);
        sampleBO.updateManagedProperty(managedProperty);
        sampleBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void updateManagedPropertyOnDataSet(String sessionToken, TechId experimentId, IManagedProperty managedProperty, IManagedUiAction updateAction) {
        Session session = this.getSession(sessionToken);
        IDataBO dataSetBO = this.businessObjectFactory.createDataBO(session);
        dataSetBO.loadDataByTechId(experimentId);
        dataSetBO.enrichWithProperties();
        Set<DataSetPropertyPE> properties = dataSetBO.getData().getProperties();
        IManagedPropertyEvaluator evaluator = this.tryManagedPropertyEvaluator(managedProperty, properties);
        CommonServer.extendWithPerson(updateAction, session.tryGetPerson());
        evaluator.updateFromUI(managedProperty, PersonTranslator.translateToIPerson(session.tryGetPerson()), updateAction);
        dataSetBO.updateManagedProperty(managedProperty);
        dataSetBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void updateManagedPropertyOnMaterial(String sessionToken, TechId experimentId, IManagedProperty managedProperty, IManagedUiAction updateAction) {
        Session session = this.getSession(sessionToken);
        IMaterialBO materialBO = this.businessObjectFactory.createMaterialBO(session);
        materialBO.loadDataByTechId(experimentId);
        materialBO.enrichWithProperties();
        Set<MaterialPropertyPE> properties = materialBO.getMaterial().getProperties();
        IManagedPropertyEvaluator evaluator = this.tryManagedPropertyEvaluator(managedProperty, properties);
        CommonServer.extendWithPerson(updateAction, session.tryGetPerson());
        evaluator.updateFromUI(managedProperty, PersonTranslator.translateToIPerson(session.tryGetPerson()), updateAction);
        materialBO.updateManagedProperty(managedProperty);
        materialBO.save();
    }

    private static void extendWithPerson(IManagedUiAction updateAction, PersonPE personOrNull) {
        if (personOrNull != null && updateAction instanceof ManagedUiActionDescription) {
            IPerson person = PersonTranslator.translateToIPerson(personOrNull);
            ManagedUiActionDescription action = (ManagedUiActionDescription)updateAction;
            action.setPerson(person);
        }
    }

    private IManagedPropertyEvaluator tryManagedPropertyEvaluator(IManagedProperty managedProperty, Set<? extends EntityPropertyPE> properties) {
        String managedPropertyCode = managedProperty.getPropertyTypeCode();
        IEntityPropertyHolder managedPropertyPE = null;
        for (EntityPropertyPE entityPropertyPE : properties) {
            if (!entityPropertyPE.getEntityTypePropertyType().getPropertyType().getCode().equals(managedPropertyCode)) continue;
            managedPropertyPE = entityPropertyPE;
        }
        if (managedPropertyPE == null) {
            return null;
        }
        return this.managedPropertyEvaluatorFactory.createManagedPropertyEvaluator(managedPropertyPE.getEntityTypePropertyType());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public String getDefaultPutDataStoreBaseURL(String sessionToken) {
        this.checkSession(sessionToken);
        IDataStoreDAO dataStoreDAO = this.getDAOFactory().getDataStoreDAO();
        List<DataStorePE> dataStores = dataStoreDAO.listDataStores();
        if (dataStores.size() == 1) {
            return dataStores.get(0).getDownloadUrl();
        }
        if (dataStores.isEmpty()) {
            throw new ConfigurationFailureException("No Data Store Server registered to openBIS.");
        }
        if (this.defaultPutDataStoreServerCodeOrNull == null) {
            throw ConfigurationFailureException.fromTemplate("There are %d Data Store Servers registered in openBIS, but property dss-rpc.put.dss-code is not set.", dataStores.size());
        }
        for (DataStorePE store : dataStores) {
            if (!this.defaultPutDataStoreServerCodeOrNull.equalsIgnoreCase(store.getCode())) continue;
            return store.getDownloadUrl();
        }
        throw ConfigurationFailureException.fromTemplate("Property dss-rpc.put.dss-code is set to '%s', but no Data Store Server with that code is known.", this.defaultPutDataStoreServerCodeOrNull);
    }

    public void setDefaultPutDataStoreServerCode(String defaultPutDataStoreServerCode) {
        this.defaultPutDataStoreServerCodeOrNull = CommonServer.isResolved(defaultPutDataStoreServerCode) ? defaultPutDataStoreServerCode : null;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_DATASET_PROPERTIES")
    public void updateDataSetProperties(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.DataSetTechIdPredicate.class) TechId entityId, List<PropertyUpdates> modifiedProperties) {
        this.checkSession(sessionToken);
        AbstractExternalData dataSet = this.getDataSetInfo(sessionToken, entityId);
        try {
            String sampleIdentifier;
            DataSetUpdatesDTO updates = new DataSetUpdatesDTO();
            updates.setDatasetId(entityId);
            updates.setVersion(dataSet.getVersion());
            Map<String, String> properties = this.createPropertiesMap(modifiedProperties);
            updates.setProperties(EntityHelper.translatePropertiesMapToList(properties));
            Experiment exp = dataSet.getExperiment();
            if (exp != null) {
                updates.setExperimentIdentifierOrNull(ExperimentIdentifierFactory.parse(exp.getIdentifier()));
            }
            if ((sampleIdentifier = dataSet.getSampleIdentifier()) != null) {
                updates.setSampleIdentifierOrNull(SampleIdentifierFactory.parse(sampleIdentifier));
            }
            if (dataSet instanceof PhysicalDataSet) {
                updates.setFileFormatTypeCode(((PhysicalDataSet)dataSet).getFileFormatType().getCode());
            }
            this.updateDataSet(sessionToken, updates);
        }
        catch (UserFailureException e) {
            throw CommonServer.wrapExceptionWithEntityIdentifier(e, dataSet);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_EXPERIMENT_PROPERTIES")
    public void updateExperimentProperties(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId entityId, List<PropertyUpdates> modifiedProperties) {
        this.checkSession(sessionToken);
        Experiment experiment = this.getExperimentInfo(sessionToken, entityId);
        try {
            ExperimentUpdatesDTO updates = new ExperimentUpdatesDTO();
            updates.setVersion(experiment.getVersion());
            updates.setExperimentId(entityId);
            updates.setAttachments(Collections.<NewAttachment>emptySet());
            updates.setProjectIdentifier(new ProjectIdentifierFactory(experiment.getProject().getIdentifier()).createIdentifier());
            Map<String, String> properties = this.createPropertiesMap(modifiedProperties);
            updates.setProperties(EntityHelper.translatePropertiesMapToList(properties));
            this.updateExperiment(sessionToken, updates);
        }
        catch (UserFailureException e) {
            throw CommonServer.wrapExceptionWithEntityIdentifier(e, experiment);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="WRITE_SAMPLE_PROPERTIES")
    public void updateSampleProperties(String sessionToken, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId entityId, List<PropertyUpdates> modifiedProperties) {
        this.checkSession(sessionToken);
        Map<String, String> properties = this.createPropertiesMap(modifiedProperties);
        Sample sample = this.getSampleInfo(sessionToken, entityId).getParent();
        try {
            EntityHelper.updateSampleProperties((ICommonServer)this, sessionToken, sample, properties);
        }
        catch (UserFailureException e) {
            throw CommonServer.wrapExceptionWithEntityIdentifier(e, sample);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="WRITE_MATERIAL_PROPERTIES")
    public void updateMaterialProperties(String sessionToken, TechId entityId, List<PropertyUpdates> modifiedProperties) {
        this.checkSession(sessionToken);
        Date modificationDate = ((MaterialPE)this.getDAOFactory().getMaterialDAO().tryGetByTechId(entityId, new String[0])).getModificationDate();
        Map<String, String> properties = this.createPropertiesMap(modifiedProperties);
        this.updateMaterial(sessionToken, entityId, EntityHelper.translatePropertiesMapToList(properties), null, modificationDate);
    }

    private Map<String, String> createPropertiesMap(List<PropertyUpdates> updates) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropertyUpdates p : updates) {
            properties.put(CodeConverter.getPropertyTypeCode(p.getPropertyCode()), p.getValue());
        }
        return properties;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @ReturnValueFilter(validatorClass=DeletionValidator.class)
    public List<Deletion> listDeletions(String sessionToken, boolean withDeletedEntities) {
        Session session = this.getSession(sessionToken);
        IDeletionTable deletionTable = this.businessObjectFactory.createDeletionTable(session);
        deletionTable.load(withDeletedEntities);
        return deletionTable.getDeletions();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @ReturnValueFilter(validatorClass=DeletionValidator.class)
    public List<Deletion> listOriginalDeletions(String sessionToken) {
        Session session = this.getSession(sessionToken);
        IDeletionTable deletionTable = this.businessObjectFactory.createDeletionTable(session);
        deletionTable.loadOriginal();
        return deletionTable.getDeletions();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @Capability(value="RESTORE")
    public void revertDeletions(String sessionToken, @AuthorizationGuard(guardClass=RevertDeletionPredicate.class) List<TechId> deletionIds) {
        Session session = this.getSession(sessionToken);
        HashSet<Long> deletionIdsAsASet = new HashSet<Long>(TechId.asLongs(deletionIds));
        IDeletionTable deletionTable = this.getBusinessObjectFactory().createDeletionTable(session);
        deletionTable.load(true);
        List<Deletion> deletions = deletionTable.getDeletions();
        HashSet<TechId> deletedExperimentIds = new HashSet<TechId>();
        HashSet<TechId> deletedSampleIds = new HashSet<TechId>();
        HashSet<String> deletedDataSetCodes = new HashSet<String>();
        ITrashBO trashBO = this.getBusinessObjectFactory().createTrashBO(session);
        for (Deletion deletion : deletions) {
            Long deletionId = deletion.getId();
            if (!deletionIdsAsASet.contains(deletionId)) continue;
            List<IEntityInformationHolderWithIdentifier> deletedEntities = deletion.getDeletedEntities();
            for (IEntityInformationHolderWithIdentifier deletedEntity : deletedEntities) {
                EntityKind entityKind = deletedEntity.getEntityKind();
                TechId entityId = new TechId(deletedEntity.getId());
                switch (entityKind) {
                    case EXPERIMENT: {
                        deletedExperimentIds.add(entityId);
                        break;
                    }
                    case SAMPLE: {
                        deletedSampleIds.add(entityId);
                        break;
                    }
                    case DATA_SET: {
                        deletedDataSetCodes.add(deletedEntity.getCode());
                    }
                }
            }
            trashBO.revertDeletion(new TechId(deletionId));
        }
        this.updateModificationDateAndModifierOfRelatedProjectsOfExperiments(deletedExperimentIds, session);
        this.updateModificationDateAndModifierOfRelatedEntitiesOfSamples(deletedSampleIds, session);
        this.updateModificationDateAndModifierOfRelatedEntitiesOfDataSets(deletedDataSetCodes, session);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @Capability(value="PURGE")
    public void deletePermanently(String sessionToken, @AuthorizationGuard(guardClass=DeletionTechIdCollectionPredicate.class) List<TechId> deletionIds) {
        this.deletePermanentlyCommon(sessionToken, deletionIds, false);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_DISABLED})
    @Capability(value="FORCE_PURGE")
    public void deletePermanentlyForced(String sessionToken, @AuthorizationGuard(guardClass=DeletionTechIdCollectionPredicate.class) List<TechId> deletionIds) {
        this.deletePermanentlyCommon(sessionToken, deletionIds, true);
    }

    private void deletePermanentlyCommon(String sessionToken, List<TechId> deletionIds, boolean forceDisallowedTypes) {
        Session session = this.getSession(sessionToken);
        PersonPE registrator = session.tryGetPerson();
        IDeletionDAO deletionDAO = this.getDAOFactory().getDeletionDAO();
        ISampleDAO sampleDAO = this.getDAOFactory().getSampleDAO();
        for (TechId deletionId : deletionIds) {
            DeletionPE deletion = (DeletionPE)deletionDAO.getByTechId(deletionId);
            String deletionReason = deletion.getReason();
            DeletionType deletionType = DeletionType.PERMANENT;
            List<TechId> singletonList = Collections.singletonList(deletionId);
            List<String> trashedDataSets = deletionDAO.findTrashedDataSetCodes(singletonList);
            this.deleteDataSetsCommon(sessionToken, trashedDataSets, deletionReason, deletionType, forceDisallowedTypes, true);
            sampleDAO.deletePermanently(deletion, registrator);
            List<TechId> trashedExperiments = deletionDAO.findTrashedExperimentIds(singletonList);
            this.deleteExperiments(sessionToken, trashedExperiments, deletionReason, deletionType);
            DeletionPE freshDeletion = (DeletionPE)deletionDAO.getByTechId(TechId.create(deletion));
            deletionDAO.delete(freshDeletion);
        }
    }

    private static UserFailureException wrapExceptionWithEntityIdentifier(UserFailureException exception, IEntityInformationHolderWithIdentifier entity) {
        return UserFailureException.fromTemplate(exception, "%s '%s': %s", entity.getEntityKind().getDescription(), entity.getIdentifier(), exception.getMessage());
    }

    @Override
    public void registerPlugin(String sessionToken, CorePlugin plugin, ICorePluginResourceLoader resourceLoader) {
        Session session = this.getSession(sessionToken);
        EncapsulatedCommonServer encapsulated = EncapsulatedCommonServer.create(this, sessionToken);
        MasterDataRegistrationScriptRunner scriptRunner = new MasterDataRegistrationScriptRunner(encapsulated);
        ICorePluginTable pluginTable = this.businessObjectFactory.createCorePluginTable(session, scriptRunner);
        pluginTable.registerPlugin(plugin, resourceLoader);
    }

    @Override
    public List<DataStore> listDataStores() {
        IDataStoreDAO dataStoreDAO = this.getDAOFactory().getDataStoreDAO();
        List<DataStorePE> dataStorePEs = dataStoreDAO.listDataStores();
        return DataStoreTranslator.translate(dataStorePEs);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Material> searchForMaterials(String sessionToken, DetailedSearchCriteria criteria) {
        Session session = this.getSession(sessionToken);
        SearchHelper searchHelper = new SearchHelper(session, this.businessObjectFactory, this.getDAOFactory());
        return searchHelper.searchForMaterials(session.getUserName(), criteria);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public String performCustomImport(String sessionToken, String customImportCode, CustomImportFile customImportFile) throws UserFailureException {
        PropertyParametersUtil.SectionProperties[] sectionProperties;
        Session session = this.getSession(sessionToken);
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = sectionProperties = PropertyParametersUtil.extractSectionProperties(this.configurer.getResolvedProps(), CustomImport.PropertyNames.CUSTOM_IMPORTS.getName(), false);
        int n = sectionProperties.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties props = sectionPropertiesArray[n2];
            if (props.getKey().equals(customImportCode)) {
                String dssCode = props.getProperties().getProperty(CustomImport.PropertyNames.DATASTORE_CODE.getName());
                String dropboxName = props.getProperties().getProperty(CustomImport.PropertyNames.DROPBOX_NAME.getName());
                IDataStoreBO dataStore = this.businessObjectFactory.createDataStoreBO(session);
                dataStore.loadByCode(dssCode);
                dataStore.uploadFile(dropboxName, customImportFile);
                return customImportFile.getFileName();
            }
            ++n2;
        }
        throw new UserFailureException(String.format("Cannot upload file '%s' to the dss.", customImportFile.getFileName()));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void sendCountActiveUsersEmail(String sessionToken) {
        Session session = this.getSession(sessionToken);
        String email = session.getUserEmail();
        String hostName = null;
        DatabaseConfigurationContext ctx = DatabaseContextUtils.getDatabaseContext(this.getDAOFactory());
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.operationLog.warn("Couldn't get the hostname.");
        }
        StringBuilder emailBody = new StringBuilder();
        emailBody.append("Number of active users: ").append(this.countActivePersons(sessionToken)).append("\n").append("Hostname: ").append(hostName).append("\n").append("Database instance: ").append(ctx.getDatabaseInstance()).append(" [name=").append(ctx.getDatabaseName()).append("]").append("\n");
        MailClient mailClient = new MailClient(this.mailClientParameters);
        this.sendEmail(mailClient, emailBody.toString(), "Number of active users", this.CISDHelpdeskEmail, email);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public List<ExternalDataManagementSystem> listExternalDataManagementSystems(String sessionToken) {
        this.checkSession(sessionToken);
        ArrayList<ExternalDataManagementSystem> results = new ArrayList<ExternalDataManagementSystem>();
        for (ExternalDataManagementSystemPE edms : this.getDAOFactory().getExternalDataManagementSystemDAO().listExternalDataManagementSystems()) {
            results.add(ExternalDataManagementSystemTranslator.translate(edms));
        }
        return results;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public ExternalDataManagementSystem getExternalDataManagementSystem(String sessionToken, String code) {
        this.checkSession(sessionToken);
        return ExternalDataManagementSystemTranslator.translate(this.getDAOFactory().getExternalDataManagementSystemDAO().tryToFindExternalDataManagementSystemByCode(code));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void createOrUpdateExternalDataManagementSystem(String sessionToken, ExternalDataManagementSystem edms) {
        this.checkSession(sessionToken);
        IDAOFactory daoFactory = this.getDAOFactory();
        IExternalDataManagementSystemDAO edmsDAO = daoFactory.getExternalDataManagementSystemDAO();
        ExternalDataManagementSystemPE edmsPE = edmsDAO.tryToFindExternalDataManagementSystemByCode(edms.getCode());
        if (edmsPE == null) {
            edmsPE = new ExternalDataManagementSystemPE();
            edmsPE.setDatabaseInstance(daoFactory.getHomeDatabaseInstance());
        }
        edmsDAO.createOrUpdateExternalDataManagementSystem(ExternalDataManagementSystemTranslator.translate(edms, edmsPE));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Metaproject> listMetaprojects(String sessionToken) {
        Session session = this.getSession(sessionToken);
        PersonPE owner = session.tryGetPerson();
        return this.listMetaProjects(owner);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public List<Metaproject> listMetaprojectsOnBehalfOfUser(String sessionToken, String userId) {
        this.checkSession(sessionToken);
        PersonPE user = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        if (user == null) {
            throw new UserFailureException("Unknown user: " + userId);
        }
        return this.listMetaProjects(user);
    }

    private List<Metaproject> listMetaProjects(PersonPE owner) {
        IDAOFactory daoFactory = this.getDAOFactory();
        IMetaprojectDAO metaprojectDAO = daoFactory.getMetaprojectDAO();
        List<MetaprojectPE> metaprojectPEs = metaprojectDAO.listMetaprojects(owner);
        return MetaprojectTranslator.translate(metaprojectPEs);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<MetaprojectAssignmentsCount> listMetaprojectAssignmentsCounts(String sessionToken) {
        List<Metaproject> metaprojects = this.listMetaprojects(sessionToken);
        ArrayList<MetaprojectAssignmentsCount> counts = new ArrayList<MetaprojectAssignmentsCount>(metaprojects.size());
        for (Metaproject metaproject : metaprojects) {
            counts.add(this.getMetaprojectAssignmentsCount(metaproject));
        }
        return counts;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public MetaprojectAssignmentsCount getMetaprojectAssignmentsCount(String sessionToken, IMetaprojectId metaprojectId) {
        Metaproject metaproject = this.getMetaproject(sessionToken, metaprojectId);
        return this.getMetaprojectAssignmentsCount(metaproject);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public MetaprojectAssignments getMetaprojectAssignments(String sessionToken, IMetaprojectId metaprojectId) {
        return this.getMetaprojectAssignments(sessionToken, metaprojectId, EnumSet.allOf(MetaprojectAssignmentsFetchOption.class));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public MetaprojectAssignments getMetaprojectAssignmentsOnBehalfOfUser(String sessionToken, IMetaprojectId metaprojectId, String userId) {
        Session session = this.getSession(sessionToken);
        PersonPE user = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        if (user == null) {
            throw new UserFailureException("Unknown user: " + userId);
        }
        return this.getMetaprojectAssignments(session, metaprojectId, EnumSet.allOf(MetaprojectAssignmentsFetchOption.class), user);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public MetaprojectAssignments getMetaprojectAssignments(String sessionToken, IMetaprojectId metaprojectId, EnumSet<MetaprojectAssignmentsFetchOption> fetchOptions) {
        Session session = this.getSession(sessionToken);
        return this.getMetaprojectAssignments(session, metaprojectId, fetchOptions, session.tryGetPerson());
    }

    private MetaprojectAssignments getMetaprojectAssignments(Session session, IMetaprojectId metaprojectId, EnumSet<MetaprojectAssignmentsFetchOption> fetchOptions, PersonPE user) {
        if (metaprojectId == null) {
            throw new UserFailureException("Metaproject id cannot be null");
        }
        if (fetchOptions == null) {
            throw new UserFailureException("Fetch options cannot be null");
        }
        Metaproject metaproject = this.getMetaproject(session, metaprojectId, user, true);
        MetaprojectAssignmentsHelper helper = new MetaprojectAssignmentsHelper(this.getDAOFactory(), this.managedPropertyEvaluatorFactory);
        return helper.getMetaprojectAssignments(session, metaproject, session.getUserName(), fetchOptions);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void addToMetaproject(String sessionToken, IMetaprojectId metaprojectId, MetaprojectAssignmentsIds assignmentsToAdd) {
        if (metaprojectId == null) {
            throw new UserFailureException("Metaproject id cannot be null");
        }
        if (assignmentsToAdd == null) {
            throw new UserFailureException("Assignments to add cannot be null");
        }
        Session session = this.getSession(sessionToken);
        IMetaprojectBO metaprojectBO = this.getBusinessObjectFactory().createMetaprojectBO(session);
        metaprojectBO.loadByMetaprojectId(metaprojectId);
        this.getAuthorizationService(session).checkAccessMetaproject(metaprojectBO.getMetaproject());
        metaprojectBO.addExperiments(assignmentsToAdd.getExperiments());
        metaprojectBO.addSamples(assignmentsToAdd.getSamples());
        metaprojectBO.addDataSets(assignmentsToAdd.getDataSets());
        metaprojectBO.addMaterials(assignmentsToAdd.getMaterials());
        metaprojectBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void removeFromMetaproject(String sessionToken, IMetaprojectId metaprojectId, MetaprojectAssignmentsIds assignmentsToRemove) {
        if (metaprojectId == null) {
            throw new UserFailureException("Metaproject id cannot be null");
        }
        if (assignmentsToRemove == null) {
            throw new UserFailureException("Assignments to remove cannot be null");
        }
        Session session = this.getSession(sessionToken);
        IMetaprojectBO metaprojectBO = this.getBusinessObjectFactory().createMetaprojectBO(session);
        metaprojectBO.loadByMetaprojectId(metaprojectId);
        this.getAuthorizationService(session).checkAccessMetaproject(metaprojectBO.getMetaproject());
        metaprojectBO.removeExperiments(assignmentsToRemove.getExperiments());
        metaprojectBO.removeSamples(assignmentsToRemove.getSamples());
        metaprojectBO.removeDataSets(assignmentsToRemove.getDataSets());
        metaprojectBO.removeMaterials(assignmentsToRemove.getMaterials());
        metaprojectBO.save();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void deleteMetaproject(String sessionToken, IMetaprojectId metaprojectId, String reason) {
        if (metaprojectId == null) {
            throw new UserFailureException("Metaproject id cannot be null");
        }
        Session session = this.getSession(sessionToken);
        IMetaprojectBO metaprojectBO = this.getBusinessObjectFactory().createMetaprojectBO(session);
        metaprojectBO.loadByMetaprojectId(metaprojectId);
        this.getAuthorizationService(session).checkAccessMetaproject(metaprojectBO.getMetaproject());
        metaprojectBO.deleteByMetaprojectId(metaprojectId, reason);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void deleteMetaprojects(String sessionToken, List<IMetaprojectId> metaprojectIds, String reason) {
        if (metaprojectIds == null) {
            throw new UserFailureException("Metaproject ids cannot be null");
        }
        for (IMetaprojectId metaprojectId : metaprojectIds) {
            this.deleteMetaproject(sessionToken, metaprojectId, reason);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Metaproject registerMetaproject(String sessionToken, IMetaprojectRegistration registration) {
        Session session = this.getSession(sessionToken);
        IMetaprojectBO metaprojectBO = this.getBusinessObjectFactory().createMetaprojectBO(session);
        metaprojectBO.define(session.tryGetPerson().getUserId(), registration);
        metaprojectBO.save();
        return MetaprojectTranslator.translate(metaprojectBO.getMetaproject());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Metaproject updateMetaproject(String sessionToken, IMetaprojectId metaprojectId, IMetaprojectUpdates updates) {
        Session session = this.getSession(sessionToken);
        IMetaprojectBO metaprojectBO = this.getBusinessObjectFactory().createMetaprojectBO(session);
        metaprojectBO.loadByMetaprojectId(metaprojectId);
        this.getAuthorizationService(session).checkAccessMetaproject(metaprojectBO.getMetaproject());
        metaprojectBO.update(updates);
        metaprojectBO.save();
        return MetaprojectTranslator.translate(metaprojectBO.getMetaproject());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Metaproject getMetaproject(String sessionToken, IMetaprojectId metaprojectId) {
        Session session = this.getSession(sessionToken);
        return this.getMetaproject(session, metaprojectId, session.tryGetPerson());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Metaproject getMetaprojectWithoutOwnershipChecks(String sessionToken, IMetaprojectId metaprojectId) {
        Session session = this.getSession(sessionToken);
        return this.getMetaproject(session, metaprojectId, session.tryGetPerson(), false);
    }

    private Metaproject getMetaproject(Session session, IMetaprojectId metaprojectId, PersonPE user) {
        return this.getMetaproject(session, metaprojectId, user, true);
    }

    private Metaproject getMetaproject(Session session, IMetaprojectId metaprojectId, PersonPE user, boolean checkAccess) {
        if (metaprojectId == null) {
            throw new UserFailureException("Metaproject id cannot be null");
        }
        IMetaprojectBO metaprojectBO = this.getBusinessObjectFactory().createMetaprojectBO(session);
        MetaprojectPE metaprojectPE = metaprojectBO.tryFindByMetaprojectId(metaprojectId);
        if (metaprojectPE == null) {
            throw new UserFailureException("Metaproject with id: " + metaprojectId + " doesn't exist");
        }
        if (checkAccess) {
            AuthorizationServiceUtils authorizationUtils = new AuthorizationServiceUtils(this.getDAOFactory(), user);
            authorizationUtils.checkAccessMetaproject(metaprojectPE);
        }
        return MetaprojectTranslator.translate(metaprojectPE);
    }

    private MetaprojectAssignmentsCount getMetaprojectAssignmentsCount(Metaproject metaproject) {
        IMetaprojectDAO metaprojectDAO = this.getDAOFactory().getMetaprojectDAO();
        MetaprojectAssignmentsCount count = new MetaprojectAssignmentsCount();
        count.setMetaproject(metaproject);
        count.setExperimentCount(metaprojectDAO.getMetaprojectAssignmentsCount(metaproject.getId(), ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.EXPERIMENT));
        count.setSampleCount(metaprojectDAO.getMetaprojectAssignmentsCount(metaproject.getId(), ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.SAMPLE));
        count.setDataSetCount(metaprojectDAO.getMetaprojectAssignmentsCount(metaproject.getId(), ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.DATA_SET));
        count.setMaterialCount(metaprojectDAO.getMetaprojectAssignmentsCount(metaproject.getId(), ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind.MATERIAL));
        return count;
    }

    private AuthorizationServiceUtils getAuthorizationService(Session session) {
        return new AuthorizationServiceUtils(this.getDAOFactory(), session.tryGetPerson());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<String> listPredeployedPlugins(String sessionToken, ScriptType scriptType) {
        this.checkSession(sessionToken);
        switch (scriptType) {
            case ENTITY_VALIDATION: {
                return this.entityValidationFactory.listPredeployedPlugins();
            }
            case DYNAMIC_PROPERTY: {
                return this.dynamicPropertyCalculatorFactory.listPredeployedPlugins();
            }
            case MANAGED_PROPERTY: {
                return this.managedPropertyEvaluatorFactory.listPredeployedPlugins();
            }
        }
        return null;
    }
}

