/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

class CapabilityMap {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, CapabilityMap.class);
    private final Map<String, Collection<RoleWithHierarchy>> capMap = new HashMap<String, Collection<RoleWithHierarchy>>();

    private static final List<String> readLines(File file) {
        if (!file.exists()) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format("No file '%s", file.getPath()));
            }
            return Collections.emptyList();
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Reading capability role map file " + file);
        }
        try {
            return FileUtils.readLines((File)file);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    CapabilityMap(File file) {
        this(CapabilityMap.readLines(file), file.getPath());
    }

    CapabilityMap(List<String> lines, String filePath) {
        for (String line : lines) {
            String[] roleNameArray;
            String trimmed = line.trim();
            if (trimmed.length() == 0 || trimmed.startsWith("#")) continue;
            String[] splitted = StringUtils.split((String)trimmed, (String)" \t:");
            if (splitted.length != 2) {
                operationLog.warn(String.format("Ignoring mal-formed line '%s' in %s.", trimmed, filePath));
                continue;
            }
            String capabilityName = splitted[0];
            String roleNames = splitted[1];
            String[] stringArray = roleNameArray = StringUtils.split((String)roleNames, (String)",");
            int n = roleNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                String roleName = stringArray[n2];
                try {
                    RoleWithHierarchy role = RoleWithHierarchy.valueOf(roleName);
                    Collection<RoleWithHierarchy> roles = this.capMap.get(capabilityName);
                    if (roles == null) {
                        roles = new HashSet<RoleWithHierarchy>();
                        this.capMap.put(capabilityName, roles);
                    }
                    roles.add(role);
                    if (operationLog.isDebugEnabled()) {
                        operationLog.debug(String.format("Add to map: '%s' -> %s", capabilityName, role));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    operationLog.warn(String.format("Ignoring mal-formed line '%s' in %s [role '%s' doesn't exist].", trimmed, filePath, roleName));
                }
                ++n2;
            }
        }
    }

    Collection<RoleWithHierarchy> tryGetRoles(Method m) {
        Capability cap = m.getAnnotation(Capability.class);
        if (cap == null) {
            return null;
        }
        String capabilityName = cap.value().toUpperCase();
        Collection<RoleWithHierarchy> rolesOrNull = this.capMap.get(capabilityName);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Request: '%s' -> %s", capabilityName, rolesOrNull));
        }
        return rolesOrNull;
    }
}

