/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ITrashBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.dao.DataAccessException;

public class TrashBO
extends AbstractBusinessObject
implements ITrashBO {
    private final ICommonBusinessObjectFactory boFactory;
    private DeletionPE deletion;

    public TrashBO(IDAOFactory daoFactory, ICommonBusinessObjectFactory boFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
        this.boFactory = boFactory;
    }

    @Override
    public void createDeletion(String reason) {
        try {
            this.deletion = new DeletionPE();
            this.deletion.setReason(reason);
            this.deletion.setRegistrator(this.session.tryGetPerson());
            this.getDeletionDAO().create(this.deletion);
        }
        catch (DataAccessException ex) {
            TrashBO.throwException(ex, "Deletion");
        }
    }

    @Override
    public void trashDataSets(List<TechId> dataSetIds) {
        this.trashDataSets(dataSetIds, true);
    }

    @Override
    public void trashExperiments(List<TechId> experimentIds) {
        this.trashExperiments(experimentIds, true);
    }

    @Override
    public void trashSamples(List<TechId> sampleIds) {
        assert (this.deletion != null);
        this.trashSamples(sampleIds, CascadeSampleDependentComponents.TRUE, true);
    }

    private void trashSamples(List<TechId> sampleIds, CascadeSampleDependentComponents cascadeType, boolean isOriginalDeletion) {
        assert (this.deletion != null);
        TrashBatchOperation batchOperation = new TrashBatchOperation(EntityKind.SAMPLE, sampleIds, this.deletion, this.getDeletionDAO(), isOriginalDeletion);
        BatchOperationExecutor.executeInBatches(batchOperation);
        if (batchOperation.counter > 0) {
            if (cascadeType == CascadeSampleDependentComponents.TRUE) {
                this.trashSampleDependentComponents(sampleIds);
            }
            this.trashSampleDependentDataSets(sampleIds);
        }
    }

    public void trashExperiments(List<TechId> experimentIds, boolean isOriginalDeletion) {
        assert (this.deletion != null);
        TrashBatchOperation batchOperation = new TrashBatchOperation(EntityKind.EXPERIMENT, experimentIds, this.deletion, this.getDeletionDAO(), isOriginalDeletion);
        BatchOperationExecutor.executeInBatches(batchOperation);
        if (batchOperation.counter > 0) {
            this.trashExperimentDependentDataSets(experimentIds);
            this.trashExperimentDependentSamples(experimentIds);
        }
    }

    public void trashDataSets(List<TechId> dataSetIds, boolean isOriginalDeletion) {
        assert (this.deletion != null);
        List<TechId> allIdsAsList = this.getDataDAO().listContainedDataSetsRecursively(dataSetIds);
        this.checkForNonDeletableDataSets(allIdsAsList);
        if (isOriginalDeletion) {
            allIdsAsList.removeAll(dataSetIds);
            TrashBatchOperation batchOperation = new TrashBatchOperation(EntityKind.DATA_SET, dataSetIds, this.deletion, this.getDeletionDAO(), true);
            BatchOperationExecutor.executeInBatches(batchOperation);
            batchOperation = new TrashBatchOperation(EntityKind.DATA_SET, allIdsAsList, this.deletion, this.getDeletionDAO(), false);
            BatchOperationExecutor.executeInBatches(batchOperation);
        } else {
            TrashBatchOperation batchOperation = new TrashBatchOperation(EntityKind.DATA_SET, allIdsAsList, this.deletion, this.getDeletionDAO(), false);
            BatchOperationExecutor.executeInBatches(batchOperation);
        }
    }

    private void checkForNonDeletableDataSets(List<TechId> allIdsAsList) {
        IDataSetTable dataSetTable = this.boFactory.createDataSetTable(this.session);
        dataSetTable.loadByIds(allIdsAsList);
        List<ExternalDataPE> unavailableDataSets = dataSetTable.getNonDeletableExternalDataSets();
        if (unavailableDataSets.isEmpty()) {
            return;
        }
        TreeMap<DataSetArchivingStatus, ArrayList<String>> statusToCodesMap = new TreeMap<DataSetArchivingStatus, ArrayList<String>>();
        for (ExternalDataPE dataSet : unavailableDataSets) {
            DataSetArchivingStatus status = dataSet.getStatus();
            ArrayList<String> codes = (ArrayList<String>)statusToCodesMap.get((Object)status);
            if (codes == null) {
                codes = new ArrayList<String>();
                statusToCodesMap.put(status, codes);
            }
            codes.add(dataSet.getCode());
        }
        StringBuilder builder = new StringBuilder();
        Set entrySet = statusToCodesMap.entrySet();
        for (Map.Entry entry : entrySet) {
            builder.append("\n Status: ").append(entry.getKey()).append(", data sets: ");
            builder.append(entry.getValue());
        }
        throw new UserFailureException("Deletion not possible because the following data sets are not deletable:" + builder);
    }

    private void trashSampleDependentComponents(List<TechId> sampleIds) {
        final ISampleDAO sampleDAO = this.getSampleDAO();
        AbstractQueryBatchOperation batchOperation = new AbstractQueryBatchOperation(EntityKind.SAMPLE, sampleIds, "listSampleIdsByContainerIds"){

            @Override
            public Collection<TechId> listAction(List<TechId> entities) {
                return sampleDAO.listSampleIdsByContainerIds(entities);
            }
        };
        BatchOperationExecutor.executeInBatches(batchOperation);
        this.trashSamples(batchOperation.getResults(), CascadeSampleDependentComponents.FALSE, false);
    }

    private void trashSampleDependentDataSets(List<TechId> sampleIds) {
        AbstractQueryBatchOperation batchOperation = new AbstractQueryBatchOperation(EntityKind.DATA_SET, sampleIds, "listDataSetIdsBySampleIds"){

            public List<TechId> listAction(List<TechId> entities) {
                return TrashBO.this.getDataDAO().listDataSetIdsBySampleIds(entities);
            }
        };
        BatchOperationExecutor.executeInBatches(batchOperation);
        this.trashDataSets(batchOperation.getResults(), false);
    }

    private void trashExperimentDependentSamples(List<TechId> experimentIds) {
        AbstractQueryBatchOperation batchOperation = new AbstractQueryBatchOperation(EntityKind.SAMPLE, experimentIds, "listSampleIdsByExperimentIds"){

            public List<TechId> listAction(List<TechId> entities) {
                return TrashBO.this.getSampleDAO().listSampleIdsByExperimentIds(entities);
            }
        };
        BatchOperationExecutor.executeInBatches(batchOperation);
        this.trashSamples(batchOperation.getResults(), CascadeSampleDependentComponents.TRUE, false);
    }

    private void trashExperimentDependentDataSets(List<TechId> experimentIds) {
        AbstractQueryBatchOperation batchOperation = new AbstractQueryBatchOperation(EntityKind.DATA_SET, experimentIds, "listDataSetIdsByExperimentIds"){

            public List<TechId> listAction(List<TechId> entities) {
                return TrashBO.this.getDataDAO().listDataSetIdsByExperimentIds(entities);
            }
        };
        BatchOperationExecutor.executeInBatches(batchOperation);
        this.trashDataSets(batchOperation.getResults(), false);
    }

    @Override
    public void revertDeletion(TechId deletionId) {
        try {
            this.deletion = (DeletionPE)this.getDeletionDAO().getByTechId(deletionId);
            this.getDeletionDAO().revert(this.deletion, this.session.tryGetPerson());
        }
        catch (DataAccessException ex) {
            TrashBO.throwException(ex, "Deletion");
        }
    }

    private static abstract class AbstractQueryBatchOperation
    implements IBatchOperation<TechId> {
        private final EntityKind entityKind;
        private final List<TechId> entityIds;
        private final String operationName;
        private final Set<TechId> results = new LinkedHashSet<TechId>();

        public AbstractQueryBatchOperation(EntityKind entityKind, List<TechId> entityIds, String operationName) {
            this.entityKind = entityKind;
            this.entityIds = entityIds;
            this.operationName = operationName;
        }

        public abstract Collection<TechId> listAction(List<TechId> var1);

        @Override
        public void execute(List<TechId> entities) {
            this.results.addAll(this.listAction(entities));
        }

        @Override
        public List<TechId> getAllEntities() {
            return this.entityIds;
        }

        @Override
        public String getEntityName() {
            return this.entityKind.getLabel();
        }

        @Override
        public String getOperationName() {
            return this.operationName;
        }

        public List<TechId> getResults() {
            return new ArrayList<TechId>(this.results);
        }
    }

    private static enum CascadeSampleDependentComponents {
        TRUE,
        FALSE;

    }

    private static class TrashBatchOperation
    implements IBatchOperation<TechId> {
        private final EntityKind entityKind;
        private final List<TechId> entityIds;
        private final DeletionPE deletion;
        private final IDeletionDAO deletionDAO;
        private final boolean isOriginalDeletion;
        private int counter = 0;

        public TrashBatchOperation(EntityKind entityKind, List<TechId> entityIds, DeletionPE deletion, IDeletionDAO deletionDAO, boolean isOriginalDeletion) {
            this.entityKind = entityKind;
            this.entityIds = entityIds;
            this.deletion = deletion;
            this.deletionDAO = deletionDAO;
            this.isOriginalDeletion = isOriginalDeletion;
        }

        @Override
        public void execute(List<TechId> entities) {
            this.counter += this.deletionDAO.trash(this.entityKind, entities, this.deletion, this.isOriginalDeletion);
        }

        @Override
        public List<TechId> getAllEntities() {
            return this.entityIds;
        }

        @Override
        public String getEntityName() {
            return this.entityKind.getLabel();
        }

        @Override
        public String getOperationName() {
            return "trash";
        }
    }
}

