/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.common.resource.ReleasableIterable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.AbstractEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityAdaptorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityAdaptorIterator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.ExternalDataAdaptorRelationsLoader;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.INonAbstractEntityAdapter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDataAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IExperimentAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.ISampleAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import org.apache.lucene.search.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;

public class ExternalDataAdaptor
extends AbstractEntityAdaptor
implements IDataAdaptor,
INonAbstractEntityAdapter {
    private final DataPE externalDataPE;
    private final Session session;

    public ExternalDataAdaptor(DataPE externalDataPE, IDynamicPropertyEvaluator evaluator, Session session) {
        super(externalDataPE, evaluator);
        this.session = session;
        this.externalDataPE = externalDataPE;
    }

    public DataPE externalDataPE() {
        return this.externalDataPE;
    }

    @Override
    public DataPE entityPE() {
        return this.externalDataPE();
    }

    @Override
    public IExperimentAdaptor experiment() {
        IExperimentAdaptor adaptor = EntityAdaptorFactory.create(this.externalDataPE.getExperiment(), this.evaluator, this.session);
        this.getResources().add(adaptor);
        return adaptor;
    }

    @Override
    public ISampleAdaptor sample() {
        SamplePE sample = this.externalDataPE.tryGetSample();
        if (sample != null) {
            ISampleAdaptor adaptor = EntityAdaptorFactory.create(sample, this.evaluator, this.session);
            this.getResources().add(adaptor);
            return adaptor;
        }
        return null;
    }

    @Override
    public Iterable<IDataAdaptor> parents() {
        return this.parentsOfType(ENTITY_TYPE_ANY_CODE_REGEXP);
    }

    @Override
    public Iterable<IDataAdaptor> parentsOfType(String typeCodeRegexp) {
        ReleasableIterable<IDataAdaptor> iterable = new ReleasableIterable<IDataAdaptor>(new ExternalDataAdaptorRelationsLoader(this.externalDataPE, this.evaluator, this.session).parentsOfType(typeCodeRegexp));
        this.getResources().add(iterable);
        return iterable;
    }

    @Override
    public Iterable<IDataAdaptor> children() {
        return this.childrenOfType(ENTITY_TYPE_ANY_CODE_REGEXP);
    }

    @Override
    public Iterable<IDataAdaptor> childrenOfType(String typeCodeRegexp) {
        ReleasableIterable<IDataAdaptor> iterable = new ReleasableIterable<IDataAdaptor>(new ExternalDataAdaptorRelationsLoader(this.externalDataPE, this.evaluator, this.session).childrenOfType(typeCodeRegexp));
        this.getResources().add(iterable);
        return iterable;
    }

    @Override
    public IDataAdaptor container() {
        DataPE container = this.externalDataPE.getContainer();
        if (container != null) {
            IDataAdaptor adaptor = EntityAdaptorFactory.create(container, this.evaluator, this.session);
            this.getResources().add(adaptor);
            return adaptor;
        }
        return null;
    }

    @Override
    public Iterable<IDataAdaptor> contained() {
        return this.containedOfType(ENTITY_TYPE_ANY_CODE_REGEXP);
    }

    @Override
    public Iterable<IDataAdaptor> containedOfType(String typeCodeRegexp) {
        Query typeConstraint = this.regexpConstraint(ENTITY_TYPE_CODE_FIELD, typeCodeRegexp.toLowerCase());
        Query containerConstraint = this.constraint("container id", Long.toString(this.externalDataPE.getId()));
        Query query = this.and(typeConstraint, containerConstraint);
        ScrollableResults results = this.execute(query, DataPE.class, this.session);
        EntityAdaptorIterator<IDataAdaptor> iterator = new EntityAdaptorIterator<IDataAdaptor>(results, this.evaluator, this.session);
        this.getResources().add(iterator);
        return iterator;
    }
}

