/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetWithEntityTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.AbstractGenericExperimentRegisterEditForm;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Collections;
import java.util.List;

public final class GenericExperimentEditForm
extends AbstractGenericExperimentRegisterEditForm {
    private Experiment originalExperiment;

    public static DatabaseModificationAwareComponent create(IViewContext<IGenericClientServiceAsync> viewContext, IIdAndCodeHolder identifiable) {
        GenericExperimentEditForm form = new GenericExperimentEditForm(viewContext, identifiable);
        return new DatabaseModificationAwareComponent((Component)form, (IDatabaseModificationObserver)form);
    }

    private GenericExperimentEditForm(IViewContext<IGenericClientServiceAsync> viewContext, IIdAndCodeHolder identifiable) {
        super(viewContext, Collections.<String, List<IManagedInputWidgetDescription>>emptyMap(), new ActionContext(), identifiable);
        this.setRevertButtonVisible(true);
    }

    private void loadSamplesInBackground() {
        ListSampleDisplayCriteria sampleCriteria = ListSampleDisplayCriteria.createForExperiment(this.techIdOrNull);
        this.viewContext.getCommonService().listSamples(sampleCriteria, new ListSamplesCallback(this.viewContext));
    }

    @Override
    protected void save() {
        ExperimentUpdates updates = new ExperimentUpdates();
        updates.setExperimentId(TechId.create(this.originalExperiment));
        updates.setVersion(this.originalExperiment.getVersion());
        updates.setProperties(this.extractProperties());
        updates.setProjectIdentifier(this.extractProjectIdentifier());
        updates.setAttachmentSessionKey(this.attachmentsSessionKey);
        updates.setAttachments(this.attachmentsManager.extractAttachments());
        updates.setSampleCodes(this.getSamples());
        updates.setSampleType(this.getSampleType());
        updates.setGenerateCodes(this.autoGenerateCodes.getValue());
        updates.setRegisterSamples(this.existingSamplesRadio.getValue() == false);
        updates.setSamplesSessionKey(this.samplesSessionKey);
        updates.setMetaprojectsOrNull(this.metaprojectArea.tryGetModifiedMetaprojects());
        ((IGenericClientServiceAsync)this.viewContext.getService()).updateExperiment(updates, new UpdateExperimentCallback(this.viewContext));
    }

    public void updateOriginalValues(List<String> samples) {
        this.updatePropertyFieldsOriginalValues();
        this.updateFieldOriginalValue(this.projectChooser);
        this.samplesArea.setSampleCodes(samples);
        this.updateFieldOriginalValue(this.metaprojectArea);
    }

    private void setOriginalExperiment(Experiment experiment) {
        this.originalExperiment = experiment;
    }

    @Override
    protected void initializeFormFields() {
        this.propertiesEditor.initWithProperties(this.originalExperiment.getExperimentType().getAssignedPropertyTypes(), this.originalExperiment.getProperties());
        this.samplesArea.setEnabled(false);
        this.samplesArea.setValue(this.viewContext.getMessage("load_in_progress", new Object[0]));
        this.loadSamplesInBackground();
        this.updateSamples();
        this.codeField.setValue(this.originalExperiment.getCode());
        this.projectChooser.selectProjectAndUpdateOriginal(this.originalExperiment.getProject().getIdentifier());
        this.metaprojectArea.setMetaprojects(this.originalExperiment.getMetaprojects());
    }

    @Override
    protected void loadForm() {
        this.viewContext.getCommonService().getExperimentInfo(this.techIdOrNull, (AsyncCallback<Experiment>)new ExperimentInfoCallback(this.viewContext));
    }

    private final class ExperimentInfoCallback
    extends AbstractAsyncCallback<Experiment> {
        private ExperimentInfoCallback(IViewContext<IGenericClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(Experiment result) {
            GenericExperimentEditForm.this.setOriginalExperiment(result);
            GenericExperimentEditForm.this.initGUI();
        }
    }

    private class ListSamplesCallback
    extends AbstractAsyncCallback<ResultSetWithEntityTypes<Sample>> {
        public ListSamplesCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(ResultSetWithEntityTypes<Sample> result) {
            GenericExperimentEditForm.this.samplesArea.setSamples(result.getResultSet().getList().extractOriginalObjects());
            GenericExperimentEditForm.this.samplesArea.setEnabled(true);
            GenericExperimentEditForm.this.updateDirtyCheck();
        }
    }

    private final class UpdateExperimentCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<ExperimentUpdateResult> {
        UpdateExperimentCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(ExperimentUpdateResult result) {
            GenericExperimentEditForm.this.originalExperiment.setVersion(result.getVersion());
            GenericExperimentEditForm.this.updateOriginalValues(result.getSamples());
            super.process(result);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(ExperimentUpdateResult result) {
            return "Experiment successfully updated";
        }
    }
}

