/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.InvalidDataTypeException;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.ResultColumn;
import net.lemnik.eodsql.TypeMapper;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.DataObjectBindingCache;
import net.lemnik.eodsql.spi.util.MutableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultDataObjectBinding<T>
extends DataObjectBinding<T> {
    private static final boolean HAVE_ACCESSIBLE_PERMISSION = DataObjectBindingCache.HAVE_ACCESSIBLE_PERMISSION;
    private TypeMapper<?>[] mappers = null;
    private MutableColumn[] columns;
    private String[] keyColumns = null;
    private AtomicReference<State> complete = new AtomicReference<State>(State.NOT_COMPLETE);

    DefaultDataObjectBinding(Class<T> clazz) {
        this.setObjectType(clazz);
    }

    private void complete(ResultSetMetaData resultSetMetaData) throws EoDException {
        try {
            DataObjectBindingCache dataObjectBindingCache = DataObjectBindingCache.getDataObjectBindingCache(this.getObjectType());
            switch (this.getBindingType()) {
                case FIRST_COLUMN_BINDING: 
                case KEYS_BINDING: {
                    this.init(dataObjectBindingCache.getKeyColumns(), resultSetMetaData);
                    break;
                }
                default: {
                    this.init(dataObjectBindingCache.getNormalColumns(), resultSetMetaData);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new EoDException("Could not create binding for data-type: " + this.getObjectType().getName(), sQLException);
        }
    }

    private void ensureComplete(ResultSetMetaData resultSetMetaData) throws EoDException {
        State state;
        while ((state = this.complete.get()) != State.COMPLETE) {
            if (this.complete.compareAndSet(State.NOT_COMPLETE, State.COMPLETION_IN_PROCESS)) {
                try {
                    this.complete(resultSetMetaData);
                    this.complete.set(State.COMPLETE);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    this.complete.set(State.NOT_COMPLETE);
                    throw runtimeException;
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String[] getKeyColumns0() {
        DataObjectBindingCache dataObjectBindingCache = DataObjectBindingCache.getDataObjectBindingCache(this.getObjectType());
        Map<DataObjectBindingCache.ColumnName, MutableColumn> map = dataObjectBindingCache.getKeyColumns();
        int n = map.size();
        String[] stringArray = new String[n];
        Iterator<DataObjectBindingCache.ColumnName> iterator = map.keySet().iterator();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = iterator.next().getColumnName();
        }
        return stringArray;
    }

    private void init(Map<DataObjectBindingCache.ColumnName, MutableColumn> map, ResultSetMetaData resultSetMetaData) throws SQLException, EoDException {
        Map<Class, TypeMapper> map2 = QueryTool.getTypeMap();
        if (this.getBindingType() == DataObjectBinding.BindingType.FIRST_COLUMN_BINDING) {
            if (map.size() != 1) {
                throw new EoDException("Exactly one AutoGeneratedKeys field required for a FIRST_COLUMN_BINDING.");
            }
            MutableColumn mutableColumn = map.values().iterator().next();
            TypeMapper typeMapper = map2.get(mutableColumn.getType());
            if (typeMapper == null) {
                throw new EoDException("No TypeMapper found for property: " + mutableColumn + " of type " + mutableColumn.getType().getName());
            }
            this.mappers = new TypeMapper[]{typeMapper};
            this.columns = new MutableColumn[]{mutableColumn};
        } else {
            this.mappers = new TypeMapper[resultSetMetaData.getColumnCount()];
            this.columns = new MutableColumn[resultSetMetaData.getColumnCount()];
            for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                String string = resultSetMetaData.getColumnLabel(i + 1);
                MutableColumn mutableColumn = map.get(new DataObjectBindingCache.ColumnName(string));
                if (mutableColumn != null) {
                    TypeMapper typeMapper = map2.get(mutableColumn.getType());
                    if (typeMapper == null) {
                        throw new EoDException("No TypeMapper found for object: " + mutableColumn + " of type " + mutableColumn.getType().getName());
                    }
                    this.mappers[i] = typeMapper;
                    this.columns[i] = mutableColumn;
                    continue;
                }
                this.mappers[i] = null;
                this.columns[i] = null;
            }
        }
    }

    @Override
    public T newInstance() throws EoDException {
        try {
            Constructor constructor = this.getObjectType().getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible() && HAVE_ACCESSIBLE_PERMISSION) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EoDException("Cannot instantiate type: " + this.getObjectType().getName() + ". Make sure it has a public default constrcutor.", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EoDException("Cannot instantiate type: " + this.getObjectType().getName() + ". Make sure it has a public default constrcutor.", invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new EoDException("Cannot instantiate type: " + this.getObjectType().getName() + ". Make sure it has a public default constrcutor.", noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new EoDException("Cannot instantiate type: " + this.getObjectType().getName() + ". Make sure it has a public default constrcutor.", securityException);
        }
        catch (InstantiationException instantiationException) {
            throw new EoDException("Cannot instantiate type: " + this.getObjectType().getName() + ". Make sure it has a public default constrcutor.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EoDException("Cannot instantiate type: " + this.getObjectType().getName() + ". Make sure it has a public default constrcutor.", illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBindingType(DataObjectBinding.BindingType bindingType) {
        if (this.complete.compareAndSet(State.NOT_COMPLETE, State.SET_BINDING_TYPE_IN_PROCESS)) {
            try {
                boolean bl = super.setBindingType(bindingType);
                return bl;
            }
            finally {
                this.complete.set(State.NOT_COMPLETE);
            }
        }
        return false;
    }

    @Override
    public void unmarshall(ResultSet resultSet, T t) throws SQLException, EoDException {
        this.ensureComplete(resultSet.getMetaData());
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            if (this.columns[i] == null) continue;
            Object obj = this.mappers[i].get(resultSet, i + 1);
            if (resultSet.wasNull()) {
                obj = null;
            }
            this.columns[i].set(t, obj);
        }
    }

    @Override
    public void marshall(T t, ResultSet resultSet) throws SQLException, EoDException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        this.ensureComplete(resultSetMetaData);
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            if (this.columns[i] == null) continue;
            Object object = this.columns[i].get(t);
            if (this.columns[i].isAutoKey()) continue;
            if (object == null) {
                resultSet.updateNull(i + 1);
                continue;
            }
            this.mappers[i].set(resultSet, i + 1, object);
        }
    }

    @Override
    public String[] getKeyColumnNames() {
        switch (this.getBindingType()) {
            case FIRST_COLUMN_BINDING: 
            case KEYS_BINDING: {
                String[] stringArray = this.keyColumns;
                if (stringArray == null) {
                    stringArray = this.getKeyColumns0();
                    this.keyColumns = stringArray;
                }
                return stringArray;
            }
        }
        return NO_KEY_COLUMNS;
    }

    public static void validate(Class<?> clazz) throws InvalidDataTypeException {
        Field[] fieldArray = clazz.getFields();
        Method[] methodArray = clazz.getMethods();
        try {
            AccessibleObject[] accessibleObjectArray = clazz.getDeclaredConstructor(new Class[0]);
            if (!HAVE_ACCESSIBLE_PERMISSION && !Modifier.isPublic(accessibleObjectArray.getModifiers())) {
                throw new InvalidDataTypeException("EoD SQL does not have permission to set the accessable flag. All DataObject classes must have a default constructor.", clazz);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvalidDataTypeException("All Data-Object classes must have a default constructor.", clazz);
        }
        for (Field accessibleObject : fieldArray) {
            if (!accessibleObject.isAnnotationPresent(ResultColumn.class)) continue;
            DefaultDataObjectBinding.validateResultColumnMember(accessibleObject);
        }
        for (AccessibleObject accessibleObject : methodArray) {
            if (!accessibleObject.isAnnotationPresent(ResultColumn.class)) continue;
            DefaultDataObjectBinding.validateResultColumnMember((Member)((Object)accessibleObject));
        }
    }

    private static void validateResultColumnMember(Member member) {
        Method method;
        int n = member.getModifiers();
        if (!HAVE_ACCESSIBLE_PERMISSION && !Modifier.isPublic(n)) {
            throw new InvalidDataTypeException("EoD SQL does not have permission to set the accessable flag. All members annotated with @ResultColumn must therefore be public: " + member.getName(), member.getDeclaringClass());
        }
        if (Modifier.isStatic(n)) {
            throw new InvalidDataTypeException("Members annotated with @ResultColumn may not be static: " + member.getName(), member.getDeclaringClass());
        }
        if (member instanceof Field) {
            if (Modifier.isFinal(n)) {
                throw new InvalidDataTypeException("A field annotated with @ResultColumn may not be final: " + member.getName(), member.getDeclaringClass());
            }
            if (Modifier.isTransient(n)) {
                throw new InvalidDataTypeException("A field annotated with @ResultColumn may not be transient: " + member.getName(), member.getDeclaringClass());
            }
        }
        if (member instanceof Method && (method = (Method)member).getParameterTypes().length != 1) {
            throw new InvalidDataTypeException("A Method annotated with @ResultColumn must accept exactly 1 parameter.", member.getDeclaringClass(), method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NOT_COMPLETE,
        SET_BINDING_TYPE_IN_PROCESS,
        COMPLETION_IN_PROCESS,
        COMPLETE;

    }
}

