/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.impl;

import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.etlserver.registrator.api.impl.AbstractTransactionalCommand;
import java.io.File;

public class NewFileCommand
extends AbstractTransactionalCommand {
    private static final long serialVersionUID = 1L;
    private final String fileAbsolutePath;

    public NewFileCommand(String directoryAbsoutePath) {
        this.fileAbsolutePath = directoryAbsoutePath;
    }

    @Override
    public void execute() {
        File src = new File(this.fileAbsolutePath);
        IFileOperations fileOperations = FileOperations.getMonitoredInstanceForCurrentThread();
        fileOperations.createNewFile(src);
    }

    @Override
    public void rollback() {
        File src = new File(this.fileAbsolutePath);
        if (!src.exists()) {
            return;
        }
        IFileOperations fileOperations = FileOperations.getMonitoredInstanceForCurrentThread();
        fileOperations.delete(src);
        if (src.exists()) {
            NewFileCommand.getOperationLog().error((Object)("Could not delete file '" + src + "'."));
        }
    }

    public String toString() {
        return "NewFileCommand [fileAbsolutePath=" + this.fileAbsolutePath + "]";
    }
}

