/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.content;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.string.StringUtilities;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.IPersistenceManager;
import java.io.File;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class SimpleFileBasePersistenceManager
implements IPersistenceManager {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SimpleFileBasePersistenceManager.class);
    private final File file;
    private final File fileNew;
    private final String nameOfObject;
    private Serializable object;

    public SimpleFileBasePersistenceManager(File file, String nameOfObject) {
        this.file = file;
        this.nameOfObject = nameOfObject;
        this.fileNew = new File(file.getParentFile(), String.valueOf(file.getName()) + ".new");
    }

    @Override
    public Serializable load(Serializable defaultObject) {
        if (defaultObject == null) {
            throw new IllegalArgumentException("Unspecified default object.");
        }
        this.object = this.doLoad(defaultObject);
        return this.object;
    }

    private Serializable doLoad(Serializable defaultObject) {
        if (!this.file.exists()) {
            return defaultObject;
        }
        try {
            return FileUtilities.loadToObject(this.file, Serializable.class);
        }
        catch (Exception e) {
            operationLog.warn((Object)(String.valueOf(StringUtilities.capitalize(this.nameOfObject)) + " couldn't be reloaded from file " + this.file + ": " + e));
            return defaultObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPersistence() {
        Serializable serializable = this.object;
        synchronized (serializable) {
            boolean result;
            File folder = this.fileNew.getParentFile();
            if (!folder.exists() && !(result = folder.mkdirs())) {
                throw new EnvironmentFailureException("Couldn't create folder: " + folder);
            }
            FileUtilities.writeToFile(this.fileNew, this.object);
            this.fileNew.renameTo(this.file);
        }
    }
}

