/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.model;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.renderer.VocabularyPropertyColRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VocabularyTermModel
extends SimplifiedBaseModel
implements Comparable<VocabularyTermModel> {
    private static final String ORDINAL = "ordinal";
    private static final String IS_OFFICIAL = "is_official";
    public static final String DISPLAY_FIELD = "display_field";
    private static final long serialVersionUID = 1L;

    public VocabularyTermModel(VocabularyTerm term) {
        this.set("code", term.getCode());
        this.set(ORDINAL, term.getOrdinal());
        this.set(IS_OFFICIAL, term.isOfficial());
        this.set("code_with_label", term.getCodeOrLabel());
        this.set(DISPLAY_FIELD, this.generateDisplayField(term));
        this.set("tooltip", VocabularyPropertyColRenderer.renderAsTooltip(term));
        this.set("object", term);
    }

    public String generateDisplayField(VocabularyTerm term) {
        Element span = DOM.createSpan();
        if (!term.isOfficial().booleanValue()) {
            span.setAttribute("style", "color: grey; font-style:italic");
        }
        span.setInnerHTML(term.getCodeOrLabel());
        return DOM.toString((Element)span);
    }

    public static final List<VocabularyTermModel> convert(List<VocabularyTerm> terms) {
        ArrayList<VocabularyTermModel> list = new ArrayList<VocabularyTermModel>();
        for (VocabularyTerm t : terms) {
            list.add(new VocabularyTermModel(t));
        }
        Collections.sort(list);
        return list;
    }

    public VocabularyTerm getTerm() {
        return (VocabularyTerm)this.get("object");
    }

    @Override
    public int compareTo(VocabularyTermModel o) {
        if (this.isOfficial() == o.isOfficial()) {
            return this.getValueToCompare().compareTo(o.getValueToCompare());
        }
        return this.isOfficial() != false ? -1 : 1;
    }

    private Long getValueToCompare() {
        return (Long)this.get(ORDINAL);
    }

    private Boolean isOfficial() {
        return (Boolean)this.get(IS_OFFICIAL);
    }
}

