/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.TableExportType;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.SplitButton;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.extjs.gxt.ui.client.widget.menu.CheckMenuItem;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.PagingToolBar;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class BrowserGridPagingToolBar
extends PagingToolBar {
    public static final String REFRESH_BUTTON_ID = "openbis_paged-grid-refresh-button";
    public static final String CONFIG_BUTTON_ID = "openbis_paged-grid-config-button";
    private final IViewContext<?> messageProvider;
    private final Button exportButton;
    private final Button refreshButton;
    private final Button configButton;
    private final Button showFiltersButton;
    private int nextTableButtonIndex;

    void setPagingComponentsHidden(boolean hide) {
        Component separator1 = this.getItem(this.indexOf((Component)this.prev) + 1);
        Component pageTextWidget = this.getItem(this.indexOf((Component)this.beforePage) + 1);
        Component separator2 = this.getItem(this.indexOf((Component)this.afterText) + 1);
        Component separator3 = this.getItem(this.indexOf((Component)this.last) + 1);
        ArrayList<Component> components = new ArrayList<Component>();
        components.addAll(Arrays.asList(this.first, this.prev, separator1, this.beforePage, pageTextWidget, this.afterText, separator2, this.next, this.last, separator3, this.refresh));
        for (Component c : components) {
            if (hide) {
                c.hide();
                continue;
            }
            c.show();
            if (!(c instanceof Button)) continue;
            Button button = (Button)c;
            button.setIcon(button.getIcon());
        }
        this.syncSize();
    }

    public BrowserGridPagingToolBar(IBrowserGridActionInvoker invoker, IViewContext<?> viewContext, int pageSize, String gridId) {
        super(pageSize);
        int logID = viewContext.log("create paging tool bar for " + gridId);
        this.remove((Component)this.refresh);
        Component fillItem = this.getItem(this.indexOf((Component)this.displayText) - 1);
        this.remove(fillItem);
        this.nextTableButtonIndex = this.indexOf((Component)this.displayText) + 1;
        SeparatorToolItem separator = new SeparatorToolItem();
        this.insertTableButton((Component)separator);
        this.messageProvider = viewContext;
        this.insertTableButton(this.createTableOperationsLabel());
        this.showFiltersButton = BrowserGridPagingToolBar.createShowFiltersButton(viewContext, invoker);
        this.showFiltersButton.setId(String.valueOf(gridId) + "-show-filters");
        this.insertTableButton((Component)this.showFiltersButton);
        this.configButton = BrowserGridPagingToolBar.createConfigButton(viewContext, invoker, gridId);
        this.insertTableButton((Component)this.configButton);
        this.updateDefaultConfigButton(false);
        this.refreshButton = BrowserGridPagingToolBar.createRefreshButton(viewContext, invoker);
        this.insertTableButton((Component)this.refreshButton);
        this.updateDefaultRefreshButton(false);
        this.refreshButton.setId(REFRESH_BUTTON_ID);
        this.exportButton = BrowserGridPagingToolBar.createExportButton(viewContext, invoker);
        this.disableExportButton();
        this.insertTableButton((Component)this.exportButton);
        this.insertTableButton((Component)new FillToolItem());
        viewContext.logStop(logID);
        this.setPagingComponentsHidden(true);
    }

    public void removeButtons(PagingToolBarButtonKind ... buttonKinds) {
        HashSet<PagingToolBarButtonKind> buttonSet = new HashSet<PagingToolBarButtonKind>(Arrays.asList(buttonKinds));
        for (PagingToolBarButtonKind buttonKind : buttonSet) {
            switch (buttonKind) {
                case CONFIG: {
                    this.configButton.removeFromParent();
                    break;
                }
                case REFRESH: {
                    this.refreshButton.removeFromParent();
                    break;
                }
                case FILTERS: {
                    this.showFiltersButton.removeFromParent();
                    break;
                }
                case EXPORT: {
                    this.exportButton.removeFromParent();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled button " + (Object)((Object)buttonKind));
                }
            }
        }
    }

    protected void onLoad(LoadEvent event) {
        super.onLoad(event);
        if (this.pages < 2) {
            this.setPagingComponentsHidden(true);
        } else {
            this.setPagingComponentsHidden(false);
        }
    }

    public int getTotalCount() {
        return this.totalLength;
    }

    private void insertTableButton(Component item) {
        this.insert(item, this.nextTableButtonIndex);
        ++this.nextTableButtonIndex;
    }

    public final void addEntityOperationsLabel() {
        this.add((Component)new SeparatorToolItem());
        this.add((Component)new LabelToolItem(this.messageProvider.getMessage("entity_operations", new Object[0])));
    }

    public boolean isDefaultRefreshButtonEnabled() {
        return this.refreshButton.isEnabled();
    }

    public void disableForLoadingRest() {
        this.displayText.setLabel(this.messageProvider.getMessage("load_rest_of_data", new Object[0]));
        this.disable();
    }

    public final void updateDefaultRefreshButton(boolean isEnabled) {
        BrowserGridPagingToolBar.updateRefreshButton(this.refreshButton, isEnabled, this.messageProvider);
    }

    public final void updateDefaultConfigButton(boolean isEnabled) {
        BrowserGridPagingToolBar.updateConfigButton(this.configButton, isEnabled, this.messageProvider);
    }

    public static final void updateConfigButton(Button button, boolean isEnabled, IMessageProvider messageProvider) {
        if (button.isEnabled() != isEnabled) {
            button.setEnabled(isEnabled);
            if (isEnabled) {
                GWTUtils.setToolTip((Component)button, messageProvider.getMessage("tooltip_config_enabled", new Object[0]));
            } else {
                GWTUtils.setToolTip((Component)button, messageProvider.getMessage("tooltip_config_disabled", new Object[0]));
            }
        }
    }

    public static final void updateRefreshButton(Button refreshButton, boolean isEnabled, IMessageProvider messageProvider) {
        if (refreshButton.isEnabled() != isEnabled) {
            refreshButton.setEnabled(isEnabled);
            if (isEnabled) {
                GWTUtils.setToolTip((Component)refreshButton, messageProvider.getMessage("tooltip_refresh_enabled", new Object[0]));
            } else {
                GWTUtils.setToolTip((Component)refreshButton, messageProvider.getMessage("tooltip_refresh_disabled", new Object[0]));
            }
        }
    }

    public final void enableExportButton() {
        if (!this.exportButton.isEnabled()) {
            this.exportButton.enable();
        }
    }

    public final void disableExportButton() {
        if (this.exportButton.isEnabled()) {
            this.exportButton.disable();
            String title = this.messageProvider.getMessage("tooltip_export_disabled", new Object[0]);
            GWTUtils.setToolTip((Component)this.exportButton, title);
        }
    }

    public static Button createRefreshButton(IMessageProvider messageProvider, final IBrowserGridActionInvoker invoker) {
        Button button = new Button(messageProvider.getMessage("button_refresh", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                if (ce.getButton().isEnabled()) {
                    invoker.refresh();
                }
            }
        });
        return button;
    }

    public static Button createExportButton(IViewContext<?> viewContext, IBrowserGridActionInvoker invoker) {
        if (viewContext.getModel().isEmbeddedMode()) {
            return BrowserGridPagingToolBar.createVisibleColumnsExportButton(viewContext, invoker);
        }
        return new ExportButtonMenu(viewContext, invoker);
    }

    private static Button createVisibleColumnsExportButton(IMessageProvider messageProvider, final IBrowserGridActionInvoker invoker) {
        Button button = new Button(messageProvider.getMessage("button_export_visible", new Object[0]));
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                invoker.export(TableExportType.VISIBLE);
            }
        });
        return button;
    }

    private static Button createConfigButton(IMessageProvider messageProvider, final IBrowserGridActionInvoker invoker, String gridId) {
        Button button = new Button(messageProvider.getMessage("button_configure", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                invoker.configure();
            }
        });
        button.setId(CONFIG_BUTTON_ID + gridId);
        return button;
    }

    public static Button createShowFiltersButton(IMessageProvider messageProvider, final IBrowserGridActionInvoker invoker) {
        final ToggleButton button = new ToggleButton(messageProvider.getMessage("button_filters", new Object[0]));
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                invoker.toggleFilters(button.isPressed());
            }
        });
        return button;
    }

    private Component createTableOperationsLabel() {
        return new LabelToolItem(this.messageProvider.getMessage("table_operations", new Object[0]));
    }

    public void enable() {
        if (this.rendered) {
            this.onEnable();
        }
        this.disabled = false;
        this.fireEvent(Events.Enable);
    }

    public void disable() {
        if (this.rendered) {
            this.onDisable();
        }
        this.disabled = true;
        this.fireEvent(Events.Disable);
    }

    private static class ExportButtonMenu
    extends SplitButton {
        private static final String TOOLTIP_EXPORT_PREFIX = "tooltip_export_";
        private final Map<TableExportType, CheckMenuItem> exportMenuItems = new HashMap<TableExportType, CheckMenuItem>();
        private final IMessageProvider messageProvider;

        public ExportButtonMenu(final IMessageProvider messageProvider, final IBrowserGridActionInvoker invoker) {
            super(messageProvider.getMessage("button_export_visible", new Object[0]));
            this.messageProvider = messageProvider;
            Menu exportMenu = new Menu();
            SelectionListener<MenuEvent> menuEventListener = new SelectionListener<MenuEvent>(){

                public void componentSelected(MenuEvent ce) {
                    TableExportType selectedType = ExportButtonMenu.this.getSelectedType();
                    invoker.export(selectedType);
                    ExportButtonMenu.this.setText(messageProvider.getMessage("button_export_" + selectedType.toString().toLowerCase(), new Object[0]));
                    ExportButtonMenu.this.updateTooltip();
                }
            };
            HashSet<TableExportType> types = new HashSet<TableExportType>(Arrays.asList(TableExportType.values()));
            if (!invoker.supportsExportForUpdate()) {
                types.remove((Object)TableExportType.FOR_UPDATE);
            }
            for (TableExportType exportType : types) {
                String typeAsString = exportType.toString().toLowerCase();
                CheckMenuItem exportMenuItem = new CheckMenuItem(messageProvider.getMessage("export_" + typeAsString, new Object[0]));
                exportMenuItem.setToolTip(messageProvider.getMessage(TOOLTIP_EXPORT_PREFIX + typeAsString, new Object[0]));
                exportMenuItem.setGroup("exportType");
                exportMenuItem.addSelectionListener((SelectionListener)menuEventListener);
                this.exportMenuItems.put(exportType, exportMenuItem);
                exportMenu.add((Component)exportMenuItem);
            }
            this.setMenu(exportMenu);
            this.exportMenuItems.get((Object)TableExportType.VISIBLE).setChecked(true);
            this.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent be) {
                    invoker.export(ExportButtonMenu.this.getSelectedType());
                }
            });
        }

        private TableExportType getSelectedType() {
            Set<Map.Entry<TableExportType, CheckMenuItem>> entrySet = this.exportMenuItems.entrySet();
            for (Map.Entry<TableExportType, CheckMenuItem> entry : entrySet) {
                if (!entry.getValue().isChecked()) continue;
                return entry.getKey();
            }
            return TableExportType.VISIBLE;
        }

        private void updateTooltip() {
            GWTUtils.setToolTip((Component)this, this.messageProvider.getMessage(TOOLTIP_EXPORT_PREFIX + this.getSelectedType().toString().toLowerCase(), new Object[0]));
        }

        public void enable() {
            super.enable();
            this.updateTooltip();
        }
    }

    public static enum PagingToolBarButtonKind {
        REFRESH,
        CONFIG,
        EXPORT,
        FILTERS;

    }
}

