/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListExperimentsCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.MetaprojectTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.basic.DeletionUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumnGroup;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class ExperimentProvider
extends AbstractCommonTableModelProvider<Experiment> {
    private final ListExperimentsCriteria criteria;

    public ExperimentProvider(ICommonServer commonServer, String sessionToken, ListExperimentsCriteria criteria) {
        super(commonServer, sessionToken);
        this.criteria = criteria;
    }

    @Override
    protected TypedTableModel<Experiment> createTableModel() {
        List<Experiment> experiments = null;
        experiments = this.criteria.tryGetMetaprojectId() != null ? this.commonServer.listMetaprojectExperiments(this.sessionToken, new MetaprojectTechIdId(this.criteria.tryGetMetaprojectId())) : (this.criteria.tryGetProjectCode() != null ? this.commonServer.listExperiments(this.sessionToken, this.criteria.getExperimentType(), new ProjectIdentifier(this.criteria.getSpaceCode(), this.criteria.tryGetProjectCode())) : this.commonServer.listExperiments(this.sessionToken, this.criteria.getExperimentType(), new SpaceIdentifier(this.criteria.getSpaceCode())));
        TypedTableModelBuilder<Experiment> builder = new TypedTableModelBuilder<Experiment>();
        builder.addColumn("CODE");
        builder.addColumn("EXPERIMENT_TYPE").hideByDefault();
        builder.addColumn("EXPERIMENT_IDENTIFIER").hideByDefault().withDefaultWidth(150);
        builder.addColumn("DATABASE_INSTANCE").hideByDefault();
        builder.addColumn("SPACE").hideByDefault();
        builder.addColumn("PROJECT").hideByDefault();
        builder.addColumn("REGISTRATOR");
        builder.addColumn("MODIFIER");
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(200);
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(200).hideByDefault();
        builder.addColumn("IS_DELETED").hideByDefault();
        builder.addColumn("PERM_ID").hideByDefault();
        builder.addColumn("SHOW_DETAILS_LINK").hideByDefault();
        builder.addColumn("METAPROJECTS");
        TableMap<String, ExperimentType> experimentTypes = this.getExperimentTypes();
        for (Experiment experiment : experiments) {
            builder.addRow(experiment);
            if (experiment.isStub()) {
                builder.column("PERM_ID").addString(experiment.getPermId());
                continue;
            }
            builder.column("CODE").addEntityLink(experiment, experiment.getCode());
            builder.column("EXPERIMENT_TYPE").addString(experiment.getExperimentType().getCode());
            builder.column("EXPERIMENT_IDENTIFIER").addEntityLink(experiment, experiment.getIdentifier());
            builder.column("DATABASE_INSTANCE").addString(experiment.getProject().getSpace().getInstance().getCode());
            builder.column("SPACE").addString(experiment.getProject().getSpace().getCode());
            builder.column("PROJECT").addString(experiment.getProject().getCode());
            builder.column("REGISTRATOR").addPerson(experiment.getRegistrator());
            builder.column("MODIFIER").addPerson(experiment.getModifier());
            builder.column("REGISTRATION_DATE").addDate(experiment.getRegistrationDate());
            builder.column("MODIFICATION_DATE").addDate(experiment.getModificationDate());
            builder.column("IS_DELETED").addString(SimpleYesNoRenderer.render(DeletionUtils.isDeleted(experiment)));
            builder.column("PERM_ID").addString(experiment.getPermId());
            builder.column("SHOW_DETAILS_LINK").addString(experiment.getPermlink());
            builder.column("METAPROJECTS").addString(this.metaProjectsToString(experiment.getMetaprojects()));
            ExperimentType experimentType = experimentTypes.tryGet(experiment.getExperimentType().getCode());
            IColumnGroup columnGroup = builder.columnGroup("property-");
            if (experimentType != null) {
                columnGroup.addColumnsForAssignedProperties(experimentType);
            }
            columnGroup.addProperties(experiment.getProperties());
        }
        return builder.getModel();
    }

    protected TableMap<String, ExperimentType> getExperimentTypes() {
        List<ExperimentType> experimentTypes = this.commonServer.listExperimentTypes(this.sessionToken);
        TableMap<String, ExperimentType> experimentTypMap = new TableMap<String, ExperimentType>(experimentTypes, new IKeyExtractor<String, ExperimentType>(){

            @Override
            public String getKey(ExperimentType e) {
                return e.getCode();
            }
        });
        return experimentTypMap;
    }
}

