/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataTransactionErrors;
import java.util.List;

public class MasterDataRegistrationException
extends HighLevelException {
    private static final long serialVersionUID = 1L;
    private final List<MasterDataTransactionErrors> transactionErrors;

    public MasterDataRegistrationException(String message, List<MasterDataTransactionErrors> transactionErrors) {
        super(message);
        this.transactionErrors = transactionErrors;
    }

    public List<MasterDataTransactionErrors> getTransactionErrors() {
        return this.transactionErrors;
    }

    public void logErrors(ISimpleLogger errorLogger) {
        for (MasterDataTransactionErrors errors : this.getTransactionErrors()) {
            for (MasterDataTransactionErrors.TransactionError error : errors.getErrors()) {
                errorLogger.log(LogLevel.ERROR, error.getDescription());
            }
        }
    }
}

