/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.collection.UnmodifiableSetDecorator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.IMatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.LinkDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.OrderBy;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="data", uniqueConstraints={@UniqueConstraint(columnNames={"code"})})
@Inheritance(strategy=InheritanceType.JOINED)
@Indexed(index="DataPE")
public class DataPE
extends AbstractIdAndCodeHolder<DataPE>
implements IEntityInformationWithPropertiesHolder,
IMatchingEntity,
IIdentifierHolder,
IDeletablePE,
IEntityWithMetaprojects,
IModifierAndModificationDateBean {
    private static final long serialVersionUID = 35L;
    public static final DataPE[] EMPTY_ARRAY = new DataPE[0];
    private transient Long id;
    private String code;
    private boolean placeholder;
    private boolean isDerived;
    private PersonPE registrator;
    private PersonPE modifier;
    private Date registrationDate;
    private Date accessDate;
    private DataSetTypePE dataSetType;
    private ExperimentPE experiment;
    private SamplePE sample;
    private Date productionDate;
    private Date modificationDate;
    private int version;
    private String dataProducerCode;
    private DataPE container = null;
    private List<DataPE> containedDataSets = new ArrayList<DataPE>();
    private Set<MetaprojectAssignmentPE> metaprojectAssignments = new HashSet<MetaprojectAssignmentPE>();
    private DeletionPE deletion;
    private Integer originalDeletion;
    private Integer orderInContainer;
    private DataStorePE dataStore;
    private Set<DataSetRelationshipPE> parentRelationships = new HashSet<DataSetRelationshipPE>();
    private Set<DataSetRelationshipPE> childRelationships = new HashSet<DataSetRelationshipPE>();
    private Set<DataSetPropertyPE> properties = new HashSet<DataSetPropertyPE>();

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentDataSet")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<DataSetRelationshipPE> getDataSetChildRelationships() {
        return this.childRelationships;
    }

    private void setDataSetChildRelationships(Set<DataSetRelationshipPE> childRelationships) {
        this.childRelationships = childRelationships;
    }

    @Transient
    public Set<DataSetRelationshipPE> getChildRelationships() {
        return new UnmodifiableSetDecorator<DataSetRelationshipPE>(this.getDataSetChildRelationships());
    }

    public void addChildRelationship(DataSetRelationshipPE relationship) {
        relationship.setParentDataSet(this);
        this.getDataSetChildRelationships().add(relationship);
    }

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="childDataSet", orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<DataSetRelationshipPE> getDataSetParentRelationships() {
        return this.parentRelationships;
    }

    private void setDataSetParentRelationships(Set<DataSetRelationshipPE> parentRelationships) {
        this.parentRelationships = parentRelationships;
    }

    @Transient
    public Set<DataSetRelationshipPE> getParentRelationships() {
        return new UnmodifiableSetDecorator<DataSetRelationshipPE>(this.getDataSetParentRelationships());
    }

    @Transient
    public boolean isParentRelationshipsInitialized() {
        return HibernateUtils.isInitialized(this.getDataSetParentRelationships());
    }

    @Transient
    public boolean isChildrenRelationshipsInitialized() {
        return HibernateUtils.isInitialized(this.getDataSetChildRelationships());
    }

    public void setParentRelationships(Set<DataSetRelationshipPE> parentRelationships) {
        this.getDataSetParentRelationships().clear();
        for (DataSetRelationshipPE dataSetRelationship : parentRelationships) {
            DataPE parent = dataSetRelationship.getChildDataSet();
            if (parent != null) {
                parent.getDataSetParentRelationships().remove(dataSetRelationship);
            }
            this.addParentRelationship(dataSetRelationship);
        }
    }

    public void addParentRelationship(DataSetRelationshipPE relationship) {
        relationship.setChildDataSet(this);
        this.getDataSetParentRelationships().add(relationship);
    }

    public void removeParentRelationship(DataSetRelationshipPE relationship) {
        this.getDataSetParentRelationships().remove(relationship);
        relationship.getParentDataSet().getDataSetChildRelationships().remove(relationship);
        relationship.setChildDataSet(null);
        relationship.setParentDataSet(null);
    }

    @Transient
    public List<DataPE> getParents() {
        Set<DataSetRelationshipPE> relationships = this.getParentRelationships();
        ArrayList<DataPE> parents = new ArrayList<DataPE>();
        for (DataSetRelationshipPE r : relationships) {
            assert (r.getChildDataSet().equals(this));
            parents.add(r.getParentDataSet());
        }
        return parents;
    }

    @Transient
    public List<DataPE> getChildren() {
        Set<DataSetRelationshipPE> relationships = this.getChildRelationships();
        ArrayList<DataPE> children = new ArrayList<DataPE>();
        for (DataSetRelationshipPE r : relationships) {
            assert (r.getParentDataSet().equals(this));
            children.add(r.getChildDataSet());
        }
        return children;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull(message="Data store can not be null.")
    @JoinColumn(name="dast_id", updatable=false)
    public DataStorePE getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(DataStorePE dataStorePE) {
        this.dataStore = dataStorePE;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_registerer", updatable=false)
    @IndexedEmbedded(prefix="registrator ")
    public PersonPE getRegistrator() {
        return this.registrator;
    }

    public void setRegistrator(PersonPE registrator) {
        this.registrator = registrator;
    }

    @Override
    @OptimisticLock(excluded=true)
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_modifier")
    @IndexedEmbedded(prefix="modifier ")
    public PersonPE getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifier(PersonPE modifier) {
        this.modifier = modifier;
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false)
    @Generated(value=GenerationTime.ALWAYS)
    @Field(name="registration_date", index=Index.UN_TOKENIZED, store=Store.NO)
    @DateBridge(resolution=Resolution.SECOND)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull(message="Data set type can not be null.")
    @JoinColumn(name="dsty_id")
    @IndexedEmbedded(prefix="type ")
    public DataSetTypePE getDataSetType() {
        return this.dataSetType;
    }

    public void setDataSetType(DataSetTypePE dataSetType) {
        this.dataSetType = dataSetType;
    }

    @Column(name="is_derived")
    public boolean isDerived() {
        return this.isDerived;
    }

    public void setDerived(boolean isDerived) {
        this.isDerived = isDerived;
    }

    @Column(name="ctnr_order")
    public Integer getOrderInContainer() {
        return this.orderInContainer;
    }

    public void setOrderInContainer(Integer orderInContainer) {
        this.orderInContainer = orderInContainer;
    }

    @Transient
    public boolean isMeasured() {
        return !this.isDerived;
    }

    @Column(name="is_placeholder")
    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
    }

    public void setSampleAcquiredFrom(SamplePE sample) {
        this.setDerived(false);
        this.setSample(sample);
    }

    public void setSample(SamplePE sample) {
        if (sample != null) {
            sample.addDataSet(this);
        } else {
            SamplePE previousSample = this.tryGetSample();
            if (previousSample != null) {
                previousSample.removeDataSet(this);
            }
        }
    }

    @Transient
    public SamplePE tryGetSample() {
        return this.getSampleInternal();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="samp_id")
    private SamplePE getSampleInternal() {
        return this.sample;
    }

    void setSampleInternal(SamplePE sample) {
        this.sample = sample;
    }

    @Transient
    @Field(index=Index.UN_TOKENIZED, store=Store.YES, name="sample id")
    private Long getSampleId() {
        Long result = null;
        if (this.getSampleInternal() != null) {
            result = HibernateUtils.getId(this.getSampleInternal());
            assert (result != null);
        }
        return result;
    }

    @Column(name="production_timestamp")
    public Date getProductionDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.productionDate);
    }

    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }

    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Column(name="data_producer_code")
    public String getDataProducerCode() {
        return this.dataProducerCode;
    }

    public void setDataProducerCode(String dataProducerCode) {
        this.dataProducerCode = dataProducerCode;
    }

    @Version
    @Column(name="version", nullable=false)
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    @OptimisticLock(excluded=true)
    @Column(name="modification_timestamp", nullable=false)
    @Field(name="modification_date", index=Index.UN_TOKENIZED, store=Store.NO)
    @DateBridge(resolution=Resolution.SECOND)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Column(name="access_timestamp", nullable=false, insertable=false)
    @Generated(value=GenerationTime.ALWAYS)
    public Date getAccessDate() {
        return this.accessDate;
    }

    public void setAccessDate(Date versionDate) {
        this.accessDate = versionDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Transient
    public DataPE getContainer() {
        return this.getContainerInternal();
    }

    @ManyToOne(fetch=FetchType.EAGER, targetEntity=DataPE.class)
    @JoinColumn(name="ctnr_id", updatable=true)
    private DataPE getContainerInternal() {
        return this.container;
    }

    private void setContainerInternal(DataPE container) {
        this.container = container;
    }

    @Transient
    @Field(index=Index.UN_TOKENIZED, store=Store.YES, name="container id")
    private Long getContainerId() {
        Long result = null;
        if (this.getContainer() != null) {
            result = HibernateUtils.getId(this.getContainerInternal());
            assert (result != null);
        }
        return result;
    }

    public void addComponent(DataPE component, PersonPE modifierPerson) {
        assert (component != null);
        this.containedDataSets.add(component);
        component.setContainerInternal(this);
        component.setModifier(modifierPerson);
        component.setOrderInContainer(this.containedDataSets.size());
    }

    public void removeComponent(DataPE component) {
        assert (component != null);
        this.containedDataSets.remove(component);
        component.setContainerInternal(null);
        component.setOrderInContainer(null);
    }

    @OptimisticLock(excluded=true)
    @OneToMany(mappedBy="containerInternal", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @OrderBy(clause="ctnr_order")
    public List<DataPE> getContainedDataSets() {
        return this.containedDataSets;
    }

    private void setContainedDataSets(List<DataPE> containedDataSets) {
        this.containedDataSets = containedDataSets;
    }

    @Override
    @Id
    @SequenceGenerator(name="DATA_ID_SEQ", sequenceName="DATA_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATA_ID_SEQ")
    @DocumentId(name="id")
    public Long getId() {
        return this.id;
    }

    @Override
    @Column(unique=true)
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Field(index=Index.TOKENIZED, store=Store.YES, name="code")
    public String getCode() {
        return this.code;
    }

    public void setExperiment(ExperimentPE experiment) {
        if (experiment != null) {
            experiment.addDataSet(this);
            if (this.containedDataSets != null) {
                for (DataPE contained : this.containedDataSets) {
                    if (contained.equals(this)) continue;
                    contained.setExperiment(experiment);
                }
            }
        }
    }

    @Transient
    public ExperimentPE getExperiment() {
        return this.getExperimentInternal();
    }

    void setExperimentInternal(ExperimentPE experiment) {
        this.experiment = experiment;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull(message="Experiment  can not be null.")
    @JoinColumn(name="expe_id", updatable=true)
    private ExperimentPE getExperimentInternal() {
        return this.experiment;
    }

    @Transient
    @Field(index=Index.UN_TOKENIZED, store=Store.YES, name="experiment id")
    private Long getExperimentId() {
        Long result = null;
        if (this.getExperimentInternal() != null) {
            result = HibernateUtils.getId(this.getExperimentInternal());
            assert (result != null);
        }
        return result;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="entity", orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @IndexedEmbedded(prefix="property ")
    @BatchSize(size=100)
    private Set<DataSetPropertyPE> getDataSetProperties() {
        return this.properties;
    }

    private void setDataSetProperties(Set<DataSetPropertyPE> properties) {
        this.properties = properties;
    }

    @Override
    public void setProperties(Set<? extends EntityPropertyPE> properties) {
        this.getDataSetProperties().clear();
        for (EntityPropertyPE entityPropertyPE : properties) {
            DataSetPropertyPE property = (DataSetPropertyPE)entityPropertyPE;
            DataPE parent = property.getEntity();
            if (parent != null) {
                parent.getDataSetProperties().remove(property);
            }
            this.addProperty(property);
        }
    }

    @Override
    public void addProperty(EntityPropertyPE property) {
        property.setEntity(this);
        this.getDataSetProperties().add((DataSetPropertyPE)property);
    }

    @Override
    public void removeProperty(EntityPropertyPE property) {
        this.getDataSetProperties().remove(property);
        property.setEntity(null);
    }

    @Transient
    public Set<DataSetPropertyPE> getProperties() {
        return new UnmodifiableSetDecorator<DataSetPropertyPE>(this.getDataSetProperties());
    }

    @Override
    @Transient
    public boolean isPropertiesInitialized() {
        return HibernateUtils.isInitialized(this.getDataSetProperties());
    }

    @Override
    @Transient
    public EntityKind getEntityKind() {
        return EntityKind.DATA_SET;
    }

    @Override
    @Transient
    public EntityTypePE getEntityType() {
        return this.getDataSetType();
    }

    @Override
    @Transient
    @Field(index=Index.NO, store=Store.YES, name="identifier")
    public String getIdentifier() {
        return this.getCode();
    }

    @Override
    @Transient
    @Field(index=Index.NO, store=Store.YES, name="perm_id")
    public String getPermId() {
        return this.code;
    }

    @Transient
    public boolean isContainer() {
        return this.tryAsExternalData() == null && !this.isLinkData();
    }

    @Transient
    public boolean isExternalData() {
        return !this.isPlaceholder() && !this.isContainer() && !this.isLinkData();
    }

    @Transient
    public ExternalDataPE tryAsExternalData() {
        return this instanceof ExternalDataPE ? (ExternalDataPE)this : null;
    }

    @Transient
    public boolean isLinkData() {
        return false;
    }

    @Transient
    public LinkDataPE tryAsLinkData() {
        return null;
    }

    @Transient
    public boolean isAvailable() {
        return false;
    }

    @Transient
    public boolean isDeletable() {
        return true;
    }

    @Transient
    public SpacePE getSpace() {
        return this.getExperiment().getProject().getSpace();
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }

    @Column(name="orig_del", nullable=false)
    public Integer getOriginalDeletion() {
        return this.originalDeletion;
    }

    public void setOriginalDeletion(Integer originalDeletion) {
        this.originalDeletion = originalDeletion;
    }

    @Override
    public void addMetaproject(MetaprojectPE metaprojectPE) {
        if (metaprojectPE == null) {
            throw new IllegalArgumentException("Metaproject cannot be null");
        }
        MetaprojectAssignmentPE assignmentPE = new MetaprojectAssignmentPE();
        assignmentPE.setMetaproject(metaprojectPE);
        assignmentPE.setDataSet(this);
        this.getMetaprojectAssignmentsInternal().add(assignmentPE);
        metaprojectPE.getAssignmentsInternal().add(assignmentPE);
    }

    @Override
    public void removeMetaproject(MetaprojectPE metaprojectPE) {
        if (metaprojectPE == null) {
            throw new IllegalArgumentException("Metaproject cannot be null");
        }
        MetaprojectAssignmentPE assignmentPE = new MetaprojectAssignmentPE();
        assignmentPE.setMetaproject(metaprojectPE);
        assignmentPE.setDataSet(this);
        this.getMetaprojectAssignmentsInternal().remove(assignmentPE);
        metaprojectPE.getAssignmentsInternal().remove(assignmentPE);
    }

    @Override
    @Transient
    @IndexedEmbedded(prefix="metaproject ")
    public Set<MetaprojectPE> getMetaprojects() {
        HashSet<MetaprojectPE> metaprojects = new HashSet<MetaprojectPE>();
        for (MetaprojectAssignmentPE assignment : this.getMetaprojectAssignmentsInternal()) {
            metaprojects.add(assignment.getMetaproject());
        }
        return new UnmodifiableSetDecorator<MetaprojectPE>((Set<MetaprojectPE>)metaprojects);
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="dataSet")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<MetaprojectAssignmentPE> getMetaprojectAssignmentsInternal() {
        return this.metaprojectAssignments;
    }

    private void setMetaprojectAssignmentsInternal(Set<MetaprojectAssignmentPE> metaprojectAssignments) {
        this.metaprojectAssignments = metaprojectAssignments;
    }
}

