/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Channel;
import ome.xml.model.Dataset;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.Image;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.Plate;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.Project;
import ome.xml.model.ROI;
import ome.xml.model.Reagent;
import ome.xml.model.Reference;
import ome.xml.model.Screen;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Annotation
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Annotation.class);
    private String namespace;
    private String id;
    private String description;
    private List<Annotation> annotationLinks = new ArrayList<Annotation>();
    private List<Image> imageLinks = new ArrayList<Image>();
    private List<Pixels> pixelsLinks = new ArrayList<Pixels>();
    private List<Plane> planeLinks = new ArrayList<Plane>();
    private List<Channel> channelLinks = new ArrayList<Channel>();
    private List<Project> projectLinks = new ArrayList<Project>();
    private List<ExperimenterGroup> experimenterGroupLinks = new ArrayList<ExperimenterGroup>();
    private List<Dataset> datasetLinks = new ArrayList<Dataset>();
    private List<Experimenter> experimenterLinks = new ArrayList<Experimenter>();
    private List<ROI> roiLinks = new ArrayList<ROI>();
    private List<Plate> plateLinks = new ArrayList<Plate>();
    private List<Reagent> reagentLinks = new ArrayList<Reagent>();
    private List<Screen> screenLinks = new ArrayList<Screen>();
    private List<PlateAcquisition> plateAcquisitionLinks = new ArrayList<PlateAcquisition>();
    private List<Well> wellLinks = new ArrayList<Well>();
    private List<WellSample> wellSampleLinks = new ArrayList<WellSample>();

    public Annotation() {
    }

    public Annotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Annotation".equals(tagName)) {
            LOGGER.debug("Expecting node name of Annotation got {}", (Object)tagName);
        }
        if (element.hasAttribute("Namespace")) {
            this.setNamespace(String.valueOf(element.getAttribute("Namespace")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Annotation missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Description_nodeList = Annotation.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> AnnotationRef_nodeList = Annotation.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            if (!this.annotationLinks.contains(o_casted)) {
                this.annotationLinks.add(o_casted);
            }
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        if (!this.annotationLinks.contains(o)) {
            return this.annotationLinks.add(o);
        }
        return false;
    }

    public boolean unlinkAnnotation(Annotation o) {
        return this.annotationLinks.remove(o);
    }

    public int sizeOfLinkedImageList() {
        return this.imageLinks.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.imageLinks);
    }

    public Image getLinkedImage(int index) {
        return this.imageLinks.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.imageLinks.set(index, o);
    }

    public boolean linkImage(Image o) {
        if (!this.imageLinks.contains(o)) {
            return this.imageLinks.add(o);
        }
        return false;
    }

    public boolean unlinkImage(Image o) {
        return this.imageLinks.remove(o);
    }

    public int sizeOfLinkedPixelsList() {
        return this.pixelsLinks.size();
    }

    public List<Pixels> copyLinkedPixelsList() {
        return new ArrayList<Pixels>(this.pixelsLinks);
    }

    public Pixels getLinkedPixels(int index) {
        return this.pixelsLinks.get(index);
    }

    public Pixels setLinkedPixels(int index, Pixels o) {
        return this.pixelsLinks.set(index, o);
    }

    public boolean linkPixels(Pixels o) {
        if (!this.pixelsLinks.contains(o)) {
            return this.pixelsLinks.add(o);
        }
        return false;
    }

    public boolean unlinkPixels(Pixels o) {
        return this.pixelsLinks.remove(o);
    }

    public int sizeOfLinkedPlaneList() {
        return this.planeLinks.size();
    }

    public List<Plane> copyLinkedPlaneList() {
        return new ArrayList<Plane>(this.planeLinks);
    }

    public Plane getLinkedPlane(int index) {
        return this.planeLinks.get(index);
    }

    public Plane setLinkedPlane(int index, Plane o) {
        return this.planeLinks.set(index, o);
    }

    public boolean linkPlane(Plane o) {
        if (!this.planeLinks.contains(o)) {
            return this.planeLinks.add(o);
        }
        return false;
    }

    public boolean unlinkPlane(Plane o) {
        return this.planeLinks.remove(o);
    }

    public int sizeOfLinkedChannelList() {
        return this.channelLinks.size();
    }

    public List<Channel> copyLinkedChannelList() {
        return new ArrayList<Channel>(this.channelLinks);
    }

    public Channel getLinkedChannel(int index) {
        return this.channelLinks.get(index);
    }

    public Channel setLinkedChannel(int index, Channel o) {
        return this.channelLinks.set(index, o);
    }

    public boolean linkChannel(Channel o) {
        if (!this.channelLinks.contains(o)) {
            return this.channelLinks.add(o);
        }
        return false;
    }

    public boolean unlinkChannel(Channel o) {
        return this.channelLinks.remove(o);
    }

    public int sizeOfLinkedProjectList() {
        return this.projectLinks.size();
    }

    public List<Project> copyLinkedProjectList() {
        return new ArrayList<Project>(this.projectLinks);
    }

    public Project getLinkedProject(int index) {
        return this.projectLinks.get(index);
    }

    public Project setLinkedProject(int index, Project o) {
        return this.projectLinks.set(index, o);
    }

    public boolean linkProject(Project o) {
        if (!this.projectLinks.contains(o)) {
            return this.projectLinks.add(o);
        }
        return false;
    }

    public boolean unlinkProject(Project o) {
        return this.projectLinks.remove(o);
    }

    public int sizeOfLinkedExperimenterGroupList() {
        return this.experimenterGroupLinks.size();
    }

    public List<ExperimenterGroup> copyLinkedExperimenterGroupList() {
        return new ArrayList<ExperimenterGroup>(this.experimenterGroupLinks);
    }

    public ExperimenterGroup getLinkedExperimenterGroup(int index) {
        return this.experimenterGroupLinks.get(index);
    }

    public ExperimenterGroup setLinkedExperimenterGroup(int index, ExperimenterGroup o) {
        return this.experimenterGroupLinks.set(index, o);
    }

    public boolean linkExperimenterGroup(ExperimenterGroup o) {
        if (!this.experimenterGroupLinks.contains(o)) {
            return this.experimenterGroupLinks.add(o);
        }
        return false;
    }

    public boolean unlinkExperimenterGroup(ExperimenterGroup o) {
        return this.experimenterGroupLinks.remove(o);
    }

    public int sizeOfLinkedDatasetList() {
        return this.datasetLinks.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.datasetLinks);
    }

    public Dataset getLinkedDataset(int index) {
        return this.datasetLinks.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.datasetLinks.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        if (!this.datasetLinks.contains(o)) {
            return this.datasetLinks.add(o);
        }
        return false;
    }

    public boolean unlinkDataset(Dataset o) {
        return this.datasetLinks.remove(o);
    }

    public int sizeOfLinkedExperimenterList() {
        return this.experimenterLinks.size();
    }

    public List<Experimenter> copyLinkedExperimenterList() {
        return new ArrayList<Experimenter>(this.experimenterLinks);
    }

    public Experimenter getLinkedExperimenter(int index) {
        return this.experimenterLinks.get(index);
    }

    public Experimenter setLinkedExperimenter(int index, Experimenter o) {
        return this.experimenterLinks.set(index, o);
    }

    public boolean linkExperimenter(Experimenter o) {
        if (!this.experimenterLinks.contains(o)) {
            return this.experimenterLinks.add(o);
        }
        return false;
    }

    public boolean unlinkExperimenter(Experimenter o) {
        return this.experimenterLinks.remove(o);
    }

    public int sizeOfLinkedROIList() {
        return this.roiLinks.size();
    }

    public List<ROI> copyLinkedROIList() {
        return new ArrayList<ROI>(this.roiLinks);
    }

    public ROI getLinkedROI(int index) {
        return this.roiLinks.get(index);
    }

    public ROI setLinkedROI(int index, ROI o) {
        return this.roiLinks.set(index, o);
    }

    public boolean linkROI(ROI o) {
        if (!this.roiLinks.contains(o)) {
            return this.roiLinks.add(o);
        }
        return false;
    }

    public boolean unlinkROI(ROI o) {
        return this.roiLinks.remove(o);
    }

    public int sizeOfLinkedPlateList() {
        return this.plateLinks.size();
    }

    public List<Plate> copyLinkedPlateList() {
        return new ArrayList<Plate>(this.plateLinks);
    }

    public Plate getLinkedPlate(int index) {
        return this.plateLinks.get(index);
    }

    public Plate setLinkedPlate(int index, Plate o) {
        return this.plateLinks.set(index, o);
    }

    public boolean linkPlate(Plate o) {
        if (!this.plateLinks.contains(o)) {
            return this.plateLinks.add(o);
        }
        return false;
    }

    public boolean unlinkPlate(Plate o) {
        return this.plateLinks.remove(o);
    }

    public int sizeOfLinkedReagentList() {
        return this.reagentLinks.size();
    }

    public List<Reagent> copyLinkedReagentList() {
        return new ArrayList<Reagent>(this.reagentLinks);
    }

    public Reagent getLinkedReagent(int index) {
        return this.reagentLinks.get(index);
    }

    public Reagent setLinkedReagent(int index, Reagent o) {
        return this.reagentLinks.set(index, o);
    }

    public boolean linkReagent(Reagent o) {
        if (!this.reagentLinks.contains(o)) {
            return this.reagentLinks.add(o);
        }
        return false;
    }

    public boolean unlinkReagent(Reagent o) {
        return this.reagentLinks.remove(o);
    }

    public int sizeOfLinkedScreenList() {
        return this.screenLinks.size();
    }

    public List<Screen> copyLinkedScreenList() {
        return new ArrayList<Screen>(this.screenLinks);
    }

    public Screen getLinkedScreen(int index) {
        return this.screenLinks.get(index);
    }

    public Screen setLinkedScreen(int index, Screen o) {
        return this.screenLinks.set(index, o);
    }

    public boolean linkScreen(Screen o) {
        if (!this.screenLinks.contains(o)) {
            return this.screenLinks.add(o);
        }
        return false;
    }

    public boolean unlinkScreen(Screen o) {
        return this.screenLinks.remove(o);
    }

    public int sizeOfLinkedPlateAcquisitionList() {
        return this.plateAcquisitionLinks.size();
    }

    public List<PlateAcquisition> copyLinkedPlateAcquisitionList() {
        return new ArrayList<PlateAcquisition>(this.plateAcquisitionLinks);
    }

    public PlateAcquisition getLinkedPlateAcquisition(int index) {
        return this.plateAcquisitionLinks.get(index);
    }

    public PlateAcquisition setLinkedPlateAcquisition(int index, PlateAcquisition o) {
        return this.plateAcquisitionLinks.set(index, o);
    }

    public boolean linkPlateAcquisition(PlateAcquisition o) {
        if (!this.plateAcquisitionLinks.contains(o)) {
            return this.plateAcquisitionLinks.add(o);
        }
        return false;
    }

    public boolean unlinkPlateAcquisition(PlateAcquisition o) {
        return this.plateAcquisitionLinks.remove(o);
    }

    public int sizeOfLinkedWellList() {
        return this.wellLinks.size();
    }

    public List<Well> copyLinkedWellList() {
        return new ArrayList<Well>(this.wellLinks);
    }

    public Well getLinkedWell(int index) {
        return this.wellLinks.get(index);
    }

    public Well setLinkedWell(int index, Well o) {
        return this.wellLinks.set(index, o);
    }

    public boolean linkWell(Well o) {
        if (!this.wellLinks.contains(o)) {
            return this.wellLinks.add(o);
        }
        return false;
    }

    public boolean unlinkWell(Well o) {
        return this.wellLinks.remove(o);
    }

    public int sizeOfLinkedWellSampleList() {
        return this.wellSampleLinks.size();
    }

    public List<WellSample> copyLinkedWellSampleList() {
        return new ArrayList<WellSample>(this.wellSampleLinks);
    }

    public WellSample getLinkedWellSample(int index) {
        return this.wellSampleLinks.get(index);
    }

    public WellSample setLinkedWellSample(int index, WellSample o) {
        return this.wellSampleLinks.set(index, o);
    }

    public boolean linkWellSample(WellSample o) {
        if (!this.wellSampleLinks.contains(o)) {
            return this.wellSampleLinks.add(o);
        }
        return false;
    }

    public boolean unlinkWellSample(WellSample o) {
        return this.wellSampleLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Annotation_element) {
        if (Annotation_element == null) {
            Annotation_element = document.createElementNS(NAMESPACE, "Annotation");
        }
        if (this.namespace != null) {
            Annotation_element.setAttribute("Namespace", this.namespace.toString());
        }
        if (this.id != null) {
            Annotation_element.setAttribute("ID", this.id.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Annotation_element.appendChild(description_element);
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Annotation_element.appendChild(o.asXMLElement(document));
            }
        }
        if (this.imageLinks != null) {
            // empty if block
        }
        if (this.pixelsLinks != null) {
            // empty if block
        }
        if (this.planeLinks != null) {
            // empty if block
        }
        if (this.channelLinks != null) {
            // empty if block
        }
        if (this.projectLinks != null) {
            // empty if block
        }
        if (this.experimenterGroupLinks != null) {
            // empty if block
        }
        if (this.datasetLinks != null) {
            // empty if block
        }
        if (this.experimenterLinks != null) {
            // empty if block
        }
        if (this.roiLinks != null) {
            // empty if block
        }
        if (this.plateLinks != null) {
            // empty if block
        }
        if (this.reagentLinks != null) {
            // empty if block
        }
        if (this.screenLinks != null) {
            // empty if block
        }
        if (this.plateAcquisitionLinks != null) {
            // empty if block
        }
        if (this.wellLinks != null) {
            // empty if block
        }
        if (this.wellSampleLinks != null) {
            // empty if block
        }
        return super.asXMLElement(document, Annotation_element);
    }
}

