/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.knime.server;

import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IRowBuilderAdaptor;
import ch.systemsx.cisd.openbis.knime.server.FieldType;
import java.util.HashSet;
import java.util.Set;

public class VocabularyBuilder {
    private final IRowBuilderAdaptor row;
    private final Set<String> terms = new HashSet<String>();
    private final StringBuilder termsBuilder = new StringBuilder();

    VocabularyBuilder(IRowBuilderAdaptor row) {
        this.row = row;
        row.setCell("type", FieldType.VOCABULARY.toString());
    }

    public VocabularyBuilder term(String term) {
        if (this.terms.contains(term)) {
            throw new IllegalArgumentException("There is already a term '" + term + "' defined.");
        }
        if (this.termsBuilder.length() > 0) {
            this.termsBuilder.append(", ");
        }
        this.termsBuilder.append(term);
        this.row.setCell("type", (Object)((Object)FieldType.VOCABULARY) + ":" + this.termsBuilder);
        return this;
    }
}

