/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.control;

import ch.systemsx.cisd.common.filesystem.control.IClock;
import ch.systemsx.cisd.common.filesystem.control.IEventFeed;
import ch.systemsx.cisd.common.filesystem.control.IEventFilter;
import ch.systemsx.cisd.common.filesystem.control.SystemClock;
import java.util.ArrayList;
import java.util.List;

public class DelayingDecorator
implements IEventFeed {
    private final IEventFeed eventFeed;
    private IClock clock;
    private final long interval;
    private long lastCall;

    public DelayingDecorator(long interval, IEventFeed eventFeed) {
        this(interval, eventFeed, new SystemClock());
    }

    DelayingDecorator(long interval, IEventFeed eventFeed, IClock clock) {
        this.eventFeed = eventFeed;
        this.clock = clock;
        this.interval = interval;
        this.lastCall = 0L;
    }

    @Override
    public List<String> getNewEvents(IEventFilter filter) {
        long currentTime = this.clock.getTime();
        if (currentTime - this.lastCall > this.interval) {
            this.lastCall = currentTime;
            return this.eventFeed.getNewEvents(filter);
        }
        return new ArrayList<String>();
    }
}

